/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.components.FontChooser;
import com.vividsolutions.jump.workbench.ui.components.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.dim.DimFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.BshTextPanel;
import com.vividsolutions.jump.workbench.ui.style.LinePatternPanel;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.style.DimStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiPoint;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimStylePanel
extends AbstractStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(DimStylePanel.class);
    private final DecimalFormat df = new DecimalFormat();
    private String strDegree = "degree";
    private String strGon = "gon";
    private String strPixel = "pixel";
    private String strPoint = "pt";
    private String strUnits = "units";
    private LayerStyleCollection sCol;
    private PlugInContext context = null;
    private BshTextPanel bshTextPanel;
    private boolean bolUpdateControls = true;
    private boolean bolTransparencyChanging = false;
    private TextStyleModel tooltipStyle = new TextStyleModel();
    private DimStyleModel dimStyle = new DimStyleModel();
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private JButton butDimTextFont;
    private JButton butTooltips;
    private JCheckBox cboClipping;
    private JCheckBox cboDimLine;
    private JCheckBox cboDimLinePattern;
    private JCheckBox cboDimSymbol;
    private JCheckBox cboDimText;
    private JCheckBox cboRefLine;
    private JCheckBox cboRefLinePattern;
    private JCheckBox cboTooltips;
    private JComboBox cmbDimSymbol;
    private JComboBox cmbLength;
    private JComboBox cmbOri;
    private JLabel lblCommonSettings;
    private JLabel lblDim;
    private JLabel lblDimLineUnit;
    private JLabel lblDimLineWidth;
    private JLabel lblDimTextDecPlaces;
    private JLabel lblDimTextSize;
    private JLabel lblDimTextUnit;
    private JLabel lblLength;
    private JLabel lblOri;
    private JLabel lblRefLineOverDim;
    private JLabel lblRefLineOverDimUnit;
    private JLabel lblRefLineWidth;
    private JLabel lblRefLineWidthUnit;
    private JLabel lblSymbolSize;
    private JLabel lblSymbolUnit;
    private JLabel lblTransparency;
    private JLabel lblUnit;
    private ColorChooserPanel pnlDimLineColor;
    private LinePatternPanel pnlDimLinePattern;
    private ColorChooserPanel pnlDimTextClipColor;
    private ColorChooserPanel pnlDimTextColor;
    private JPanel pnlDimTextSize;
    private JPanel pnlDimTextType;
    private JPanel pnlDimUnit;
    private ColorChooserPanel pnlRefLineColor;
    private JPanel pnlRefLineOverDim;
    private LinePatternPanel pnlRefLinePattern;
    private JPanel pnlRefLineWidth;
    private JPanel pnlSymbolSize;
    private TransparencyPanel pnlTransparency;
    private JPanel pnlUnit;
    private JFormattedTextField txtDimLineWidth;
    private JFormattedTextField txtDimTextDecPlaces;
    private JFormattedTextField txtDimTextSize;
    private JFormattedTextField txtRefLineOverDim;
    private JFormattedTextField txtRefLineWidth;
    private JFormattedTextField txtSymbolSize;
    private JFormattedTextField txtTransparency;

    public DimStylePanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.df.setMaximumFractionDigits(3);
        this.df.setGroupingUsed(false);
        this.sCol = _sCol;
        this.context = _context;
        this.initComponents();
        this.i18n();
        this.init();
        this.updateControls();
    }

    private void i18n() {
        this.strDegree = I18N.get("common.degree");
        this.strGon = I18N.get("common.gon");
        this.strPixel = I18N.get("common.pixel");
        this.strPoint = I18N.get("common.pt");
        this.strUnits = I18N.get("common.drawing-units");
        this.lblTransparency.setText(I18N.get("ui.style.DimStylePanel.transparency"));
        this.lblCommonSettings.setText(I18N.get("ui.style.DimStylePanel.common-settings"));
        this.cboTooltips.setText(I18N.get("ui.style.DimStylePanel.show-tooltips"));
        this.butTooltips.setText(I18N.get("ui.style.DimStylePanel.tooltip-settings"));
        this.lblUnit.setText(I18N.get("ui.style.DimStylePanel.units"));
        this.lblLength.setText(I18N.get("ui.style.DimStylePanel.length-in"));
        this.lblOri.setText(I18N.get("ui.style.DimStylePanel.angle-in"));
        this.lblDim.setText(I18N.get("ui.style.DimStylePanel.dimension"));
        this.cboDimLine.setText(I18N.get("ui.style.DimStylePanel.dim-line"));
        this.cboDimLinePattern.setText(I18N.get("ui.style.DimStylePanel.dim-line-pattern"));
        this.lblDimLineWidth.setText(I18N.get("ui.style.DimStylePanel.dim-line-width"));
        this.cboRefLine.setText(I18N.get("ui.style.DimStylePanel.ref-line"));
        this.cboRefLinePattern.setText(I18N.get("ui.style.DimStylePanel.ref-line-pattern"));
        this.lblRefLineWidth.setText(I18N.get("ui.style.DimStylePanel.ref-line-width"));
        this.lblRefLineOverDim.setText(I18N.get("ui.style.DimStylePanel.ref-line-length-over-dim"));
        this.cboDimText.setText(I18N.get("ui.style.DimStylePanel.dim-text"));
        this.butDimTextFont.setText(I18N.get("ui.style.DimStylePanel.dim-text-font"));
        this.lblDimTextDecPlaces.setText(I18N.get("ui.style.DimStylePanel.dim-text-dec-places"));
        this.lblDimTextSize.setText(I18N.get("ui.style.DimStylePanel.dim-text-size"));
        this.cboClipping.setText(I18N.get("ui.style.DimStylePanel.dim-text-clipping"));
        this.cboDimSymbol.setText(I18N.get("ui.style.DimStylePanel.dim-symbol"));
        this.bolUpdateControls = false;
        try {
            this.cmbDimSymbol.addItem(I18N.get("ui.style.DimStylePanel.dim-symbol-arrow"));
            this.cmbDimSymbol.addItem(I18N.get("ui.style.DimStylePanel.dim-symbol-line"));
            this.cmbDimSymbol.addItem(I18N.get("ui.style.DimStylePanel.dim-symbol-none"));
        }
        finally {
            this.bolUpdateControls = true;
        }
        this.lblSymbolSize.setText(I18N.get("ui.style.DimStylePanel.symbol-size"));
    }

    private void init() {
        this.bolUpdateControls = false;
        try {
            this.cboTooltips.setVisible(false);
            this.butTooltips.setVisible(false);
            this.cmbLength.addItem(this.strPixel);
            this.cmbLength.addItem(this.strUnits);
            this.cmbOri.addItem(this.strDegree);
            this.cmbOri.addItem(this.strGon);
            this.pnlTransparency.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    if (DimStylePanel.this.bolTransparencyChanging) {
                        return;
                    }
                    DimStylePanel.this.bolTransparencyChanging = true;
                    try {
                        DimStylePanel.this.changeTransparency(DimStylePanel.this.pnlTransparency.getAlpha());
                        DimStylePanel.this.txtTransparency.setText("" + (255 - DimStylePanel.this.dimStyle.getIntAlpha()));
                    }
                    finally {
                        DimStylePanel.this.bolTransparencyChanging = false;
                    }
                }
            });
            this.txtTransparency.setFormatterFactory(GUIUtil.getNumberFormat(this.nf));
            this.pnlDimLinePattern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DimStylePanel.this.dimStyle.setStrDimLinePattern(DimStylePanel.this.pnlDimLinePattern.getSelectedPattern());
                    DimStylePanel.this.updateControls();
                }
            });
            this.pnlDimLinePattern.addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DimStylePanel.this.dimStyle.setStrDimLinePattern(DimStylePanel.this.pnlDimLinePattern.getSelectedPattern());
                    DimStylePanel.this.updateControls();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DimStylePanel.this.dimStyle.setStrDimLinePattern(DimStylePanel.this.pnlDimLinePattern.getSelectedPattern());
                    DimStylePanel.this.updateControls();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DimStylePanel.this.dimStyle.setStrDimLinePattern(DimStylePanel.this.pnlDimLinePattern.getSelectedPattern());
                    DimStylePanel.this.updateControls();
                }
            });
            this.pnlRefLinePattern.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DimStylePanel.this.dimStyle.setStrRefLinePattern(DimStylePanel.this.pnlRefLinePattern.getSelectedPattern());
                    DimStylePanel.this.updateControls();
                }
            });
            this.pnlRefLinePattern.addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DimStylePanel.this.dimStyle.setStrRefLinePattern(DimStylePanel.this.pnlRefLinePattern.getSelectedPattern());
                    DimStylePanel.this.updateControls();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DimStylePanel.this.dimStyle.setStrRefLinePattern(DimStylePanel.this.pnlRefLinePattern.getSelectedPattern());
                    DimStylePanel.this.updateControls();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DimStylePanel.this.dimStyle.setStrRefLinePattern(DimStylePanel.this.pnlRefLinePattern.getSelectedPattern());
                    DimStylePanel.this.updateControls();
                }
            });
            this.txtDimLineWidth.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
            this.txtRefLineWidth.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
            this.txtRefLineOverDim.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
            this.txtDimTextSize.setFormatterFactory(GUIUtil.getNumberFormat(this.df));
            this.txtDimTextDecPlaces.setFormatterFactory(GUIUtil.getNumberFormat(this.nf));
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void changeTransparency(int _alpha) {
        this.dimStyle.setIntAlpha(_alpha);
        this.updateControls();
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        this.bolUpdateControls = false;
        try {
            this.cboTooltips.setSelected(this.dimStyle.isShowTooltips());
            if (this.dimStyle.isShowTooltips()) {
                this.butTooltips.setEnabled(true);
            } else {
                this.butTooltips.setEnabled(false);
            }
            this.pnlTransparency.getSlider().setValue(255 - this.dimStyle.getIntAlpha());
            this.cmbLength.setSelectedIndex(this.dimStyle.getLengthUnit());
            this.cmbOri.setSelectedIndex(this.dimStyle.getOriUnit());
            this.lblDimLineUnit.setText(this.cmbLength.getSelectedItem().toString());
            this.lblRefLineWidthUnit.setText(this.cmbLength.getSelectedItem().toString());
            this.lblRefLineOverDimUnit.setText(this.cmbLength.getSelectedItem().toString());
            this.lblSymbolUnit.setText(this.cmbLength.getSelectedItem().toString());
            if (this.cmbLength.getSelectedIndex() == 0) {
                this.lblDimTextUnit.setText(this.strPoint);
            } else {
                this.lblDimTextUnit.setText(this.cmbLength.getSelectedItem().toString());
            }
            this.cboDimLine.setSelected(this.dimStyle.isBolDimLine());
            this.pnlDimLineColor.setAlpha(this.dimStyle.getIntAlpha());
            this.pnlDimLineColor.setColor(RiwaJumpModelUtilities.colorByColorModel(this.dimStyle.getColorDimLine()));
            this.cboDimLinePattern.setSelected(this.dimStyle.isBolDimLinePattern());
            if (this.dimStyle.getStrDimLinePattern() != null) {
                this.pnlDimLinePattern.setSelectedPattern(this.dimStyle.getStrDimLinePattern());
            }
            this.txtDimLineWidth.setText(this.df.format(this.dimStyle.getFltDimLineWidth()));
            if (this.dimStyle.isBolDimLine()) {
                this.pnlDimLineColor.setEnabled(true);
                this.cboDimLinePattern.setEnabled(true);
                if (this.dimStyle.isBolDimLinePattern()) {
                    this.pnlDimLinePattern.setEnabled(true);
                } else {
                    this.pnlDimLinePattern.setEnabled(false);
                }
                this.txtDimLineWidth.setEnabled(true);
                this.lblDimLineWidth.setEnabled(true);
            } else {
                this.pnlDimLineColor.setEnabled(false);
                this.cboDimLinePattern.setEnabled(false);
                this.pnlDimLinePattern.setEnabled(false);
                this.txtDimLineWidth.setEnabled(false);
                this.lblDimLineWidth.setEnabled(false);
            }
            this.cboRefLine.setSelected(this.dimStyle.isBolRefLine());
            this.pnlRefLineColor.setAlpha(this.dimStyle.getIntAlpha());
            this.pnlRefLineColor.setColor(RiwaJumpModelUtilities.colorByColorModel(this.dimStyle.getColorRefLine()));
            this.cboRefLinePattern.setSelected(this.dimStyle.isBolRefLinePattern());
            if (this.dimStyle.getStrRefLinePattern() != null) {
                this.pnlRefLinePattern.setSelectedPattern(this.dimStyle.getStrRefLinePattern());
            }
            this.txtRefLineWidth.setText(this.df.format(this.dimStyle.getFltRefLineWidth()));
            this.txtRefLineOverDim.setText(this.df.format(this.dimStyle.getFltRefLineOverDim()));
            if (this.dimStyle.isBolRefLine()) {
                this.pnlRefLineColor.setEnabled(true);
                this.cboRefLinePattern.setEnabled(true);
                if (this.dimStyle.isBolRefLinePattern()) {
                    this.pnlRefLinePattern.setEnabled(true);
                } else {
                    this.pnlRefLinePattern.setEnabled(false);
                }
                this.txtRefLineWidth.setEnabled(true);
                this.lblRefLineWidth.setEnabled(true);
                this.txtRefLineOverDim.setEnabled(true);
                this.lblRefLineOverDim.setEnabled(true);
            } else {
                this.pnlRefLineColor.setEnabled(false);
                this.cboRefLinePattern.setEnabled(false);
                this.pnlRefLinePattern.setEnabled(false);
                this.txtRefLineWidth.setEnabled(false);
                this.lblRefLineWidth.setEnabled(false);
                this.txtRefLineOverDim.setEnabled(false);
                this.lblRefLineOverDim.setEnabled(false);
            }
            this.cboDimText.setSelected(this.dimStyle.isBolDimText());
            this.pnlDimTextColor.setAlpha(this.dimStyle.getIntAlpha());
            this.pnlDimTextColor.setColor(RiwaJumpModelUtilities.colorByColorModel(this.dimStyle.getColorDimText()));
            this.txtDimTextSize.setText(this.df.format(this.dimStyle.getFltDimTextHeight()));
            this.txtDimTextDecPlaces.setText(this.nf.format(this.dimStyle.getIntDimTextDecPlaces()));
            this.cboClipping.setSelected(this.dimStyle.isBolDimTextOpaque());
            this.pnlDimTextClipColor.setAlpha(this.dimStyle.getIntAlpha());
            this.pnlDimTextClipColor.setColor(RiwaJumpModelUtilities.colorByColorModel(this.dimStyle.getColorDimTextOpaque()));
            if (this.dimStyle.getFontDimText() != null) {
                this.butDimTextFont.setFont(TextRenderer.retrieveAwtFont(this.dimStyle.getFontDimText()));
            }
            if (this.dimStyle.getColorDimText() != null) {
                this.butDimTextFont.setForeground(RiwaJumpModelUtilities.colorByColorModel(this.dimStyle.getColorDimText()));
            }
            if (this.dimStyle.isBolDimText()) {
                this.butDimTextFont.setEnabled(true);
                this.pnlDimTextColor.setEnabled(true);
                this.txtDimTextSize.setEnabled(true);
                this.lblDimTextSize.setEnabled(true);
                this.txtDimTextDecPlaces.setEnabled(true);
                this.lblDimTextDecPlaces.setEnabled(true);
                this.cboClipping.setEnabled(true);
                if (this.dimStyle.isBolDimTextOpaque()) {
                    this.pnlDimTextClipColor.setEnabled(true);
                } else {
                    this.pnlDimTextClipColor.setEnabled(false);
                }
            } else {
                this.butDimTextFont.setEnabled(false);
                this.pnlDimTextColor.setEnabled(false);
                this.txtDimTextSize.setEnabled(false);
                this.lblDimTextSize.setEnabled(false);
                this.txtDimTextDecPlaces.setEnabled(false);
                this.lblDimTextDecPlaces.setEnabled(false);
                this.cboClipping.setEnabled(false);
                this.pnlDimTextClipColor.setEnabled(false);
            }
            this.cboDimSymbol.setSelected(this.dimStyle.isBolShowSymbol());
            this.cmbDimSymbol.setSelectedItem(this.dimStyle.getIntSymbolType());
            this.txtSymbolSize.setText(this.df.format(this.dimStyle.getFltSymbolSize()));
            if (this.dimStyle.isBolShowSymbol()) {
                this.cmbDimSymbol.setEnabled(true);
                this.txtSymbolSize.setEnabled(true);
            } else {
                this.cmbDimSymbol.setEnabled(false);
                this.txtSymbolSize.setEnabled(false);
            }
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    @Override
    public String validateInput() {
        try {
            if (this.getFeatureRetriever().getFeatureType().getGeometryDescriptor() == null) {
                return "No geometry attribute found.";
            }
            if (!(this.getFeatureRetriever().getFeatureType().getGeometryDescriptor().getType().getBinding().equals(MultiPoint.class) || this.getFeatureRetriever().getFeatureType().getGeometryDescriptor().getType().getBinding().equals(Geometry.class) || this.getFeatureRetriever().getFeatureType().getGeometryDescriptor().getType().getBinding().equals(GeometryCollection.class))) {
                return "Geometry attribute has wrong type. Required is MulitPoint, Geometry or GeometryCollection.";
            }
            Object notFoundTypes = "";
            for (DimFeatureAtts fatt : DimFeatureAtts.values()) {
                if (fatt.isOptional() || FeatureUtil.getAttributeDescriptor((SimpleFeatureType)this.getFeatureRetriever().getFeatureType(), (String)fatt.getName()) != null) continue;
                if (!((String)notFoundTypes).isEmpty()) {
                    notFoundTypes = (String)notFoundTypes + ", ";
                }
                notFoundTypes = (String)notFoundTypes + fatt.getName();
            }
            if (!((String)notFoundTypes).isEmpty()) {
                return String.format("<html>Attributes <b>'%s'</b> found. This attributes are need for drawing the layer.</html>", notFoundTypes);
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Error at validation of DimStylePanel", (Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.DimStylePanel.name");
    }

    @Override
    public void setStyleCollection(StyleCollection _sCol) {
        this.sCol = (LayerStyleCollection)_sCol;
        try {
            this.dimStyle = this.sCol.getStyle(DimStyleModel.class).clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new RuntimeException("Should never reach here.", cne);
        }
        this.tooltipStyle = this.dimStyle.getTooltipStyle();
        this.updateControls();
    }

    @Override
    public void updateStyles() {
        Iterator<StyleModel> iStyles = this.sCol.getStyles().iterator();
        while (iStyles.hasNext()) {
            this.sCol.removeStyle(iStyles.next());
        }
        this.dimStyle.setTooltipStyle(this.tooltipStyle);
        try {
            this.sCol.addStyle((StyleModel)this.dimStyle.clone());
        }
        catch (CloneNotSupportedException cne) {
            throw new RuntimeException("Should never reach here", cne);
        }
    }

    private void promptTooltipStyle() {
        if (this.bshTextPanel == null) {
            this.bshTextPanel = new BshTextPanel(this.getFeatureRetriever());
        }
        this.bshTextPanel.setFeatureTypeRetriever(this.getFeatureRetriever());
        this.bshTextPanel.setText(this.tooltipStyle.getStrText());
        final OKCancelPanel okCancelPanel = new OKCancelPanel();
        final JDialog dialog = new JDialog((JDialog)SwingUtilities.windowForComponent(this), I18N.get("ui.style.DimStylePanel.tooltips-title"), true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this.bshTextPanel, "Center");
        dialog.getContentPane().add((Component)okCancelPanel, "South");
        okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DimStylePanel.this.bshTextPanel.validateInput() != null && okCancelPanel.wasOKPressed()) {
                    JOptionPane.showMessageDialog(DimStylePanel.this.bshTextPanel, DimStylePanel.this.bshTextPanel.validateInput(), I18N.get("common.alert"), 0);
                } else {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.pack();
        dialog.setResizable(false);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (okCancelPanel.wasOKPressed()) {
            this.tooltipStyle = new TextStyleModel();
            this.tooltipStyle.setStrText(this.bshTextPanel.getText());
        }
        this.updateControls();
    }

    private void initComponents() {
        this.lblCommonSettings = new JLabel();
        this.pnlTransparency = new TransparencyPanel();
        this.lblTransparency = new JLabel();
        this.cboTooltips = new JCheckBox();
        this.butTooltips = new JButton();
        this.txtTransparency = new JFormattedTextField();
        this.lblUnit = new JLabel();
        this.pnlUnit = new JPanel();
        this.lblLength = new JLabel();
        this.cmbLength = new JComboBox();
        this.cmbOri = new JComboBox();
        this.lblOri = new JLabel();
        this.cboRefLinePattern = new JCheckBox();
        this.pnlRefLinePattern = new LinePatternPanel();
        this.cboDimLinePattern = new JCheckBox();
        this.pnlDimLinePattern = new LinePatternPanel();
        this.cboRefLine = new JCheckBox();
        this.cboDimText = new JCheckBox();
        this.lblRefLineWidth = new JLabel();
        this.pnlRefLineWidth = new JPanel();
        this.txtRefLineWidth = new JFormattedTextField();
        this.lblRefLineWidthUnit = new JLabel();
        this.lblRefLineOverDim = new JLabel();
        this.pnlRefLineOverDim = new JPanel();
        this.txtRefLineOverDim = new JFormattedTextField();
        this.lblRefLineOverDimUnit = new JLabel();
        this.lblDimTextSize = new JLabel();
        this.pnlDimTextSize = new JPanel();
        this.txtDimTextSize = new JFormattedTextField();
        this.lblDimTextUnit = new JLabel();
        this.lblDimLineWidth = new JLabel();
        this.pnlDimUnit = new JPanel();
        this.txtDimLineWidth = new JFormattedTextField();
        this.lblDimLineUnit = new JLabel();
        this.pnlRefLineColor = new ColorChooserPanel();
        this.pnlDimLineColor = new ColorChooserPanel();
        this.pnlDimTextClipColor = new ColorChooserPanel();
        this.lblDim = new JLabel();
        this.cboDimLine = new JCheckBox();
        this.cboClipping = new JCheckBox();
        this.cboDimSymbol = new JCheckBox();
        this.cmbDimSymbol = new JComboBox();
        this.lblSymbolSize = new JLabel();
        this.pnlSymbolSize = new JPanel();
        this.txtSymbolSize = new JFormattedTextField();
        this.lblSymbolUnit = new JLabel();
        this.pnlDimTextType = new JPanel();
        this.butDimTextFont = new JButton();
        this.pnlDimTextColor = new ColorChooserPanel();
        this.lblDimTextDecPlaces = new JLabel();
        this.txtDimTextDecPlaces = new JFormattedTextField();
        this.setLayout(new GridBagLayout());
        this.lblCommonSettings.setFont(this.lblCommonSettings.getFont().deriveFont(this.lblCommonSettings.getFont().getStyle() | 1));
        this.lblCommonSettings.setText("Allgemeine Einstellungen:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.lblCommonSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.add((Component)this.pnlTransparency, gridBagConstraints);
        this.lblTransparency.setText("Transparenz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 2, 3, 2);
        this.add((Component)this.lblTransparency, gridBagConstraints);
        this.cboTooltips.setText("Tooltips anzeigen");
        this.cboTooltips.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboTooltips.setMargin(new Insets(0, 0, 0, 0));
        this.cboTooltips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cboTooltips_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cboTooltips, gridBagConstraints);
        this.butTooltips.setText("Einstellungen");
        this.butTooltips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.butTooltips_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.add((Component)this.butTooltips, gridBagConstraints);
        this.txtTransparency.setHorizontalAlignment(4);
        this.txtTransparency.setMaximumSize(new Dimension(40, 22));
        this.txtTransparency.setMinimumSize(new Dimension(40, 22));
        this.txtTransparency.setPreferredSize(new Dimension(40, 22));
        this.txtTransparency.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DimStylePanel.this.txtTransparency_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.txtTransparency, gridBagConstraints);
        this.lblUnit.setFont(this.lblUnit.getFont().deriveFont(this.lblUnit.getFont().getStyle() | 1));
        this.lblUnit.setText("Einheiten:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblUnit, gridBagConstraints);
        this.pnlUnit.setLayout(new GridBagLayout());
        this.lblLength.setText("L\u00e4ngen in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.lblLength, gridBagConstraints);
        this.cmbLength.setMinimumSize(new Dimension(120, 20));
        this.cmbLength.setPreferredSize(new Dimension(120, 22));
        this.cmbLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cmbLength_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.cmbLength, gridBagConstraints);
        this.cmbOri.setMinimumSize(new Dimension(120, 20));
        this.cmbOri.setPreferredSize(new Dimension(120, 22));
        this.cmbOri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cmbOri_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.cmbOri, gridBagConstraints);
        this.lblOri.setText("Winkel in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.lblOri, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.pnlUnit, gridBagConstraints);
        this.cboRefLinePattern.setText("Linienmuster");
        this.cboRefLinePattern.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboRefLinePattern.setMargin(new Insets(0, 0, 0, 0));
        this.cboRefLinePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cboRefLinePattern_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.add((Component)this.cboRefLinePattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.add((Component)this.pnlRefLinePattern, gridBagConstraints);
        this.cboDimLinePattern.setText("Linienmuster");
        this.cboDimLinePattern.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboDimLinePattern.setMargin(new Insets(0, 0, 0, 0));
        this.cboDimLinePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cboDimLinePattern_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.add((Component)this.cboDimLinePattern, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.add((Component)this.pnlDimLinePattern, gridBagConstraints);
        this.cboRefLine.setFont(this.cboRefLine.getFont().deriveFont(this.cboRefLine.getFont().getStyle() | 1));
        this.cboRefLine.setText("Hilfslinie");
        this.cboRefLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboRefLine.setMargin(new Insets(0, 0, 0, 0));
        this.cboRefLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cboRefLine_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.cboRefLine, gridBagConstraints);
        this.cboDimText.setFont(this.cboDimText.getFont().deriveFont(this.cboDimText.getFont().getStyle() | 1));
        this.cboDimText.setText("Ma\u00dftext");
        this.cboDimText.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboDimText.setMargin(new Insets(0, 0, 0, 0));
        this.cboDimText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cboDimText_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.cboDimText, gridBagConstraints);
        this.lblRefLineWidth.setText("Linienbreite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.add((Component)this.lblRefLineWidth, gridBagConstraints);
        this.pnlRefLineWidth.setLayout(new FlowLayout(0));
        this.txtRefLineWidth.setHorizontalAlignment(4);
        this.txtRefLineWidth.setMaximumSize(new Dimension(40, 20));
        this.txtRefLineWidth.setMinimumSize(new Dimension(40, 20));
        this.txtRefLineWidth.setPreferredSize(new Dimension(40, 20));
        this.txtRefLineWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DimStylePanel.this.txtRefLineWidth_onFocusLost(evt);
            }
        });
        this.pnlRefLineWidth.add(this.txtRefLineWidth);
        this.lblRefLineWidthUnit.setText("unit");
        this.pnlRefLineWidth.add(this.lblRefLineWidthUnit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.pnlRefLineWidth, gridBagConstraints);
        this.lblRefLineOverDim.setText("L\u00e4nge \u00fcber Ma\u00dflinie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.add((Component)this.lblRefLineOverDim, gridBagConstraints);
        this.pnlRefLineOverDim.setLayout(new FlowLayout(0));
        this.txtRefLineOverDim.setHorizontalAlignment(4);
        this.txtRefLineOverDim.setMaximumSize(new Dimension(40, 20));
        this.txtRefLineOverDim.setMinimumSize(new Dimension(40, 20));
        this.txtRefLineOverDim.setPreferredSize(new Dimension(40, 20));
        this.txtRefLineOverDim.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DimStylePanel.this.txtRefLineOverDim_onFocusLost(evt);
            }
        });
        this.pnlRefLineOverDim.add(this.txtRefLineOverDim);
        this.lblRefLineOverDimUnit.setText("unit");
        this.pnlRefLineOverDim.add(this.lblRefLineOverDimUnit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.pnlRefLineOverDim, gridBagConstraints);
        this.lblDimTextSize.setText("Texth\u00f6he:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.add((Component)this.lblDimTextSize, gridBagConstraints);
        this.pnlDimTextSize.setLayout(new FlowLayout(0));
        this.txtDimTextSize.setHorizontalAlignment(4);
        this.txtDimTextSize.setMaximumSize(new Dimension(40, 20));
        this.txtDimTextSize.setMinimumSize(new Dimension(40, 20));
        this.txtDimTextSize.setPreferredSize(new Dimension(40, 20));
        this.txtDimTextSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DimStylePanel.this.txtDimTextSize_onFocusLost(evt);
            }
        });
        this.pnlDimTextSize.add(this.txtDimTextSize);
        this.lblDimTextUnit.setText("unit");
        this.pnlDimTextSize.add(this.lblDimTextUnit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.pnlDimTextSize, gridBagConstraints);
        this.lblDimLineWidth.setText("Linienbreite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.add((Component)this.lblDimLineWidth, gridBagConstraints);
        this.pnlDimUnit.setLayout(new FlowLayout(0));
        this.txtDimLineWidth.setHorizontalAlignment(4);
        this.txtDimLineWidth.setMaximumSize(new Dimension(40, 20));
        this.txtDimLineWidth.setMinimumSize(new Dimension(40, 20));
        this.txtDimLineWidth.setPreferredSize(new Dimension(40, 20));
        this.txtDimLineWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DimStylePanel.this.txtDimLineWidth_onFocusLost(evt);
            }
        });
        this.pnlDimUnit.add(this.txtDimLineWidth);
        this.lblDimLineUnit.setText("unit");
        this.pnlDimUnit.add(this.lblDimLineUnit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.pnlDimUnit, gridBagConstraints);
        this.pnlRefLineColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.pnlRefLineColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 5, 3, 6);
        this.add((Component)this.pnlRefLineColor, gridBagConstraints);
        this.pnlDimLineColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.pnlDimLineColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 5, 3, 6);
        this.add((Component)this.pnlDimLineColor, gridBagConstraints);
        this.pnlDimTextClipColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.pnlDimTextClipColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.add((Component)this.pnlDimTextClipColor, gridBagConstraints);
        this.lblDim.setFont(this.lblDim.getFont().deriveFont(this.lblDim.getFont().getStyle() | 1));
        this.lblDim.setText("Bema\u00dfung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.lblDim, gridBagConstraints);
        this.cboDimLine.setFont(this.cboDimLine.getFont().deriveFont(this.cboDimLine.getFont().getStyle() | 1));
        this.cboDimLine.setText("Ma\u00dflinie");
        this.cboDimLine.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboDimLine.setMargin(new Insets(0, 0, 0, 0));
        this.cboDimLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cboDimLine_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.cboDimLine, gridBagConstraints);
        this.cboClipping.setText("Freistellen");
        this.cboClipping.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboClipping.setMargin(new Insets(0, 0, 0, 0));
        this.cboClipping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cboClipping_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 10, 3, 3);
        this.add((Component)this.cboClipping, gridBagConstraints);
        this.cboDimSymbol.setFont(this.cboDimSymbol.getFont().deriveFont(this.cboDimSymbol.getFont().getStyle() | 1));
        this.cboDimSymbol.setText("Symbol");
        this.cboDimSymbol.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboDimSymbol.setMargin(new Insets(0, 0, 0, 0));
        this.cboDimSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cboDimSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.cboDimSymbol, gridBagConstraints);
        this.cmbDimSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.cmbDimSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 5, 3, 3);
        this.add((Component)this.cmbDimSymbol, gridBagConstraints);
        this.lblSymbolSize.setText("Symbolgr\u00f6\u00dfe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 3, 10);
        this.add((Component)this.lblSymbolSize, gridBagConstraints);
        this.pnlSymbolSize.setLayout(new FlowLayout(0));
        this.txtSymbolSize.setHorizontalAlignment(4);
        this.txtSymbolSize.setMaximumSize(new Dimension(40, 20));
        this.txtSymbolSize.setMinimumSize(new Dimension(40, 20));
        this.txtSymbolSize.setPreferredSize(new Dimension(40, 20));
        this.txtSymbolSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DimStylePanel.this.txtSymbolSize_onFocusLost(evt);
            }
        });
        this.pnlSymbolSize.add(this.txtSymbolSize);
        this.lblSymbolUnit.setText("unit");
        this.pnlSymbolSize.add(this.lblSymbolUnit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.pnlSymbolSize, gridBagConstraints);
        this.pnlDimTextType.setLayout(new FlowLayout(0, 5, 0));
        this.butDimTextFont.setText("Schrift...");
        this.butDimTextFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.butDimTextFont_onActionPerformed(evt);
            }
        });
        this.pnlDimTextType.add(this.butDimTextFont);
        this.pnlDimTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DimStylePanel.this.pnlDimTextColor_onActionPerformed(evt);
            }
        });
        this.pnlDimTextType.add(this.pnlDimTextColor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.add((Component)this.pnlDimTextType, gridBagConstraints);
        this.lblDimTextDecPlaces.setText("Nachkommastellen:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 3, 10);
        this.add((Component)this.lblDimTextDecPlaces, gridBagConstraints);
        this.txtDimTextDecPlaces.setHorizontalAlignment(4);
        this.txtDimTextDecPlaces.setMaximumSize(new Dimension(40, 20));
        this.txtDimTextDecPlaces.setMinimumSize(new Dimension(40, 20));
        this.txtDimTextDecPlaces.setPreferredSize(new Dimension(40, 20));
        this.txtDimTextDecPlaces.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DimStylePanel.this.txtDimTextDecPlaces_onFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 5, 3, 3);
        this.add((Component)this.txtDimTextDecPlaces, gridBagConstraints);
    }

    private void cmbDimSymbol_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setIntSymbolType(this.cmbDimSymbol.getSelectedIndex());
        this.updateControls();
    }

    private void txtDimTextDecPlaces_onFocusLost(FocusEvent evt) {
        try {
            this.dimStyle.setIntDimTextDecPlaces(this.nf.parse(this.txtDimTextDecPlaces.getText()).intValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtSymbolSize_onFocusLost(FocusEvent evt) {
        try {
            this.dimStyle.setFltSymbolSize(this.df.parse(this.txtSymbolSize.getText()).floatValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void butDimTextFont_onActionPerformed(ActionEvent evt) {
        Font newFont = FontChooser.showDialog((JDialog)SwingUtilities.windowForComponent(this), I18N.get("ui.style.TextStylePanel.change-font"), TextRenderer.retrieveAwtFont(this.dimStyle.getFontDimText()));
        if (newFont == null) {
            return;
        }
        this.dimStyle.setFontDimText(TextRenderer.retrieveFontModel(newFont));
        this.updateControls();
    }

    private void pnlDimTextClipColor_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setColorDimTextOpaque(RiwaJumpModelUtilities.colorModelByColor(this.pnlDimTextClipColor.getColor()));
        this.updateControls();
    }

    private void pnlDimTextColor_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setColorDimText(RiwaJumpModelUtilities.colorModelByColor(this.pnlDimTextColor.getColor()));
        this.updateControls();
    }

    private void cboDimSymbol_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setBolShowSymbol(this.cboDimSymbol.isSelected());
        this.updateControls();
    }

    private void cboClipping_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setBolDimTextOpaque(this.cboClipping.isSelected());
        this.updateControls();
    }

    private void pnlRefLineColor_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setColorRefLine(RiwaJumpModelUtilities.colorModelByColor(this.pnlRefLineColor.getColor()));
        this.updateControls();
    }

    private void cboDimText_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setBolDimText(this.cboDimText.isSelected());
        this.updateControls();
    }

    private void cboRefLinePattern_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setBolRefLinePattern(this.cboRefLinePattern.isSelected());
        this.updateControls();
    }

    private void cboRefLine_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setBolRefLine(this.cboRefLine.isSelected());
        this.updateControls();
    }

    private void txtDimTextSize_onFocusLost(FocusEvent evt) {
        try {
            this.dimStyle.setFltDimTextHeight(this.df.parse(this.txtDimTextSize.getText()).floatValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtRefLineOverDim_onFocusLost(FocusEvent evt) {
        try {
            this.dimStyle.setFltRefLineOverDim(this.df.parse(this.txtRefLineOverDim.getText()).floatValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtRefLineWidth_onFocusLost(FocusEvent evt) {
        try {
            this.dimStyle.setFltRefLineWidth(this.df.parse(this.txtRefLineWidth.getText()).floatValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtDimLineWidth_onFocusLost(FocusEvent evt) {
        try {
            this.dimStyle.setFltDimLineWidth(this.df.parse(this.txtDimLineWidth.getText()).floatValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void cboDimLinePattern_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setBolDimLinePattern(this.cboDimLinePattern.isSelected());
        this.updateControls();
    }

    private void pnlDimLineColor_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setColorDimLine(RiwaJumpModelUtilities.colorModelByColor(this.pnlDimLineColor.getColor()));
        this.updateControls();
    }

    private void cboDimLine_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setBolDimLine(this.cboDimLine.isSelected());
        this.updateControls();
    }

    private void cmbOri_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setOriUnit(this.cmbOri.getSelectedIndex());
        this.updateControls();
    }

    private void cmbLength_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setLengthUnit(this.cmbLength.getSelectedIndex());
        this.updateControls();
    }

    private void txtTransparency_onKeyReleased(KeyEvent evt) {
        if (this.bolTransparencyChanging) {
            return;
        }
        this.bolTransparencyChanging = true;
        try {
            int intAlpha = this.nf.parse(this.txtTransparency.getText()).intValue();
            if (intAlpha < 0) {
                intAlpha = 0;
            }
            if (intAlpha > 255) {
                intAlpha = 255;
            }
            intAlpha = 255 - intAlpha;
            this.changeTransparency(intAlpha);
            this.pnlTransparency.getSlider().setValue(255 - this.dimStyle.getIntAlpha());
        }
        catch (Exception exception) {
        }
        finally {
            this.txtTransparency.setText("" + (255 - this.dimStyle.getIntAlpha()));
            this.bolTransparencyChanging = false;
        }
    }

    private void butTooltips_onActionPerformed(ActionEvent evt) {
        this.promptTooltipStyle();
    }

    private void cboTooltips_onActionPerformed(ActionEvent evt) {
        this.dimStyle.setShowTooltips(this.cboTooltips.isSelected());
        this.butTooltips.setEnabled(this.cboTooltips.isSelected());
        this.updateControls();
    }
}

