/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemovePanel;
import com.vividsolutions.jump.workbench.ui.addremove.DefaultAddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.style.CadRenderer;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPanel;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.lang.StringComparator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CadStylePanel
extends AbstractStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(CadStylePanel.class);
    private final DecimalFormat df = new DecimalFormat();
    private String strDegree = "degree";
    private String strGon = "gon";
    private String strPixel = "pixel";
    private String strPoint = "pt";
    private String strUnits = "units";
    private LayerStyleCollection sCol;
    private PlugInContext context = null;
    private boolean bolUpdateControls = true;
    private boolean bolUpdateAddRemove = true;
    private CadStyleModel cadStyle = new CadStyleModel();
    private LinkedHashMap<String, Integer> mapDrawingLayers = new LinkedHashMap();
    private final StringComparator sComp = new StringComparator();
    private JCheckBox cboFilterDatastore;
    private JCheckBox cboLoadAllLayers;
    private JCheckBox cboTooltips;
    private JCheckBox cboUseOrderBy;
    private JComboBox cmbLengthUnit;
    private JComboBox cmbOriUnit;
    private JComboBox cmbSymbolstore;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JLabel lblLengthUnit;
    private JLabel lblMessage;
    private JLabel lblOriUnit;
    private JLabel lblSymbolstore;
    private AddRemovePanel pnlLayerActivity;
    private AddRemovePanel pnlLayerVisibility;
    private ToolboxPanel toolboxPanel;

    public CadStylePanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.df.setMaximumFractionDigits(3);
        this.df.setGroupingUsed(false);
        this.sCol = _sCol;
        this.context = _context;
        this.initComponents();
        this.i18n();
        this.init();
        this.updateControls();
    }

    private void i18n() {
        this.strDegree = I18N.get("common.degree");
        this.strGon = I18N.get("common.gon");
        this.strPixel = I18N.get("common.pixel");
        this.strPoint = I18N.get("common.pt");
        this.strUnits = I18N.get("common.drawing-units");
        this.lblLengthUnit.setText(I18N.get("ui.style.CadStylePanel.length-in"));
        this.lblOriUnit.setText(I18N.get("ui.style.CadStylePanel.ori-in"));
        this.lblSymbolstore.setText(I18N.get("ui.style.CadStylePanel.symbolstore"));
        this.cboTooltips.setText(I18N.get("ui.style.CadStylePanel.show-tooltips"));
        this.cboUseOrderBy.setText(I18N.get("ui.style.CadStylePanel.use-order-by"));
        this.cboLoadAllLayers.setText(I18N.get("ui.style.CadStylePanel.show-all-layers"));
        this.cboFilterDatastore.setText(I18N.get("ui.style.CadStylePanel.filter-datastore"));
        this.pnlLayerActivity.setLeftLabel(new JLabel(I18N.get("ui.style.CadStylePanel.inactive-layers")));
        this.pnlLayerActivity.setRightLabel(new JLabel(I18N.get("ui.style.CadStylePanel.active-layers")));
        this.pnlLayerVisibility.setLeftLabel(new JLabel(I18N.get("ui.style.CadStylePanel.invisible-layers")));
        this.pnlLayerVisibility.setRightLabel(new JLabel(I18N.get("ui.style.CadStylePanel.visible-layers")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.bolUpdateControls = false;
        try {
            this.cmbLengthUnit.addItem(this.strPixel);
            this.cmbLengthUnit.addItem(this.strUnits);
            this.cmbOriUnit.addItem(this.strDegree);
            this.cmbOriUnit.addItem(this.strGon);
            ((DefaultAddRemoveListModel)this.pnlLayerActivity.getRightList().getModel()).setSorted(true);
            ((DefaultAddRemoveListModel)this.pnlLayerActivity.getLeftList().getModel()).setSorted(true);
            ((DefaultAddRemoveListModel)this.pnlLayerVisibility.getRightList().getModel()).setSorted(true);
            ((DefaultAddRemoveListModel)this.pnlLayerVisibility.getLeftList().getModel()).setSorted(true);
            AddThemePlugIn addThemePlugIn = new AddThemePlugIn();
            this.toolboxPanel.addPlugIn(addThemePlugIn, addThemePlugIn.createEnableCheck(), addThemePlugIn.getIcon());
            DeleteThemePlugIn deleteThemePlugIn = new DeleteThemePlugIn();
            this.toolboxPanel.addPlugIn(deleteThemePlugIn, deleteThemePlugIn.createEnableCheck(), deleteThemePlugIn.getIcon());
            this.toolboxPanel.getToolBar().addSeparator(new Dimension(7, 25));
            ReloadThemesPlugIn reloadThemesPlugIn = new ReloadThemesPlugIn();
            this.toolboxPanel.addPlugIn(reloadThemesPlugIn, reloadThemesPlugIn.createEnableCheck(), reloadThemesPlugIn.getIcon());
            this.toolboxPanel.getToolBar().addSeparator(new Dimension(7, 25));
            CheckStructurePlugIn checkStructurePlugIn = new CheckStructurePlugIn();
            this.toolboxPanel.addPlugIn(checkStructurePlugIn, checkStructurePlugIn.createEnableCheck(), checkStructurePlugIn.getIcon());
            ListSelectionListener selListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    CadStylePanel.this.toolboxPanel.updateEnabledState();
                }
            };
            this.pnlLayerActivity.getLeftList().addSelectionListener(selListener);
            this.pnlLayerActivity.add(new InputChangedListener(){

                @Override
                public void inputChanged() {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (!CadStylePanel.this.bolUpdateAddRemove) {
                                return;
                            }
                            CadStylePanel.this.bolUpdateAddRemove = false;
                            try {
                                List lstItems = CadStylePanel.this.pnlLayerActivity.getRightItems();
                                List lstItemsVisi = CadStylePanel.this.pnlLayerVisibility.getRightItems();
                                for (Object item : lstItemsVisi) {
                                    if (lstItems.contains(item)) continue;
                                    CadStylePanel.this.pnlLayerVisibility.getRightList().getModel().remove(item);
                                }
                                AddRemoveListModel lstModel = CadStylePanel.this.pnlLayerVisibility.getLeftList().getModel();
                                Iterator iItem = lstModel.getItems().iterator();
                                while (iItem.hasNext()) {
                                    lstModel.remove(iItem.next());
                                }
                                lstItemsVisi = CadStylePanel.this.pnlLayerVisibility.getRightItems();
                                for (Object item : lstItems) {
                                    if (lstItemsVisi.contains(item)) continue;
                                    CadStylePanel.this.pnlLayerVisibility.getLeftList().getModel().add(item);
                                }
                                CadStylePanel.this.pnlLayerVisibility.updateEnabled();
                            }
                            finally {
                                CadStylePanel.this.bolUpdateAddRemove = true;
                            }
                        }
                    });
                }
            });
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private LinkedHashMap sortMapByKey(Map map) {
        Object[] arrObj = new Object[map.size()];
        int i = 0;
        for (Object obj : map.keySet()) {
            arrObj[i] = obj;
            ++i;
        }
        Arrays.sort(arrObj, this.sComp);
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Object obj : arrObj) {
            sortedMap.put(obj, map.get(obj));
        }
        return sortedMap;
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        this.bolUpdateControls = false;
        try {
            this.cboTooltips.setSelected(this.cadStyle.isShowTooltips());
            this.cboLoadAllLayers.setSelected(this.cadStyle.isLoadAllLayers());
            this.cboUseOrderBy.setSelected(this.cadStyle.isUseOrderBy());
            if (!this.cadStyle.isLoadAllLayers()) {
                this.cboFilterDatastore.setEnabled(true);
            } else {
                this.cboFilterDatastore.setEnabled(false);
            }
            this.cboFilterDatastore.setSelected(this.cadStyle.isUseFiltering());
            this.cmbLengthUnit.setSelectedIndex(this.cadStyle.getIntUnitLength());
            this.cmbOriUnit.setSelectedIndex(this.cadStyle.getIntUnitOri());
            this.cmbSymbolstore.setSelectedItem(this.cadStyle.getStrSymStore());
            if (this.cadStyle.isLoadAllLayers()) {
                this.pnlLayerActivity.setEnabled(false);
                this.pnlLayerVisibility.setEnabled(false);
            } else {
                this.pnlLayerActivity.setEnabled(true);
                this.pnlLayerActivity.updateEnabled();
                this.pnlLayerVisibility.setEnabled(true);
                this.pnlLayerVisibility.updateEnabled();
            }
            this.toolboxPanel.updateEnabledState();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    @Override
    public String validateInput() {
        try {
            Object[] arrError = CadFeatureAtts.checkStructure(this.getFeatureRetriever().getFeatureType());
            if (arrError != null) {
                return I18N.get("ui.style.CadStylePanel.structure-not-ok") + " " + StringUtils.join((Object[])arrError, (char)',');
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Error at validation of CadStylePanel", (Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.CadStylePanel.title");
    }

    private void clearAddRemoveList(AddRemovePanel addRemovePanel) {
        AddRemoveListModel lstModel = addRemovePanel.getLeftList().getModel();
        Iterator iItem = lstModel.getItems().iterator();
        while (iItem.hasNext()) {
            lstModel.remove(iItem.next());
        }
        lstModel = addRemovePanel.getRightList().getModel();
        iItem = lstModel.getItems().iterator();
        while (iItem.hasNext()) {
            lstModel.remove(iItem.next());
        }
    }

    private String loadDrawingLayers(final boolean clearOldList) {
        final WaitDialog dlgWait = new WaitDialog(SwingUtilities.windowForComponent(this), I18N.get("ui.style.CadStylePanel.please-wait-collection-layers"));
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SimpleFeatureType fType;
                    if (clearOldList) {
                        CadStylePanel.this.mapDrawingLayers.clear();
                    }
                    if (!FeatureUtil.hasAttributeDescriptor((SimpleFeatureType)(fType = CadStylePanel.this.getFeatureRetriever().getFeatureType()), (String)CadFeatureAtts.LAYERNAME.getName())) {
                        LOG.error("Column " + CadFeatureAtts.LAYERNAME.getName() + " not found in FeatureType.");
                        GUISupport.msgbox((Component)CadStylePanel.this, (String)(I18N.get("ui.style.CadStylePanel.attribute-not-found") + " " + CadFeatureAtts.LAYERNAME.getName()), (String)I18N.get("common.error"));
                        CadStylePanel.this.cboFilterDatastore.setEnabled(false);
                        CadStylePanel.this.cadStyle.setUseFiltering(false);
                        return;
                    }
                    CadStylePanel.this.cboFilterDatastore.setEnabled(false);
                    FeatureIterator<SimpleFeature> fi = null;
                    try {
                        fi = CadStylePanel.this.getFeatureRetriever().getFeatureIterator((Filter)Filter.INCLUDE);
                        while (fi.hasNext()) {
                            if (!dlgWait.isVisible()) {
                                if (clearOldList) {
                                    CadStylePanel.this.mapDrawingLayers.clear();
                                }
                                CadStylePanel.this.cboFilterDatastore.setEnabled(false);
                                return;
                            }
                            SimpleFeature feat = (SimpleFeature)fi.next();
                            Object objLyName = FeatureUtil.getAttribute((SimpleFeature)feat, (String)CadFeatureAtts.LAYERNAME.getName());
                            String strLyName = Objects.toString(objLyName, "");
                            if (CadStylePanel.this.mapDrawingLayers.containsKey(strLyName)) continue;
                            CadStylePanel.this.mapDrawingLayers.put(strLyName, -1);
                        }
                        CadStylePanel.this.mapDrawingLayers = CadStylePanel.this.sortMapByKey(CadStylePanel.this.mapDrawingLayers);
                    }
                    finally {
                        try {
                            fi.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    LOG.error("Error loading themes: ", (Throwable)e);
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setCancelable(true);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            return dlgWait.getError().getMessage();
        }
        return null;
    }

    private Object getModelLyName(Object strLy) {
        if (strLy.equals(CadRenderer.NO_LAYER)) {
            return "";
        }
        return strLy;
    }

    private String getViewLyName(String strLy) {
        if (strLy.trim().length() == 0) {
            return CadRenderer.NO_LAYER;
        }
        return strLy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refillDrawingLayers(boolean removeThemesNotFound) {
        this.bolUpdateAddRemove = false;
        try {
            this.clearAddRemoveList(this.pnlLayerActivity);
            this.clearAddRemoveList(this.pnlLayerVisibility);
            Iterator<String> iDLy = this.mapDrawingLayers.keySet().iterator();
            while (iDLy.hasNext()) {
                String strLy = iDLy.next();
                if (this.cadStyle.getMapLayerID().containsKey(strLy)) continue;
                this.pnlLayerActivity.getLeftList().getModel().add(this.getViewLyName(strLy));
            }
            for (String strLy : this.cadStyle.getMapLayerID().keySet()) {
                if (removeThemesNotFound) {
                    if (!this.mapDrawingLayers.containsKey(strLy)) continue;
                    this.pnlLayerActivity.getRightList().getModel().add(this.getViewLyName(strLy));
                    continue;
                }
                this.pnlLayerActivity.getRightList().getModel().add(this.getViewLyName(strLy));
            }
            Iterator<String> iNVLy = this.mapDrawingLayers.keySet().iterator();
            while (iDLy.hasNext()) {
                String strLy = iNVLy.next();
                if (this.cadStyle.getMapLayerVisi().containsKey(strLy)) continue;
                this.pnlLayerVisibility.getLeftList().getModel().add(this.getViewLyName(strLy));
            }
            for (String strLy : this.cadStyle.getMapLayerVisi().keySet()) {
                this.pnlLayerVisibility.getRightList().getModel().add(this.getViewLyName(strLy));
            }
        }
        finally {
            this.bolUpdateAddRemove = true;
        }
        this.pnlLayerActivity.updateEnabled();
        this.pnlLayerVisibility.updateEnabled();
    }

    @Override
    public void setStyleCollection(StyleCollection _sCol) {
        this.bolUpdateControls = false;
        try {
            this.sCol = (LayerStyleCollection)_sCol;
            this.cadStyle = this.sCol.getStyle(CadStyleModel.class).clone();
            this.mapDrawingLayers.clear();
            this.mapDrawingLayers.putAll(this.cadStyle.getMapLayerID());
            this.refillDrawingLayers(false);
            SMDCollection smdCol = this.getSMDCollection();
            this.cmbSymbolstore.removeAllItems();
            this.cmbSymbolstore.addItem("_buildIn");
            for (SymbolstoreMetadata smd : smdCol) {
                this.cmbSymbolstore.addItem(smd.getName());
            }
        }
        catch (CloneNotSupportedException cne) {
            throw new RuntimeException("Should never reach here.", cne);
        }
        finally {
            this.bolUpdateControls = true;
        }
        this.updateControls();
    }

    private SMDCollection getSMDCollection() {
        return this.sCol.getLayer().getLayerManager().getTask().getLocalSymbolStores();
    }

    private void setAddRemoveList2Style() {
        LinkedHashMap mapLayerID = new LinkedHashMap();
        List lstLayerID = this.pnlLayerActivity.getRightItems();
        for (Object obj : lstLayerID) {
            if (this.mapDrawingLayers.containsKey(obj = this.getModelLyName(obj))) {
                mapLayerID.put(obj, this.mapDrawingLayers.get(obj));
                continue;
            }
            if (!this.cadStyle.getMapLayerID().containsKey(obj)) continue;
            mapLayerID.put(obj, this.cadStyle.getMapLayerID().get(obj));
        }
        mapLayerID = this.sortMapByKey(mapLayerID);
        this.cadStyle.setMapLayerID((Map)mapLayerID);
        HashMap mapLayerVisi = new HashMap();
        List lstLayerVisi = this.pnlLayerVisibility.getRightItems();
        for (Object obj : lstLayerVisi) {
            if (!mapLayerID.containsKey(obj = this.getModelLyName(obj))) continue;
            mapLayerVisi.put(obj, mapLayerID.get(obj));
        }
        this.cadStyle.setMapLayerVisi(mapLayerVisi);
    }

    @Override
    public void updateStyles() {
        this.setAddRemoveList2Style();
        Iterator<StyleModel> iStyles = this.sCol.getStyles().iterator();
        while (iStyles.hasNext()) {
            this.sCol.removeStyle(iStyles.next());
        }
        try {
            this.sCol.addStyle((StyleModel)this.cadStyle.clone());
        }
        catch (CloneNotSupportedException cne) {
            throw new RuntimeException("Should never reach here.", cne);
        }
    }

    private void initComponents() {
        this.cboTooltips = new JCheckBox();
        this.pnlLayerVisibility = new AddRemovePanel();
        this.cboUseOrderBy = new JCheckBox();
        this.cboLoadAllLayers = new JCheckBox();
        this.pnlLayerActivity = new AddRemovePanel();
        this.lblMessage = new JLabel();
        this.jPanel2 = new JPanel();
        this.cmbOriUnit = new JComboBox();
        this.cmbSymbolstore = new JComboBox();
        this.cmbLengthUnit = new JComboBox();
        this.lblLengthUnit = new JLabel();
        this.lblOriUnit = new JLabel();
        this.lblSymbolstore = new JLabel();
        this.cboFilterDatastore = new JCheckBox();
        this.toolboxPanel = new ToolboxPanel();
        this.jSeparator1 = new JSeparator();
        this.setLayout(new GridBagLayout());
        this.cboTooltips.setText("Tooltips anzeigen");
        this.cboTooltips.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboTooltips.setMargin(new Insets(0, 0, 0, 0));
        this.cboTooltips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CadStylePanel.this.cboTooltips_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cboTooltips, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlLayerVisibility, gridBagConstraints);
        this.cboUseOrderBy.setText("Zeichenpriorit\u00e4t ber\u00fccksichtigen ( l\u00e4ngere Ladezeiten)");
        this.cboUseOrderBy.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboUseOrderBy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CadStylePanel.this.cboUseOrderByActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cboUseOrderBy, gridBagConstraints);
        this.cboLoadAllLayers.setText("alle Ebenen anzeigen");
        this.cboLoadAllLayers.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboLoadAllLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CadStylePanel.this.cboLoadAllLayersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cboLoadAllLayers, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlLayerActivity, gridBagConstraints);
        this.lblMessage.setForeground(new Color(255, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.lblMessage, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.cmbOriUnit.setMinimumSize(new Dimension(80, 20));
        this.cmbOriUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CadStylePanel.this.cmbOriUnitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.cmbOriUnit, gridBagConstraints);
        this.cmbSymbolstore.setMinimumSize(new Dimension(80, 20));
        this.cmbSymbolstore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CadStylePanel.this.cmbSymbolstoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.cmbSymbolstore, gridBagConstraints);
        this.cmbLengthUnit.setMinimumSize(new Dimension(80, 20));
        this.cmbLengthUnit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CadStylePanel.this.cmbLengthUnitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.cmbLengthUnit, gridBagConstraints);
        this.lblLengthUnit.setText("L\u00e4ngen in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lblLengthUnit, gridBagConstraints);
        this.lblOriUnit.setText("Winkel in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.jPanel2.add((Component)this.lblOriUnit, gridBagConstraints);
        this.lblSymbolstore.setText("Symbolquelle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.lblSymbolstore, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.cboFilterDatastore.setText("Gew\u00e4hlte Ebenen in Datenquelle filtern");
        this.cboFilterDatastore.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboFilterDatastore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CadStylePanel.this.cboFilterDatastoreActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cboFilterDatastore, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        this.add((Component)this.toolboxPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }

    private void cboTooltips_onActionPerformed(ActionEvent evt) {
        this.cadStyle.setShowTooltips(this.cboTooltips.isSelected());
        this.updateControls();
    }

    private void cboUseOrderByActionPerformed(ActionEvent evt) {
        this.cadStyle.setUseOrderBy(this.cboUseOrderBy.isSelected());
        this.updateControls();
    }

    private void cboLoadAllLayersActionPerformed(ActionEvent evt) {
        this.cadStyle.setLoadAllLayers(this.cboLoadAllLayers.isSelected());
        if (this.cboLoadAllLayers.isSelected()) {
            this.cadStyle.setUseFiltering(false);
        }
        this.updateControls();
    }

    private void cmbLengthUnitActionPerformed(ActionEvent evt) {
        this.cadStyle.setIntUnitLength(this.cmbLengthUnit.getSelectedIndex());
    }

    private void cmbOriUnitActionPerformed(ActionEvent evt) {
        this.cadStyle.setIntUnitOri(this.cmbOriUnit.getSelectedIndex());
    }

    private void cmbSymbolstoreActionPerformed(ActionEvent evt) {
        if (!this.bolUpdateControls) {
            return;
        }
        if (this.cmbSymbolstore.getSelectedItem() == null) {
            this.cadStyle.setStrSymStore(null);
        } else {
            this.cadStyle.setStrSymStore(this.cmbSymbolstore.getSelectedItem().toString());
        }
    }

    private void cboFilterDatastoreActionPerformed(ActionEvent evt) {
        this.cadStyle.setUseFiltering(this.cboFilterDatastore.isSelected());
    }

    private class AddThemePlugIn
    extends AbstractPlugIn {
        private AddThemePlugIn() {
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            String strNewTheme = GUISupport.inputbox((Component)CadStylePanel.this, (String)I18N.get("ui.style.CadStylePanel.insert-theme-name"), (String)this.getName(), (String)"");
            if (strNewTheme == null) {
                return true;
            }
            if (strNewTheme.trim().isEmpty() || CadStylePanel.this.pnlLayerActivity.getLeftItems().contains(strNewTheme) || CadStylePanel.this.pnlLayerActivity.getRightItems().contains(strNewTheme)) {
                GUISupport.msgbox((Component)CadStylePanel.this, (String)I18N.get("ui.style.CadStylePanel.insert-theme-name-invalid"), (String)I18N.get("common.error"));
                return true;
            }
            CadStylePanel.this.mapDrawingLayers.put(strNewTheme, -1);
            CadStylePanel.this.sortMapByKey(CadStylePanel.this.mapDrawingLayers);
            CadStylePanel.this.cadStyle.addMapLayerID(strNewTheme, Integer.valueOf(-1));
            CadStylePanel.this.pnlLayerActivity.getLeftList().getModel().add(strNewTheme);
            return true;
        }

        @Override
        public ImageIcon getIcon() {
            return IconLoader.svgIcon((String)"layer_add.svg");
        }

        @Override
        public String getName() {
            return I18N.get("ui.style.CadStylePanel.add-theme");
        }

        @Override
        public EnableCheck createEnableCheck() {
            return component -> {
                if (CadStylePanel.this.cboLoadAllLayers.isSelected()) {
                    return "All layers are loaded.";
                }
                return null;
            };
        }
    }

    private class DeleteThemePlugIn
    extends AbstractPlugIn {
        private DeleteThemePlugIn() {
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            boolean delete = GUISupport.yesnobox((Component)CadStylePanel.this, (String)I18N.get("ui.style.CadStylePanel.delete-theme-confirm"), (String)I18N.get("common.alert"));
            if (delete) {
                ArrayList lstThemes2Delete = new ArrayList(CadStylePanel.this.pnlLayerActivity.getLeftList().getSelectedItems());
                lstThemes2Delete.addAll(CadStylePanel.this.pnlLayerActivity.getRightList().getSelectedItems());
                for (String strTheme : lstThemes2Delete) {
                    CadStylePanel.this.mapDrawingLayers.remove(strTheme);
                }
                CadStylePanel.this.refillDrawingLayers(true);
            }
            return true;
        }

        @Override
        public ImageIcon getIcon() {
            return IconLoader.svgIcon((String)"layer_delete_theme.svg");
        }

        @Override
        public String getName() {
            return I18N.get("ui.style.CadStylePanel.delete-theme");
        }

        @Override
        public EnableCheck createEnableCheck() {
            return component -> {
                if (CadStylePanel.this.pnlLayerActivity.getLeftList().getSelectedItems().isEmpty()) {
                    return "Please select item in list";
                }
                return null;
            };
        }
    }

    private class ReloadThemesPlugIn
    extends AbstractPlugIn {
        private ReloadThemesPlugIn() {
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            boolean bolClearOldThemes = GUISupport.yesnobox((Component)CadStylePanel.this, (String)I18N.get("ui.style.CadStylePanel.reload-themes-remove-not-found"), (String)I18N.get("common.alert"));
            String strError = CadStylePanel.this.loadDrawingLayers(bolClearOldThemes);
            if (strError != null) {
                GUISupport.msgbox((Component)CadStylePanel.this, (String)("Error loading drawing layers: " + strError), (String)I18N.get("common.error"));
            }
            CadStylePanel.this.setAddRemoveList2Style();
            CadStylePanel.this.refillDrawingLayers(true);
            CadStylePanel.this.updateControls();
            return true;
        }

        @Override
        public ImageIcon getIcon() {
            return IconLoader.svgIcon((String)"layer_fill.svg");
        }

        @Override
        public String getName() {
            return I18N.get("ui.style.CadStylePanel.reload-themes");
        }

        @Override
        public EnableCheck createEnableCheck() {
            return component -> {
                if (CadStylePanel.this.cboLoadAllLayers.isSelected()) {
                    return "All layers are loaded.";
                }
                return null;
            };
        }
    }

    private class CheckStructurePlugIn
    extends AbstractPlugIn {
        private CheckStructurePlugIn() {
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            Object[] arrError = CadFeatureAtts.checkStructure(CadStylePanel.this.getFeatureRetriever().getFeatureType());
            if (arrError == null) {
                GUISupport.msgbox((Component)CadStylePanel.this, (String)I18N.get("ui.style.CadStylePanel.structure-ok"), (String)I18N.get("common.message"));
            } else {
                GUISupport.msgbox((Component)CadStylePanel.this, (String)(I18N.get("ui.style.CadStylePanel.structure-not-ok") + " " + StringUtils.join((Object[])arrError, (char)',')), (String)I18N.get("common.error"));
            }
            return true;
        }

        @Override
        public ImageIcon getIcon() {
            return IconLoader.svgIcon((String)"layer_above.svg");
        }

        @Override
        public String getName() {
            return I18N.get("ui.style.CadStylePanel.check-structure");
        }

        @Override
        public EnableCheck createEnableCheck() {
            return new EnableCheck(this){

                @Override
                public String check(JComponent component) {
                    return null;
                }
            };
        }
    }
}

