/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.style.AttributePanel;
import com.vividsolutions.jump.workbench.ui.style.EmptyFeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.opengis.feature.simple.SimpleFeatureType;

public class BshTextPanel
extends JPanel {
    private String strTitle = "Tooltips";
    private String strErrorAt = "Error at";
    private boolean bolUpdateControls = true;
    private String strText = "";
    private final List<ActionListener> lstListener = new ArrayList<ActionListener>();
    private FeatureRetriever ftRetriever = null;
    private AttributePanel attributePanel1;
    private JLabel lblText;
    private JScrollPane scrText;
    private JTextArea txtText;

    public BshTextPanel() {
        this(EmptyFeatureRetriever.instanceOf());
    }

    public BshTextPanel(FeatureRetriever _ftRetriever) {
        this.ftRetriever = _ftRetriever;
        this.initComponents();
        this.i18n();
        this.init();
    }

    public void addActionListener(ActionListener listener) {
        if (!this.lstListener.contains(listener)) {
            this.lstListener.add(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.lstListener.remove(listener);
    }

    private void fireActionEvent() {
        ActionEvent evt = new ActionEvent(this, 0, "BeanShell changed");
        for (ActionListener listener : this.lstListener) {
            listener.actionPerformed(evt);
        }
    }

    private void i18n() {
        this.strTitle = I18N.get("ui.style.BshTextPanel.title");
        this.strErrorAt = I18N.get("ui.style.BshTextPanel.error-at");
        this.lblText.setText(I18N.get("ui.style.BshTextPanel.text"));
    }

    private void init() {
        this.attributePanel1.addTextComponent(this.txtText);
        this.updateControls();
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        this.bolUpdateControls = false;
        try {
            this.txtText.setText(this.strText);
        }
        finally {
            this.bolUpdateControls = true;
        }
        this.fireActionEvent();
    }

    public String getTitle() {
        return this.strTitle;
    }

    public final void setFeatureTypeRetriever(FeatureRetriever _ftRetriever) {
        this.ftRetriever = _ftRetriever;
        if (this.ftRetriever == null) {
            this.ftRetriever = EmptyFeatureRetriever.instanceOf();
        }
        this.attributePanel1.fillAttributes(this.ftRetriever.getFeatureType());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.txtText.setEnabled(enabled);
        this.lblText.setEnabled(enabled);
        this.attributePanel1.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.txtText.isEnabled();
    }

    public void setText(String _strText) {
        this.strText = _strText != null ? _strText : "";
        this.updateControls();
        this.txtText_onKeyReleased(null);
        this.fireActionEvent();
    }

    public String getText() {
        return this.strText;
    }

    public String validateInput() {
        SimpleFeatureType fSchema = this.ftRetriever.getFeatureType();
        String strError = FeatBshValidator.validateTextExpression((String)this.strText, (SimpleFeatureType)fSchema);
        if (strError != null) {
            return this.strErrorAt + " " + this.lblText.getText() + " " + strError;
        }
        return strError;
    }

    private void initComponents() {
        this.lblText = new JLabel();
        this.scrText = new JScrollPane();
        this.txtText = new JTextArea();
        this.attributePanel1 = new AttributePanel();
        this.setLayout(new GridBagLayout());
        this.lblText.setText("Text:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 0, 3);
        this.add((Component)this.lblText, gridBagConstraints);
        this.scrText.setMinimumSize(new Dimension(24, 40));
        this.scrText.setPreferredSize(new Dimension(300, 150));
        this.txtText.setColumns(20);
        this.txtText.setFont(this.lblText.getFont());
        this.txtText.setRows(5);
        this.txtText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BshTextPanel.this.txtText_onFocusLost(evt);
            }
        });
        this.txtText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BshTextPanel.this.txtText_onKeyReleased(evt);
            }
        });
        this.scrText.setViewportView(this.txtText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 9, 9, 3);
        this.add((Component)this.scrText, gridBagConstraints);
        this.attributePanel1.setMinimumSize(new Dimension(110, 38));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 9, 9);
        this.add((Component)this.attributePanel1, gridBagConstraints);
    }

    private void txtText_onFocusLost(FocusEvent evt) {
        this.strText = this.txtText.getText();
        this.updateControls();
    }

    private void txtText_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateTextExpression((String)this.txtText.getText(), (SimpleFeatureType)this.ftRetriever.getFeatureType()) == null) {
            this.txtText.setForeground(Color.GREEN.darker());
        } else {
            this.txtText.setForeground(Color.RED.darker());
        }
        this.strText = this.txtText.getText();
        this.fireActionEvent();
    }
}

