/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStyleTransPanel
extends AbstractStylePanel
implements BasicStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(BasicStyleTransPanel.class);
    private String strErrorAt = "Error at";
    private LayerStyleCollection sCol;
    private PlugInContext context = null;
    private boolean bolUpdateControls = true;
    private boolean bolUseAlphaArea = true;
    private boolean bolUseAlphaLine = true;
    private boolean bolUseAlphaText = true;
    private boolean bolUseAlphaSymbol = true;
    private int alpha = 205;
    private NumberFormat nf = NumberFormat.getIntegerInstance();
    private boolean bolTransparencyChanging = false;
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code != 27 && code == 10) {
                BasicStyleTransPanel.this.updateControls();
            }
        }
    };
    private JCheckBox cboTransArea;
    private JCheckBox cboTransLine;
    private JCheckBox cboTransSymbol;
    private JCheckBox cboTransText;
    private JPanel pnlAlphaAreaLine;
    private JPanel pnlFiller;
    private JPanel pnlTransparency;
    private TransparencyPanel transparencyPanel;
    private JFormattedTextField txtTransparency;

    public BasicStyleTransPanel() {
        this.initComponents();
    }

    public BasicStyleTransPanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.bolUpdateControls = false;
        try {
            this.context = _context;
            this.initComponents();
            this.i18n();
            this.init();
            this.setStyleCollection(_sCol);
            this.updateControls();
            GUISupport.addKeyListenersRecursively((Component)this, (KeyListener)this.keyListener);
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void i18n() {
        this.cboTransArea.setText(I18N.get("ui.style.BasicStyleTransPanel.trancparency-area"));
        this.cboTransLine.setText(I18N.get("ui.style.BasicStyleTransPanel.trancparency-line"));
        this.cboTransText.setText(I18N.get("ui.style.BasicStyleTransPanel.trancparency-text"));
        this.cboTransSymbol.setText(I18N.get("ui.style.BasicStyleTransPanel.trancparency-symbol"));
        ((TitledBorder)this.pnlTransparency.getBorder()).setTitle(I18N.get("ui.style.BasicStyleTransPanel.transparency"));
    }

    public final void init() {
        this.transparencyPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (BasicStyleTransPanel.this.bolTransparencyChanging) {
                    return;
                }
                BasicStyleTransPanel.this.bolTransparencyChanging = true;
                try {
                    BasicStyleTransPanel.this.changeTransparency(BasicStyleTransPanel.this.transparencyPanel.getAlpha());
                    BasicStyleTransPanel.this.txtTransparency.setText("" + (255 - BasicStyleTransPanel.this.alpha));
                }
                finally {
                    BasicStyleTransPanel.this.bolTransparencyChanging = false;
                }
            }
        });
        this.txtTransparency.setFormatterFactory(GUIUtil.getNumberFormat(this.nf));
        this.txtTransparency.setColumns(3);
        this.txtTransparency.setHorizontalAlignment(4);
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        try {
            this.bolUpdateControls = false;
            this.transparencyPanel.getSlider().setValue(255 - this.alpha);
            this.cboTransArea.setSelected(this.bolUseAlphaArea);
            this.cboTransLine.setSelected(this.bolUseAlphaLine);
            this.cboTransText.setSelected(this.bolUseAlphaText);
            this.cboTransSymbol.setSelected(this.bolUseAlphaSymbol);
            if (this.sCol.getLayerable() instanceof LabelLayer) {
                this.cboTransLine.setSelected(false);
                this.cboTransLine.setEnabled(false);
                this.cboTransArea.setSelected(false);
                this.cboTransArea.setEnabled(false);
            } else {
                this.cboTransLine.setEnabled(true);
                this.cboTransArea.setEnabled(true);
            }
            this.setEnabledState();
            this.fireStyleChanged();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void setEnabledState() {
    }

    private void changeTransparency(int _alpha) {
        this.alpha = _alpha;
        this.fireStyleChanged();
    }

    @Override
    public void setTransparency(int _alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
        this.alpha = _alpha;
        this.bolUseAlphaArea = bolArea;
        this.bolUseAlphaLine = bolLine;
        this.bolUseAlphaText = bolText;
        this.bolUseAlphaSymbol = bolSymbol;
        this.updateControls();
    }

    @Override
    public void updateBasicStyle(BasicStyleModel basicStyle) {
        basicStyle.setIntAlpha(this.alpha);
        basicStyle.setBolUseAlphaArea(this.bolUseAlphaArea);
        basicStyle.setBolUseAlphaLine(this.bolUseAlphaLine);
        basicStyle.setBolUseAlphaText(this.bolUseAlphaText);
        basicStyle.setBolUseAlphaSymbol(this.bolUseAlphaSymbol);
    }

    @Override
    public boolean isStyleActive() {
        return this.bolUseAlphaArea || this.bolUseAlphaLine || this.bolUseAlphaSymbol || this.bolUseAlphaText;
    }

    @Override
    public void setBasicStyle(BasicStyleModel basicStyle) {
        this.alpha = basicStyle.getIntAlpha();
        this.bolUseAlphaArea = basicStyle.isBolUseAlphaArea();
        this.bolUseAlphaLine = basicStyle.isBolUseAlphaLine();
        this.bolUseAlphaText = basicStyle.isBolUseAlphaText();
        this.bolUseAlphaSymbol = basicStyle.isBolUseAlphaSymbol();
        this.updateControls();
    }

    @Override
    public String validateInput() {
        return null;
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.BasicStyleTransPanel.title");
    }

    @Override
    public final void setStyleCollection(StyleCollection _sCol) {
        boolean useTheming;
        this.sCol = (LayerStyleCollection)_sCol;
        BasicStyleModel bStyle = this.sCol.getBasicStyle();
        boolean bl = useTheming = !this.sCol.getBasicStyle().isEnabled();
        if (useTheming) {
            ColorThemingStyleModel thStyle = ColorThemingRenderer.get(this.sCol);
            bStyle = thStyle.getDefaultStyle();
        }
        this.setBasicStyle(bStyle);
    }

    @Override
    public void updateStyles() {
        throw new UnsupportedOperationException();
    }

    private void initComponents() {
        this.pnlTransparency = new JPanel();
        this.transparencyPanel = new TransparencyPanel();
        this.txtTransparency = new JFormattedTextField();
        this.pnlAlphaAreaLine = new JPanel();
        this.cboTransArea = new JCheckBox();
        this.cboTransLine = new JCheckBox();
        this.cboTransText = new JCheckBox();
        this.cboTransSymbol = new JCheckBox();
        this.pnlFiller = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pnlTransparency.setBorder(BorderFactory.createTitledBorder("Transparenz"));
        this.pnlTransparency.setMinimumSize(new Dimension(425, 95));
        this.pnlTransparency.setPreferredSize(new Dimension(425, 95));
        this.pnlTransparency.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlTransparency.add((Component)this.transparencyPanel, gridBagConstraints);
        this.txtTransparency.setColumns(3);
        this.txtTransparency.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleTransPanel.this.txtTransparency_onFocusLost(evt);
            }
        });
        this.txtTransparency.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleTransPanel.this.txtTransparency_onKeyReleased(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                BasicStyleTransPanel.this.txtTransparency_onKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlTransparency.add((Component)this.txtTransparency, gridBagConstraints);
        this.pnlAlphaAreaLine.setLayout(new GridBagLayout());
        this.cboTransArea.setText("auf Fl\u00e4chen anwenden");
        this.cboTransArea.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboTransArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleTransPanel.this.cboTransAreaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlAlphaAreaLine.add((Component)this.cboTransArea, gridBagConstraints);
        this.cboTransLine.setText("auf Linien anwenden");
        this.cboTransLine.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboTransLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleTransPanel.this.cboTransLineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlAlphaAreaLine.add((Component)this.cboTransLine, gridBagConstraints);
        this.cboTransText.setText("auf Texte anwenden");
        this.cboTransText.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboTransText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleTransPanel.this.cboTransTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlAlphaAreaLine.add((Component)this.cboTransText, gridBagConstraints);
        this.cboTransSymbol.setText("auf Symbole anwenden");
        this.cboTransSymbol.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.cboTransSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleTransPanel.this.cboTransSymbolActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAlphaAreaLine.add((Component)this.cboTransSymbol, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlTransparency.add((Component)this.pnlAlphaAreaLine, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.pnlTransparency, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFiller, gridBagConstraints);
    }

    private void txtTransparency_onFocusLost(FocusEvent evt) {
    }

    private void txtTransparency_onKeyReleased(KeyEvent evt) {
        if (this.bolTransparencyChanging) {
            return;
        }
        this.bolTransparencyChanging = true;
        try {
            int intAlpha = this.nf.parse(this.txtTransparency.getText()).intValue();
            if (intAlpha < 0) {
                intAlpha = 0;
            }
            if (intAlpha > 255) {
                intAlpha = 255;
            }
            intAlpha = 255 - intAlpha;
            this.changeTransparency(intAlpha);
            this.transparencyPanel.getSlider().setValue(255 - this.alpha);
        }
        catch (Exception exception) {
        }
        finally {
            this.txtTransparency.setText("" + (255 - this.alpha));
            this.bolTransparencyChanging = false;
        }
    }

    private void txtTransparency_onKeyTyped(KeyEvent evt) {
    }

    private void cboTransAreaActionPerformed(ActionEvent evt) {
        this.bolUseAlphaArea = this.cboTransArea.isSelected();
        this.changeTransparency(this.alpha);
        this.updateControls();
    }

    private void cboTransLineActionPerformed(ActionEvent evt) {
        this.bolUseAlphaLine = this.cboTransLine.isSelected();
        this.changeTransparency(this.alpha);
        this.updateControls();
    }

    private void cboTransTextActionPerformed(ActionEvent evt) {
        this.bolUseAlphaText = this.cboTransText.isSelected();
        this.changeTransparency(this.alpha);
        this.updateControls();
    }

    private void cboTransSymbolActionPerformed(ActionEvent evt) {
        this.bolUseAlphaSymbol = this.cboTransSymbol.isSelected();
        this.changeTransparency(this.alpha);
        this.updateControls();
    }
}

