/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.BshTextPanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStyleTooltipPanel
extends AbstractStylePanel
implements BasicStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(BasicStyleTooltipPanel.class);
    private LayerStyleCollection sCol;
    private PlugInContext context = null;
    private boolean bolUpdateControls = true;
    private boolean useTooltips = false;
    private boolean useUrls = false;
    private String strTooltip = "";
    private String strURL = "";
    private JCheckBox cboTooltips;
    private JCheckBox cboUrl;
    private BshTextPanel pnlTooltip;
    private BshTextPanel pnlUrl;

    public BasicStyleTooltipPanel() {
        this.initComponents();
    }

    public BasicStyleTooltipPanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.bolUpdateControls = false;
        try {
            this.context = _context;
            this.initComponents();
            this.i18n();
            this.init();
            this.setStyleCollection(_sCol);
            this.updateControls();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void i18n() {
        this.cboTooltips.setText(I18N.get("ui.style.BasicStyleTooltipPanel.tooltips"));
        this.cboUrl.setText(I18N.get("ui.style.BasicStyleTooltipPanel.urls"));
    }

    public final void init() {
        this.pnlTooltip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicStyleTooltipPanel.this.strTooltip = BasicStyleTooltipPanel.this.pnlTooltip.getText();
            }
        });
        this.pnlUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicStyleTooltipPanel.this.strURL = BasicStyleTooltipPanel.this.pnlUrl.getText();
            }
        });
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        try {
            this.bolUpdateControls = false;
            this.cboTooltips.setSelected(this.useTooltips);
            this.cboUrl.setSelected(this.useUrls);
            this.pnlTooltip.setText(ObjectUtils.toString((Object)this.strTooltip));
            this.pnlUrl.setText(ObjectUtils.toString((Object)this.strURL));
            this.setEnabledState();
            this.fireStyleChanged();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void setEnabledState() {
        this.pnlTooltip.setEnabled(this.useTooltips);
        this.pnlUrl.setEnabled(this.useUrls);
    }

    @Override
    public void updateBasicStyle(BasicStyleModel basicStyle) {
        basicStyle.setShowTooltips(this.useTooltips);
        basicStyle.setUseUrl(this.useUrls);
        if (this.useTooltips) {
            TextStyleModel tooltipStyle = new TextStyleModel();
            tooltipStyle.setStrText(this.strTooltip);
            basicStyle.setTooltipStyle(tooltipStyle);
        } else {
            basicStyle.setTooltipStyle(null);
        }
        if (this.useUrls) {
            basicStyle.setUrl(this.strURL);
        } else {
            basicStyle.setUrl(null);
        }
    }

    @Override
    public boolean isStyleActive() {
        return this.useTooltips || this.useUrls;
    }

    @Override
    public void setBasicStyle(BasicStyleModel basicStyle) {
        this.useTooltips = basicStyle.isShowTooltips();
        this.strTooltip = this.useTooltips && basicStyle.getTooltipStyle() != null ? ObjectUtils.toString((Object)basicStyle.getTooltipStyle().getStrText()) : "";
        this.useUrls = basicStyle.isUseUrl();
        this.strURL = this.useUrls ? ObjectUtils.toString((Object)basicStyle.getUrl()) : "";
        this.updateControls();
    }

    @Override
    public String validateInput() {
        try {
            String strError;
            StringBuilder sbError = new StringBuilder();
            if (this.useTooltips && (strError = this.pnlTooltip.validateInput()) != null) {
                sbError.append(strError);
            }
            if (this.useUrls && (strError = this.pnlUrl.validateInput()) != null) {
                if (sbError.length() > 0) {
                    sbError.append("\n");
                }
                sbError.append(strError);
            }
            if (sbError.length() > 0) {
                return sbError.toString();
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Error at validation of TooltipStylePanel", (Throwable)e);
            return e.getMessage();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.BasicStyleTooltipPanel.title");
    }

    @Override
    public final void setStyleCollection(StyleCollection _sCol) {
        this.sCol = (LayerStyleCollection)_sCol;
        this.setBasicStyle(this.sCol.getBasicStyle());
    }

    @Override
    public void setFeatureRetriever(FeatureRetriever featureTypeRetriever) {
        super.setFeatureRetriever(featureTypeRetriever);
        this.pnlTooltip.setFeatureTypeRetriever(this.getFeatureRetriever());
        this.pnlUrl.setFeatureTypeRetriever(this.getFeatureRetriever());
    }

    @Override
    public void updateStyles() {
        throw new UnsupportedOperationException();
    }

    private void initComponents() {
        this.pnlUrl = new BshTextPanel();
        this.pnlTooltip = new BshTextPanel();
        this.cboUrl = new JCheckBox();
        this.cboTooltips = new JCheckBox();
        this.setPreferredSize(new Dimension(400, 426));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.pnlUrl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.add((Component)this.pnlTooltip, gridBagConstraints);
        this.cboUrl.setText("URL aufrufen");
        this.cboUrl.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboUrl.setMargin(new Insets(0, 0, 0, 0));
        this.cboUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleTooltipPanel.this.cboUrl_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 8, 0, 3);
        this.add((Component)this.cboUrl, gridBagConstraints);
        this.cboTooltips.setText("Tooltips anzeigen");
        this.cboTooltips.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboTooltips.setMargin(new Insets(0, 0, 0, 0));
        this.cboTooltips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleTooltipPanel.this.cboTooltips_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 8, 0, 3);
        this.add((Component)this.cboTooltips, gridBagConstraints);
    }

    private void cboUrl_onActionPerformed(ActionEvent evt) {
        this.useUrls = this.cboUrl.isSelected();
        this.updateControls();
    }

    private void cboTooltips_onActionPerformed(ActionEvent evt) {
        this.useTooltips = this.cboTooltips.isSelected();
        this.updateControls();
    }

    @Override
    public void setTransparency(int _alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
    }
}

