/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.renderer.style.DefaultLegendLabelRenderer;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class BasicStyleListCellRenderer<T>
implements ListCellRenderer<T> {
    private DefaultLegendLabelRenderer llRenderer = new DefaultLegendLabelRenderer();
    private Icon previewIcon = null;
    private StyleCollection sCol = null;
    private JLabel previewLabel = new JLabel(){
        Dimension defaultSize = new Dimension(0, 0);

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (BasicStyleListCellRenderer.this.previewIcon == null) {
                return this.defaultSize;
            }
            return new Dimension(BasicStyleListCellRenderer.this.previewIcon.getIconWidth(), BasicStyleListCellRenderer.this.previewIcon.getIconHeight());
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            BasicStyleListCellRenderer.this.previewIcon.paintIcon(this, g, 0, 0);
        }
    };
    private final DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setFont(this.getFont().deriveFont(10.0f));
            return label;
        }
    };

    public void initialize(StyleCollection sCol) {
        this.sCol = sCol;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof String) {
            return this.defaultListCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        BasicStyleModel basicStyle = (BasicStyleModel)value;
        this.previewIcon = this.sCol == null ? null : this.llRenderer.getImage(this.sCol, (StyleModel)basicStyle);
        this.previewLabel.setOpaque(isSelected);
        if (isSelected) {
            this.previewLabel.setBackground(list.getSelectionBackground());
        }
        return this.previewLabel;
    }
}

