/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanelWithDB;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.style.AbstractPalettePanel;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.jump.workbench.ui.style.AttributePanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.ListPalettePanel;
import de.riwagis.geotools.feature.bsh.FeatBshValidator;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.LineStyleModel;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.gui.SymbolListDialog;
import de.riwagis.riwajump.symbol.model.SMDCollection;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.ObjectUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStyleLineAreaPanel
extends AbstractStylePanel
implements BasicStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(BasicStyleLineAreaPanel.class);
    private DecimalFormat df = new DecimalFormat();
    private LayerStyleCollection sCol;
    private PlugInContext context = null;
    private boolean bolUpdateControls = true;
    private boolean bolUseAlphaArea = true;
    private boolean bolUseAlphaLine = true;
    private boolean bolUseAlphaText = true;
    private boolean bolUseAlphaSymbol = true;
    private int alpha = 205;
    private ColorModel fillColor = ColorModel.RED;
    private boolean bolRenderFill = false;
    private boolean bolRenderFillPattern = false;
    private String lineBasePattern;
    private ColorModel lineBaseColor = ColorModel.RED;
    private String strLineBaseWidth = "1.0";
    private boolean bolRenderLineBase = false;
    private boolean bolRenderLineBasePattern = false;
    private String lineForegroundPattern;
    private ColorModel lineForegroundColor = ColorModel.RED;
    private String strLineForegroundWidth = "1.0";
    private boolean bolRenderLineForeground = false;
    private boolean bolRenderLineForegroundPattern = false;
    private String lineBackgroundPattern;
    private ColorModel lineBackgroundColor = ColorModel.RED;
    private String strLineBackgroundWidth = "1.0";
    private boolean bolRenderLineBackground = false;
    private boolean bolRenderLineBackgroundPattern = false;
    private String strFillSymWidth = "10";
    private String strFillSymStore = null;
    private String strFillSymName = null;
    private boolean bolFillOverwrite = true;
    private String strPixel = "pixel";
    private String strUnits = "units";
    private String strGon = "gon";
    private String strDegree = "degree";
    private int intLengthUnit = 0;
    private int intOriUnit = 0;
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            if (code != 27 && code == 10) {
                BasicStyleLineAreaPanel.this.updateControls();
            }
        }
    };
    private AttributePanel attPanel;
    private JPanel attPrevPanel;
    private JButton butSymbol;
    private JCheckBox cboFill;
    private JCheckBox cboFillPattern;
    private JCheckBox cboLineBackground;
    private JCheckBox cboLineBackgroundPattern;
    private JCheckBox cboLineBase;
    private JCheckBox cboLineBasePattern;
    private JCheckBox cboLineForeground;
    private JCheckBox cboLineForegroundPattern;
    private JCheckBox cboOverwrite;
    private JComboBox cmbLength;
    private JComboBox cmbOri;
    private JComboBox cmbSymbolSource;
    private ColorChooserPanelWithDB colorModelChooserLineBackground;
    private ColorChooserPanelWithDB colorModelChooserLineBase;
    private ColorChooserPanelWithDB colorModelChooserLineForeground;
    private ColorChooserPanelWithDB colorModelChooserPanelArea;
    private JLabel lblDefaults;
    private JLabel lblLength;
    private JLabel lblLengthUnitLineBackground;
    private JLabel lblLengthUnitLineBase;
    private JLabel lblLengthUnitLineForeground;
    private JLabel lblLineBackgroundWidth;
    private JLabel lblLineBaseWidth;
    private JLabel lblLineForegroundWidth;
    private JLabel lblOri;
    private JLabel lblSymbol;
    private JLabel lblSymbolSource;
    private JLabel lblWidth;
    private JPanel panelDefaults;
    private JPanel pnlFill;
    private JPanel pnlLineBackground;
    private JPanel pnlLineBase;
    private JPanel pnlLineForeground;
    private JPanel pnlUnit;
    private JTabbedPane tabPaneLines;
    private JTextField txtLineBackgroundPattern;
    private JFormattedTextField txtLineBackgroundWidth;
    private JTextField txtLineBasePattern;
    private JFormattedTextField txtLineBaseWidth;
    private JTextField txtLineForegroundPattern;
    private JFormattedTextField txtLineForegroundWidth;
    private JTextField txtSymbol;
    private JFormattedTextField txtWidth;

    public BasicStyleLineAreaPanel() {
        this.initComponents();
    }

    public BasicStyleLineAreaPanel(LayerStyleCollection _sCol, PlugInContext _context) {
        this.bolUpdateControls = false;
        try {
            this.df.setMaximumFractionDigits(3);
            this.df.setGroupingUsed(false);
            this.context = _context;
            this.initComponents();
            this.i18n();
            this.init();
            this.setStyleCollection(_sCol);
            this.updateControls();
            GUISupport.addKeyListenersRecursively((Component)this, (KeyListener)this.keyListener);
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void i18n() {
        this.strPixel = I18N.get("common.pixel");
        this.strUnits = I18N.get("common.drawing-units");
        this.strGon = I18N.get("common.gon");
        this.strDegree = I18N.get("common.degree");
        ((TitledBorder)this.pnlUnit.getBorder()).setTitle(I18N.get("ui.style.BasicStyleLineAreaPanel.units"));
        ((TitledBorder)this.pnlFill.getBorder()).setTitle(I18N.get("ui.style.BasicStyleLineAreaPanel.header-area"));
        this.lblLength.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.length-in"));
        this.lblOri.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.ori-in"));
        this.cboFill.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.fill"));
        this.cboFillPattern.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.fill-pattern"));
        this.lblSymbolSource.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.symbolsource"));
        this.lblSymbol.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.symbol"));
        this.lblWidth.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.width"));
        this.cboOverwrite.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.overwrite"));
        this.tabPaneLines.setTitleAt(0, I18N.get("ui.style.BasicStyleLineAreaPanel.linebase"));
        this.tabPaneLines.setTitleAt(1, I18N.get("ui.style.BasicStyleLineAreaPanel.lineforeground"));
        this.tabPaneLines.setTitleAt(2, I18N.get("ui.style.BasicStyleLineAreaPanel.linebackground"));
        this.cboLineBase.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-show"));
        this.lblLineBaseWidth.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-width"));
        this.cboLineBasePattern.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-pattern"));
        this.cboLineForeground.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-show"));
        this.lblLineForegroundWidth.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-width"));
        this.cboLineForegroundPattern.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-pattern"));
        this.cboLineBackground.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-show"));
        this.lblLineBackgroundWidth.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-width"));
        this.cboLineBackgroundPattern.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.line-pattern"));
        this.lblDefaults.setText(I18N.get("ui.style.BasicStyleLineAreaPanel.presets"));
    }

    public final void init() {
        this.cmbLength.addItem(this.strPixel);
        this.cmbLength.addItem(this.strUnits);
        this.cmbOri.addItem(this.strDegree);
        this.cmbOri.addItem(this.strGon);
        this.colorModelChooserPanelArea.setStylePanel(this);
        this.colorModelChooserLineBase.setStylePanel(this);
        this.colorModelChooserLineBackground.setStylePanel(this);
        this.colorModelChooserLineForeground.setStylePanel(this);
        ((AbstractPalettePanel)this.panelDefaults).add(new AbstractPalettePanel.Listener(){

            @Override
            public void basicStyleChosen(BasicStyleModel basicStyle) {
                BasicStyleLineAreaPanel.this.fillColor = basicStyle.getFillColor();
                BasicStyleLineAreaPanel.this.bolRenderFill = basicStyle.isRenderingFill();
                boolean bl = BasicStyleLineAreaPanel.this.bolRenderLineBase = basicStyle.getLineBase() != null;
                if (BasicStyleLineAreaPanel.this.bolRenderLineBase) {
                    BasicStyleLineAreaPanel.this.strLineBaseWidth = basicStyle.getLineBase().getLineWidth();
                    BasicStyleLineAreaPanel.this.lineBaseColor = basicStyle.getLineBase().getLineColor();
                }
                BasicStyleLineAreaPanel.this.updateControls();
            }
        });
        this.attPanel.addTextComponent(this.txtLineBasePattern);
        this.attPanel.addTextComponent(this.txtLineBaseWidth);
        this.attPanel.addTextComponent(this.txtSymbol);
        this.attPanel.addTextComponent(this.txtWidth);
        this.attPanel.addTextComponent(this.colorModelChooserPanelArea.getInternalTextComponent(), true);
        this.attPanel.addTextComponent(this.colorModelChooserLineBase.getInternalTextComponent(), true);
        this.attPanel.addTextComponent(this.colorModelChooserLineForeground.getInternalTextComponent(), true);
        this.attPanel.addTextComponent(this.colorModelChooserLineBackground.getInternalTextComponent(), true);
        this.colorModelChooserLineBase.getInternalColorChooser().getComponentPopupMenu().addSeparator();
        JMenuItem miSyncLineBaseColor = new JMenuItem(I18N.get("ui.style.BasicStyleLineAreaPanel.sync-line-color-with-fill-color"));
        miSyncLineBaseColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicStyleLineAreaPanel.this.lineBaseColor = RiwaJumpModelUtilities.colorModelByColor(RiwaJumpModelUtilities.colorByColorModel(BasicStyleLineAreaPanel.this.fillColor).darker());
                BasicStyleLineAreaPanel.this.updateControls();
            }
        });
        this.colorModelChooserLineBase.getInternalColorChooser().getComponentPopupMenu().add(miSyncLineBaseColor);
        this.colorModelChooserLineForeground.getInternalColorChooser().getComponentPopupMenu().addSeparator();
        JMenuItem miSyncLineForegroundColor = new JMenuItem(I18N.get("ui.style.BasicStyleLineAreaPanel.sync-line-color-with-fill-color"));
        miSyncLineForegroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicStyleLineAreaPanel.this.lineForegroundColor = RiwaJumpModelUtilities.colorModelByColor(RiwaJumpModelUtilities.colorByColorModel(BasicStyleLineAreaPanel.this.fillColor).darker());
                BasicStyleLineAreaPanel.this.updateControls();
            }
        });
        this.colorModelChooserLineForeground.getInternalColorChooser().getComponentPopupMenu().add(miSyncLineForegroundColor);
        this.colorModelChooserLineBackground.getInternalColorChooser().getComponentPopupMenu().addSeparator();
        JMenuItem miSyncLineBackgroundColor = new JMenuItem(I18N.get("ui.style.BasicStyleLineAreaPanel.sync-line-color-with-fill-color"));
        miSyncLineBackgroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicStyleLineAreaPanel.this.lineBackgroundColor = RiwaJumpModelUtilities.colorModelByColor(RiwaJumpModelUtilities.colorByColorModel(BasicStyleLineAreaPanel.this.fillColor).darker());
                BasicStyleLineAreaPanel.this.updateControls();
            }
        });
        this.colorModelChooserLineBackground.getInternalColorChooser().getComponentPopupMenu().add(miSyncLineBackgroundColor);
    }

    private void updateControls() {
        if (!this.bolUpdateControls) {
            return;
        }
        try {
            this.bolUpdateControls = false;
            this.cmbLength.setSelectedIndex(this.intLengthUnit);
            this.cmbOri.setSelectedIndex(this.intOriUnit);
            this.lblLengthUnitLineBase.setText(this.cmbLength.getSelectedItem().toString());
            this.lblLengthUnitLineBackground.setText(this.cmbLength.getSelectedItem().toString());
            this.lblLengthUnitLineForeground.setText(this.cmbLength.getSelectedItem().toString());
            ((AbstractPalettePanel)this.panelDefaults).setAlpha(this.alpha, this.bolUseAlphaArea, this.bolUseAlphaLine);
            if (this.bolUseAlphaArea) {
                this.colorModelChooserPanelArea.setAlpha(this.alpha);
            } else {
                this.colorModelChooserPanelArea.setAlpha(255);
            }
            this.colorModelChooserPanelArea.setColorModel(this.fillColor);
            if (this.bolUseAlphaLine) {
                this.colorModelChooserLineBase.setAlpha(this.alpha);
                this.colorModelChooserLineForeground.setAlpha(this.alpha);
                this.colorModelChooserLineBackground.setAlpha(this.alpha);
            } else {
                this.colorModelChooserLineBase.setAlpha(255);
                this.colorModelChooserLineForeground.setAlpha(255);
                this.colorModelChooserLineBackground.setAlpha(255);
            }
            this.colorModelChooserLineBase.setColorModel(this.lineBaseColor);
            this.cboLineBase.setSelected(this.bolRenderLineBase);
            this.cboLineBasePattern.setSelected(this.bolRenderLineBasePattern);
            this.txtLineBasePattern.setText(ObjectUtils.toString((Object)this.lineBasePattern));
            this.txtLineBaseWidth.setText(this.strLineBaseWidth);
            this.colorModelChooserLineForeground.setColorModel(this.lineForegroundColor);
            this.cboLineForeground.setSelected(this.bolRenderLineForeground);
            this.cboLineForegroundPattern.setSelected(this.bolRenderLineForegroundPattern);
            this.txtLineForegroundPattern.setText(ObjectUtils.toString((Object)this.lineForegroundPattern));
            this.txtLineForegroundWidth.setText(this.strLineForegroundWidth);
            this.colorModelChooserLineBackground.setColorModel(this.lineBackgroundColor);
            this.cboLineBackground.setSelected(this.bolRenderLineBackground);
            this.cboLineBackgroundPattern.setSelected(this.bolRenderLineBackgroundPattern);
            this.txtLineBackgroundPattern.setText(ObjectUtils.toString((Object)this.lineBackgroundPattern));
            this.txtLineBackgroundWidth.setText(this.strLineBackgroundWidth);
            this.cboFill.setSelected(this.bolRenderFill);
            this.cboFillPattern.setSelected(this.bolRenderFillPattern);
            this.txtWidth.setText(this.strFillSymWidth);
            this.cboOverwrite.setSelected(this.bolFillOverwrite);
            this.cmbSymbolSource.setSelectedItem(this.strFillSymStore);
            this.txtSymbol.setText(this.strFillSymName);
            BasicStyleModel prevBasStyle = new BasicStyleModel();
            this.updateBasicStyle(prevBasStyle);
            RenderUtil.getRenderer(prevBasStyle).initialize(this.sCol);
            this.setEnabledState();
            this.fireStyleChanged();
        }
        finally {
            this.bolUpdateControls = true;
        }
    }

    private void setEnabledState() {
        if (!this.cboFill.isSelected()) {
            this.colorModelChooserPanelArea.setEnabled(false);
            this.cboFillPattern.setEnabled(false);
            this.enableFill(false);
        } else {
            this.colorModelChooserPanelArea.setEnabled(true);
            this.cboFillPattern.setEnabled(true);
            if (!this.cboFillPattern.isSelected()) {
                this.enableFill(false);
            } else {
                this.enableFill(true);
            }
        }
        if (!this.cboLineBase.isSelected()) {
            this.colorModelChooserLineBase.setEnabled(false);
            this.cboLineBasePattern.setEnabled(false);
            this.txtLineBaseWidth.setEnabled(false);
            this.txtLineBasePattern.setEnabled(false);
            this.lblLineBaseWidth.setEnabled(false);
            this.tabPaneLines.setEnabledAt(1, false);
            this.tabPaneLines.setEnabledAt(2, false);
        } else {
            this.colorModelChooserLineBase.setEnabled(true);
            this.cboLineBasePattern.setEnabled(true);
            this.txtLineBaseWidth.setEnabled(true);
            if (!this.cboLineBasePattern.isSelected()) {
                this.txtLineBasePattern.setEnabled(false);
            } else {
                this.txtLineBasePattern.setEnabled(true);
            }
            this.lblLineBaseWidth.setEnabled(true);
            this.tabPaneLines.setEnabledAt(1, true);
            this.tabPaneLines.setEnabledAt(2, true);
        }
        if (!this.cboLineForeground.isSelected()) {
            this.colorModelChooserLineForeground.setEnabled(false);
            this.cboLineForegroundPattern.setEnabled(false);
            this.txtLineForegroundWidth.setEnabled(false);
            this.txtLineForegroundPattern.setEnabled(false);
            this.lblLineForegroundWidth.setEnabled(false);
        } else {
            this.colorModelChooserLineForeground.setEnabled(true);
            this.cboLineForegroundPattern.setEnabled(true);
            this.txtLineForegroundWidth.setEnabled(true);
            if (!this.cboLineForegroundPattern.isSelected()) {
                this.txtLineForegroundPattern.setEnabled(false);
            } else {
                this.txtLineForegroundPattern.setEnabled(true);
            }
            this.lblLineForegroundWidth.setEnabled(true);
        }
        if (!this.cboLineBackground.isSelected()) {
            this.colorModelChooserLineBackground.setEnabled(false);
            this.cboLineBackgroundPattern.setEnabled(false);
            this.txtLineBackgroundWidth.setEnabled(false);
            this.txtLineBackgroundPattern.setEnabled(false);
            this.lblLineBackgroundWidth.setEnabled(false);
        } else {
            this.colorModelChooserLineBackground.setEnabled(true);
            this.cboLineBackgroundPattern.setEnabled(true);
            this.txtLineBackgroundWidth.setEnabled(true);
            if (!this.cboLineBackgroundPattern.isSelected()) {
                this.txtLineBackgroundPattern.setEnabled(false);
            } else {
                this.txtLineBackgroundPattern.setEnabled(true);
            }
            this.lblLineBackgroundWidth.setEnabled(true);
        }
        if (!(this.cboLineBase.isSelected() || this.cboLineForeground.isSelected() || this.cboLineBackground.isSelected() || this.cboFill.isSelected())) {
            this.panelDefaults.setEnabled(false);
            this.lblDefaults.setEnabled(false);
        } else {
            this.panelDefaults.setEnabled(true);
            this.lblDefaults.setEnabled(true);
        }
    }

    private void enableFill(boolean bolEnable) {
        this.lblSymbolSource.setEnabled(bolEnable);
        this.cmbSymbolSource.setEnabled(bolEnable);
        this.lblSymbol.setEnabled(bolEnable);
        this.txtSymbol.setEnabled(bolEnable);
        this.butSymbol.setEnabled(bolEnable);
        this.lblWidth.setEnabled(bolEnable);
        this.txtWidth.setEnabled(bolEnable);
        this.cboOverwrite.setEnabled(bolEnable);
    }

    @Override
    public void setTransparency(int _alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
        this.alpha = _alpha;
        this.bolUseAlphaArea = bolArea;
        this.bolUseAlphaLine = bolLine;
        this.bolUseAlphaText = bolText;
        this.bolUseAlphaSymbol = bolSymbol;
        this.updateControls();
    }

    @Override
    public void updateBasicStyle(BasicStyleModel basicStyle) {
        basicStyle.setFillColor(this.fillColor);
        basicStyle.setIntAlpha(this.alpha);
        basicStyle.setBolUseAlphaArea(this.bolUseAlphaArea);
        basicStyle.setBolUseAlphaLine(this.bolUseAlphaLine);
        basicStyle.setBolUseAlphaText(this.bolUseAlphaText);
        basicStyle.setBolUseAlphaSymbol(this.bolUseAlphaSymbol);
        if (this.bolRenderLineBase) {
            LineStyleModel lineBaseModel = new LineStyleModel();
            lineBaseModel.setLineColor(this.lineBaseColor);
            lineBaseModel.setRenderingLinePattern(this.bolRenderLineBasePattern);
            if (this.lineBasePattern != null) {
                lineBaseModel.setLinePattern(this.lineBasePattern);
            }
            lineBaseModel.setLineWidth(this.strLineBaseWidth);
            basicStyle.setLineBase(lineBaseModel);
        } else {
            basicStyle.setLineBase(null);
        }
        if (this.bolRenderLineForeground) {
            LineStyleModel lineForegroundModel = new LineStyleModel();
            lineForegroundModel.setLineColor(this.lineForegroundColor);
            lineForegroundModel.setRenderingLinePattern(this.bolRenderLineForegroundPattern);
            if (this.lineForegroundPattern != null) {
                lineForegroundModel.setLinePattern(this.lineForegroundPattern);
            }
            lineForegroundModel.setLineWidth(this.strLineForegroundWidth);
            basicStyle.setLineForeground(lineForegroundModel);
        } else {
            basicStyle.setLineForeground(null);
        }
        if (this.bolRenderLineBackground) {
            LineStyleModel lineBackgroundModel = new LineStyleModel();
            lineBackgroundModel.setLineColor(this.lineBackgroundColor);
            lineBackgroundModel.setRenderingLinePattern(this.bolRenderLineBackgroundPattern);
            if (this.lineBackgroundPattern != null) {
                lineBackgroundModel.setLinePattern(this.lineBackgroundPattern);
            }
            lineBackgroundModel.setLineWidth(this.strLineBackgroundWidth);
            basicStyle.setLineBackground(lineBackgroundModel);
        } else {
            basicStyle.setLineBackground(null);
        }
        basicStyle.setRenderingFill(this.bolRenderFill);
        basicStyle.setRenderingFillPattern(this.bolRenderFillPattern);
        basicStyle.setStrFillSymStore(this.strFillSymStore);
        basicStyle.setStrFillSymName(this.strFillSymName);
        basicStyle.setFillSymWidth(this.strFillSymWidth);
        basicStyle.setBolFillSymColorOverwrite(this.bolFillOverwrite);
        basicStyle.setLengthUnit(this.intLengthUnit);
        basicStyle.setOriUnit(this.intOriUnit);
        basicStyle.setLengthUnit(this.intLengthUnit);
        basicStyle.setOriUnit(this.intOriUnit);
        basicStyle.cleanUp();
    }

    @Override
    public boolean isStyleActive() {
        return this.bolRenderFill || this.bolRenderLineBase;
    }

    @Override
    public void setBasicStyle(BasicStyleModel basicStyle) {
        this.fillColor = basicStyle.getFillColor();
        this.bolRenderFill = basicStyle.isRenderingFill();
        boolean bl = this.bolRenderLineBase = basicStyle.getLineBase() != null;
        if (this.bolRenderLineBase) {
            this.lineBaseColor = basicStyle.getLineBase().getLineColor();
            this.strLineBaseWidth = basicStyle.getLineBase().getLineWidth();
            this.bolRenderLineBasePattern = basicStyle.getLineBase().isRenderingLinePattern();
            this.lineBasePattern = basicStyle.getLineBase().getLinePattern();
        } else {
            this.lineBaseColor = ColorModel.RED;
            this.strLineBaseWidth = "1";
            this.bolRenderLineBasePattern = false;
            this.lineBasePattern = "3";
        }
        boolean bl2 = this.bolRenderLineForeground = basicStyle.getLineForeground() != null;
        if (this.bolRenderLineForeground) {
            this.lineForegroundColor = basicStyle.getLineForeground().getLineColor();
            this.strLineForegroundWidth = basicStyle.getLineForeground().getLineWidth();
            this.bolRenderLineForegroundPattern = basicStyle.getLineForeground().isRenderingLinePattern();
            this.lineForegroundPattern = basicStyle.getLineForeground().getLinePattern();
        } else {
            this.lineForegroundColor = ColorModel.RED;
            this.strLineForegroundWidth = "1";
            this.bolRenderLineForegroundPattern = false;
            this.lineForegroundPattern = "3";
        }
        boolean bl3 = this.bolRenderLineBackground = basicStyle.getLineBackground() != null;
        if (this.bolRenderLineBackground) {
            this.lineBackgroundColor = basicStyle.getLineBackground().getLineColor();
            this.strLineBackgroundWidth = basicStyle.getLineBackground().getLineWidth();
            this.bolRenderLineBackgroundPattern = basicStyle.getLineBackground().isRenderingLinePattern();
            this.lineBackgroundPattern = basicStyle.getLineBackground().getLinePattern();
        } else {
            this.lineBackgroundColor = ColorModel.RED;
            this.strLineBackgroundWidth = "1";
            this.bolRenderLineBackgroundPattern = false;
            this.lineBackgroundPattern = "3";
        }
        this.alpha = basicStyle.getIntAlpha();
        this.bolUseAlphaArea = basicStyle.isBolUseAlphaArea();
        this.bolUseAlphaLine = basicStyle.isBolUseAlphaLine();
        this.bolUseAlphaText = basicStyle.isBolUseAlphaText();
        this.bolUseAlphaSymbol = basicStyle.isBolUseAlphaSymbol();
        this.bolRenderFillPattern = basicStyle.isRenderingFillPattern();
        this.strFillSymName = basicStyle.getStrFillSymName();
        this.strFillSymStore = basicStyle.getStrFillSymStore();
        this.strFillSymWidth = basicStyle.getFillSymWidth();
        this.bolFillOverwrite = basicStyle.isBolFillSymColorOverwrite();
        this.intLengthUnit = basicStyle.getLengthUnit();
        this.intOriUnit = basicStyle.getOriUnit();
        this.updateControls();
    }

    private SMDCollection getSMDCollection() {
        return this.sCol.getLayer().getLayerManager().getTask().getLocalSymbolStores();
    }

    private SymbolListDialog getSymList() {
        SymbolListDialog dlgSymList = null;
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent instanceof Frame) {
            dlgSymList = new SymbolListDialog((Frame)parent, true);
        }
        if (parent instanceof Dialog) {
            dlgSymList = new SymbolListDialog((Dialog)parent, true);
        }
        GUIUtil.centreOnScreen(dlgSymList);
        return dlgSymList;
    }

    @Override
    public String validateInput() {
        try {
            SimpleFeatureType fSchema = this.getFeatureRetriever().getFeatureType();
            String strError = null;
            strError = FeatBshValidator.validateTextExpression((String)this.strFillSymName, (SimpleFeatureType)fSchema);
            if (strError != null) {
                return this.getErrorMessageWithDetails(this.strFillSymName, strError);
            }
            strError = FeatBshValidator.validateCalcExpression((String)this.strFillSymWidth, (SimpleFeatureType)fSchema);
            if (strError != null) {
                return this.getErrorMessageWithDetails(this.strFillSymWidth, strError);
            }
            strError = FeatBshValidator.validateTextExpression((String)this.lineBasePattern, (SimpleFeatureType)fSchema);
            if (strError != null) {
                return this.getErrorMessageWithDetails(this.lineBasePattern, strError);
            }
            strError = FeatBshValidator.validateCalcExpression((String)this.strLineBaseWidth, (SimpleFeatureType)fSchema);
            if (strError != null) {
                return this.getErrorMessageWithDetails(this.strLineBaseWidth, strError);
            }
            strError = FeatBshValidator.validateTextExpression((String)this.lineForegroundPattern, (SimpleFeatureType)fSchema);
            if (strError != null) {
                return this.getErrorMessageWithDetails(this.lineForegroundPattern, strError);
            }
            strError = FeatBshValidator.validateCalcExpression((String)this.strLineForegroundWidth, (SimpleFeatureType)fSchema);
            if (strError != null) {
                return this.getErrorMessageWithDetails(this.strLineForegroundWidth, strError);
            }
            strError = FeatBshValidator.validateTextExpression((String)this.lineBackgroundPattern, (SimpleFeatureType)fSchema);
            if (strError != null) {
                return this.getErrorMessageWithDetails(this.lineBackgroundPattern, strError);
            }
            strError = FeatBshValidator.validateCalcExpression((String)this.strLineBackgroundWidth, (SimpleFeatureType)fSchema);
            if (strError != null) {
                return this.getErrorMessageWithDetails(this.strLineBackgroundWidth, strError);
            }
            if (this.fillColor != null && (strError = FeatBshValidator.validateTextExpression((String)this.fillColor.getBsh(), (SimpleFeatureType)fSchema)) != null) {
                return this.getErrorMessageWithDetails(this.fillColor.getBsh(), strError);
            }
            if (this.lineBaseColor != null && (strError = FeatBshValidator.validateTextExpression((String)this.lineBaseColor.getBsh(), (SimpleFeatureType)fSchema)) != null) {
                return this.getErrorMessageWithDetails(this.lineBaseColor.getBsh(), strError);
            }
            if (this.lineForegroundColor != null && (strError = FeatBshValidator.validateTextExpression((String)this.lineForegroundColor.getBsh(), (SimpleFeatureType)fSchema)) != null) {
                return this.getErrorMessageWithDetails(this.lineForegroundColor.getBsh(), strError);
            }
            if (this.lineBackgroundColor != null && (strError = FeatBshValidator.validateTextExpression((String)this.lineBackgroundColor.getBsh(), (SimpleFeatureType)fSchema)) != null) {
                return this.getErrorMessageWithDetails(this.lineBackgroundColor.getBsh(), strError);
            }
            return strError;
        }
        catch (Exception e) {
            LOG.warn("Error at validation of VectorStylePanel", (Throwable)e);
            return e.getMessage();
        }
    }

    private String getErrorMessageWithDetails(String expression, String errorMessage) {
        return I18N.getMessage("ui.style.BasicStyleLineAreaPanel.validation.invalid-expression", expression, errorMessage.trim());
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.style.BasicStyleLineAreaPanel.header-linearea");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setStyleCollection(StyleCollection _sCol) {
        this.bolUpdateControls = false;
        try {
            this.sCol = (LayerStyleCollection)_sCol;
            SMDCollection smdCol = this.getSMDCollection();
            this.cmbSymbolSource.removeAllItems();
            this.cmbSymbolSource.addItem("_buildIn");
            for (SymbolstoreMetadata smd : smdCol) {
                this.cmbSymbolSource.addItem(smd.getName());
            }
            this.setBasicStyle(this.sCol.getBasicStyle());
        }
        finally {
            this.bolUpdateControls = true;
        }
        this.updateControls();
    }

    @Override
    public void setFeatureRetriever(FeatureRetriever featureTypeRetriever) {
        super.setFeatureRetriever(featureTypeRetriever);
        this.attPanel.fillAttributes(this.getFeatureRetriever().getFeatureType());
    }

    @Override
    public void updateStyles() {
        throw new UnsupportedOperationException();
    }

    private void initComponents() {
        this.pnlUnit = new JPanel();
        this.lblLength = new JLabel();
        this.cmbLength = new JComboBox();
        this.cmbOri = new JComboBox();
        this.lblOri = new JLabel();
        this.pnlFill = new JPanel();
        this.cboFill = new JCheckBox();
        this.cboFillPattern = new JCheckBox();
        this.lblSymbolSource = new JLabel();
        this.cmbSymbolSource = new JComboBox();
        this.lblSymbol = new JLabel();
        this.txtSymbol = new JTextField();
        this.butSymbol = new JButton();
        this.lblWidth = new JLabel();
        this.txtWidth = new JFormattedTextField();
        this.cboOverwrite = new JCheckBox();
        this.colorModelChooserPanelArea = new ColorChooserPanelWithDB();
        this.attPrevPanel = new JPanel();
        this.attPanel = new AttributePanel();
        this.lblDefaults = new JLabel();
        this.panelDefaults = new ListPalettePanel(22);
        this.tabPaneLines = new JTabbedPane();
        this.pnlLineBase = new JPanel();
        this.lblLineBaseWidth = new JLabel();
        this.cboLineBase = new JCheckBox();
        this.cboLineBasePattern = new JCheckBox();
        this.txtLineBasePattern = new JTextField();
        this.txtLineBaseWidth = new JFormattedTextField();
        this.lblLengthUnitLineBase = new JLabel();
        this.colorModelChooserLineBase = new ColorChooserPanelWithDB();
        this.pnlLineForeground = new JPanel();
        this.lblLineForegroundWidth = new JLabel();
        this.cboLineForeground = new JCheckBox();
        this.cboLineForegroundPattern = new JCheckBox();
        this.txtLineForegroundPattern = new JTextField();
        this.txtLineForegroundWidth = new JFormattedTextField();
        this.lblLengthUnitLineForeground = new JLabel();
        this.colorModelChooserLineForeground = new ColorChooserPanelWithDB();
        this.pnlLineBackground = new JPanel();
        this.lblLineBackgroundWidth = new JLabel();
        this.cboLineBackground = new JCheckBox();
        this.cboLineBackgroundPattern = new JCheckBox();
        this.txtLineBackgroundPattern = new JTextField();
        this.txtLineBackgroundWidth = new JFormattedTextField();
        this.lblLengthUnitLineBackground = new JLabel();
        this.colorModelChooserLineBackground = new ColorChooserPanelWithDB();
        this.setLayout(new GridBagLayout());
        this.pnlUnit.setBorder(BorderFactory.createTitledBorder("Einheiten"));
        this.pnlUnit.setLayout(new GridBagLayout());
        this.lblLength.setText("L\u00e4ngen in:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.lblLength, gridBagConstraints);
        this.cmbLength.setMinimumSize(new Dimension(120, 20));
        this.cmbLength.setPreferredSize(new Dimension(120, 22));
        this.cmbLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cmbLength_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.cmbLength, gridBagConstraints);
        this.cmbOri.setMinimumSize(new Dimension(120, 20));
        this.cmbOri.setPreferredSize(new Dimension(120, 22));
        this.cmbOri.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cmbOri_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.cmbOri, gridBagConstraints);
        this.lblOri.setText("Winkel in:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlUnit.add((Component)this.lblOri, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.add((Component)this.pnlUnit, gridBagConstraints);
        this.pnlFill.setBorder(BorderFactory.createTitledBorder("Fl\u00e4chen"));
        this.pnlFill.setLayout(new GridBagLayout());
        this.cboFill.setText("F\u00fcllen");
        this.cboFill.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboFill.setMargin(new Insets(0, 0, 0, 0));
        this.cboFill.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboFill_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(9, 7, 3, 2);
        this.pnlFill.add((Component)this.cboFill, gridBagConstraints);
        this.cboFillPattern.setText("F\u00fcllmuster");
        this.cboFillPattern.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboFillPattern.setMargin(new Insets(0, 0, 0, 0));
        this.cboFillPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboFillPatter_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 15, 3, 10);
        this.pnlFill.add((Component)this.cboFillPattern, gridBagConstraints);
        this.lblSymbolSource.setText("Symbolquelle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.pnlFill.add((Component)this.lblSymbolSource, gridBagConstraints);
        this.cmbSymbolSource.setEditable(true);
        this.cmbSymbolSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cmbSymbolSource_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 0);
        this.pnlFill.add((Component)this.cmbSymbolSource, gridBagConstraints);
        this.lblSymbol.setText("Symbol:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 3, 3, 3);
        this.pnlFill.add((Component)this.lblSymbol, gridBagConstraints);
        this.txtSymbol.setColumns(15);
        this.txtSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleLineAreaPanel.this.txtSymbol_onFocusLost(evt);
            }
        });
        this.txtSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleLineAreaPanel.this.txtSymbol_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.pnlFill.add((Component)this.txtSymbol, gridBagConstraints);
        this.butSymbol.setText("...");
        this.butSymbol.setMargin(new Insets(0, 2, 0, 2));
        this.butSymbol.setPreferredSize(new Dimension(22, 22));
        this.butSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.butSymbol_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 2, 3, 3);
        this.pnlFill.add((Component)this.butSymbol, gridBagConstraints);
        this.lblWidth.setText("Breite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 3, 3, 3);
        this.pnlFill.add((Component)this.lblWidth, gridBagConstraints);
        this.txtWidth.setColumns(15);
        this.txtWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleLineAreaPanel.this.txtWidth_onFocusLost(evt);
            }
        });
        this.txtWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleLineAreaPanel.this.txtWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.pnlFill.add((Component)this.txtWidth, gridBagConstraints);
        this.cboOverwrite.setText("Farben \u00fcberschreiben");
        this.cboOverwrite.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboOverwrite.setMargin(new Insets(0, 0, 0, 0));
        this.cboOverwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboOverwrite_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlFill.add((Component)this.cboOverwrite, gridBagConstraints);
        this.colorModelChooserPanelArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.colorModelChooserPanelAreaActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.pnlFill.add((Component)this.colorModelChooserPanelArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.add((Component)this.pnlFill, gridBagConstraints);
        this.attPrevPanel.setLayout(new GridBagLayout());
        this.attPanel.setMinimumSize(new Dimension(100, 38));
        this.attPanel.setPreferredSize(new Dimension(100, 146));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 11, 2, 2);
        this.attPrevPanel.add((Component)this.attPanel, gridBagConstraints);
        this.lblDefaults.setText("Vorgaben");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 15;
        this.attPrevPanel.add((Component)this.lblDefaults, gridBagConstraints);
        this.panelDefaults.setBackground(new Color(255, 255, 255));
        this.panelDefaults.setMinimumSize(new Dimension(50, 60));
        this.panelDefaults.setPreferredSize(new Dimension(80, 100));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 11, 4, 6);
        this.attPrevPanel.add((Component)this.panelDefaults, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.attPrevPanel, gridBagConstraints);
        this.pnlLineBase.setLayout(new GridBagLayout());
        this.lblLineBaseWidth.setText("Linienbreite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 15, 3, 10);
        this.pnlLineBase.add((Component)this.lblLineBaseWidth, gridBagConstraints);
        this.cboLineBase.setText("anzeigen");
        this.cboLineBase.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboLineBase.setMargin(new Insets(0, 0, 0, 0));
        this.cboLineBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboLineBase_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 7, 3, 2);
        this.pnlLineBase.add((Component)this.cboLineBase, gridBagConstraints);
        this.cboLineBasePattern.setText("Linienmuster");
        this.cboLineBasePattern.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboLineBasePattern.setMargin(new Insets(0, 0, 0, 0));
        this.cboLineBasePattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboLineBasePattern_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 15, 0, 10);
        this.pnlLineBase.add((Component)this.cboLineBasePattern, gridBagConstraints);
        this.txtLineBasePattern.setColumns(15);
        this.txtLineBasePattern.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineBasePattern_onFocusLost(evt);
            }
        });
        this.txtLineBasePattern.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineBasePattern_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLineBase.add((Component)this.txtLineBasePattern, gridBagConstraints);
        this.txtLineBaseWidth.setColumns(15);
        this.txtLineBaseWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineBaseWidth_onFocusLost(evt);
            }
        });
        this.txtLineBaseWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineBaseWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLineBase.add((Component)this.txtLineBaseWidth, gridBagConstraints);
        this.lblLengthUnitLineBase.setText("unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 2);
        this.pnlLineBase.add((Component)this.lblLengthUnitLineBase, gridBagConstraints);
        this.colorModelChooserLineBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.colorModelChooserLineBaseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 3, 3, 3);
        this.pnlLineBase.add((Component)this.colorModelChooserLineBase, gridBagConstraints);
        this.tabPaneLines.addTab("Linienbasis", this.pnlLineBase);
        this.pnlLineForeground.setLayout(new GridBagLayout());
        this.lblLineForegroundWidth.setText("Linienbreite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 15, 3, 10);
        this.pnlLineForeground.add((Component)this.lblLineForegroundWidth, gridBagConstraints);
        this.cboLineForeground.setText("anzeigen");
        this.cboLineForeground.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboLineForeground.setMargin(new Insets(0, 0, 0, 0));
        this.cboLineForeground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboLineForeground_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 7, 3, 2);
        this.pnlLineForeground.add((Component)this.cboLineForeground, gridBagConstraints);
        this.cboLineForegroundPattern.setText("Linienmuster");
        this.cboLineForegroundPattern.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboLineForegroundPattern.setMargin(new Insets(0, 0, 0, 0));
        this.cboLineForegroundPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboLineForegroundPattern_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 15, 0, 10);
        this.pnlLineForeground.add((Component)this.cboLineForegroundPattern, gridBagConstraints);
        this.txtLineForegroundPattern.setColumns(15);
        this.txtLineForegroundPattern.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineForegroundPattern_onFocusLost(evt);
            }
        });
        this.txtLineForegroundPattern.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineForegroundPattern_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLineForeground.add((Component)this.txtLineForegroundPattern, gridBagConstraints);
        this.txtLineForegroundWidth.setColumns(15);
        this.txtLineForegroundWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineForegroundWidth_onFocusLost(evt);
            }
        });
        this.txtLineForegroundWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineForegroundWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLineForeground.add((Component)this.txtLineForegroundWidth, gridBagConstraints);
        this.lblLengthUnitLineForeground.setText("unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 2);
        this.pnlLineForeground.add((Component)this.lblLengthUnitLineForeground, gridBagConstraints);
        this.colorModelChooserLineForeground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.colorModelChooserLineForegroundActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 3, 3, 3);
        this.pnlLineForeground.add((Component)this.colorModelChooserLineForeground, gridBagConstraints);
        this.tabPaneLines.addTab("Linienvordergrund", this.pnlLineForeground);
        this.pnlLineBackground.setLayout(new GridBagLayout());
        this.lblLineBackgroundWidth.setText("Linienbreite:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 15, 3, 10);
        this.pnlLineBackground.add((Component)this.lblLineBackgroundWidth, gridBagConstraints);
        this.cboLineBackground.setText("anzeigen");
        this.cboLineBackground.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboLineBackground.setMargin(new Insets(0, 0, 0, 0));
        this.cboLineBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboLineBackground_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 7, 3, 2);
        this.pnlLineBackground.add((Component)this.cboLineBackground, gridBagConstraints);
        this.cboLineBackgroundPattern.setText("Linienmuster");
        this.cboLineBackgroundPattern.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboLineBackgroundPattern.setMargin(new Insets(0, 0, 0, 0));
        this.cboLineBackgroundPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.cboLineBackgroundPattern_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 15, 0, 10);
        this.pnlLineBackground.add((Component)this.cboLineBackgroundPattern, gridBagConstraints);
        this.txtLineBackgroundPattern.setColumns(15);
        this.txtLineBackgroundPattern.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineBackgroundPattern_onFocusLost(evt);
            }
        });
        this.txtLineBackgroundPattern.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineBackgroundPattern_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLineBackground.add((Component)this.txtLineBackgroundPattern, gridBagConstraints);
        this.txtLineBackgroundWidth.setColumns(15);
        this.txtLineBackgroundWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineBackgroundWidth_onFocusLost(evt);
            }
        });
        this.txtLineBackgroundWidth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                BasicStyleLineAreaPanel.this.txtLineBackgroundWidth_onKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLineBackground.add((Component)this.txtLineBackgroundWidth, gridBagConstraints);
        this.lblLengthUnitLineBackground.setText("unit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 3, 2, 2);
        this.pnlLineBackground.add((Component)this.lblLengthUnitLineBackground, gridBagConstraints);
        this.colorModelChooserLineBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleLineAreaPanel.this.colorModelChooserLineBackgroundActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 3, 3, 3);
        this.pnlLineBackground.add((Component)this.colorModelChooserLineBackground, gridBagConstraints);
        this.tabPaneLines.addTab("Linienhintergrund", this.pnlLineBackground);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 0);
        this.add((Component)this.tabPaneLines, gridBagConstraints);
    }

    private void txtLineBasePattern_onFocusLost(FocusEvent evt) {
        try {
            this.lineBasePattern = this.txtLineBasePattern.getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtLineBasePattern_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateTextExpression((String)this.txtLineBasePattern.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineBasePattern.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineBasePattern.setForeground(Color.RED.darker());
        }
        this.lineBasePattern = this.txtLineBasePattern.getText();
        this.fireStyleChanged();
    }

    private void txtLineBaseWidth_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateCalcExpression((String)this.txtLineBaseWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineBaseWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineBaseWidth.setForeground(Color.RED.darker());
        }
        this.strLineBaseWidth = this.txtLineBaseWidth.getText();
        this.fireStyleChanged();
    }

    private void cmbOri_onActionPerformed(ActionEvent evt) {
        this.intOriUnit = this.cmbOri.getSelectedIndex();
        this.updateControls();
    }

    private void cmbLength_onActionPerformed(ActionEvent evt) {
        this.intLengthUnit = this.cmbLength.getSelectedIndex();
        this.updateControls();
    }

    private void txtLineBaseWidth_onFocusLost(FocusEvent evt) {
        try {
            this.strLineBaseWidth = this.txtLineBaseWidth.getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void cboLineBasePattern_onActionPerformed(ActionEvent evt) {
        this.bolRenderLineBasePattern = this.cboLineBasePattern.isSelected();
        if (this.lineBasePattern == null) {
            this.lineBasePattern = "3";
        }
        this.updateControls();
    }

    private void cboLineBase_onActionPerformed(ActionEvent evt) {
        this.bolRenderLineBase = this.cboLineBase.isSelected();
        if (this.lineBaseColor == null) {
            this.lineBaseColor = ColorModel.RED;
        }
        if (!this.bolRenderLineBase) {
            this.bolRenderLineForeground = false;
            this.bolRenderLineBackground = false;
        }
        this.updateControls();
    }

    private void cboFillPatter_onActionPerformed(ActionEvent evt) {
        this.bolRenderFillPattern = this.cboFillPattern.isSelected();
        this.updateControls();
    }

    private void cboFill_onActionPerformed(ActionEvent evt) {
        this.bolRenderFill = this.cboFill.isSelected();
        this.updateControls();
    }

    private void cmbSymbolSource_onActionPerformed(ActionEvent evt) {
        this.strFillSymStore = ObjectUtils.toString((Object)this.cmbSymbolSource.getSelectedItem());
        this.updateControls();
    }

    private void txtSymbol_onFocusLost(FocusEvent evt) {
        this.strFillSymName = this.txtSymbol.getText();
        this.updateControls();
    }

    private void txtSymbol_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateTextExpression((String)this.txtSymbol.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtSymbol.setForeground(Color.GREEN.darker());
        } else {
            this.txtSymbol.setForeground(Color.RED.darker());
        }
        this.strFillSymName = this.txtSymbol.getText();
        this.fireStyleChanged();
    }

    private void butSymbol_onActionPerformed(ActionEvent evt) {
        try {
            if (ObjectUtils.toString((Object)this.strFillSymStore).isEmpty()) {
                return;
            }
            SymbolListDialog dlg = this.getSymList();
            SymbolStore store = RenderUtil.getSymbolStore(this.strFillSymStore, this.sCol.getTask());
            dlg.setSymbolStore(store);
            dlg.selectSymbol(this.strFillSymName);
            dlg.setVisible(true);
            if (dlg.wasOKPressed()) {
                this.strFillSymName = "\"" + dlg.getSymbolName() + "\"";
                this.updateControls();
            }
            dlg.setVisible(false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, I18N.get("common.error") + ": " + e.getMessage());
        }
    }

    private void txtWidth_onFocusLost(FocusEvent evt) {
        this.strFillSymWidth = this.txtWidth.getText();
        this.updateControls();
    }

    private void txtWidth_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateCalcExpression((String)this.txtWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtWidth.setForeground(Color.RED.darker());
        }
        this.strFillSymWidth = this.txtWidth.getText();
        this.fireStyleChanged();
    }

    private void cboOverwrite_onActionPerformed(ActionEvent evt) {
        this.bolFillOverwrite = this.cboOverwrite.isSelected();
        this.updateControls();
    }

    private void cboLineForeground_onActionPerformed(ActionEvent evt) {
        this.bolRenderLineForeground = this.cboLineForeground.isSelected();
        if (this.lineForegroundColor == null) {
            this.lineForegroundColor = ColorModel.RED;
        }
        this.updateControls();
    }

    private void cboLineForegroundPattern_onActionPerformed(ActionEvent evt) {
        this.bolRenderLineForegroundPattern = this.cboLineForegroundPattern.isSelected();
        if (this.lineForegroundPattern == null) {
            this.lineForegroundPattern = "3";
        }
        this.updateControls();
    }

    private void txtLineForegroundPattern_onFocusLost(FocusEvent evt) {
        try {
            this.lineForegroundPattern = this.txtLineForegroundPattern.getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtLineForegroundPattern_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateTextExpression((String)this.txtLineForegroundPattern.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineForegroundPattern.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineForegroundPattern.setForeground(Color.RED.darker());
        }
        this.lineForegroundPattern = this.txtLineForegroundPattern.getText();
        this.fireStyleChanged();
    }

    private void txtLineForegroundWidth_onFocusLost(FocusEvent evt) {
        try {
            this.strLineForegroundWidth = this.txtLineForegroundWidth.getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtLineForegroundWidth_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateCalcExpression((String)this.txtLineForegroundWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineForegroundWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineForegroundWidth.setForeground(Color.RED.darker());
        }
        this.strLineForegroundWidth = this.txtLineForegroundWidth.getText();
        this.fireStyleChanged();
    }

    private void cboLineBackground_onActionPerformed(ActionEvent evt) {
        this.bolRenderLineBackground = this.cboLineBackground.isSelected();
        if (this.lineBackgroundColor == null) {
            this.lineBackgroundColor = ColorModel.RED;
        }
        this.updateControls();
    }

    private void cboLineBackgroundPattern_onActionPerformed(ActionEvent evt) {
        this.bolRenderLineBackgroundPattern = this.cboLineBackgroundPattern.isSelected();
        if (this.lineBackgroundPattern == null) {
            this.lineBackgroundPattern = "3";
        }
        this.updateControls();
    }

    private void txtLineBackgroundPattern_onFocusLost(FocusEvent evt) {
        try {
            this.lineBackgroundPattern = this.txtLineBackgroundPattern.getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtLineBackgroundPattern_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateTextExpression((String)this.txtLineBackgroundPattern.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineBackgroundPattern.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineBackgroundPattern.setForeground(Color.RED.darker());
        }
        this.lineBackgroundPattern = this.txtLineBackgroundPattern.getText();
        this.fireStyleChanged();
    }

    private void txtLineBackgroundWidth_onFocusLost(FocusEvent evt) {
        try {
            this.strLineBackgroundWidth = this.txtLineBackgroundWidth.getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateControls();
    }

    private void txtLineBackgroundWidth_onKeyReleased(KeyEvent evt) {
        if (FeatBshValidator.validateCalcExpression((String)this.txtLineBackgroundWidth.getText(), (SimpleFeatureType)this.getFeatureRetriever().getFeatureType()) == null) {
            this.txtLineBackgroundWidth.setForeground(Color.GREEN.darker());
        } else {
            this.txtLineBackgroundWidth.setForeground(Color.RED.darker());
        }
        this.strLineBackgroundWidth = this.txtLineBackgroundWidth.getText();
        this.fireStyleChanged();
    }

    private void colorModelChooserPanelAreaActionPerformed(ActionEvent evt) {
        this.fillColor = this.colorModelChooserPanelArea.getColorChooserColorModel();
        this.updateControls();
    }

    private void colorModelChooserLineBaseActionPerformed(ActionEvent evt) {
        this.lineBaseColor = this.colorModelChooserLineBase.getColorChooserColorModel();
        this.updateControls();
    }

    private void colorModelChooserLineBackgroundActionPerformed(ActionEvent evt) {
        this.lineBackgroundColor = this.colorModelChooserLineBackground.getColorChooserColorModel();
        this.updateControls();
    }

    private void colorModelChooserLineForegroundActionPerformed(ActionEvent evt) {
        this.lineForegroundColor = this.colorModelChooserLineForeground.getColorChooserColorModel();
        this.updateControls();
    }
}

