/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.LabelLayer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.style.BasicStyleLineAreaPanel;
import com.vividsolutions.jump.workbench.ui.style.BasicStylePanel;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import com.vividsolutions.jump.workbench.ui.style.symbol.BasicStyleSymbolPanel;
import com.vividsolutions.jump.workbench.ui.style.text.BasicStyleTextPanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class BasicStyleDialog
extends JDialog {
    private final List<StylePanel> stylePanels = new ArrayList<StylePanel>();
    private final PlugInContext context = null;
    private BasicStyleLineAreaPanel lineAreaPanel = null;
    private BasicStyleSymbolPanel symbolPanel = null;
    private BasicStyleTextPanel textPanel = null;
    private boolean blockStyleChangedEvents = false;
    private StyleCollection sCol = null;
    private final List<ActionListener> lstStyleChangedListeners = new ArrayList<ActionListener>();
    private final ActionListener panelStyleChangedListener = e -> {
        StylePanel pnl = (StylePanel)e.getSource();
        this.fireStyleChanged(pnl, e);
    };
    private JButton butClose;
    private JLabel lblError;
    private JTabbedPane tabPane;

    public BasicStyleDialog(Window parent, boolean modal, LayerStyleCollection sCol, PlugInContext context) {
        super(parent);
        this.setModal(modal);
        this.initComponents();
        this.init(sCol, context);
        this.i18n();
    }

    private void init(LayerStyleCollection sCol, PlugInContext context) {
        this.sCol = sCol;
        this.lblError.setVisible(false);
        this.lineAreaPanel = new BasicStyleLineAreaPanel(sCol, context);
        this.symbolPanel = new BasicStyleSymbolPanel(sCol, context);
        this.textPanel = new BasicStyleTextPanel(sCol, context);
        this.stylePanels.add(this.lineAreaPanel);
        this.stylePanels.add(this.symbolPanel);
        this.stylePanels.add(this.textPanel);
        this.addTabPanels(this.stylePanels);
    }

    private void i18n() {
        this.butClose.setText(I18N.get("common.close"));
    }

    public String validateInputAndSetErrorState() {
        StringBuilder sbError = new StringBuilder();
        for (StylePanel pnl : this.stylePanels) {
            String strError = pnl.validateInput();
            if (strError == null) continue;
            if (sbError.length() > 0) {
                sbError.append(System.lineSeparator());
            }
            sbError.append(pnl.getTitle()).append(": ").append(strError);
        }
        String errorMessages = sbError.toString();
        this.updateErrorState(errorMessages);
        return errorMessages;
    }

    private void addTabPanels(List<StylePanel> lstPanels) {
        int idx = this.tabPane.getSelectedIndex();
        for (StylePanel pnl : lstPanels) {
            this.tabPane.add(pnl.getTitle(), (Component)((Object)pnl));
            pnl.addStyleChangedListener(this.panelStyleChangedListener);
        }
        if (this.tabPane.getTabCount() - 1 > ++idx) {
            this.tabPane.setSelectedIndex(idx);
        }
    }

    public boolean isBlockStyleChangedEvents() {
        return this.blockStyleChangedEvents;
    }

    public void setBlockStyleChangedEvents(boolean blockStyleChangedEvents) {
        this.blockStyleChangedEvents = blockStyleChangedEvents;
    }

    public void setStyleCollection(StyleCollection _sCol) {
        this.sCol = _sCol;
        for (StylePanel stylePanel : this.stylePanels) {
            stylePanel.setStyleCollection(_sCol);
        }
    }

    public void setFeatureTypeRetriever(FeatureRetriever ftRetriever) {
        for (StylePanel stylePanel : this.stylePanels) {
            stylePanel.setFeatureRetriever(ftRetriever);
        }
    }

    public void setBasicStyle(BasicStyleModel basicStyle) {
        for (StylePanel stylePanel : this.stylePanels) {
            if (!(stylePanel instanceof BasicStylePanel)) continue;
            ((BasicStylePanel)((Object)stylePanel)).setBasicStyle(basicStyle);
        }
        this.updateTabLabels();
    }

    public void updateBasicStyle(BasicStyleModel basicStyle) {
        for (StylePanel stylePanel : this.stylePanels) {
            if (!(stylePanel instanceof BasicStylePanel)) continue;
            ((BasicStylePanel)((Object)stylePanel)).updateBasicStyle(basicStyle);
        }
    }

    public void setTransparency(int _alpha, boolean bolArea, boolean bolLine, boolean bolText, boolean bolSymbol) {
        for (StylePanel stylePanel : this.stylePanels) {
            if (!(stylePanel instanceof BasicStylePanel)) continue;
            ((BasicStylePanel)((Object)stylePanel)).setTransparency(_alpha, bolArea, bolLine, bolText, bolSymbol);
        }
    }

    public void addStyleChangedListener(ActionListener listener) {
        this.lstStyleChangedListeners.add(listener);
    }

    public void removeStyleChangedListener(ActionListener listener) {
        this.lstStyleChangedListeners.remove(listener);
    }

    private void fireStyleChanged(StylePanel pnl, ActionEvent evt) {
        if (this.blockStyleChangedEvents) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.updateTabLabels();
            String strError = this.validateInputAndSetErrorState();
            if (StringUtils.isBlank((CharSequence)strError)) {
                for (ActionListener listener : this.lstStyleChangedListeners) {
                    listener.actionPerformed(evt);
                }
            }
        });
    }

    private void updateErrorState(String strError) {
        if (StringUtils.isBlank((CharSequence)strError)) {
            this.lblError.setText("");
            this.lblError.setVisible(false);
        } else {
            this.lblError.setText(strError);
            this.lblError.setToolTipText(this.lblError.getText());
            this.lblError.setVisible(true);
        }
    }

    private void updateTabLabels() {
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            if (this.tabPane.getComponentAt(i) instanceof BasicStylePanel && this.tabPane.getComponentAt(i) instanceof StylePanel) {
                BasicStylePanel bspnl = (BasicStylePanel)((Object)this.tabPane.getComponentAt(i));
                StylePanel spnl = (StylePanel)((Object)this.tabPane.getComponentAt(i));
                if (bspnl.isStyleActive()) {
                    this.tabPane.setTitleAt(i, "<html><b>" + spnl.getTitle() + "</b></html>");
                } else {
                    this.tabPane.setTitleAt(i, spnl.getTitle());
                }
            }
            if (this.tabPane.getComponentAt(i) instanceof BasicStyleLineAreaPanel && this.sCol.getLayerable() instanceof LabelLayer) {
                this.tabPane.setEnabledAt(i, false);
                if (this.tabPane.getSelectedIndex() != i) continue;
                this.tabPane.setSelectedIndex(i + 1);
                continue;
            }
            this.tabPane.setEnabledAt(i, true);
        }
    }

    private void changeFocus() {
        Component comp = this.getFocusOwner();
        this.requestFocusInWindow();
        if (comp != null) {
            comp.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.tabPane = new JTabbedPane();
        this.lblError = new JLabel();
        this.butClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.lblError.setFont(this.lblError.getFont().deriveFont(this.lblError.getFont().getStyle() | 1, this.lblError.getFont().getSize() + 1));
        this.lblError.setForeground(new Color(255, 0, 0));
        this.lblError.setIcon(IconLoader.svgIcon((String)"common_attention.svg"));
        this.lblError.setText("error Message");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.lblError, gridBagConstraints);
        this.butClose.setText("schlie\u00dfen");
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicStyleDialog.this.butClose_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.butClose, gridBagConstraints);
        this.pack();
    }

    private void butClose_onActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

