/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class AttributePanel
extends JPanel {
    private SimpleFeatureType fSchema = null;
    private final Map<JTextComponent, Boolean> mapTextComp = new HashMap<JTextComponent, Boolean>();
    private JLabel lblAtt;
    private JList<String> lstAttributes;
    private JScrollPane scpAttributes;

    public AttributePanel() {
        this.initComponents();
        this.i18n();
    }

    public final void i18n() {
        this.lblAtt.setText(I18N.get("ui.style.AttributePanel.attributes"));
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.lstAttributes.setEnabled(enabled);
        this.lblAtt.setEnabled(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.lstAttributes.isEnabled();
    }

    public void fillAttributes(SimpleFeatureType _fSchema) {
        int i;
        this.fSchema = _fSchema;
        this.lstAttributes.removeAll();
        this.lstAttributes.setModel(new DefaultListModel());
        String[] arrAttributes = new String[this.fSchema.getAttributeCount()];
        for (i = 0; i < this.fSchema.getAttributeCount(); ++i) {
            arrAttributes[i] = this.fSchema.getDescriptor(i).getLocalName();
        }
        Arrays.sort(arrAttributes, String.CASE_INSENSITIVE_ORDER);
        for (i = 0; i < this.fSchema.getAttributeCount(); ++i) {
            ((DefaultListModel)this.lstAttributes.getModel()).addElement(arrAttributes[i]);
        }
    }

    public void addTextComponent(JTextComponent comp, boolean useOnlyValMethod) {
        this.mapTextComp.put(comp, useOnlyValMethod);
    }

    public void addTextComponent(JTextComponent comp) {
        this.addTextComponent(comp, false);
    }

    public void removeTextComponent(JTextComponent comp) {
        this.mapTextComp.remove(comp);
    }

    private void initComponents() {
        this.lblAtt = new JLabel();
        this.scpAttributes = new JScrollPane();
        this.lstAttributes = new JList();
        this.setFocusable(false);
        this.setLayout(new GridBagLayout());
        this.lblAtt.setText("Attribute");
        this.lblAtt.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lblAtt, gridBagConstraints);
        this.scpAttributes.setPreferredSize(new Dimension(120, 130));
        this.lstAttributes.setFocusable(false);
        this.lstAttributes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AttributePanel.this.lstAttributes_onMouseClicked(evt);
            }
        });
        this.scpAttributes.setViewportView(this.lstAttributes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scpAttributes, gridBagConstraints);
    }

    private void lstAttributes_onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.fSchema == null) {
                return;
            }
            String strAttName = this.lstAttributes.getModel().getElementAt(this.lstAttributes.getSelectedIndex());
            long count = this.mapTextComp.keySet().stream().filter(comp -> comp.hasFocus()).count();
            if (count == 1L) {
                this.mapTextComp.keySet().forEach(comp -> {
                    if (comp.hasFocus()) {
                        KeyListener[] arrKeyListener;
                        Object strText = comp.getText();
                        if (((String)strText).length() > 0) {
                            strText = (String)strText + " + ";
                        }
                        strText = (String)strText + this.retrieveBshByType(strAttName, this.mapTextComp.get(comp));
                        comp.setText((String)strText);
                        for (KeyListener arrKeyListener1 : arrKeyListener = (KeyListener[])comp.getListeners(KeyListener.class)) {
                            arrKeyListener1.keyReleased(null);
                        }
                    }
                });
            }
        }
    }

    private String retrieveBshByType(String strAttName, boolean useOnlyValMethod) {
        if (useOnlyValMethod) {
            return "val(\"" + strAttName + "\")";
        }
        AttributeDescriptor attType = this.fSchema.getDescriptor(strAttName);
        Object strTempText = attType.getType().getBinding() == String.class ? "str(\"" + strAttName + "\")" : (attType.getType().getBinding() == Double.class ? "num(\"" + strAttName + "\")" : (attType.getType().getBinding() == Float.class ? "num(\"" + strAttName + "\")" : (attType.getType().getBinding() == Short.class ? "num(\"" + strAttName + "\")" : (attType.getType().getBinding() == BigDecimal.class ? "num(\"" + strAttName + "\")" : (attType.getType().getBinding() == Long.class ? "lng(\"" + strAttName + "\")" : (attType.getType().getBinding() == BigInteger.class ? "lng(\"" + strAttName + "\")" : (attType.getType().getBinding() == Integer.class ? "integer(\"" + strAttName + "\")" : (attType.getType().getBinding() == Byte.class ? "integer(\"" + strAttName + "\")" : (attType.getType().getBinding() == Date.class ? "date(\"" + strAttName + "\")" : (Geometry.class.isAssignableFrom(attType.getType().getBinding()) ? "area()" : "str(\"" + strAttName + "\")"))))))))));
        return strTempText;
    }
}

