/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingSupport;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaPreviewPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(AreaPreviewPanel.class);
    private StyleModel style = null;
    private int height = -1;
    private int width = -1;
    private SimpleFeature areafeature = null;
    private SimpleFeature textfeature = null;
    private SimpleFeature symfeature = null;
    private final Viewport viewport = new Viewport(new JPanel(), false){
        private final AffineTransform transform;
        {
            this.transform = new AffineTransform();
        }

        @Override
        public Envelope getEnvelopeInModelCoordinates() {
            int width = AreaPreviewPanel.this.getWidth();
            int height = AreaPreviewPanel.this.getHeight();
            return new Envelope(0.0, (double)width, 0.0, (double)height);
        }

        @Override
        public AffineTransform getModelToViewTransform() {
            return this.transform;
        }

        @Override
        public Point2D toViewPoint(Coordinate modelCoordinate) {
            return new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
        }
    };

    public AreaPreviewPanel() {
        this.initComponents();
        this.setBackground(Color.white);
    }

    public synchronized void setStyle(StyleModel _style) {
        if (_style instanceof BasicStyleModel) {
            BasicStyleModel bstyle = (BasicStyleModel)_style;
            try {
                Double.parseDouble(bstyle.getFillSymWidth());
            }
            catch (Exception e) {
                bstyle.setFillSymWidth("10");
            }
        }
        this.style = _style;
        this.repaint();
    }

    public StyleModel getStyle() {
        return this.style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void paint(StyleModel style, Graphics2D g) {
        if (style == null) {
            return;
        }
        Stroke originalStroke = g.getStroke();
        if (this.symfeature == null || this.textfeature == null || this.areafeature == null || this.height != this.getHeight() || this.width != this.getWidth()) {
            this.createFeatures();
        }
        this.height = this.getHeight();
        this.width = this.getWidth();
        try {
            ShapeFeatureSTRtree tree = new ShapeFeatureSTRtree();
            if (style instanceof BasicStyleModel) {
                RenderUtil.getRenderer((BasicStyleModel)style).paint(this.areafeature, g, this.viewport, tree);
            }
            if (style instanceof TextStyleModel) {
                RenderUtil.getRenderer((TextStyleModel)style).paint(this.textfeature, g, this.viewport, tree);
            }
            if (style instanceof SymbolStyleModel) {
                RenderUtil.getRenderer((SymbolStyleModel)style).paint(this.symfeature, g, this.viewport, tree);
            }
        }
        catch (Exception e) {
            LOG.warn("Error drawing preview", (Throwable)e);
        }
        finally {
            g.setStroke(originalStroke);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        RenderingSupport.setRenderingHints((Graphics2D)g, RenderingSupport.RENDERHINTS_DEFAULT);
        this.paint(this.style, (Graphics2D)g);
    }

    private void createFeatures() {
        this.areafeature = this.createAreaFeature();
        this.textfeature = this.createTextFeature();
        this.symfeature = this.createSymFeature();
    }

    private SimpleFeature createAreaFeature() {
        int widthInternal = this.getWidth();
        int heightInternal = this.getHeight();
        String strWKT = "POLYGON ((0 " + (heightInternal + 30) + ", " + (widthInternal / 2 - widthInternal / 5) + " " + (heightInternal / 2 - heightInternal / 5) + ", " + (widthInternal + 30) + " 0, " + (widthInternal + 30) + " " + (heightInternal + 30) + ", 0 " + (heightInternal + 30) + "))";
        return FeatureUtil.getWKTFeature((String)strWKT);
    }

    private SimpleFeature createTextFeature() {
        int widthInternal = this.getWidth();
        int heightInternal = this.getHeight();
        String strWKT = "POINT (" + widthInternal / 9 + " " + (heightInternal - heightInternal / 4) + ")";
        return FeatureUtil.getWKTFeature((String)strWKT);
    }

    private SimpleFeature createSymFeature() {
        int widthInternal = this.getWidth();
        int heightInternal = this.getHeight();
        String strWKT = "POINT (" + widthInternal / 2 + " " + heightInternal / 2 + ")";
        return FeatureUtil.getWKTFeature((String)strWKT);
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(50, 50));
        this.setPreferredSize(new Dimension(100, 100));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                AreaPreviewPanel.this.this_onComponentShown(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
    }

    private void this_onComponentShown(ComponentEvent evt) {
        this.setStyle(this.style);
    }
}

