/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.vividsolutions.jump.util.StringUtil;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorModel;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPalettePanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPalettePanel.class);
    private final List<Listener> listeners = new ArrayList<Listener>();
    private static BasicStyleList basicStyleList = null;

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public abstract void setAlpha(int var1, boolean var2, boolean var3);

    protected void fireBasicStyleChosen(BasicStyleModel basicStyle) {
        for (Listener listener : this.listeners) {
            listener.basicStyleChosen(basicStyle);
        }
    }

    public static List<BasicStyleModel> basicStyles() {
        if (basicStyleList == null) {
            String resourceName = StringUtil.classNameWithoutQualifiers(AbstractPalettePanel.class.getName()) + ".xml";
            try (InputStream stream = AbstractPalettePanel.class.getResourceAsStream(resourceName);
                 InputStreamReader reader = new InputStreamReader(stream);){
                XStream xstream = AbstractPalettePanel.createSecuredXStream();
                basicStyleList = (BasicStyleList)xstream.fromXML((Reader)reader);
            }
            catch (Exception e) {
                LOG.error("Error loading basicStyles", (Throwable)e);
                Assert.shouldNeverReachHere();
                return null;
            }
        }
        return basicStyleList.getBasicStyles();
    }

    private static XStream createSecuredXStream() {
        XStream xstream = new XStream();
        xstream.addPermission(NoTypePermission.NONE);
        xstream.addPermission(NullPermission.NULL);
        xstream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        xstream.allowTypes(new Class[]{String.class, BasicStyleList.class});
        xstream.allowTypesByWildcard(new String[]{"de.riwagis.riwajump.model.style.**"});
        xstream.processAnnotations(BasicStyleModel.class);
        return xstream;
    }

    public static void main(String[] args) {
        BasicStyleList lst = new BasicStyleList();
        BasicStyleModel style = new BasicStyleModel();
        style.setFillColor(new ColorModel(0, 180, 0));
        style.getLineBase().setLineColor(new ColorModel(0, 125, 0));
        lst.addBasicStyle(style);
        XStream xstream = AbstractPalettePanel.createSecuredXStream();
        LOG.info(xstream.toXML((Object)lst));
    }

    public static interface Listener {
        public void basicStyleChosen(BasicStyleModel var1);
    }

    public static class BasicStyleList {
        private final List<BasicStyleModel> basicStyles = new ArrayList<BasicStyleModel>();

        public List<BasicStyleModel> getBasicStyles() {
            return Collections.unmodifiableList(this.basicStyles);
        }

        public void addBasicStyle(BasicStyleModel basicStyle) {
            this.basicStyles.add(basicStyle);
        }
    }
}

