/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.style.FeatureRetriever;
import com.vividsolutions.jump.workbench.ui.style.FeaturestorePanel;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import com.vividsolutions.jump.workbench.ui.style.scale.ScaleRangeStylePanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.locationtech.jts.util.Assert;

public abstract class AbstractChangeStylePlugIn
extends AbstractPlugIn {
    private StylePanel stylePanel = null;
    private List<LayerStylePanel> layerPanels = null;
    private MultiInputDialog currentDialog = null;
    private JTabbedPane tabbedPane = null;

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, this.getLayerableClass())).add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(0));
    }

    @Override
    public String getName() {
        return I18N.get("ui.style.SelectChangeStylesPlugIn.name") + "...";
    }

    protected abstract Class<?> getLayerableClass();

    protected abstract List<LayerStylePanel> generateLayerPanels(PlugInContext var1, AbstractLayerable var2) throws Exception;

    protected abstract StylePanel generateStylePanel(PlugInContext var1, AbstractLayerable var2) throws Exception;

    protected abstract AbstractLayerable generateLayerable(PlugInContext var1) throws Exception;

    protected abstract void addDialogListener(PlugInContext var1, List<LayerStylePanel> var2, MultiInputDialog var3, AbstractLayerable var4);

    protected boolean testLayerConnection(AbstractLayerable layer, PlugInContext context) {
        return true;
    }

    protected abstract boolean isDialogModal();

    protected boolean isResizable() {
        return true;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        ScaleRangeStylePanel scaleRangePanel;
        FeatureRetriever ftRetriever;
        if (this.currentDialog != null && this.currentDialog.isVisible()) {
            GUISupport.msgbox((Component)context.getWorkbenchFrame(), (String)I18N.getMessage("ui.style.SelectChangeStylesPlugIn.please-finish-current-dialog", this.currentDialog.getTitle()), (String)I18N.get("common.message"));
            return true;
        }
        AbstractLayerable layer = this.generateLayerable(context);
        if (this.layerPanels == null) {
            this.layerPanels = this.generateLayerPanels(context, layer);
        }
        if (this.stylePanel == null) {
            this.stylePanel = this.generateStylePanel(context, layer);
        }
        if ((ftRetriever = this.retrieveFeatureTypeRetriever(this.layerPanels)) != null) {
            this.stylePanel.setFeatureRetriever(ftRetriever);
        }
        if ((scaleRangePanel = this.retrieveScaleRangeStylePanel(this.layerPanels)) != null) {
            scaleRangePanel.setStylePanel(this.stylePanel);
        }
        ArrayList<LayerStylePanel> lstPanels = new ArrayList<LayerStylePanel>(this.layerPanels);
        if (this.currentDialog == null) {
            this.currentDialog = this.generateDialog(context, lstPanels, this.isDialogModal(), this.isResizable());
        }
        this.currentDialog.removeAllOKApplyCancelListener();
        this.addDialogListener(context, this.layerPanels, this.currentDialog, layer);
        for (LayerStylePanel stPanel : this.layerPanels) {
            stPanel.setLayerable(layer);
            this.handleTabEnabling(stPanel);
        }
        MultiInputDialog.fitDialogToContent(this.currentDialog);
        this.currentDialog.setVisible(true);
        return true;
    }

    protected final MultiInputDialog generateDialog(PlugInContext context, List<LayerStylePanel> lstPanels, boolean bolModal, boolean resizable) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.get("ui.style.SelectChangeStylesPlugIn.name"), bolModal);
        dialog.setInset(0);
        dialog.setApplyVisible(!bolModal);
        this.tabbedPane = new JTabbedPane();
        for (LayerStylePanel lyrPanel2Add : lstPanels) {
            if (lyrPanel2Add instanceof StylePanel) {
                StylePanel stylePanel2Add = (StylePanel)((Object)lyrPanel2Add);
                this.tabbedPane.add((Component)((Object)stylePanel2Add), stylePanel2Add.getTitle());
                dialog.addEnableChecks(stylePanel2Add.getTitle(), Collections.singletonList(component -> stylePanel2Add.validateInput()));
                continue;
            }
            this.tabbedPane.add((Component)((Object)lyrPanel2Add), lyrPanel2Add.getTitle());
            dialog.addEnableChecks(lyrPanel2Add.getTitle(), Collections.singletonList(component -> lyrPanel2Add.validateInput()));
        }
        JLabel dummyLabel = new JLabel("");
        dummyLabel.setVisible(false);
        dialog.addRow("DUMMY", dummyLabel, this.tabbedPane, 1, 1, null, null);
        dialog.setResizable(resizable);
        dialog.setLocationRelativeTo(context.getWorkbenchFrame());
        return dialog;
    }

    private void handleTabEnabling(LayerStylePanel stPanel) {
        if (this.tabbedPane == null) {
            return;
        }
        int tabIndex = this.tabbedPane.indexOfComponent((Component)((Object)stPanel));
        String message = stPanel.isPanelEnabled();
        if (message != null) {
            this.tabbedPane.setSelectedIndex(0);
        }
        this.tabbedPane.setEnabledAt(tabIndex, message == null);
        this.tabbedPane.setToolTipTextAt(tabIndex, message);
    }

    protected final ScaleRangeStylePanel retrieveScaleRangeStylePanel(List<LayerStylePanel> lstPanels) {
        for (LayerStylePanel pnl : lstPanels) {
            if (!(pnl instanceof ScaleRangeStylePanel)) continue;
            return (ScaleRangeStylePanel)pnl;
        }
        return null;
    }

    protected final FeatureRetriever retrieveFeatureTypeRetriever(List<LayerStylePanel> lstPanels) {
        for (LayerStylePanel pnl : lstPanels) {
            if (!(pnl instanceof FeaturestorePanel)) continue;
            return ((FeaturestorePanel)pnl).getFeatureRetriever();
        }
        return null;
    }

    protected static void addEditLayerListener(PlugInContext context, List<LayerStylePanel> layerPanels, MultiInputDialog dialog, final AbstractLayerable layer) {
        dialog.addOkApplyCancelListener(e -> {
            if (dialog.wasApplyPressed() || dialog.wasOKPressed()) {
                final ArrayList<UndoableCommand> lstUndo = new ArrayList<UndoableCommand>();
                for (LayerStylePanel currPanel : layerPanels) {
                    lstUndo.add(currPanel.updateLayer());
                }
                AbstractPlugIn.execute(new UndoableCommand(I18N.get("ui.plugin.AbstractChangeStylePlugIn.edit-layerable")){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute() {
                        boolean isFiringEvents = layer.getLayerManager().isFiringEvents();
                        layer.getLayerManager().setFiringEvents(false);
                        try {
                            for (UndoableCommand cmd : lstUndo) {
                                cmd.execute();
                            }
                        }
                        finally {
                            layer.getLayerManager().setFiringEvents(isFiringEvents);
                            if (layer instanceof Layer) {
                                ((Layer)layer).clearFeatureCache();
                            }
                            layer.fireAppearanceChanged();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void unexecute() {
                        boolean isFiringEvents = layer.getLayerManager().isFiringEvents();
                        layer.getLayerManager().setFiringEvents(false);
                        try {
                            for (UndoableCommand currCommand : lstUndo) {
                                currCommand.unexecute();
                            }
                        }
                        finally {
                            layer.getLayerManager().setFiringEvents(isFiringEvents);
                            if (layer instanceof Layer) {
                                ((Layer)layer).clearFeatureCache();
                            }
                            layer.fireAppearanceChanged();
                        }
                    }
                }, (LayerManagerProxy)context);
                for (LayerStylePanel currLayerStylePanel : layerPanels) {
                    currLayerStylePanel.setLayerable(layer);
                }
            }
        });
    }

    protected static void addAddLayerListener(final PlugInContext context, List<LayerStylePanel> layerPanels, MultiInputDialog dialog, final AbstractLayerable layer) {
        dialog.addOkApplyCancelListener(e -> {
            if (dialog.wasApplyPressed() || dialog.wasOKPressed()) {
                ArrayList<UndoableCommand> lstUndo = new ArrayList<UndoableCommand>();
                for (LayerStylePanel currPanel : layerPanels) {
                    lstUndo.add(currPanel.updateLayer());
                }
                boolean isFiringEvents = layer.getLayerManager().isFiringEvents();
                layer.getLayerManager().setFiringEvents(false);
                try {
                    for (UndoableCommand currCommand : lstUndo) {
                        currCommand.execute();
                    }
                }
                finally {
                    layer.getLayerManager().setFiringEvents(isFiringEvents);
                }
                AbstractPlugIn.execute(new UndoableCommand(I18N.get("ui.plugin.AbstractChangeStylePlugIn.add-layerable")){
                    private final LayerManager layMngr;
                    private String catName;
                    {
                        super(name);
                        this.layMngr = layer.getLayerManager();
                        this.catName = null;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute() {
                        boolean isFiringEvents = layer.getLayerManager().isFiringEvents();
                        layer.getLayerManager().setFiringEvents(false);
                        boolean categoryCreated = false;
                        try {
                            for (Category tmpCat : context.getLayerNamePanel().getSelectedCategories()) {
                                if (tmpCat.isBuildIn() && !(layer instanceof RedlineLayer)) continue;
                                this.catName = tmpCat.getName();
                            }
                            if (this.catName == null) {
                                this.catName = StandardCategoryNames.WORKING;
                                categoryCreated = true;
                            }
                            this.layMngr.addLayerable(this.catName, (Layerable)layer);
                        }
                        catch (Exception e) {
                            Assert.shouldNeverReachHere((String)e.getMessage());
                        }
                        finally {
                            this.layMngr.setFiringEvents(isFiringEvents);
                            if (layer instanceof Layer) {
                                ((Layer)layer).clearFeatureCache();
                            }
                            if (categoryCreated) {
                                this.layMngr.fireCategoryChanged(layer.getCategory(), CategoryEventType.ADDED);
                            }
                            this.layMngr.fireLayerChanged(layer, LayerEventType.ADDED);
                            layer.fireAppearanceChanged();
                        }
                    }

                    @Override
                    public void unexecute() {
                        try {
                            this.layMngr.remove(layer);
                        }
                        catch (Exception e) {
                            Assert.shouldNeverReachHere((String)e.getMessage());
                        }
                    }
                }, (LayerManagerProxy)context);
                for (LayerStylePanel currLayer : layerPanels) {
                    currLayer.setLayerable(layer);
                }
            }
        });
    }
}

