/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.plugin.VerticesInFencePlugIn;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;
import java.util.ArrayList;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapToVerticesPolicy
implements SnapPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SnapToVerticesPolicy.class);
    private static final GeometryFactory factory = new GeometryFactory();
    private final Blackboard blackboard;
    public static final String ENABLED_KEY = SnapToVerticesPolicy.class.getName() + " - ENABLED";

    public SnapToVerticesPolicy(Blackboard blackboard) {
        this.blackboard = blackboard;
    }

    @Override
    public Coordinate snap(LayerViewPanel panel, Coordinate originalPoint) {
        if (!this.blackboard.get(ENABLED_KEY, true)) {
            return null;
        }
        Geometry bufferedTransformedCursorLocation = factory.createPoint(originalPoint).buffer((double)SnapManager.getToleranceInPixels(this.blackboard) / panel.getViewport().getScale());
        ArrayList<Coordinate> vertices = new ArrayList<Coordinate>();
        for (Layer layer : panel.getLayerManager()) {
            if (!layer.isVisibleOnScreen()) continue;
            try {
                FeatureIterator<SimpleFeature> fi = layer.getLastFeatureIterator(bufferedTransformedCursorLocation.getEnvelopeInternal());
                while (fi.hasNext()) {
                    Geometry pointsAndLines;
                    Geometry candGeom = (Geometry)((SimpleFeature)fi.next()).getDefaultGeometry();
                    if (candGeom == null || candGeom.isEmpty() || (pointsAndLines = SnapToVerticesPolicy.toPointsAndLines(candGeom)) == null || pointsAndLines.isEmpty()) continue;
                    vertices.addAll(VerticesInFencePlugIn.verticesInFence(pointsAndLines, bufferedTransformedCursorLocation, true).getCoordinates());
                }
            }
            catch (Exception e) {
                LOG.debug("Error snapping intersection", (Throwable)e);
            }
        }
        if (vertices.isEmpty()) {
            return null;
        }
        return CoordUtil.closest(vertices, originalPoint);
    }

    private static Geometry toPointsAndLines(Geometry g) {
        if (g.getDimension() <= 1) {
            return g;
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection oldCollection = (GeometryCollection)g;
            ArrayList<Geometry> newCollection = new ArrayList<Geometry>();
            for (int i = 0; i < oldCollection.getNumGeometries(); ++i) {
                newCollection.add(SnapToVerticesPolicy.toPointsAndLines(oldCollection.getGeometryN(i)));
            }
            return factory.createGeometryCollection(newCollection.toArray(new Geometry[0]));
        }
        Assert.isTrue((boolean)(g instanceof Polygon));
        return ((Polygon)g).getBoundary();
    }
}

