/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;
import de.riwagis.util.jts.JTSSupport;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapToIntersectionPolicy
implements SnapPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SnapToIntersectionPolicy.class);
    private static final GeometryFactory factory = new GeometryFactory();
    private final Blackboard blackboard;
    public static final String ENABLED_KEY = SnapToIntersectionPolicy.class.getName() + " - ENABLED";

    public SnapToIntersectionPolicy(Blackboard blackboard) {
        this.blackboard = blackboard;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Coordinate snap(LayerViewPanel panel, Coordinate originalPoint) {
        if (!this.blackboard.get(SnapToIntersectionPolicy.ENABLED_KEY, true)) {
            return null;
        }
        bufferedCursorPosition = SnapToIntersectionPolicy.factory.createPoint(originalPoint).buffer((double)SnapManager.getToleranceInPixels(this.blackboard) / panel.getViewport().getScale());
        lstGeom = new ArrayList<Geometry>();
        var5_5 = panel.getLayerManager().iterator();
        block11: while (true) {
            block17: {
                if (!var5_5.hasNext()) break block17;
                layer = var5_5.next();
                if (!layer.isVisibleOnScreen()) continue;
                try {
                    fi = layer.getLastFeatureIterator(bufferedCursorPosition.getEnvelopeInternal());
                    ** try [egrp 1[TRYBLOCK] [2 : 105->234)] { 
lbl13:
                    // 2 sources

                    while (true) {
                        ** GOTO lbl-1000
                        break;
                    }
lbl15:
                    // 1 sources

                    finally {
                        if (fi == null) continue;
                        fi.close();
                    }
                }
                catch (Exception e) {
                    SnapToIntersectionPolicy.LOG.debug("Error accessing FeatureIterator of layer ", (Throwable)e);
                }
                continue;
            }
            vertices = new ArrayList<Coordinate>();
            if (lstGeom.size() > 1) {
                try {
                    this.findVerticesCreatedByUnion(lstGeom, vertices);
                    this.findDuplicateVertices(lstGeom, vertices);
                }
                catch (Exception e) {
                    SnapToIntersectionPolicy.LOG.debug("Error snapping intersection", (Throwable)e);
                    return null;
                }
            }
            if (vertices.isEmpty()) {
                return null;
            }
            return CoordUtil.closest(vertices, originalPoint);
lbl-1000:
            // 1 sources

            {
                while (true) {
                    if (fi.hasNext()) ** break;
                    continue block11;
                    try {
                        if ((geomTmp = (Geometry)((SimpleFeature)fi.next()).getDefaultGeometry()) == null) ** continue;
                        if (geomTmp.isEmpty()) continue;
                        pointsAndLines = SnapToIntersectionPolicy.toPointsAndLines(geomTmp);
                        arrGeom = JTSSupport.getGeometries((Geometry)pointsAndLines);
                        Arrays.stream(arrGeom).filter((Predicate<Geometry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$snap$0(org.locationtech.jts.geom.Geometry org.locationtech.jts.geom.Geometry ), (Lorg/locationtech/jts/geom/Geometry;)Z)((Geometry)bufferedCursorPosition)).map((Function<Geometry, Geometry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$snap$1(org.locationtech.jts.geom.Geometry org.locationtech.jts.geom.Geometry ), (Lorg/locationtech/jts/geom/Geometry;)Lorg/locationtech/jts/geom/Geometry;)((Geometry)bufferedCursorPosition)).filter((Predicate<Geometry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$snap$2(org.locationtech.jts.geom.Geometry ), (Lorg/locationtech/jts/geom/Geometry;)Z)()).forEach((Consumer<Geometry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$snap$3(java.util.List org.locationtech.jts.geom.Geometry ), (Lorg/locationtech/jts/geom/Geometry;)V)(lstGeom));
                    }
                    catch (Exception e) {
                        SnapToIntersectionPolicy.LOG.debug("Error snapping intersection", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            break;
        }
    }

    private void findDuplicateVertices(List<Geometry> geomsToValidate, List<Coordinate> vertices) {
        for (int i = 0; i < geomsToValidate.size(); ++i) {
            for (int j = i + 1; j < geomsToValidate.size(); ++j) {
                Geometry g2;
                Geometry g1 = geomsToValidate.get(i);
                if (g1.equals(g2 = geomsToValidate.get(j))) continue;
                Coordinate[] arrCoord1 = g1.getCoordinates();
                Coordinate[] arrCoord2 = g2.getCoordinates();
                for (Coordinate coord1 : arrCoord1) {
                    for (Coordinate coord2 : arrCoord2) {
                        if (!coord1.equals2D(coord2)) continue;
                        vertices.add(coord1);
                    }
                }
            }
        }
    }

    private void findVerticesCreatedByUnion(List<Geometry> geomsToValidate, List<Coordinate> vertices) {
        Geometry geom = factory.buildGeometry(geomsToValidate);
        Geometry geom2 = geom.union();
        for (Coordinate coord : geom2.getCoordinates()) {
            boolean bolFound = false;
            for (Coordinate coord2 : geom.getCoordinates()) {
                if (!coord.equals2D(coord2)) continue;
                bolFound = true;
            }
            if (bolFound) continue;
            vertices.add(coord);
        }
    }

    private static Geometry toPointsAndLines(Geometry g) {
        if (g.getDimension() <= 1) {
            return g;
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection oldCollection = (GeometryCollection)g;
            ArrayList<Geometry> newCollection = new ArrayList<Geometry>();
            for (int i = 0; i < oldCollection.getNumGeometries(); ++i) {
                newCollection.add(SnapToIntersectionPolicy.toPointsAndLines(oldCollection.getGeometryN(i)));
            }
            return factory.createGeometryCollection((Geometry[])newCollection.toArray(Geometry[]::new));
        }
        Assert.isTrue((boolean)(g instanceof Polygon));
        return ((Polygon)g).getBoundary();
    }

    private static /* synthetic */ void lambda$snap$3(List lstGeom, Geometry geom) {
        Geometry[] arrGeom2 = JTSSupport.getGeometries((Geometry)geom);
        Collections.addAll(lstGeom, arrGeom2);
    }

    private static /* synthetic */ boolean lambda$snap$2(Geometry geom) {
        return geom != null && !geom.isEmpty() && geom.isValid();
    }

    private static /* synthetic */ Geometry lambda$snap$1(Geometry bufferedCursorPosition, Geometry geom) {
        return geom.intersection(bufferedCursorPosition);
    }

    private static /* synthetic */ boolean lambda$snap$0(Geometry bufferedCursorPosition, Geometry geom) {
        return geom != null && geom.getEnvelopeInternal().intersects(bufferedCursorPosition.getEnvelopeInternal());
    }
}

