/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.snap.SnapManager;
import com.vividsolutions.jump.workbench.ui.snap.SnapPolicy;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapToFeaturesPolicy
implements SnapPolicy {
    private final Blackboard blackboard;
    public static final String ENABLED_KEY = SnapToFeaturesPolicy.class.getName() + " - ENABLED";
    private final InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
    private static GeometryFactory factory = new GeometryFactory();
    private static final Logger LOG = LoggerFactory.getLogger(SnapToFeaturesPolicy.class);

    public SnapToFeaturesPolicy(Blackboard blackboard) {
        this.blackboard = blackboard;
    }

    public SnapToFeaturesPolicy() {
        this(new Blackboard());
        this.blackboard.put(ENABLED_KEY, true);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Coordinate snap(LayerViewPanel panel, Coordinate originalCoordinate) {
        if (!this.blackboard.get(SnapToFeaturesPolicy.ENABLED_KEY, false)) {
            return null;
        }
        bufferedCursorPosition = SnapToFeaturesPolicy.factory.createPoint(originalCoordinate).buffer((double)SnapManager.getToleranceInPixels(this.blackboard) / panel.getViewport().getScale());
        var4_4 = panel.getLayerManager().iterator();
        while (var4_4.hasNext() != false) {
            layer = var4_4.next();
            if (!layer.isVisibleOnScreen()) continue;
            try {
                fi = layer.getLastFeatureIterator(bufferedCursorPosition.getEnvelopeInternal());
                try {
                    while (fi.hasNext()) {
                        block14: {
                            block13: {
                                candidate = SnapToFeaturesPolicy.toPointsAndLines((Geometry)((SimpleFeature)fi.next()).getDefaultGeometry());
                                if (!(candidate instanceof GeometryCollection)) ** GOTO lbl28
                                gcol = (GeometryCollection)candidate;
                                interiorPoint = IntStream.range(0, gcol.getNumGeometries()).mapToObj((IntFunction<Geometry>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$snap$0(org.locationtech.jts.geom.GeometryCollection int ), (I)Lorg/locationtech/jts/geom/Geometry;)((GeometryCollection)gcol)).filter((Predicate<Geometry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$snap$1(org.locationtech.jts.geom.Geometry org.locationtech.jts.geom.Geometry ), (Lorg/locationtech/jts/geom/Geometry;)Z)((Geometry)bufferedCursorPosition)).map((Function<Geometry, Geometry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$snap$2(org.locationtech.jts.geom.Geometry org.locationtech.jts.geom.Geometry ), (Lorg/locationtech/jts/geom/Geometry;)Lorg/locationtech/jts/geom/Geometry;)((Geometry)bufferedCursorPosition)).filter((Predicate<Geometry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$snap$3(org.locationtech.jts.geom.Geometry ), (Lorg/locationtech/jts/geom/Geometry;)Z)()).findFirst().map((Function<Geometry, Coordinate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$snap$4(org.locationtech.jts.geom.Geometry ), (Lorg/locationtech/jts/geom/Geometry;)Lorg/locationtech/jts/geom/Coordinate;)((SnapToFeaturesPolicy)this)).orElse(null);
                                if (interiorPoint == null) break block13;
                                var10_14 = interiorPoint;
                                if (fi == null) return var10_14;
                                {
                                    catch (Exception e) {
                                        SnapToFeaturesPolicy.LOG.debug(String.format("error snap to feature on layer '%s' (coord: %s): %s", new Object[]{layer, originalCoordinate, e.getLocalizedMessage()}), (Throwable)e);
                                        continue;
                                    }
                                }
                                fi.close();
                                return var10_14;
                            }
                            break block14;
lbl28:
                            // 1 sources

                            if (candidate == null || !candidate.getEnvelopeInternal().intersects(bufferedCursorPosition.getEnvelopeInternal()) || (intersection = candidate.intersection(bufferedCursorPosition)).isEmpty()) break block14;
                            var10_15 = this.interiorPointFinder.findPoint(intersection);
                            if (fi == null) return var10_15;
                            fi.close();
                            return var10_15;
                        }
                    }
                    if (fi == null) continue;
                }
                catch (Throwable var7_10) {
                    if (fi == null) throw var7_10;
                    try {
                        fi.close();
                        throw var7_10;
                    }
                    catch (Throwable var8_12) {
                        var7_10.addSuppressed(var8_12);
                    }
                    throw var7_10;
                }
                fi.close();
            }
            catch (Exception e) {
                SnapToFeaturesPolicy.LOG.debug(String.format("error accessing FeatureIterator of layer '%s' (coord: %s): %s", new Object[]{layer, originalCoordinate, e.getLocalizedMessage()}), (Throwable)e);
            }
        }
        return null;
    }

    private static Geometry toPointsAndLines(Geometry g) {
        if (g.getDimension() <= 1) {
            return g;
        }
        if (g instanceof GeometryCollection) {
            ArrayList<Geometry> newCollection = new ArrayList<Geometry>();
            SnapToFeaturesPolicy.toPointsAndLines(g, newCollection);
            return factory.createGeometryCollection((Geometry[])newCollection.toArray(Geometry[]::new));
        }
        Assert.isTrue((boolean)(g instanceof Polygon));
        return ((Polygon)g).getBoundary();
    }

    private static void toPointsAndLines(Geometry g, List<Geometry> lstGeom) {
        if (g.getDimension() <= 1) {
            lstGeom.add(g);
            return;
        }
        if (g instanceof GeometryCollection) {
            GeometryCollection oldCollection = (GeometryCollection)g;
            for (int i = 0; i < oldCollection.getNumGeometries(); ++i) {
                SnapToFeaturesPolicy.toPointsAndLines(oldCollection.getGeometryN(i), lstGeom);
            }
            return;
        }
        Assert.isTrue((boolean)(g instanceof Polygon));
        lstGeom.add(((Polygon)g).getBoundary());
    }

    private /* synthetic */ Coordinate lambda$snap$4(Geometry intersection) {
        return this.interiorPointFinder.findPoint(intersection);
    }

    private static /* synthetic */ boolean lambda$snap$3(Geometry intersection) {
        return !intersection.isEmpty();
    }

    private static /* synthetic */ Geometry lambda$snap$2(Geometry bufferedCursorPosition, Geometry geom) {
        return geom.intersection(bufferedCursorPosition);
    }

    private static /* synthetic */ boolean lambda$snap$1(Geometry bufferedCursorPosition, Geometry geom) {
        return geom.getEnvelopeInternal().intersects(bufferedCursorPosition.getEnvelopeInternal());
    }

    private static /* synthetic */ Geometry lambda$snap$0(GeometryCollection gcol, int n) {
        return gcol.getGeometryN(n);
    }
}

