/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.snap;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderer;
import com.vividsolutions.jump.workbench.ui.snap.SnapToGridPolicy;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class GridRenderer
extends SimpleRenderer {
    public static final String CONTENT_ID = "GRID";
    public static final String ENABLED_KEY = String.valueOf(GridRenderer.class) + " - ENABLED";
    public static final String DOTS_ENABLED_KEY = String.valueOf(GridRenderer.class) + " - DOTS ENABLED";
    public static final String LINES_ENABLED_KEY = String.valueOf(GridRenderer.class) + " - LINES ENABLED";
    private final Blackboard blackboard;
    private final LayerViewPanel panel;
    private final Stroke stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 2.0f}, 0.0f);

    public GridRenderer(Blackboard blackboard, LayerViewPanel panel) {
        super(CONTENT_ID, panel.getContext());
        this.blackboard = blackboard;
        this.panel = panel;
    }

    @Override
    protected void paint(Graphics2D g) throws NoninvertibleTransformException {
        if (!this.blackboard.get(ENABLED_KEY, false)) {
            return;
        }
        double gridSize = this.blackboard.get(SnapToGridPolicy.GRID_SIZE_KEY, 20.0);
        double viewGridSize = gridSize * this.panel.getViewport().getScale();
        if (viewGridSize < 5.0) {
            return;
        }
        double minModelX = Math.floor(this.panel.getViewport().getEnvelopeInModelCoordinates().getMinX() / gridSize) * gridSize;
        double maxModelX = Math.ceil(this.panel.getViewport().getEnvelopeInModelCoordinates().getMaxX() / gridSize) * gridSize;
        double minModelY = Math.floor(this.panel.getViewport().getEnvelopeInModelCoordinates().getMinY() / gridSize) * gridSize;
        double maxModelY = Math.ceil(this.panel.getViewport().getEnvelopeInModelCoordinates().getMaxY() / gridSize) * gridSize;
        if (this.blackboard.get(DOTS_ENABLED_KEY, false)) {
            g.setColor(Color.BLACK);
            this.paintDots(g, gridSize, minModelX, maxModelX, minModelY, maxModelY);
        }
        if (this.blackboard.get(LINES_ENABLED_KEY, false)) {
            g.setColor(Color.GRAY);
            this.paintLines(g, gridSize, minModelX, maxModelX, minModelY, maxModelY);
        }
    }

    private void paintDots(Graphics2D g, double gridSize, double minModelX, double maxModelX, double minModelY, double maxModelY) throws NoninvertibleTransformException {
        for (double x = minModelX; x < maxModelX; x += gridSize) {
            for (double y = minModelY; y < maxModelY; y += gridSize) {
                Point2D p = this.panel.getViewport().toViewPoint(new Coordinate(x, y));
                g.drawLine((int)p.getX() - 2, (int)p.getY(), (int)p.getX() + 2, (int)p.getY());
                g.drawLine((int)p.getX(), (int)p.getY() - 2, (int)p.getX(), (int)p.getY() + 2);
            }
        }
    }

    private void paintLines(Graphics2D g, double gridSize, double minModelX, double maxModelX, double minModelY, double maxModelY) throws NoninvertibleTransformException {
        Point2D max;
        Point2D min;
        Envelope viewport = this.panel.getViewport().getEnvelopeInModelCoordinates();
        g.setStroke(this.stroke);
        for (double x = minModelX; x < maxModelX; x += gridSize) {
            min = this.panel.getViewport().toViewPoint(new Coordinate(x, viewport.getMinY()));
            max = this.panel.getViewport().toViewPoint(new Coordinate(x, viewport.getMaxY()));
            g.drawLine((int)min.getX(), (int)min.getY(), (int)max.getX(), (int)max.getY());
        }
        for (double y = minModelY; y < maxModelY; y += gridSize) {
            min = this.panel.getViewport().toViewPoint(new Coordinate(viewport.getMinX(), y));
            max = this.panel.getViewport().toViewPoint(new Coordinate(viewport.getMaxX(), y));
            g.drawLine((int)min.getX(), (int)min.getY(), (int)max.getX(), (int)max.getY());
        }
    }
}

