/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.selection;

import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.CategoryEventType;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.GeometryEditor;
import com.vividsolutions.jump.workbench.ui.selection.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.selection.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.selection.LineStringSelection;
import com.vividsolutions.jump.workbench.ui.selection.PartSelection;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import de.riwagis.geotools.feature.util.FeatureUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class SelectionManager {
    private final FeatureSelection featureSelection;
    private final PartSelection partSelection;
    private final LineStringSelection lineStringSelection;
    private final LayerManagerProxy layerManagerProxy;
    private final Collection<SelectionListener> selectionListeners = new LinkedHashSet<SelectionListener>();
    private final AtomicBoolean panelUpdatesEnabled = new AtomicBoolean(true);
    private final GeometryEditor geometryEditor = new GeometryEditor();
    private final LayerListener layerListener = new LayerListener(){

        @Override
        public void featuresChanged(FeatureEvent e) {
            if (e.getType() == FeatureEventType.DELETED) {
                SelectionManager.this.unselectItems(e.getLayer(), e.getFeatures());
            } else if (e.getType() == FeatureEventType.GEOMETRY_MODIFIED) {
                SelectionManager.this.unselectFromFeaturesWithModifiedItemCounts(e.getLayer(), e.getFeatures(), e.getOldFeatureClones());
            } else if (e.getType() == FeatureEventType.ATTRIBUTES_MODIFIED) {
                SelectionManager.this.unselectFromFeaturesWithModifiedItemCounts(e.getLayer(), e.getFeatures(), e.getOldFeatureAttClones());
            }
        }

        @Override
        public void layerChanged(LayerEvent e) {
            if ((!e.getLayerable().isVisible() || e.getType() != LayerEventType.VISIBILITY_CHANGED) && e.getLayerable() instanceof Layer) {
                SelectionManager.this.runWithoutUpdates(() -> {
                    if (e.getType() == LayerEventType.REMOVED || e.getType() == LayerEventType.VISIBILITY_CHANGED) {
                        SelectionManager.this.unselectItems((Layer)e.getLayerable());
                    }
                });
                SelectionManager.this.updatePanel();
            }
        }

        @Override
        public void categoryChanged(CategoryEvent e) {
            if (!e.getCategory().isVisible() || e.getType() != CategoryEventType.VISIBILITY_CHANGED) {
                SelectionManager.this.runWithoutUpdates(() -> {
                    if (e.getType() == CategoryEventType.VISIBILITY_CHANGED) {
                        for (Layerable ly : e.getCategory().getAllLayerables()) {
                            if (!(ly instanceof Layer)) continue;
                            SelectionManager.this.unselectItems((Layer)ly);
                        }
                    }
                });
                SelectionManager.this.updatePanel();
            }
        }
    };
    private final Collection<AbstractSelection> selections;

    public Collection<SimpleFeature> createFeaturesFromSelectedItems() {
        ArrayList<SimpleFeature> newFeatures = new ArrayList<SimpleFeature>();
        for (Layer layer : this.getLayersWithSelectedItems()) {
            newFeatures.addAll(this.createFeaturesFromSelectedItems(layer));
        }
        return newFeatures;
    }

    public Collection<SimpleFeature> createFeaturesFromSelectedItems(Layer layer) {
        ArrayList<SimpleFeature> newFeatures = new ArrayList<SimpleFeature>();
        for (SimpleFeature feature : this.getFeaturesWithSelectedItems(layer)) {
            try {
                SimpleFeature newFeature = FeatureUtil.cloneFeature((SimpleFeature)feature);
                newFeature.setDefaultGeometry((Object)this.filterGeometryIfNecessary(layer, feature));
                newFeatures.add(newFeature);
            }
            catch (Exception e) {
                Assert.shouldNeverReachHere((String)e.getMessage());
            }
        }
        return newFeatures;
    }

    public Geometry filterGeometryIfNecessary(Layer layer, SimpleFeature feature) {
        Geometry sourceGeometry = (Geometry)feature.getDefaultGeometry();
        List<Geometry> selectedItems = this.getSelections().stream().flatMap(s -> s.items(sourceGeometry, s.getSelectedItemIndices(layer, feature)).stream()).collect(Collectors.toList());
        if (selectedItems.contains(sourceGeometry)) {
            return sourceGeometry;
        }
        return this.geometryEditor.filter(sourceGeometry, selectedItems);
    }

    public SelectionManager(LayerManagerProxy layerManagerProxy) {
        this.layerManagerProxy = layerManagerProxy;
        this.featureSelection = new FeatureSelection(this);
        this.lineStringSelection = new LineStringSelection(this);
        this.partSelection = new PartSelection(this);
        this.featureSelection.setParent(null);
        this.featureSelection.setChild(this.partSelection);
        this.partSelection.setParent(this.featureSelection);
        this.partSelection.setChild(this.lineStringSelection);
        this.lineStringSelection.setParent(this.partSelection);
        this.lineStringSelection.setChild(null);
        this.selections = Collections.unmodifiableList(Arrays.asList(this.featureSelection, this.partSelection, this.lineStringSelection));
        this.addLayerListenerTo(layerManagerProxy.getLayerManager());
    }

    private void addLayerListenerTo(LayerManager layerManager) {
        layerManager.addLayerListener(this.layerListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        assert (selectionListener != null);
        if (selectionListener != null && !this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (selectionListener != null) {
            this.selectionListeners.remove(selectionListener);
        }
    }

    public void clear() {
        this.runWithoutUpdates(() -> {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems();
            }
        });
        this.updatePanel();
    }

    public FeatureSelection getFeatureSelection() {
        return this.featureSelection;
    }

    public LineStringSelection getLineStringSelection() {
        return this.lineStringSelection;
    }

    public Collection<AbstractSelection> getSelections() {
        return this.selections;
    }

    public Collection<Geometry> getSelectedItems() {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems());
        }
        return selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer) {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer));
        }
        return selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer, SimpleFeature feature) {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer, feature));
        }
        return selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer, SimpleFeature feature, Geometry geometry) {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        for (AbstractSelection selection : this.selections) {
            selectedItems.addAll(selection.getSelectedItems(layer, feature, geometry));
        }
        return selectedItems;
    }

    public Collection<Layer> getLayersWithSelectedItems() {
        HashSet<Layer> layersWithSelectedItems = new HashSet<Layer>();
        for (AbstractSelection selection : this.selections) {
            layersWithSelectedItems.addAll(selection.getLayersWithSelectedItems());
        }
        return layersWithSelectedItems;
    }

    public PartSelection getPartSelection() {
        return this.partSelection;
    }

    public void fireSelectionChanged() {
        for (SelectionListener currListener : this.selectionListeners) {
            if (currListener == null) continue;
            currListener.selectionChanged();
        }
    }

    public void updatePanel() {
        if (this.arePanelUpdatesEnabled()) {
            this.fireSelectionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPanelUpdatesEnabled(boolean panelUpdatesEnabled) {
        AtomicBoolean atomicBoolean = this.panelUpdatesEnabled;
        synchronized (atomicBoolean) {
            this.panelUpdatesEnabled.set(panelUpdatesEnabled);
        }
    }

    public Collection<SimpleFeature> getFeaturesWithSelectedItems(Layer layer) {
        HashSet<SimpleFeature> featuresWithSelectedItems = new HashSet<SimpleFeature>();
        for (AbstractSelection selection : this.selections) {
            featuresWithSelectedItems.addAll(selection.getFeaturesWithSelectedItems(layer));
        }
        return featuresWithSelectedItems;
    }

    public void unselectItems(Layer layer) {
        this.runWithoutUpdates(() -> {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems(layer);
            }
        });
        this.updatePanel();
    }

    public void unselectItems(Layer layer, Collection<SimpleFeature> features) {
        this.runWithoutUpdates(() -> {
            for (AbstractSelection selection : this.selections) {
                selection.unselectItems(layer, features);
            }
        });
        this.updatePanel();
    }

    public void unselectFromFeaturesWithModifiedItemCounts(Layer layer, Collection<SimpleFeature> features, Collection<SimpleFeature> oldFeatureClones) {
        this.runWithoutUpdates(() -> {
            for (AbstractSelection selection : this.selections) {
                selection.unselectFromFeaturesWithModifiedItemCounts(layer, features, oldFeatureClones);
            }
        });
        this.updatePanel();
    }

    public Collection<SimpleFeature> getFeaturesWithSelectedItems() {
        ArrayList<SimpleFeature> featuresWithSelectedItems = new ArrayList<SimpleFeature>();
        for (Layer layer : this.getLayersWithSelectedItems()) {
            featuresWithSelectedItems.addAll(this.getFeaturesWithSelectedItems(layer));
        }
        return featuresWithSelectedItems;
    }

    public boolean arePanelUpdatesEnabled() {
        return this.panelUpdatesEnabled.get();
    }

    public void dispose() {
        this.layerManagerProxy.getLayerManager().removeLayerListener(this.layerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithoutUpdates(Runnable runnable) {
        AtomicBoolean atomicBoolean = this.panelUpdatesEnabled;
        synchronized (atomicBoolean) {
            boolean originalPanelUpdatesEnabled = this.panelUpdatesEnabled.getAndSet(false);
            try {
                runnable.run();
            }
            finally {
                this.panelUpdatesEnabled.set(originalPanelUpdatesEnabled);
            }
        }
    }

    public boolean hasSelections(Layer layer) {
        for (AbstractSelection selection : this.selections) {
            if (!selection.hasSelection(layer)) continue;
            return true;
        }
        return false;
    }
}

