/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.selection;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.selection.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.selection.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.selection.LineStringSelection;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class PartSelection
extends AbstractSelection {
    public List items(Geometry geometry) {
        ArrayList<Geometry> items = new ArrayList<Geometry>();
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < ((GeometryCollection)geometry).getNumGeometries(); ++i) {
                items.addAll(this.items(((GeometryCollection)geometry).getGeometryN(i)));
            }
        } else {
            items.add(geometry);
        }
        return items;
    }

    public PartSelection(SelectionManager selectionManager) {
        super(selectionManager);
    }

    @Override
    public String getRendererContentID() {
        return "SELECTED_PARTS";
    }

    @Override
    protected boolean selectedInAncestors(Layer layer, SimpleFeature feature, Geometry item) {
        Assert.isTrue((boolean)(this.getParent() instanceof FeatureSelection));
        return this.getParent().getFeaturesWithSelectedItems().contains(this.getSelectionFeature(layer, feature));
    }

    protected void unselectInDescendants(Layer layer, SimpleFeature feature, Collection items) {
        Assert.isTrue((boolean)(this.getChild() instanceof LineStringSelection));
        for (Geometry part : items) {
            List<Geometry> partLineStrings = this.getChild().items(part);
            for (LineString lineString : this.getChild().getSelectedItems(layer, feature)) {
                if (!partLineStrings.contains(lineString)) continue;
                this.getChild().unselectItem(layer, feature, partLineStrings.indexOf(lineString));
            }
        }
    }
}

