/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.selection;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.selection.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.selection.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.selection.PartSelection;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public class LineStringSelection
extends AbstractSelection {
    public List items(Geometry geometry) {
        int i;
        ArrayList<Object> items = new ArrayList<Object>();
        if (geometry instanceof LineString) {
            items.add(geometry);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            items.add(polygon.getExteriorRing());
            for (i = 0; i < polygon.getNumInteriorRing(); ++i) {
                items.add(polygon.getInteriorRingN(i));
            }
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            for (i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                items.addAll(this.items(geometryCollection.getGeometryN(i)));
            }
        }
        return items;
    }

    public LineStringSelection(SelectionManager selectionManager) {
        super(selectionManager);
    }

    @Override
    public String getRendererContentID() {
        return "SELECTED_LINESTRINGS";
    }

    @Override
    protected boolean selectedInAncestors(Layer layer, SimpleFeature feature, Geometry item) {
        Assert.isTrue((boolean)(this.getParent().getParent() instanceof FeatureSelection));
        Assert.isTrue((boolean)(this.getParent() instanceof PartSelection));
        if (this.getParent().getParent().getFeaturesWithSelectedItems().contains(this.getSelectionFeature(layer, feature))) {
            return true;
        }
        for (Geometry selectedPart : this.getParent().getSelectedItems(layer, feature)) {
            if (!this.items(selectedPart).contains(item)) continue;
            return true;
        }
        return false;
    }

    protected void unselectInDescendants(Layer layer, SimpleFeature feature, Collection items) {
        Assert.isTrue((this.getChild() == null ? 1 : 0) != 0);
    }
}

