/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.selection;

import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public abstract class AbstractSelection {
    private final Map<Layer, CollectionMap<SimpleFeature, Integer>> layerMap = new HashMap<Layer, CollectionMap<SimpleFeature, Integer>>();
    private final Map<Layer, Map<String, SimpleFeature>> layerFidMap = new HashMap<Layer, Map<String, SimpleFeature>>();
    private AbstractSelection child;
    private AbstractSelection parent;
    private final SelectionManager selectionManager;
    private final ReadWriteLock selLock = new ReentrantReadWriteLock();

    public AbstractSelection(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public abstract List<Geometry> items(Geometry var1);

    public abstract String getRendererContentID();

    protected abstract boolean selectedInAncestors(Layer var1, SimpleFeature var2, Geometry var3);

    protected abstract void unselectInDescendants(Layer var1, SimpleFeature var2, Collection<Geometry> var3);

    public Collection<Geometry> items(Geometry geometry, Collection<Integer> indices) {
        List<Geometry> allItems = this.items(geometry);
        ArrayList<Geometry> items = new ArrayList<Geometry>();
        for (Integer index : indices) {
            if (allItems.size() < index + 1) continue;
            items.add(allItems.get(index));
        }
        return items;
    }

    private CollectionMap<SimpleFeature, Integer> getFeatureToSelectedItemIndexCollectionMap(Layer layer) {
        if (this.layerMap.containsKey(layer)) {
            return this.layerMap.get(layer);
        }
        return null;
    }

    private CollectionMap<SimpleFeature, Integer> getFeatureToSelectedItemIndexCollectionMapCreate(Layer layer) {
        if (!this.layerMap.containsKey(layer)) {
            this.layerMap.put(layer, new CollectionMap());
        }
        return this.layerMap.get(layer);
    }

    private Map<String, SimpleFeature> getFidToFeatureMap(Layer layer) {
        if (this.layerFidMap.containsKey(layer)) {
            return this.layerFidMap.get(layer);
        }
        return null;
    }

    private Map<String, SimpleFeature> getFidToFeatureMapCreate(Layer layer) {
        if (!this.layerFidMap.containsKey(layer)) {
            this.layerFidMap.put(layer, new HashMap());
        }
        return this.layerFidMap.get(layer);
    }

    public boolean hasSelection(Layer layer) {
        return this.layerMap.containsKey(layer);
    }

    private boolean hasSelection(Layer layer, SimpleFeature feature) {
        if (!this.hasSelection(layer)) {
            return false;
        }
        feature = this.getSelectionFeatureInternal(layer, feature);
        CollectionMap<SimpleFeature, Integer> colMap = this.layerMap.get(layer);
        return colMap.containsKey(feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleFeature getSelectionFeature(Layer layer, SimpleFeature feature) {
        this.selLock.readLock().lock();
        try {
            SimpleFeature simpleFeature = this.getSelectionFeatureInternal(layer, feature);
            return simpleFeature;
        }
        finally {
            this.selLock.readLock().unlock();
        }
    }

    private SimpleFeature getSelectionFeatureInternal(Layer layer, SimpleFeature feature) {
        String strFID = feature.getID();
        Map<String, SimpleFeature> mapFeature = this.getFidToFeatureMap(layer);
        if (mapFeature == null) {
            return feature;
        }
        if (mapFeature.containsKey(strFID)) {
            return mapFeature.get(strFID);
        }
        return feature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> getSelectedItemIndices(Layer layer, SimpleFeature feature) {
        this.selLock.readLock().lock();
        try {
            if (!this.hasSelection(layer)) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                return arrayList;
            }
            ArrayList<Integer> indices = this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(this.getSelectionFeatureInternal(layer, feature));
            ArrayList<Integer> arrayList = indices == null ? new ArrayList<Integer>() : indices;
            return arrayList;
        }
        finally {
            this.selLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedItemCount(Layer layer, SimpleFeature feature) {
        this.selLock.readLock().lock();
        try {
            if (!this.hasSelection(layer)) {
                int n = 0;
                return n;
            }
            int n = this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(this.getSelectionFeatureInternal(layer, feature)).size();
            return n;
        }
        finally {
            this.selLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionMap<SimpleFeature, Geometry> getFeatureToSelectedItemCollectionMap(Layer layer) {
        this.selLock.readLock().lock();
        try {
            CollectionMap<SimpleFeature, Geometry> collectionMap = new CollectionMap<SimpleFeature, Geometry>();
            if (!this.hasSelection(layer)) {
                CollectionMap<SimpleFeature, Geometry> collectionMap2 = collectionMap;
                return collectionMap2;
            }
            Set<SimpleFeature> ks = this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet();
            for (SimpleFeature feature : ks) {
                collectionMap.put(feature, this.items((Geometry)feature.getDefaultGeometry(), this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(feature)));
            }
            CollectionMap<SimpleFeature, Geometry> collectionMap3 = collectionMap;
            return collectionMap3;
        }
        finally {
            this.selLock.readLock().unlock();
        }
    }

    public Collection<Layer> getLayersWithSelectedItems() {
        ArrayList<Layer> layersWithSelectedItems = new ArrayList<Layer>();
        HashSet<Layer> keySet = null;
        this.selLock.readLock().lock();
        try {
            keySet = new HashSet<Layer>(this.layerMap.keySet());
        }
        finally {
            this.selLock.readLock().unlock();
        }
        for (Layer layer : keySet) {
            if (this.getFeaturesWithSelectedItems(layer).isEmpty()) continue;
            layersWithSelectedItems.add(layer);
        }
        return layersWithSelectedItems;
    }

    public Collection<SimpleFeature> getFeaturesWithSelectedItems() {
        ArrayList<SimpleFeature> featuresWithSelectedItems = new ArrayList<SimpleFeature>();
        HashSet<Layer> keySet = null;
        this.selLock.readLock().lock();
        try {
            keySet = new HashSet<Layer>(this.layerMap.keySet());
        }
        finally {
            this.selLock.readLock().unlock();
        }
        for (Layer layer : keySet) {
            featuresWithSelectedItems.addAll(this.getFeaturesWithSelectedItems(layer));
        }
        return featuresWithSelectedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SimpleFeature> getFeaturesWithSelectedItems(Layer layer) {
        this.selLock.readLock().lock();
        try {
            ArrayList<SimpleFeature> featuresWithSelectedItems = new ArrayList<SimpleFeature>();
            if (!this.hasSelection(layer)) {
                ArrayList<SimpleFeature> arrayList = featuresWithSelectedItems;
                return arrayList;
            }
            for (SimpleFeature feature : this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet()) {
                if (this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(feature).isEmpty()) continue;
                featuresWithSelectedItems.add(feature);
            }
            ArrayList<SimpleFeature> arrayList = featuresWithSelectedItems;
            return arrayList;
        }
        finally {
            this.selLock.readLock().unlock();
        }
    }

    public Collection<Geometry> getSelectedItems() {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        HashSet<Layer> keySet = null;
        this.selLock.readLock().lock();
        try {
            keySet = new HashSet<Layer>(this.layerMap.keySet());
        }
        finally {
            this.selLock.readLock().unlock();
        }
        for (Layer layer : keySet) {
            selectedItems.addAll(this.getSelectedItems(layer));
        }
        return selectedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Geometry> getSelectedItems(Layer layer) {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>();
        ArrayList<SimpleFeature> selectedFeatures = new ArrayList<SimpleFeature>();
        this.selLock.readLock().lock();
        try {
            if (!this.hasSelection(layer)) {
                ArrayList<Geometry> arrayList = selectedItems;
                return arrayList;
            }
            for (SimpleFeature feature : this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet()) {
                selectedFeatures.add(feature);
            }
        }
        finally {
            this.selLock.readLock().unlock();
        }
        for (SimpleFeature feature : selectedFeatures) {
            selectedItems.addAll(this.getSelectedItems(layer, feature));
        }
        return selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer, SimpleFeature feature) {
        return this.getSelectedItems(layer, feature, (Geometry)feature.getDefaultGeometry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Geometry> getSelectedItems(Layer layer, SimpleFeature feature, Geometry geometry) {
        this.selLock.readLock().lock();
        try {
            if (!this.hasSelection(layer)) {
                ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
                return arrayList;
            }
            Collection<Geometry> collection = this.items(geometry, this.getFeatureToSelectedItemIndexCollectionMap(layer).getItems(this.getSelectionFeatureInternal(layer, feature)));
            return collection;
        }
        finally {
            this.selLock.readLock().unlock();
        }
    }

    public Collection<Integer> indices(Geometry geometry, Collection<Geometry> items) {
        List<Geometry> allItems = this.items(geometry);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Geometry item : items) {
            indices.add(allItems.indexOf(item));
        }
        return indices;
    }

    public void unselectItems(Layer layer, CollectionMap<SimpleFeature, Geometry> featureToItemCollectionMap) {
        this.selectionManager.runWithoutUpdates(() -> {
            for (SimpleFeature feature : featureToItemCollectionMap.keySet()) {
                this.unselectItems(layer, feature, featureToItemCollectionMap.getItems(feature));
            }
        });
        this.updatePanel();
    }

    public void selectItems(Layer layer, CollectionMap<SimpleFeature, Geometry> featureToItemCollectionMap) {
        if (!layer.isSelectable()) {
            return;
        }
        this.selectionManager.runWithoutUpdates(() -> {
            for (SimpleFeature feature : featureToItemCollectionMap.keySet()) {
                this.selectItems(layer, feature, featureToItemCollectionMap.getItems(feature));
            }
        });
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItems(Layer layer, SimpleFeature feature, Collection<Geometry> items) {
        if (!layer.isSelectable()) {
            return;
        }
        this.selLock.writeLock().lock();
        try {
            Collection<Geometry> itemsToSelect = this.itemsNotSelectedInAncestors(layer, feature, items);
            this.selectionManager.runWithoutUpdates(() -> {
                SimpleFeature selectionFeature = this.getSelectionFeatureInternal(layer, feature);
                if (selectionFeature.getID() != null && !selectionFeature.getID().equals(feature.getID())) {
                    this.unselectInDescendants(layer, selectionFeature, itemsToSelect);
                    this.getFeatureToSelectedItemIndexCollectionMapCreate(layer).remove(selectionFeature);
                    this.getFidToFeatureMapCreate(layer).remove(selectionFeature.getID());
                }
                this.getFidToFeatureMapCreate(layer).put(feature.getID(), feature);
                this.getFeatureToSelectedItemIndexCollectionMapCreate(layer).addItems(this.getSelectionFeatureInternal(layer, feature), this.indices((Geometry)feature.getDefaultGeometry(), itemsToSelect));
            });
        }
        finally {
            this.selLock.writeLock().unlock();
        }
        this.updatePanel();
    }

    public void unselectItems(Layer layer, SimpleFeature feature, Collection<Geometry> items) {
        this.selectionManager.runWithoutUpdates(() -> {
            ArrayList<SimpleFeature> lstFeat2Unselect = new ArrayList<SimpleFeature>();
            this.selLock.writeLock().lock();
            try {
                if (!this.hasSelection(layer)) {
                    return;
                }
                SimpleFeature selFeature = this.getSelectionFeatureInternal(layer, feature);
                CollectionMap<SimpleFeature, Integer> mapCol = this.getFeatureToSelectedItemIndexCollectionMap(layer);
                mapCol.removeItems(selFeature, this.indices((Geometry)selFeature.getDefaultGeometry(), items));
                if (mapCol.getItems(selFeature).isEmpty()) {
                    lstFeat2Unselect.add(selFeature);
                }
            }
            finally {
                this.selLock.writeLock().unlock();
            }
            for (SimpleFeature feat : lstFeat2Unselect) {
                this.unselectItems(layer, feat);
            }
        });
        this.updatePanel();
    }

    private Collection<Geometry> itemsNotSelectedInAncestors(Layer layer, SimpleFeature feature, Collection<Geometry> items) {
        ArrayList<Geometry> itemsNotSelectedInAncestors = new ArrayList<Geometry>();
        for (Geometry item : items) {
            if (this.selectedInAncestors(layer, feature, item)) continue;
            itemsNotSelectedInAncestors.add(item);
        }
        return itemsNotSelectedInAncestors;
    }

    public void selectItems(Layer layer, SimpleFeature feature) {
        this.selectItems(layer, feature, this.items((Geometry)feature.getDefaultGeometry()));
    }

    public void selectItems(Layer layer, Collection<SimpleFeature> features) {
        if (!layer.isSelectable()) {
            return;
        }
        this.selectionManager.runWithoutUpdates(() -> {
            for (SimpleFeature feature : features) {
                this.selectItems(layer, feature);
            }
        });
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectFromFeaturesWithModifiedItemCounts(Layer layer, Collection<SimpleFeature> features, Collection<SimpleFeature> oldFeatureClones) {
        ArrayList<SimpleFeature> featuresToUnselect = new ArrayList<SimpleFeature>();
        ArrayList<SimpleFeature> featuresToUpdate = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> j = oldFeatureClones.iterator();
        this.selLock.readLock().lock();
        try {
            for (SimpleFeature feature : features) {
                if (j.hasNext()) {
                    SimpleFeature oldFeatureClone = j.next();
                    if (!this.hasSelection(layer, feature)) continue;
                    if (this.items((Geometry)feature.getDefaultGeometry()).size() != this.items((Geometry)oldFeatureClone.getDefaultGeometry()).size()) {
                        featuresToUnselect.add(feature);
                        continue;
                    }
                } else {
                    featuresToUnselect.add(feature);
                    continue;
                }
                featuresToUpdate.add(feature);
            }
        }
        finally {
            this.selLock.readLock().unlock();
        }
        this.unselectItems(layer, featuresToUnselect);
        for (SimpleFeature feature : featuresToUpdate) {
            Collection<Integer> colGeomIdx = this.getSelectedItemIndices(layer, feature);
            Collection<Geometry> colGeom = this.items((Geometry)feature.getDefaultGeometry(), colGeomIdx);
            this.unselectItems(layer, feature);
            this.selectItems(layer, feature, colGeom);
        }
    }

    public void unselectItems() {
        this.selLock.writeLock().lock();
        try {
            this.layerMap.clear();
            this.layerFidMap.clear();
        }
        finally {
            this.selLock.writeLock().unlock();
        }
        this.updatePanel();
    }

    public void unselectItems(Layer layer) {
        this.selLock.writeLock().lock();
        try {
            this.layerMap.remove(layer);
            this.layerFidMap.remove(layer);
        }
        finally {
            this.selLock.writeLock().unlock();
        }
        this.updatePanel();
    }

    public void unselectItems(Layer layer, Collection<SimpleFeature> features) {
        this.selectionManager.runWithoutUpdates(() -> {
            for (SimpleFeature feature : features) {
                this.unselectItems(layer, feature);
            }
        });
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, SimpleFeature feature) {
        this.selLock.writeLock().lock();
        try {
            if (!this.hasSelection(layer)) {
                return;
            }
            CollectionMap<SimpleFeature, Integer> mapCol = this.getFeatureToSelectedItemIndexCollectionMap(layer);
            if (mapCol == null) {
                return;
            }
            mapCol.remove(this.getSelectionFeatureInternal(layer, feature));
            if (mapCol.isEmpty()) {
                this.layerMap.remove(layer);
            }
            this.getFidToFeatureMap(layer).remove(feature.getID());
            if (this.getFidToFeatureMap(layer).isEmpty()) {
                this.layerFidMap.remove(layer);
            }
        }
        finally {
            this.selLock.writeLock().unlock();
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItem(Layer layer, SimpleFeature feature, int selectedItemIndex) {
        boolean bolUnselectFeature = false;
        this.selLock.writeLock().lock();
        try {
            if (!this.hasSelection(layer)) {
                return;
            }
            feature = this.getSelectionFeatureInternal(layer, feature);
            CollectionMap<SimpleFeature, Integer> mapCol = this.getFeatureToSelectedItemIndexCollectionMap(layer);
            mapCol.removeItem(feature, selectedItemIndex);
            if (mapCol.getItems(feature).isEmpty()) {
                bolUnselectFeature = true;
            }
        }
        finally {
            this.selLock.writeLock().unlock();
        }
        if (bolUnselectFeature) {
            this.unselectItems(layer, feature);
        }
    }

    private void updatePanel() {
        this.selectionManager.updatePanel();
    }

    public void setChild(AbstractSelection child) {
        this.child = child;
    }

    public void setParent(AbstractSelection parent) {
        this.parent = parent;
    }

    protected AbstractSelection getChild() {
        return this.child;
    }

    protected AbstractSelection getParent() {
        return this.parent;
    }
}

