/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style.theming;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.DynamicThemeRetriever;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.StaticThemeRetriever;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.intelligence.JumpModelIntelligence;
import de.riwagis.riwajump.model.style.theme.DynamicThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.StaticDiscreteThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.StaticRangeThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.ThemeModel;
import de.riwagis.riwajump.model.style.theme.ThemeSourceModel;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThemeRetriever<T extends ThemeSourceModel>
implements JumpModelIntelligence<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThemeRetriever.class);
    private final T model;

    ThemeRetriever(T model) {
        this.model = model;
    }

    public T getModel() {
        return this.model;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
    }

    public abstract Collection<ThemeModel> getThemes(Layer var1);

    public abstract ThemeModel getThemeForObject(Layer var1, Object var2);

    public abstract void clearCaches();

    public Collection<ThemeModel> getThemesOrEmptyOnError(Layer layer) {
        try {
            return this.getThemes(layer);
        }
        catch (Exception e) {
            log.warn("Could not retrieve themes", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void setUserDefinedAlpha(Layer layer, int alpha) {
        this.getThemes(layer).forEach(ts -> this.getRendererForTheme((ThemeModel)ts).setUserDefinedAlpha(alpha));
    }

    protected BasicStyleRenderer getRendererForTheme(ThemeModel model) {
        return (BasicStyleRenderer)model.getStyle().getIntelligence();
    }

    static {
        IntelligenceFactory.register(StaticDiscreteThemeSourceModel.class, StaticThemeRetriever::new);
        IntelligenceFactory.register(StaticRangeThemeSourceModel.class, StaticThemeRetriever::new);
        IntelligenceFactory.register(DynamicThemeSourceModel.class, DynamicThemeRetriever::new);
    }
}

