/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style.theming;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.ThemeRetriever;
import de.riwagis.geotools.feature.bsh.FeatBshObjectBuilder;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.model.event.JumpModelChangedListener;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeModificatorArgumentType;
import de.riwagis.riwajump.model.style.theme.DynamicThemeModificatorModel;
import de.riwagis.riwajump.model.style.theme.DynamicThemeSourceModel;
import de.riwagis.riwajump.model.style.theme.ThemeModel;
import de.riwagis.riwajump.search.intelligence.SearchSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.LookupTranslator;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicThemeRetriever
extends ThemeRetriever<DynamicThemeSourceModel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamicThemeRetriever.class);
    private static final CharSequenceTranslator ESCAPE_JAVA_STRINGS = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Map.of("\"", "\\\"")), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE)});
    private static final Map<DynamicThemeModificatorArgumentType, Function<Object, Object>> TYPE_APPLIERS = Map.of(DynamicThemeModificatorArgumentType.BEANSHELL, String::valueOf, DynamicThemeModificatorArgumentType.STRING, String::valueOf, DynamicThemeModificatorArgumentType.COLOR, val -> new ColorModel(String.valueOf(val)), DynamicThemeModificatorArgumentType.BOOLEAN, val -> BooleanUtils.toBoolean((String)String.valueOf(val)), DynamicThemeModificatorArgumentType.INTEGER, val -> DynamicThemeRetriever.parseOrDefault(val, NumberUtils::createInteger, 0), DynamicThemeModificatorArgumentType.FLOAT, val -> DynamicThemeRetriever.parseOrDefault(val, NumberUtils::createFloat, Float.valueOf(0.0f)), DynamicThemeModificatorArgumentType.DOUBLE, val -> DynamicThemeRetriever.parseOrDefault(val, NumberUtils::createDouble, 0.0));
    private List<ThemeModel> cachedThemes = Collections.emptyList();
    private Map<Object, ThemeModel> cachedThemePerObject = Collections.emptyMap();
    private final ReentrantLock accessLock = new ReentrantLock();
    private boolean invalidateCaches = true;
    private int userDefinedAlpha = 255;

    public DynamicThemeRetriever(DynamicThemeSourceModel model) {
        super(model);
    }

    @Override
    public Collection<ThemeModel> getThemes(Layer layer) {
        try {
            this.accessLock.lock();
            if (this.invalidateCaches) {
                this.computeThemes(layer);
            }
            List<ThemeModel> list = this.cachedThemes;
            return list;
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThemeModel getThemeForObject(Layer layer, Object key) {
        try {
            this.accessLock.lock();
            if (this.invalidateCaches) {
                this.computeThemes(layer);
            }
            ThemeModel themeModel = this.cachedThemePerObject.get(key);
            return themeModel;
        }
        finally {
            this.accessLock.unlock();
        }
    }

    @Override
    public void clearCaches() {
        try {
            this.accessLock.lock();
            this.invalidateCaches = true;
        }
        finally {
            this.accessLock.unlock();
        }
    }

    @Override
    public void setUserDefinedAlpha(Layer layer, int alpha) {
        try {
            this.accessLock.lock();
            this.userDefinedAlpha = alpha;
            if (!this.invalidateCaches) {
                super.setUserDefinedAlpha(layer, alpha);
            }
        }
        finally {
            this.accessLock.unlock();
        }
    }

    private void computeThemes(Layer layer) throws IllegalStateException, IllegalArgumentException {
        if (layer == null) {
            throw new IllegalArgumentException("Dynamic Theme Retriever requires FMD of source layer for initial fetch");
        }
        FeaturestoreMetadata fmd = layer.getFMD();
        DMDCollection dmdCol = layer.getDMDCol();
        if (dmdCol == null || fmd == null) {
            throw new IllegalArgumentException("FMD or DMD is missing for layer using dynamic theme source");
        }
        DynamicThemeSourceModel model = (DynamicThemeSourceModel)this.getModel();
        FeaturestoreMetadata themeFMD = new FeaturestoreMetadata("internal_theme_source");
        themeFMD.setDatastoreName(fmd.getDatastoreName());
        themeFMD.setDatatypeName(model.getDatatypeName());
        themeFMD.setAttributes((String[])model.getAttributes().toArray(String[]::new));
        themeFMD.setFilterText(model.getFilter());
        themeFMD.setKeyAtt(SearchSupport.nullIfPrimaryKey(model.getThemeAttribute()));
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = themeFMD.getFeatureReader(dmdCol, (Filter)Filter.INCLUDE);){
            FeatBshObjectBuilder labelBuilder = FeatBshObjectBuilder.getInstance((String)model.getLabelTemplate());
            HashMap<DynamicThemeModificatorModel, FeatBshObjectBuilder> modBuilders = new HashMap<DynamicThemeModificatorModel, FeatBshObjectBuilder>();
            for (DynamicThemeModificatorModel modificator : model.getModificators()) {
                modBuilders.put(modificator, FeatBshObjectBuilder.getInstance((String)modificator.getBsh()));
            }
            int count = 0;
            ArrayList<ThemeModel> themes = new ArrayList<ThemeModel>();
            while (reader.hasNext()) {
                if (++count > 500) {
                    log.warn("Exceeded maximum themes per layer limit.");
                    break;
                }
                SimpleFeature feature = (SimpleFeature)reader.next();
                labelBuilder.setFeature(feature);
                Object key = SearchSupport.getFeatureAtt(feature, model.getThemeAttribute());
                String label = Objects.toString(labelBuilder.getObject());
                BasicStyleModel newStyle = this.computeStyleModel(model, modBuilders, feature);
                this.registerThemeEnabledStateUpdater(newStyle, model, key);
                ThemeModel themeModel = this.createThemeModelAndTakeOverUserSettings(model, key, label, newStyle);
                themes.add(themeModel);
            }
            this.cleanUpOldThemes();
            this.cachedThemes = themes;
            this.cachedThemePerObject = themes.stream().collect(Collectors.toMap(t -> t.getKey(), t -> t));
            this.removeMissingInvisibleThemes();
            this.invalidateCaches = false;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not retrieve dynamic theme features", ex);
        }
    }

    private void registerThemeEnabledStateUpdater(BasicStyleModel newStyle, DynamicThemeSourceModel model, Object key) {
        RenderUtil.getRenderer(newStyle).addModelChangedListener(new InvisibleThemeListUpdater(model, key));
    }

    private void removeMissingInvisibleThemes() {
        Set invisibleThemes = ((DynamicThemeSourceModel)this.getModel()).getInvisibleThemes();
        List deadThemes = invisibleThemes.stream().filter(key -> !this.cachedThemePerObject.containsKey(key)).collect(Collectors.toList());
        invisibleThemes.removeAll(deadThemes);
    }

    private ThemeModel createThemeModelAndTakeOverUserSettings(DynamicThemeSourceModel model, Object key, String label, BasicStyleModel newStyle) {
        ThemeModel themeModel = new ThemeModel(key, label, newStyle);
        newStyle.setEnabled(this.getEnabledStateFromModel(model, key));
        BasicStyleRenderer themeRenderer = this.getRendererForTheme(themeModel);
        themeRenderer.setUserDefinedAlpha(this.userDefinedAlpha);
        return themeModel;
    }

    private BasicStyleModel computeStyleModel(DynamicThemeSourceModel model, Map<DynamicThemeModificatorModel, FeatBshObjectBuilder> modBuilders, SimpleFeature feature) throws CloneNotSupportedException {
        BasicStyleModel newStyle = model.getTemplateStyle().clone();
        for (DynamicThemeModificatorModel modificator : model.getModificators()) {
            FeatBshObjectBuilder modBuilder = modBuilders.get(modificator);
            modBuilder.setFeature(feature);
            BiConsumer styleApplier = modificator.getStyleApplier();
            Object newValue = modBuilder.getObject();
            Object newValueConverted = this.convertAndEscape(modificator, newValue);
            styleApplier.accept(newStyle, newValueConverted);
        }
        return newStyle;
    }

    private boolean getEnabledStateFromModel(DynamicThemeSourceModel model, Object key) {
        Set invisibleThemes = model.getInvisibleThemes();
        if (invisibleThemes == null || key == null) {
            return true;
        }
        return !invisibleThemes.contains(key);
    }

    private void cleanUpOldThemes() {
        this.cachedThemes.stream().map(theme -> theme.getStyle()).filter(style -> style != null).forEach(style -> style.cleanUp());
    }

    private Object convertAndEscape(DynamicThemeModificatorModel modificator, Object rawValue) {
        DynamicThemeModificatorArgumentType type = modificator.getApplierType();
        Function<Object, Object> converter = TYPE_APPLIERS.get(type);
        Objects.requireNonNull(converter, "Cannot convert given type for dynamic theme");
        if (type.canBeBeanShell() && !modificator.isResultBeanShell()) {
            return converter.apply(DynamicThemeRetriever.escapeStringIfNeeded(rawValue));
        }
        return converter.apply(rawValue);
    }

    private static Object escapeStringIfNeeded(Object value) {
        if (value instanceof String) {
            return "\"" + ESCAPE_JAVA_STRINGS.translate((CharSequence)((String)value)) + "\"";
        }
        return value;
    }

    private static <T> T parseOrDefault(Object value, Function<String, T> converter, T defaultValue) {
        String stringValue = String.valueOf(value);
        if (!NumberUtils.isCreatable((String)stringValue)) {
            log.warn("Value '{}' is not a valid number", (Object)stringValue);
            return defaultValue;
        }
        return converter.apply(stringValue);
    }

    private static class InvisibleThemeListUpdater
    implements JumpModelChangedListener {
        private final DynamicThemeSourceModel model;
        private final Object key;

        public InvisibleThemeListUpdater(DynamicThemeSourceModel model, Object key) {
            this.model = model;
            this.key = key;
        }

        public void fireJumpModelChanged(JumpModelEvent event) {
            if (!event.getPropertyName().equals("enabled")) {
                return;
            }
            boolean enabled = (Boolean)event.getPropertyValue();
            Set invisibleThemes = this.model.getInvisibleThemes();
            if (enabled) {
                invisibleThemes.remove(this.key);
            } else {
                invisibleThemes.add(this.key);
            }
        }
    }
}

