/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;

public abstract class VertexRenderer
implements StyleRenderer {
    transient Shape shape;
    protected int size = 4;
    private Color fillColor = null;
    private boolean enabled = false;
    private Color strokeColor = null;

    protected VertexRenderer() {
    }

    protected VertexRenderer(Shape shape) {
        this.shape = shape;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void initialize(StyleCollection _sCol) {
        LayerStyleCollection sCol = (LayerStyleCollection)_sCol;
        this.fillColor = GUIUtil.alphaColor(sCol.getBasicStyle().getFillColor(), sCol.getBasicStyle().getIntAlpha());
        if (sCol.getBasicStyle().doesRenderLine()) {
            this.strokeColor = GUIUtil.alphaColor(sCol.getBasicStyle().retrieveLeadingLineStyle().getLineColor(), sCol.getBasicStyle().getIntAlpha());
        }
    }

    public List getDecorationRenderer() {
        return null;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        Coordinate[] coordinates = ((Geometry)f.getDefaultGeometry()).getCoordinates();
        g.setColor(this.fillColor);
        for (Coordinate coordinate : coordinates) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinate)) continue;
            this.paint(g, viewport.toViewPoint(new Point2D.Double(coordinate.x, coordinate.y)));
        }
    }

    public void paint(Graphics2D g, Point2D p) {
        this.setFrame(p);
        this.render(g);
    }

    private void setFrame(Point2D p) {
        ((RectangularShape)this.shape).setFrame(p.getX() - (double)this.getSize() / 2.0, p.getY() - (double)this.getSize() / 2.0, this.getSize(), this.getSize());
    }

    protected void render(Graphics2D g) {
        g.setColor(this.strokeColor);
        g.draw(this.shape);
        g.setColor(this.fillColor);
        g.fill(this.shape);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public void cleanUp() {
    }

    @Override
    public boolean needsRendering() {
        return true;
    }
}

