/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.geom.Angle;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BshBuilderCache;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import de.riwagis.geotools.feature.RenderPointSpec;
import de.riwagis.geotools.feature.RenderType;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.FontModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.util.jts.CoordinateArraySupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextRenderer
extends AbstractStyleRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextRenderer.class);
    private final LRUMap<Pair<String, Font>, TextLayout> layoutCache = new LRUMap(5000, 100);
    private final LRUMap<Pair<String, Integer>, Font> fontCache = new LRUMap(250, 25);
    private static final int DEFAULT_TEXT_HEIGHT_PX_OR_DU = 10;
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
    private static final String TEXT_CONSTANT_TY = "Ty";
    private static final int MIN_TEXT_HEIGHT = 4;
    private static final int MIN_FONT_SIZE = 5;
    private final transient Lock calcLock = new ReentrantLock();
    public static final int LEFT_TOP = 1;
    public static final int CENTER_TOP = 2;
    public static final int RIGHT_TOP = 3;
    public static final int LEFT_CENTER = 4;
    public static final int CENTER_CENTER = 5;
    public static final int RIGHT_CENTER = 6;
    public static final int LEFT_BOTTOM = 7;
    public static final int CENTER_BOTTOM = 8;
    public static final int RIGHT_BOTTOM = 9;
    private static final String BSH_TEXT_KEY = "BSH_TEXT_KEY";
    private static final String BSH_ORI_KEY = "BSH_ORI_KEY";
    private static final String BSH_HEIGHT_KEY = "BSH_HEIGHT_KEY";
    private static final String BSH_LEFT_KEY = "BSH_LEFT_KEY";
    private static final String BSH_TOP_KEY = "BSH_TOP_KEY";
    private static final String BSH_ALIGN_POINT_KEY = "BSH_ALIGN_POINT_KEY";
    private static final String BSH_ALIGN_LINE_KEY = "BSH_ALIGN_LINE_KEY";
    private static final String BSH_ALIGN_AREA_KEY = "BSH_ALIGN_AREA_KEY";
    private static final String BSH_COLOR_KEY = "BSH_COLOR_KEY";
    private static final String BSH_OPAQUE_COLOR_KEY = "BSH_OPAQUE_COLOR_KEY";
    private Font awtTextFont = null;
    private final transient BshBuilderCache bbCache = new BshBuilderCache();
    private final TextStyleModel textStyle;
    private Color renderTextColor = null;
    private Color renderOpaqueColor = null;

    private TextRenderer(TextStyleModel textStyle) {
        this.textStyle = textStyle;
    }

    public TextStyleModel getModel() {
        return this.textStyle;
    }

    @Override
    public boolean isEnabled() {
        return this.textStyle.isEnabled();
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        this.renderTextColor = null;
        this.renderOpaqueColor = null;
        try {
            this.calcLock.lock();
            if (modelEvent.getPropertyName().equalsIgnoreCase("strText")) {
                this.bbCache.reinitStringBuilder(BSH_TEXT_KEY);
            }
            if (modelEvent.getPropertyName().equalsIgnoreCase("strOrient")) {
                this.bbCache.reinitCalculator(BSH_ORI_KEY);
            }
            if (modelEvent.getPropertyName().equalsIgnoreCase("strHeight")) {
                this.bbCache.reinitCalculator(BSH_HEIGHT_KEY);
            }
            if (modelEvent.getPropertyName().equalsIgnoreCase("strTransTop")) {
                this.bbCache.reinitCalculator(BSH_TOP_KEY);
            }
            if (modelEvent.getPropertyName().equalsIgnoreCase("strTransLeft")) {
                this.bbCache.reinitCalculator(BSH_LEFT_KEY);
            }
            if (modelEvent.getPropertyName().equalsIgnoreCase("colorText")) {
                this.bbCache.reinitObjectBuilder(BSH_COLOR_KEY);
            }
            if (modelEvent.getPropertyName().equalsIgnoreCase("colorOpaque")) {
                this.bbCache.reinitObjectBuilder(BSH_OPAQUE_COLOR_KEY);
            }
            if (modelEvent.getPropertyName().equalsIgnoreCase("fontText")) {
                this.awtTextFont = null;
            }
        }
        finally {
            this.calcLock.unlock();
        }
        this.clearLegendLabelCache();
    }

    private Color getTextColorInternal() {
        if (this.renderTextColor == null) {
            this.renderTextColor = RiwaJumpModelUtilities.colorByColorModel(this.textStyle.getColorText());
        }
        return this.renderTextColor;
    }

    private Color getOpaqueColorInternal() {
        if (this.renderOpaqueColor == null) {
            this.renderOpaqueColor = RiwaJumpModelUtilities.colorByColorModel(this.textStyle.getColorOpaque());
        }
        return this.renderOpaqueColor;
    }

    @Override
    public void initialize(StyleCollection sCol) {
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return Collections.emptyList();
    }

    public String getTextForFeature(SimpleFeature f) {
        return this.bbCache.getStringValue(BSH_TEXT_KEY, this.textStyle.getStrText(), f, "");
    }

    public double getOriForFeature(SimpleFeature f, double defaultValue) {
        return this.bbCache.getCalcValue(BSH_ORI_KEY, this.textStyle.getStrOrient(), f, defaultValue);
    }

    public double getHeightForFeature(SimpleFeature f, double defaultValue) {
        return this.bbCache.getCalcValue(BSH_HEIGHT_KEY, this.textStyle.getStrHeight(), f, defaultValue);
    }

    public double getLeftForFeature(SimpleFeature f, double defaultValue) {
        return this.bbCache.getCalcValue(BSH_LEFT_KEY, this.textStyle.getStrTransLeft(), f, defaultValue);
    }

    public double getTopForFeature(SimpleFeature f, double defaultValue) {
        return this.bbCache.getCalcValue(BSH_TOP_KEY, this.textStyle.getStrTransTop(), f, defaultValue);
    }

    public int getAlignPointForFeature(SimpleFeature f, int defaultValue) {
        return (int)Math.round(this.bbCache.getCalcValue(BSH_ALIGN_POINT_KEY, this.textStyle.getAlignPoint(), f, defaultValue));
    }

    public int getAlignLineForFeature(SimpleFeature f, int defaultValue) {
        return (int)Math.round(this.bbCache.getCalcValue(BSH_ALIGN_LINE_KEY, this.textStyle.getAlignLine(), f, defaultValue));
    }

    public int getAlignAreaForFeature(SimpleFeature f, int defaultValue) {
        return (int)Math.round(this.bbCache.getCalcValue(BSH_ALIGN_AREA_KEY, this.textStyle.getAlignArea(), f, defaultValue));
    }

    @Override
    public boolean needsRendering() {
        return StringUtils.isNotBlank((CharSequence)this.textStyle.getStrText());
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.textStyle.getStrText())) {
            return;
        }
        ModelSpaceLabelSpec spec = this.modelSpaceLabelSpec(f);
        String strLabelText = this.getTextForFeature(f);
        if (StringUtils.isBlank((CharSequence)strLabelText)) {
            return;
        }
        double unitheight = this.getHeightForFeature(f, 10.0);
        double height = this.textStyle.getIntUnitLengthText() == 1 ? unitheight * viewport.getScale() : unitheight * viewport.getPixelScale();
        double dblTransLeft = this.getLeftForFeature(f, 0.0);
        double dblTransTop = this.getTopForFeature(f, 0.0) * -1.0;
        if (this.textStyle.getIntUnitLength() == 1) {
            dblTransLeft *= viewport.getScale();
            dblTransTop *= viewport.getScale();
        } else {
            dblTransLeft *= viewport.getPixelScale();
            dblTransTop *= viewport.getPixelScale();
        }
        Object oldFractionalMetrics = g.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        for (int i = 0; i < spec.arrlocation.length; ++i) {
            Point2D labelCentreInViewSpace = viewport.toViewPoint(new Point2D.Double(spec.arrlocation[i].x, spec.arrlocation[i].y));
            this.paintText(g, strLabelText, labelCentreInViewSpace, spec.arrangle[i], spec.arrpos[i], height, dblTransLeft, dblTransTop, tree, f, spec.arrgeo[i]);
        }
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldFractionalMetrics);
    }

    void paintText(Graphics2D g, String text, Point2D viewCentre, double angle, int pos, double height, double dblTransLeft, double dblTransTop, ShapeFeatureSTRtree tree, SimpleFeature f, Geometry geo) {
        String[] arrtext = text.split("\\n");
        TextLayout[] arrlayout = new TextLayout[arrtext.length];
        for (int i = 0; i < arrtext.length; ++i) {
            if (arrtext[i].length() == 0) {
                arrtext[i] = " ";
            }
            arrlayout[i] = this.getTextLayout(g, arrtext[i], height);
        }
        this.paintText(g, arrlayout, viewCentre, angle, pos, height, dblTransLeft, dblTransTop, tree, f, geo);
    }

    void paintText(Graphics2D g, String text, Point2D viewCentre, double angle, int pos, double height, double dblTransLeft, double dblTransTop, ShapeFeatureSTRtree tree, SimpleFeature f) {
        this.paintText(g, text, viewCentre, angle, pos, height, dblTransLeft, dblTransTop, tree, f, (Geometry)f.getDefaultGeometry());
    }

    private TextLayout getTextLayout(Graphics2D g, String text, double heightInPx) {
        Pair of = Pair.of((Object)text, (Object)this.retrieveAwtFontForRendering(heightInPx));
        return (TextLayout)this.layoutCache.computeIfAbsent((Object)of, textAndHeight -> {
            AttributedString as = new AttributedString((String)textAndHeight.getLeft());
            as.addAttribute(TextAttribute.FONT, textAndHeight.getRight());
            AttributedCharacterIterator iterator = as.getIterator();
            return new TextLayout(iterator, g.getFontRenderContext());
        });
    }

    void paintText(Graphics2D g, TextLayout[] arrlayout, Point2D viewCentre, double angle, int pos, double height, double dblTransLeft, double dblTransTop, ShapeFeatureSTRtree tree, SimpleFeature f) {
        this.paintText(g, arrlayout, viewCentre, angle, pos, height, dblTransLeft, dblTransTop, tree, f, (Geometry)f.getDefaultGeometry());
    }

    private void paintText(Graphics2D g, TextLayout[] arrlayout, Point2D viewCentre, double angle, int pos, double height, double dblTransLeft, double dblTransTop, ShapeFeatureSTRtree tree, SimpleFeature f, Geometry geometry) {
        double maxwidth = 0.0;
        double maxheight = 0.0;
        TextLayout defaultLayout = this.getTy(g, height);
        double linedescent = defaultLayout.getDescent();
        double lineascent = defaultLayout.getAscent();
        for (TextLayout layout : arrlayout) {
            Rectangle2D rect = layout.getBounds();
            if (maxwidth < rect.getWidth()) {
                maxwidth = rect.getWidth();
            }
            maxheight += lineascent;
        }
        maxheight -= linedescent;
        double scale = height / lineascent;
        maxwidth *= scale;
        maxheight *= scale;
        double dblTransTopOri = 0.0;
        double dblTransLeftOri = 0.0;
        if (pos == 1 || pos == 2 || pos == 3) {
            dblTransTopOri = maxheight;
        } else if (pos == 4 || pos == 5 || pos == 6) {
            dblTransTopOri = maxheight / 2.0;
        }
        if (pos == 2 || pos == 5 || pos == 8) {
            dblTransLeftOri = -(maxwidth / 2.0);
        } else if (pos == 3 || pos == 6 || pos == 9) {
            dblTransLeftOri = -maxwidth;
        }
        Shape[] arrShp = new Shape[arrlayout.length];
        Rectangle2D rectOpaque = null;
        for (int i = 0; i < arrlayout.length; ++i) {
            double dblTransLineTop = dblTransTopOri - height * (double)(arrlayout.length - 1 - i);
            AffineTransform transform = new AffineTransform();
            if (this.textStyle.isBolTransInOri()) {
                this.configureTransform(transform, viewCentre, scale, angle, 0.0, 0.0, dblTransLeftOri + dblTransLeft, dblTransLineTop + dblTransTop);
            } else {
                this.configureTransform(transform, viewCentre, scale, angle, dblTransLeft, dblTransTop, dblTransLeftOri, dblTransLineTop);
            }
            arrShp[i] = height > 4.0 || g.getRenderingHint(Viewport.KEY_IS4PRINT) != null ? arrlayout[i].getOutline(transform) : transform.createTransformedShape(arrlayout[i].getBounds());
            if (!this.textStyle.isBolOpaque()) continue;
            Rectangle2D rect = arrlayout[i].getBounds();
            double opaqueBorder = rect.getHeight() / 7.0;
            rect.add(rect.getMinX() - opaqueBorder, rect.getMinY() - opaqueBorder);
            rect.add(rect.getMaxX() + opaqueBorder, rect.getMaxY() + opaqueBorder);
            AffineTransform transformOpaque = new AffineTransform();
            this.configureTransform(transformOpaque, new Point2D.Float(0.0f, 0.0f), 1.0, 0.0, 0.0, 0.0f - arrlayout[i].getAscent() * (float)i, 0.0, 0.0);
            rect = transformOpaque.createTransformedShape(rect).getBounds2D();
            rectOpaque = rectOpaque == null ? rect : rectOpaque.createUnion(rect);
        }
        g.setStroke(DEFAULT_STROKE);
        if (this.textStyle.isBolOpaque() && rectOpaque != null) {
            AffineTransform transform = new AffineTransform();
            if (this.textStyle.isBolTransInOri()) {
                this.configureTransform(transform, viewCentre, scale, angle, 0.0, 0.0, dblTransLeftOri + dblTransLeft, dblTransTopOri + dblTransTop);
            } else {
                this.configureTransform(transform, viewCentre, scale, angle, dblTransLeft, dblTransTop, dblTransLeftOri, dblTransTopOri);
            }
            Shape transRectOpaque = transform.createTransformedShape(rectOpaque);
            g.setColor(this.modulateColorWithUserDefinedAlpha(this.getSBOpaqueColor(f)));
            g.fill(transRectOpaque);
        }
        for (Shape arrShp1 : arrShp) {
            g.setColor(this.modulateColorWithUserDefinedAlpha(this.getSBTextColor(f)));
            g.fill(arrShp1);
        }
        if (!this.textStyle.isBolTransInOri()) {
            viewCentre = new Point2D.Double(viewCentre.getX() + dblTransLeft, viewCentre.getY() + dblTransTop);
        }
        tree.insert(arrShp, f, new RenderPointSpec(RenderType.TEXT, viewCentre, angle / Math.PI * 180.0, geometry), true);
    }

    private TextLayout getTy(Graphics2D g, double heightInPx) {
        return this.getTextLayout(g, TEXT_CONSTANT_TY, heightInPx);
    }

    private void configureTransform(AffineTransform transform, Point2D viewCentre, double scale, double angle, double transLeft, double transTop, double transLeftOri, double transTopOri) {
        double xTranslation = viewCentre.getX() + transLeft;
        double yTranslation = viewCentre.getY() + transTop;
        transform.translate(xTranslation, yTranslation);
        transform.rotate(-angle, 0.0, 0.0);
        transform.translate(transLeftOri, transTopOri);
        transform.scale(scale, scale);
    }

    public Color getSBTextColor(SimpleFeature f) {
        if (this.textStyle.getColorText().isBshColor()) {
            try {
                Object objColor = this.bbCache.getObjectValue(BSH_COLOR_KEY, this.textStyle.getColorText().getBsh(), f, null, true);
                int intAlpha = this.getTextColorInternal() != null ? this.getTextColorInternal().getAlpha() : 255;
                Color bshTextColor = RenderUtil.getColorByObject(objColor, null, this.getTextColorInternal());
                return GUIUtil.alphaColor(bshTextColor, intAlpha);
            }
            catch (Exception e) {
                return this.getTextColorInternal();
            }
        }
        return this.getTextColorInternal();
    }

    public Color getSBOpaqueColor(SimpleFeature f) {
        if (this.textStyle.getColorOpaque().isBshColor()) {
            try {
                Object objColor = this.bbCache.getObjectValue(BSH_OPAQUE_COLOR_KEY, this.textStyle.getColorOpaque().getBsh(), f, null, true);
                int intAlpha = this.getOpaqueColorInternal() != null ? this.getOpaqueColorInternal().getAlpha() : 255;
                Color bshOpaqueColor = RenderUtil.getColorByObject(objColor, null, this.getOpaqueColorInternal());
                return GUIUtil.alphaColor(bshOpaqueColor, intAlpha);
            }
            catch (Exception e) {
                return this.getOpaqueColorInternal();
            }
        }
        return this.getOpaqueColorInternal();
    }

    private ModelSpaceLabelSpec modelSpaceLabelSpec(Geometry geometry, double ori, boolean useOri, int intAlignPoint, int intAlignLine, int intAlignArea) {
        if (geometry == null) {
            return new ModelSpaceLabelSpec(new Coordinate[0], new double[0], new int[0], new Geometry[0]);
        }
        if (geometry instanceof GeometryCollection) {
            ArrayList<Coordinate> lstCoordinates = new ArrayList<Coordinate>();
            ArrayList<Double> lstOri = new ArrayList<Double>();
            ArrayList<Integer> lstInsPoint = new ArrayList<Integer>();
            ArrayList<Geometry> lstGeo = new ArrayList<Geometry>();
            boolean skipAllOtherPoints = false;
            boolean skipAllOtherLineStrings = false;
            boolean skipAllOtherPolygons = false;
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry geom = geometry.getGeometryN(i);
                String geometryType = geom.getGeometryType();
                if ("Point".equals(geometryType) && this.textStyle.isBolShowPoint() && this.textStyle.isBolOnlyLabelFirstPoint()) {
                    if (skipAllOtherPoints) continue;
                    skipAllOtherPoints = true;
                }
                if ("LineString".equals(geometryType) && this.textStyle.isBolShowLine()) {
                    if (skipAllOtherLineStrings) continue;
                    switch (this.textStyle.getIntMultiLine()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            geom = this.getLongestLineString(geometry);
                            skipAllOtherLineStrings = true;
                            break;
                        }
                        default: {
                            skipAllOtherLineStrings = true;
                        }
                    }
                }
                if ("Polygon".equals(geometryType) && this.textStyle.isBolShowArea()) {
                    if (skipAllOtherPolygons) continue;
                    switch (this.textStyle.getIntMultiPolygon()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            geom = this.getLargestPolygon(geometry);
                            skipAllOtherPolygons = true;
                            break;
                        }
                        default: {
                            skipAllOtherPolygons = true;
                        }
                    }
                }
                ModelSpaceLabelSpec spec = this.modelSpaceLabelSpec(geom, ori, useOri, intAlignPoint, intAlignLine, intAlignArea);
                for (int j = 0; j < spec.arrlocation.length; ++j) {
                    lstCoordinates.add(spec.arrlocation[j]);
                    lstOri.add(spec.arrangle[j]);
                    lstInsPoint.add(spec.arrpos[j]);
                    lstGeo.add(spec.arrgeo[j]);
                }
            }
            Coordinate[] arrCoord = new Coordinate[lstCoordinates.size()];
            double[] arrangle = new double[lstCoordinates.size()];
            int[] arrpos = new int[lstCoordinates.size()];
            Geometry[] arrgeo = new Geometry[lstGeo.size()];
            for (int i = 0; i < lstCoordinates.size(); ++i) {
                arrCoord[i] = (Coordinate)lstCoordinates.get(i);
                arrangle[i] = (Double)lstOri.get(i);
                arrpos[i] = (Integer)lstInsPoint.get(i);
                arrgeo[i] = (Geometry)lstGeo.get(i);
            }
            return new ModelSpaceLabelSpec(arrCoord, arrangle, arrpos, arrgeo);
        }
        String geometryType = geometry.getGeometryType();
        if ("Point".equals(geometryType) && this.textStyle.isBolShowPoint()) {
            return new ModelSpaceLabelSpec(geometry.getCoordinates()[0], ori, intAlignPoint, geometry);
        }
        if ("LineString".equals(geometryType) && this.textStyle.isBolShowLine()) {
            if (this.textStyle.getIntPosLine() == 0) {
                LineSegment longestSegment = TextRenderer.longestSegment(geometry);
                return new ModelSpaceLabelSpec(CoordUtil.average(longestSegment.p0, longestSegment.p1), useOri ? ori : TextRenderer.angle(longestSegment), intAlignLine, geometry);
            }
            Coordinate[] arrCoordGeom = geometry.getCoordinates();
            int count = arrCoordGeom.length - 1;
            Coordinate[] arrCoord = new Coordinate[count];
            double[] arrOri = new double[count];
            int[] arrPos = new int[count];
            Object[] arrGeo = new Geometry[count];
            Arrays.fill(arrGeo, geometry);
            for (int i = 0; i < count; ++i) {
                arrCoord[i] = CoordUtil.average(arrCoordGeom[i], arrCoordGeom[i + 1]);
                arrOri[i] = !useOri ? TextRenderer.angle(new LineSegment(arrCoordGeom[i], arrCoordGeom[i + 1])) : ori;
                arrPos[i] = intAlignLine;
            }
            return new ModelSpaceLabelSpec(arrCoord, arrOri, arrPos, (Geometry[])arrGeo);
        }
        if ("Polygon".equals(geometryType) && this.textStyle.isBolShowArea()) {
            if (this.textStyle.getIntPosArea() == 0) {
                return new ModelSpaceLabelSpec(interiorPointFinder.findPoint(geometry), ori, intAlignArea, geometry);
            }
            return new ModelSpaceLabelSpec(geometry.getCoordinates()[0], ori, intAlignArea, geometry);
        }
        return new ModelSpaceLabelSpec(new Coordinate[0], new double[0], new int[0], new Geometry[0]);
    }

    private Geometry getLongestLineString(Geometry geometry) {
        Geometry geomLongestLineString = null;
        double geomLongestLength = Double.MIN_VALUE;
        for (int l = 0; l < geometry.getNumGeometries(); ++l) {
            Geometry current = geometry.getGeometryN(l);
            if (!"LineString".equals(current.getGeometryType())) continue;
            if (geomLongestLineString == null) {
                geomLongestLineString = current;
                geomLongestLength = geomLongestLineString.getLength();
                continue;
            }
            double length = current.getLength();
            if (!(geomLongestLength < length)) continue;
            geomLongestLineString = current;
            geomLongestLength = length;
        }
        return geomLongestLineString;
    }

    private Geometry getLargestPolygon(Geometry geometry) {
        Geometry geomLargestPolygon = null;
        double geomLargestArea = Double.MIN_VALUE;
        for (int l = 0; l < geometry.getNumGeometries(); ++l) {
            Geometry current = geometry.getGeometryN(l);
            if (!"Polygon".equals(current.getGeometryType())) continue;
            if (geomLargestPolygon == null) {
                geomLargestPolygon = current;
                geomLargestArea = geomLargestPolygon.getArea();
                continue;
            }
            double area = current.getArea();
            if (!(geomLargestArea < area)) continue;
            geomLargestPolygon = current;
            geomLargestArea = area;
        }
        return geomLargestPolygon;
    }

    public final ModelSpaceLabelSpec modelSpaceLabelSpec(SimpleFeature feature) {
        double ori = 0.0;
        boolean useOri = true;
        if (StringUtils.isNotBlank((CharSequence)this.textStyle.getStrOrient())) {
            ori = this.getOriForFeature(feature, ori);
            if (this.textStyle.getIntUnitOrient() == 0) {
                ori = ori * Math.PI / 180.0;
            }
            if (this.textStyle.getIntUnitOrient() == 1) {
                ori = ori * Math.PI / 200.0;
            }
        } else {
            useOri = false;
        }
        int intAlignPoint = 7;
        if (this.textStyle.isBolShowPoint() && ((intAlignPoint = this.getAlignPointForFeature(feature, intAlignPoint)) < 1 || intAlignPoint > 9)) {
            intAlignPoint = 7;
        }
        int intAlignLine = 7;
        if (this.textStyle.isBolShowLine() && ((intAlignLine = this.getAlignLineForFeature(feature, intAlignLine)) < 1 || intAlignLine > 9)) {
            intAlignLine = 7;
        }
        int intAlignArea = 7;
        if (this.textStyle.isBolShowArea() && ((intAlignArea = this.getAlignAreaForFeature(feature, intAlignArea)) < 1 || intAlignArea > 9)) {
            intAlignArea = 7;
        }
        return this.modelSpaceLabelSpec((Geometry)feature.getDefaultGeometry(), ori, useOri, intAlignPoint, intAlignLine, intAlignArea);
    }

    public static double angle(LineSegment segment) {
        double angle = Angle.angle(segment.p0, segment.p1);
        if (angle < -1.5707963267948966) {
            angle += Math.PI;
        }
        if (angle > 1.5707963267948966) {
            angle -= Math.PI;
        }
        return angle;
    }

    public static LineSegment longestSegment(Geometry geometry) {
        double maxSegmentLength = -1.0;
        Coordinate c0 = null;
        Coordinate c1 = null;
        Collection arrays = CoordinateArraySupport.toCoordinateArrays((Geometry)geometry, (boolean)false);
        for (Coordinate[] coordinates : arrays) {
            for (int j = 1; j < coordinates.length; ++j) {
                if (!(coordinates[j - 1].distance(coordinates[j]) > maxSegmentLength)) continue;
                maxSegmentLength = coordinates[j - 1].distance(coordinates[j]);
                c0 = coordinates[j - 1];
                c1 = coordinates[j];
            }
        }
        return new LineSegment(c0, c1);
    }

    Font retrieveAwtFontForRendering(double heightInPx) {
        FontModel fontText = this.textStyle.getFontText();
        Pair key = Pair.of((Object)this.buildKeyForFontModel(fontText), (Object)((int)heightInPx));
        return (Font)this.fontCache.computeIfAbsent((Object)key, modelAndHeight -> {
            int calculatedSizeInPt = (int)Math.round((double)((Integer)modelAndHeight.getRight()).intValue() * 72.0 / 96.0);
            int clampedFontSizeInPt = Math.max(5, calculatedSizeInPt);
            return new Font(fontText.getName(), fontText.getStyle(), clampedFontSizeInPt);
        });
    }

    private String buildKeyForFontModel(FontModel fontText) {
        return fontText.getName() + "_" + fontText.getStyle();
    }

    public Font retrieveAwtFont() {
        if (this.awtTextFont == null) {
            FontModel fontText = this.textStyle.getFontText();
            this.awtTextFont = new Font(fontText.getName(), fontText.getStyle(), fontText.getSize());
        }
        return this.awtTextFont;
    }

    public static Font retrieveAwtFont(FontModel fontModel) {
        return new Font(fontModel.getName(), fontModel.getStyle(), fontModel.getSize());
    }

    public static FontModel retrieveFontModel(Font awtFont) {
        return new FontModel(awtFont.getFamily(), awtFont.getStyle(), awtFont.getSize());
    }

    static {
        IntelligenceFactory.register(TextStyleModel.class, TextRenderer::new);
    }

    public static final class ModelSpaceLabelSpec {
        public final double[] arrangle;
        public final Coordinate[] arrlocation;
        public final int[] arrpos;
        public final Geometry[] arrgeo;

        ModelSpaceLabelSpec(Coordinate[] _arrlocation, double[] _arrangle, int[] _arrpos, Geometry[] _arrgeo) {
            this.arrlocation = _arrlocation;
            this.arrangle = _arrangle;
            this.arrpos = _arrpos;
            this.arrgeo = _arrgeo;
        }

        ModelSpaceLabelSpec(Coordinate _location, double _angle, int _pos, Geometry _geo) {
            this.arrlocation = new Coordinate[]{_location};
            this.arrangle = new double[]{_angle};
            this.arrpos = new int[]{_pos};
            this.arrgeo = new Geometry[]{_geo};
        }
    }
}

