/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.geom.Angle;
import com.vividsolutions.jump.geom.InteriorPointFinder;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BshBuilderCache;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import de.riwagis.geotools.feature.RenderPointSpec;
import de.riwagis.geotools.feature.RenderType;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.symbol.SymbolStore;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolRenderer
extends AbstractStyleRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolRenderer.class);
    private static final int POINT = 0;
    private static final int START = 1;
    private static final int END = 2;
    private static final int LINE = 3;
    private static final int AREA = 4;
    public static final String BSH_POINT_SYMBOL_KEY = "strPtSymbol";
    public static final String BSH_LINE_SYMBOL_KEY = "strLineSymbol";
    public static final String BSH_LINESTART_SYMBOL_KEY = "strStartSymbol";
    public static final String BSH_LINEEND_SYMBOL_KEY = "strEndSymbol";
    public static final String BSH_AREA_SYMBOL_KEY = "strAreaSymbol";
    public static final String BSH_POINT_WIDTH_KEY = "strPtWidth";
    public static final String BSH_POINT_HEIGHT_KEY = "strPtHeight";
    public static final String BSH_POINT_LEFT_KEY = "strPtShiftLeft";
    public static final String BSH_POINT_TOP_KEY = "strPtShiftTop";
    public static final String BSH_POINT_ORI_KEY = "strPtOri";
    public static final String BSH_LINE_WIDTH_KEY = "strLineWidth";
    public static final String BSH_LINE_HEIGHT_KEY = "strLineHeight";
    public static final String BSH_LINE_DIST_KEY = "strLineDist";
    public static final String BSH_LINE_SHIFT_KEY = "strLineShift";
    public static final String BSH_LINESTART_WIDTH_KEY = "strStartWidth";
    public static final String BSH_LINESTART_HEIGHT_KEY = "strStartHeight";
    public static final String BSH_LINESTART_ORI_KEY = "strStartOri";
    public static final String BSH_LINEEND_WIDTH_KEY = "strEndWidth";
    public static final String BSH_LINEEND_HEIGHT_KEY = "strEndHeight";
    public static final String BSH_LINEEND_ORI_KEY = "strEndOri";
    public static final String BSH_AREA_WIDTH_KEY = "strAreaWidth";
    public static final String BSH_AREA_HEIGHT_KEY = "strAreaHeight";
    public static final String BSH_AREA_LEFT_KEY = "strAreaShiftLeft";
    public static final String BSH_AREA_TOP_KEY = "strAreaShiftTop";
    public static final String BSH_AREA_ORI_KEY = "strAreaOri";
    public static final String BSH_FEAT_FILL_COLOR_KEY = "featFillColor";
    public static final String BSH_FEAT_LINE_COLOR_KEY = "featLineColor";
    private BshBuilderCache bbCache = new BshBuilderCache();
    private StyleCollection sCol = null;
    private static InteriorPointFinder interiorPointFinder = new InteriorPointFinder();
    private Color renderLineColor = null;
    private Color renderFillColor = null;
    private final SymbolStyleModel symStyle;

    public SymbolRenderer(SymbolStyleModel symStyle) {
        this.symStyle = symStyle;
    }

    public BshBuilderCache getBshBuilderCache() {
        return this.bbCache;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        this.renderLineColor = null;
        this.renderFillColor = null;
        this.bbCache.reinitStringBuilder(modelEvent.getPropertyName());
        this.bbCache.reinitCalculator(modelEvent.getPropertyName());
        this.clearLegendLabelCache();
    }

    private Color getLineColorInternal() {
        if (this.renderLineColor == null) {
            this.renderLineColor = RiwaJumpModelUtilities.colorByColorModel(this.symStyle.getLineColor());
        }
        return this.renderLineColor;
    }

    private Color getOpaqueColorInternal() {
        if (this.renderFillColor == null) {
            this.renderFillColor = RiwaJumpModelUtilities.colorByColorModel(this.symStyle.getFillColor());
        }
        return this.renderFillColor;
    }

    @Override
    public boolean needsRendering() {
        if (this.symStyle.getStrPtSymbol() != null && this.symStyle.getStrPtSymbol().length() > 0) {
            return true;
        }
        if (this.symStyle.getStrStartSymbol() != null && this.symStyle.getStrStartSymbol().length() > 0) {
            return true;
        }
        if (this.symStyle.getStrEndSymbol() != null && this.symStyle.getStrEndSymbol().length() > 0) {
            return true;
        }
        return this.symStyle.getStrAreaSymbol() != null && this.symStyle.getStrAreaSymbol().length() > 0;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport view, ShapeFeatureSTRtree tree) throws NoninvertibleTransformException {
        Shape shp;
        AffineTransform aff;
        int i;
        ViewSymbolSpec spec;
        SymbolStore store = RenderUtil.getSymbolStore(this.symStyle.getStrStorename(), this.sCol.getTask());
        if (store == null) {
            if (ObjectUtils.toString((Object)this.symStyle.getStrStorename()).isEmpty()) {
                return;
            }
            throw new NoninvertibleTransformException(String.format("Symbol store '%s' not found.", this.symStyle.getStrStorename()));
        }
        Color lineOverwrite = this.getSBLineColor(f);
        Color fillOverwrite = this.getSBFillColor(f);
        int alphaOverwrite = this.getAlphaOverwrite() * this.getUserDefinedAlpha() / 255;
        if (this.symStyle.getStrPtSymbol() != null && this.symStyle.getStrPtSymbol().length() > 0) {
            try {
                String strPtSym = this.bbCache.getStringValue(BSH_POINT_SYMBOL_KEY, this.symStyle.getStrPtSymbol(), f, this.symStyle.getStrPtSymbol());
                spec = this.pointSymbolSpec(f, (Geometry)f.getDefaultGeometry(), view);
                for (i = 0; i < spec.x.length; ++i) {
                    aff = new AffineTransform();
                    aff.translate(spec.x[i], spec.y[i]);
                    aff.rotate(-spec.ori[i]);
                    aff.translate(spec.leftinori[i], -spec.topinori[i]);
                    aff.scale(spec.scale[i], spec.scale[i]);
                    shp = (int)spec.width[i] > 0 ? (this.symStyle.isBolPtRatio() ? store.renderSymbol(strPtSym, g, aff, (int)spec.width[i], lineOverwrite, fillOverwrite, alphaOverwrite) : store.renderSymbol(strPtSym, g, aff, (int)spec.width[i], (int)spec.height[i], lineOverwrite, fillOverwrite, alphaOverwrite)) : new Rectangle((int)spec.x[i], (int)spec.y[i], 1, 1);
                    this.add2RenderIndex(tree, f, shp, new RenderPointSpec(RenderType.SYMBOL, (Point2D)new Point2D.Double(spec.x[i], spec.y[i]), spec.ori[i] / Math.PI * 180.0, spec.geometry[i]));
                }
            }
            catch (Exception e) {
                LOG.error("Error Symbol Rendering", (Throwable)e);
                throw new NoninvertibleTransformException(e.getMessage());
            }
        }
        if (this.symStyle.getStrStartSymbol() != null && this.symStyle.getStrStartSymbol().length() > 0) {
            try {
                String strStartSym = this.bbCache.getStringValue(BSH_LINESTART_SYMBOL_KEY, this.symStyle.getStrStartSymbol(), f, this.symStyle.getStrStartSymbol());
                spec = this.startSymbolSpec(f, (Geometry)f.getDefaultGeometry(), view);
                for (i = 0; i < spec.x.length; ++i) {
                    aff = new AffineTransform();
                    aff.translate(spec.x[i], spec.y[i]);
                    aff.rotate(-spec.ori[i]);
                    aff.translate(spec.leftinori[i], -spec.topinori[i]);
                    aff.scale(spec.scale[i], spec.scale[i]);
                    shp = (int)spec.width[i] > 0 ? (this.symStyle.isBolStartRatio() ? store.renderSymbol(strStartSym, g, aff, (int)spec.width[i], lineOverwrite, fillOverwrite, alphaOverwrite) : store.renderSymbol(strStartSym, g, aff, (int)spec.width[i], (int)spec.height[i], lineOverwrite, fillOverwrite, alphaOverwrite)) : new Rectangle((int)spec.x[i], (int)spec.y[i], 1, 1);
                    this.add2RenderIndex(tree, f, shp, new RenderPointSpec(RenderType.SYMBOL, (Point2D)new Point2D.Double(spec.x[i], spec.y[i]), spec.ori[i] / Math.PI * 180.0, spec.geometry[i]));
                }
            }
            catch (Exception e) {
                LOG.error("Error Symbol Rendering", (Throwable)e);
                throw new NoninvertibleTransformException(e.getMessage());
            }
        }
        if (this.symStyle.getStrEndSymbol() != null && this.symStyle.getStrEndSymbol().length() > 0) {
            try {
                String strEndSym = this.bbCache.getStringValue(BSH_LINEEND_SYMBOL_KEY, this.symStyle.getStrEndSymbol(), f, this.symStyle.getStrEndSymbol());
                spec = this.endSymbolSpec(f, (Geometry)f.getDefaultGeometry(), view);
                for (i = 0; i < spec.x.length; ++i) {
                    aff = new AffineTransform();
                    aff.translate(spec.x[i], spec.y[i]);
                    aff.rotate(-spec.ori[i]);
                    aff.translate(spec.leftinori[i], -spec.topinori[i]);
                    aff.scale(spec.scale[i], spec.scale[i]);
                    shp = (int)spec.width[i] > 0 ? (this.symStyle.isBolEndRatio() ? store.renderSymbol(strEndSym, g, aff, (int)spec.width[i], lineOverwrite, fillOverwrite, alphaOverwrite) : store.renderSymbol(strEndSym, g, aff, (int)spec.width[i], (int)spec.height[i], lineOverwrite, fillOverwrite, alphaOverwrite)) : new Rectangle((int)spec.x[i], (int)spec.y[i], 1, 1);
                    this.add2RenderIndex(tree, f, shp, new RenderPointSpec(RenderType.SYMBOL, (Point2D)new Point2D.Double(spec.x[i], spec.y[i]), spec.ori[i] / Math.PI * 180.0, spec.geometry[i]));
                }
            }
            catch (Exception e) {
                LOG.error("Error Symbol Rendering", (Throwable)e);
                throw new NoninvertibleTransformException(e.getMessage());
            }
        }
        if (this.symStyle.getStrAreaSymbol() != null && this.symStyle.getStrAreaSymbol().length() > 0) {
            try {
                String strAreaSym = this.bbCache.getStringValue(BSH_AREA_SYMBOL_KEY, this.symStyle.getStrAreaSymbol(), f, this.symStyle.getStrAreaSymbol());
                spec = this.areaSymbolSpec(f, (Geometry)f.getDefaultGeometry(), view);
                for (i = 0; i < spec.x.length; ++i) {
                    aff = new AffineTransform();
                    aff.translate(spec.x[i], spec.y[i]);
                    aff.rotate(-spec.ori[i]);
                    aff.translate(spec.leftinori[i], -spec.topinori[i]);
                    aff.scale(spec.scale[i], spec.scale[i]);
                    shp = (int)spec.width[i] > 0 ? (this.symStyle.isBolAreaRatio() ? store.renderSymbol(strAreaSym, g, aff, (int)spec.width[i], lineOverwrite, fillOverwrite, alphaOverwrite) : store.renderSymbol(strAreaSym, g, aff, (int)spec.width[i], (int)spec.height[i], lineOverwrite, fillOverwrite, alphaOverwrite)) : new Rectangle((int)spec.x[i], (int)spec.y[i], 1, 1);
                    this.add2RenderIndex(tree, f, shp, new RenderPointSpec(RenderType.SYMBOL, (Point2D)new Point2D.Double(spec.x[i], spec.y[i]), spec.ori[i] / Math.PI * 180.0, spec.geometry[i]));
                }
            }
            catch (Exception e) {
                LOG.error("Error Symbol Rendering", (Throwable)e);
                throw new NoninvertibleTransformException(e.getMessage());
            }
        }
    }

    private void add2RenderIndex(ShapeFeatureSTRtree tree, SimpleFeature f, Shape shp, RenderPointSpec spec) {
        Rectangle2D rect = shp.getBounds2D();
        if (rect.getHeight() < 10.0 && rect.getWidth() < 10.0) {
            tree.insert((Shape)rect, f, spec, true);
        } else {
            tree.insert(shp, f, spec, true);
        }
    }

    public Color getSBFillColor(SimpleFeature f) {
        if (this.symStyle.isBolOverwriteAreaColor()) {
            if (this.symStyle.getFillColor().isBshColor()) {
                try {
                    Object objColor = this.bbCache.getObjectValue(BSH_FEAT_FILL_COLOR_KEY, this.symStyle.getFillColor().getBsh(), f, null, true);
                    return RenderUtil.getColorByObject(objColor, null, this.getOpaqueColorInternal());
                }
                catch (Exception e) {
                    return this.getOpaqueColorInternal();
                }
            }
            return this.getOpaqueColorInternal();
        }
        return null;
    }

    private int getAlphaOverwrite() {
        return this.getOpaqueColorInternal() != null ? this.getOpaqueColorInternal().getAlpha() : 255;
    }

    public Color getSBLineColor(SimpleFeature f) {
        if (this.symStyle.isBolOverwriteLineColor()) {
            if (this.symStyle.getLineColor().isBshColor()) {
                try {
                    Object objColor = this.bbCache.getObjectValue(BSH_FEAT_LINE_COLOR_KEY, this.symStyle.getLineColor().getBsh(), f, null, true);
                    return RenderUtil.getColorByObject(objColor, null, this.getLineColorInternal());
                }
                catch (Exception e) {
                    return this.getLineColorInternal();
                }
            }
            return this.getLineColorInternal();
        }
        return null;
    }

    @Override
    public void initialize(StyleCollection _sCol) {
        this.sCol = _sCol;
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return null;
    }

    private ViewSymbolSpec gcolSymbolSpec(SimpleFeature f, Geometry geometry, Viewport view, int intType) throws NoninvertibleTransformException {
        ArrayList<Double> lstX = new ArrayList<Double>();
        ArrayList<Double> lstY = new ArrayList<Double>();
        ArrayList<Double> lstWidth = new ArrayList<Double>();
        ArrayList<Double> lstHeight = new ArrayList<Double>();
        ArrayList<Double> lstOri = new ArrayList<Double>();
        ArrayList<Double> lstLeftInOri = new ArrayList<Double>();
        ArrayList<Double> lstTopInOri = new ArrayList<Double>();
        ArrayList<Double> lstScale = new ArrayList<Double>();
        ArrayList<Geometry> lstGeometry = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            ViewSymbolSpec spec = null;
            switch (intType) {
                case 0: {
                    spec = this.pointSymbolSpec(f, geometry.getGeometryN(i), view);
                    break;
                }
                case 1: {
                    spec = this.startSymbolSpec(f, geometry.getGeometryN(i), view);
                    break;
                }
                case 2: {
                    spec = this.endSymbolSpec(f, geometry.getGeometryN(i), view);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    spec = this.areaSymbolSpec(f, geometry.getGeometryN(i), view);
                    break;
                }
                default: {
                    spec = new ViewSymbolSpec(new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[1], new Geometry[0]);
                }
            }
            for (int j = 0; j < spec.x.length; ++j) {
                lstX.add(spec.x[j]);
                lstY.add(spec.y[j]);
                lstWidth.add(spec.width[j]);
                lstHeight.add(spec.height[j]);
                lstOri.add(spec.ori[j]);
                lstLeftInOri.add(spec.leftinori[j]);
                lstTopInOri.add(spec.topinori[j]);
                lstScale.add(spec.scale[j]);
                lstGeometry.add(geometry.getGeometryN(i));
            }
        }
        double[] arrX = new double[lstX.size()];
        double[] arrY = new double[lstY.size()];
        double[] arrWidth = new double[lstWidth.size()];
        double[] arrHeight = new double[lstHeight.size()];
        double[] arrOri = new double[lstOri.size()];
        double[] arrLeftInOri = new double[lstLeftInOri.size()];
        double[] arrTopInOri = new double[lstTopInOri.size()];
        double[] arrScale = new double[lstScale.size()];
        Geometry[] arrGeometry = new Geometry[lstGeometry.size()];
        for (int i = 0; i < arrX.length; ++i) {
            arrX[i] = (Double)lstX.get(i);
            arrY[i] = (Double)lstY.get(i);
            arrWidth[i] = (Double)lstWidth.get(i);
            arrHeight[i] = (Double)lstHeight.get(i);
            arrOri[i] = (Double)lstOri.get(i);
            arrLeftInOri[i] = (Double)lstLeftInOri.get(i);
            arrTopInOri[i] = (Double)lstTopInOri.get(i);
            arrScale[i] = (Double)lstScale.get(i);
            arrGeometry[i] = (Geometry)lstGeometry.get(i);
        }
        return new ViewSymbolSpec(arrX, arrY, arrOri, arrWidth, arrHeight, arrLeftInOri, arrTopInOri, arrScale, arrGeometry);
    }

    private ViewSymbolSpec pointSymbolSpec(SimpleFeature f, Geometry geometry, Viewport view) throws NoninvertibleTransformException {
        if (geometry instanceof GeometryCollection) {
            return this.gcolSymbolSpec(f, geometry, view, 0);
        }
        if ((geometry.getGeometryType().equals("Point") || this.symStyle.isBolRenderLineAreaPoints()) && this.symStyle.getStrPtSymbol() != null && this.symStyle.getStrPtSymbol().length() > 0) {
            Coordinate[] arrCoord = new Coordinate[]{geometry.getCoordinates()[0]};
            if (this.symStyle.isBolRenderLineAreaPoints()) {
                arrCoord = geometry.getCoordinates();
            }
            double[] arrX = new double[arrCoord.length];
            double[] arrY = new double[arrCoord.length];
            double[] arrWidth = new double[arrCoord.length];
            double[] arrHeight = new double[arrCoord.length];
            double[] arrLeft = new double[arrCoord.length];
            double[] arrTop = new double[arrCoord.length];
            double[] arrOri = new double[arrCoord.length];
            double[] arrScale = new double[arrCoord.length];
            Object[] arrGeo = new Geometry[arrCoord.length];
            Arrays.fill(arrGeo, geometry);
            for (int i = 0; i < arrCoord.length; ++i) {
                arrWidth[i] = this.bbCache.getCalcValue(BSH_POINT_WIDTH_KEY, this.symStyle.getStrPtWidth(), f, 20.0);
                arrHeight[i] = this.bbCache.getCalcValue(BSH_POINT_HEIGHT_KEY, this.symStyle.getStrPtHeight(), f, 20.0);
                arrLeft[i] = this.bbCache.getCalcValue(BSH_POINT_LEFT_KEY, this.symStyle.getStrPtShiftLeft(), f, 0.0);
                arrTop[i] = this.bbCache.getCalcValue(BSH_POINT_TOP_KEY, this.symStyle.getStrPtShiftTop(), f, 0.0);
                arrOri[i] = this.bbCache.getCalcValue(BSH_POINT_ORI_KEY, this.symStyle.getStrPtOri(), f, 0.0);
                arrScale[i] = 1.0;
                if (this.symStyle.getIntUnitAngle() == 1) {
                    int n = i;
                    arrOri[n] = arrOri[n] * 0.9;
                }
                arrOri[i] = Math.toRadians(arrOri[i]);
                if (this.symStyle.getIntUnitSizeSymbol() == 1) {
                    int n = i;
                    arrWidth[n] = arrWidth[n] * view.getScale();
                    int n2 = i;
                    arrHeight[n2] = arrHeight[n2] * view.getScale();
                } else {
                    int n = i;
                    arrWidth[n] = arrWidth[n] * view.getPixelScale();
                    int n3 = i;
                    arrHeight[n3] = arrHeight[n3] * view.getPixelScale();
                }
                if (this.symStyle.getIntUnitSize() == 1) {
                    int n = i;
                    arrLeft[n] = arrLeft[n] * view.getScale();
                    int n4 = i;
                    arrTop[n4] = arrTop[n4] * view.getScale();
                } else {
                    int n = i;
                    arrLeft[n] = arrLeft[n] * view.getPixelScale();
                    int n5 = i;
                    arrTop[n5] = arrTop[n5] * view.getPixelScale();
                }
                if (arrWidth[i] > 1000.0) {
                    arrScale[i] = arrWidth[i] / 1000.0;
                    arrHeight[i] = arrHeight[i] * 1000.0 / arrWidth[i];
                    arrWidth[i] = 1000.0;
                }
                Point2D symCentre = view.toViewPoint(arrCoord[i]);
                if (!this.symStyle.isBolPtShiftInOri()) {
                    symCentre.setLocation(symCentre.getX() + arrLeft[i], symCentre.getY() - arrTop[i]);
                    arrLeft[i] = 0.0;
                    arrTop[i] = 0.0;
                }
                arrX[i] = symCentre.getX();
                arrY[i] = symCentre.getY();
            }
            return new ViewSymbolSpec(arrX, arrY, arrOri, arrWidth, arrHeight, arrLeft, arrTop, arrScale, (Geometry[])arrGeo);
        }
        return new ViewSymbolSpec(new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[1], new Geometry[0]);
    }

    private ViewSymbolSpec startSymbolSpec(SimpleFeature f, Geometry geometry, Viewport view) throws NoninvertibleTransformException {
        if (geometry instanceof GeometryCollection) {
            return this.gcolSymbolSpec(f, geometry, view, 1);
        }
        if (!geometry.getGeometryType().equals("Point") && this.symStyle.getStrStartSymbol() != null && this.symStyle.getStrStartSymbol().length() > 0) {
            Coordinate coord = geometry.getCoordinates()[0];
            double width = this.bbCache.getCalcValue(BSH_LINESTART_WIDTH_KEY, this.symStyle.getStrStartWidth(), f, 20.0);
            double height = this.bbCache.getCalcValue(BSH_LINESTART_HEIGHT_KEY, this.symStyle.getStrStartHeight(), f, 20.0);
            double ori = this.bbCache.getCalcValue(BSH_LINESTART_ORI_KEY, this.symStyle.getStrStartOri(), f, 0.0);
            double scale = 1.0;
            if (this.symStyle.getIntUnitAngle() == 1) {
                ori *= 0.9;
            }
            if (this.symStyle.getStrStartOri() == null || this.symStyle.getStrStartOri().length() == 0) {
                Coordinate coord1 = geometry.getCoordinates()[1];
                ori = Angle.angle(coord1, coord) - 1.5707963267948966;
            } else {
                ori = Math.toRadians(ori);
            }
            if (this.symStyle.getIntUnitSizeSymbol() == 1) {
                width *= view.getScale();
                height *= view.getScale();
            } else {
                width *= view.getPixelScale();
                height *= view.getPixelScale();
            }
            if (width > 1000.0) {
                scale = width / 1000.0;
                height = height * 1000.0 / width;
                width = 1000.0;
            }
            Point2D symCentre = view.toViewPoint(coord);
            return new ViewSymbolSpec(symCentre.getX(), symCentre.getY(), ori, width, height, 0.0, 0.0, scale, geometry);
        }
        return new ViewSymbolSpec(new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[1], new Geometry[0]);
    }

    private ViewSymbolSpec endSymbolSpec(SimpleFeature f, Geometry geometry, Viewport view) throws NoninvertibleTransformException {
        if (geometry instanceof GeometryCollection) {
            return this.gcolSymbolSpec(f, geometry, view, 2);
        }
        if (!geometry.getGeometryType().equals("Point") && this.symStyle.getStrEndSymbol() != null && this.symStyle.getStrEndSymbol().length() > 0) {
            Coordinate[] arrCoord = geometry.getCoordinates();
            Coordinate coord = arrCoord[arrCoord.length - 1];
            double width = this.bbCache.getCalcValue(BSH_LINEEND_WIDTH_KEY, this.symStyle.getStrEndWidth(), f, 20.0);
            double height = this.bbCache.getCalcValue(BSH_LINEEND_HEIGHT_KEY, this.symStyle.getStrEndHeight(), f, 20.0);
            double ori = this.bbCache.getCalcValue(BSH_LINEEND_ORI_KEY, this.symStyle.getStrEndOri(), f, 0.0);
            double scale = 1.0;
            if (this.symStyle.getIntUnitAngle() == 1) {
                ori *= 0.9;
            }
            if (this.symStyle.getStrEndOri() == null || this.symStyle.getStrEndOri().length() == 0) {
                Coordinate coord1 = arrCoord[arrCoord.length - 2];
                ori = Angle.angle(coord1, coord) - 1.5707963267948966;
            } else {
                ori = Math.toRadians(ori);
            }
            if (this.symStyle.getIntUnitSizeSymbol() == 1) {
                width *= view.getScale();
                height *= view.getScale();
            } else {
                width *= view.getPixelScale();
                height *= view.getPixelScale();
            }
            if (width > 1000.0) {
                scale = width / 1000.0;
                height = height * 1000.0 / width;
                width = 1000.0;
            }
            Point2D symCentre = view.toViewPoint(coord);
            return new ViewSymbolSpec(symCentre.getX(), symCentre.getY(), ori, width, height, 0.0, 0.0, scale, geometry);
        }
        return new ViewSymbolSpec(new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[1], new Geometry[0]);
    }

    private ViewSymbolSpec areaSymbolSpec(SimpleFeature f, Geometry geometry, Viewport view) throws NoninvertibleTransformException {
        if (geometry instanceof GeometryCollection) {
            return this.gcolSymbolSpec(f, geometry, view, 4);
        }
        if (geometry.getGeometryType().equals("Polygon") && this.symStyle.getStrAreaSymbol() != null && this.symStyle.getStrAreaSymbol().length() > 0) {
            Coordinate coord = this.symStyle.getIntAreaPos() == 0 ? interiorPointFinder.findPoint(geometry) : geometry.getCoordinates()[0];
            double width = this.bbCache.getCalcValue(BSH_AREA_WIDTH_KEY, this.symStyle.getStrAreaWidth(), f, 20.0);
            double height = this.bbCache.getCalcValue(BSH_AREA_HEIGHT_KEY, this.symStyle.getStrAreaHeight(), f, 20.0);
            double ori = this.bbCache.getCalcValue(BSH_AREA_ORI_KEY, this.symStyle.getStrAreaOri(), f, 0.0);
            double left = this.bbCache.getCalcValue(BSH_AREA_LEFT_KEY, this.symStyle.getStrAreaShiftLeft(), f, 0.0);
            double top = this.bbCache.getCalcValue(BSH_AREA_TOP_KEY, this.symStyle.getStrAreaShiftTop(), f, 0.0);
            double scale = 1.0;
            if (this.symStyle.getIntUnitAngle() == 1) {
                ori *= 0.9;
            }
            ori = Math.toRadians(ori);
            if (this.symStyle.getIntUnitSizeSymbol() == 1) {
                width *= view.getScale();
                height *= view.getScale();
            } else {
                width *= view.getPixelScale();
                height *= view.getPixelScale();
            }
            if (this.symStyle.getIntUnitSize() == 1) {
                left *= view.getScale();
                top *= view.getScale();
            } else {
                left *= view.getPixelScale();
                top *= view.getPixelScale();
            }
            if (width > 1000.0) {
                scale = width / 1000.0;
                height = height * 1000.0 / width;
                width = 1000.0;
            }
            Point2D symCentre = view.toViewPoint(coord);
            if (!this.symStyle.isBolAreaShiftInOri()) {
                symCentre.setLocation(symCentre.getX() + left, symCentre.getY() - top);
                left = 0.0;
                top = 0.0;
            }
            return new ViewSymbolSpec(symCentre.getX(), symCentre.getY(), ori, width, height, left, top, scale, geometry);
        }
        return new ViewSymbolSpec(new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[0], new double[1], new Geometry[0]);
    }

    public SymbolStyleModel getModel() {
        return this.symStyle;
    }

    @Override
    public boolean isEnabled() {
        return this.symStyle.isEnabled();
    }

    static {
        IntelligenceFactory.register(SymbolStyleModel.class, SymbolRenderer::new);
    }

    private static class ViewSymbolSpec {
        public double[] x;
        public double[] y;
        public double[] ori;
        public double[] width;
        public double[] height;
        public double[] leftinori;
        public double[] topinori;
        public double[] scale;
        public Geometry[] geometry;

        ViewSymbolSpec(double[] _arrx, double[] _arry, double[] _ori, double[] _width, double[] _height, double[] _leftinori, double[] _topinori, double[] _scale, Geometry[] _geometry) {
            this.x = _arrx;
            this.y = _arry;
            this.ori = _ori;
            this.width = _width;
            this.height = _height;
            this.leftinori = _leftinori;
            this.topinori = _topinori;
            this.scale = _scale;
            this.geometry = _geometry;
        }

        ViewSymbolSpec(double _x, double _y, double _ori, double _width, double _height, double _leftinori, double _topinori, double _scale, Geometry _geometry) {
            this.x = new double[]{_x};
            this.y = new double[]{_y};
            this.ori = new double[]{_ori};
            this.width = new double[]{_width};
            this.height = new double[]{_height};
            this.leftinori = new double[]{_leftinori};
            this.topinori = new double[]{_topinori};
            this.scale = new double[]{_scale};
            this.geometry = new Geometry[]{_geometry};
        }
    }
}

