/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.resources.BuildInSymbolStore;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class SVGFillPattern
implements Paint,
Serializable {
    private transient Paint paint = null;
    private transient BufferedImage bufferedImage = null;
    public double transx = 0.0;
    public double transy = 0.0;
    private Color fillColor = Color.BLACK;
    private String strSymName = "";
    private SymbolStore symStore = null;
    private int intSymWidth = 10;
    private boolean bolColorOverwrite = true;
    private static transient BufferedImage defaultFill = null;

    public SVGFillPattern(SymbolStore _symStore, String _strSymName, int _intSymWidth, Color _fillColor, boolean _bolColorOverwrite) {
        this.symStore = _symStore;
        this.strSymName = _strSymName;
        this.setSymWidthInternal(_intSymWidth);
        this.fillColor = _fillColor;
        this.bolColorOverwrite = _bolColorOverwrite;
    }

    private synchronized BufferedImage getDefaultFill() throws IOException {
        if (defaultFill == null) {
            defaultFill = ImageIO.read(BuildInSymbolStore.class.getResourceAsStream("default.png"));
        }
        return defaultFill;
    }

    public void setSymName(String _strSymName) {
        if (!this.strSymName.equals(_strSymName)) {
            this.strSymName = _strSymName;
            this.paint = null;
            this.bufferedImage = null;
        }
    }

    public void setSymWidth(int _intSymWidth) {
        this.setSymWidthInternal(_intSymWidth);
    }

    public int getSymWidth() {
        return this.intSymWidth;
    }

    private void setSymWidthInternal(int _intSymWidth) {
        if (this.intSymWidth != _intSymWidth) {
            this.intSymWidth = _intSymWidth;
            this.paint = null;
            this.bufferedImage = null;
        }
    }

    public void setFillColor(Color _fillColor, boolean _bolColorOverwrite) {
        if (this.fillColor.equals(_fillColor) || this.bolColorOverwrite != _bolColorOverwrite) {
            this.fillColor = _fillColor;
            this.bolColorOverwrite = _bolColorOverwrite;
            this.paint = null;
            this.bufferedImage = null;
        }
    }

    private Paint getPaint() {
        if (this.paint == null) {
            BufferedImage image = this.createImage();
            Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, image.getWidth(), image.getHeight());
            this.paint = new TexturePaint(image, rect);
        }
        return this.paint;
    }

    public BufferedImage createImage() {
        try {
            if (this.bufferedImage == null) {
                BufferedImage fill = this.getImageFromStoreOrFallback();
                this.bufferedImage = new BufferedImage(fill.getWidth(), fill.getHeight(), 2);
                Graphics2D g = (Graphics2D)this.bufferedImage.getGraphics();
                g.setComposite(AlphaComposite.getInstance(3, (float)this.fillColor.getAlpha() / 255.0f));
                g.drawImage((Image)fill, 0, 0, null);
            }
            return this.bufferedImage;
        }
        catch (Exception e) {
            try {
                return this.getDefaultFill();
            }
            catch (Exception e1) {
                throw new IllegalStateException("Could not create image for SVG fill pattern", e);
            }
        }
    }

    private BufferedImage getImageFromStoreOrFallback() throws IOException {
        try {
            if (this.bolColorOverwrite) {
                return this.symStore.getSymbol(this.strSymName, this.intSymWidth, this.fillColor, this.fillColor, false);
            }
            return this.symStore.getSymbol(this.strSymName, this.intSymWidth, null, null, false);
        }
        catch (IOException ex) {
            return this.getDefaultFill();
        }
    }

    public double getRatioYX() {
        BufferedImage img = this.createImage();
        return (double)img.getHeight() / (double)img.getWidth();
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        xform.concatenate(AffineTransform.getTranslateInstance(this.transx, this.transy));
        return this.getPaint().createContext(cm, deviceBounds, userBounds, xform, hints);
    }

    @Override
    public int getTransparency() {
        return this.getPaint().getTransparency();
    }
}

