/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.plugin.raster.RasterRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.wms.WMSStyleRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.wmts.WMTSStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.PolygonShape;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractCadRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.CadRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RedlineRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.SymbolRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.style.AbstractCadStyleModel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.CadStyleModel;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.LineStyleModel;
import de.riwagis.riwajump.model.style.RasterStyleModel;
import de.riwagis.riwajump.model.style.RedlineStyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.riwajump.symbol.model.SymbolstoreMetadata;
import de.riwagis.riwajump.symbol.resources.BuildInSymbolStore;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RenderUtil.class);
    public static final Shape[] EMPTY_SHAPE_ARRAY = new Shape[0];

    public static final Shape[] paint(Geometry geometry, Graphics2D g, Viewport viewport, boolean renderingFill, Stroke fillStroke, ColorModel fillColor, boolean renderingLine, Stroke lineStroke, ColorModel lineColor, boolean renderLineWithShape, boolean renderingPoint) throws NoninvertibleTransformException {
        return RenderUtil.paint(geometry, g, viewport, renderingFill, fillStroke, RiwaJumpModelUtilities.colorByColorModel(fillColor), renderingLine, lineStroke, RiwaJumpModelUtilities.colorByColorModel(lineColor), renderLineWithShape, renderingPoint);
    }

    @Deprecated
    public static final Shape[] paint(Geometry geometry, Graphics2D g, Viewport viewport, boolean renderingFill, Stroke fillStroke, Paint fillColor, boolean renderingLine, Stroke lineStroke, Color lineColor, boolean renderingPoint) throws NoninvertibleTransformException {
        return RenderUtil.paint(geometry, g, viewport, renderingFill, fillStroke, fillColor, renderingLine, lineStroke, lineColor, true, renderingPoint);
    }

    public static final Shape[] paint(Geometry geometry, Graphics2D g, Viewport viewport, boolean renderingFill, Stroke fillStroke, Paint fillPaint, boolean renderingLine, Stroke lineStroke, Color lineColor, boolean renderLineWithShape, boolean renderingPoint) throws NoninvertibleTransformException {
        if (!geometry.getEnvelopeInternal().intersects(viewport.getEnvelopeInModelCoordinates())) {
            return EMPTY_SHAPE_ARRAY;
        }
        if (geometry instanceof GeometryCollection) {
            Shape[] arrShp = RenderUtil.paintGeometryCollection((GeometryCollection)geometry, g, viewport, renderingFill, fillStroke, fillPaint, renderingLine, lineStroke, lineColor, renderLineWithShape, renderingPoint);
            return arrShp;
        }
        if (!renderingPoint && geometry instanceof Point) {
            return EMPTY_SHAPE_ARRAY;
        }
        Shape shape = viewport.getJava2DConverter().toShape(geometry);
        if (shape instanceof PolygonShape && renderingFill) {
            g.setStroke(fillStroke);
            g.setPaint(fillPaint);
            g.fill(shape);
        }
        if (renderingLine) {
            if (renderLineWithShape) {
                Shape strokedShape = lineStroke.createStrokedShape(shape);
                g.setColor(lineColor);
                g.fill(strokedShape);
                return new Shape[]{shape, strokedShape};
            }
            g.setStroke(lineStroke);
            g.setColor(lineColor);
            g.draw(shape);
        }
        return new Shape[]{shape};
    }

    private static final Shape[] paintGeometryCollection(GeometryCollection collection, Graphics2D g, Viewport viewport, boolean renderingFill, Stroke fillStroke, Paint fillPaint, boolean renderingLine, Stroke lineStroke, Color lineColor, boolean renderLineWithShape, boolean renderingPoint) throws NoninvertibleTransformException {
        ArrayList<Shape> lstShp = new ArrayList<Shape>();
        for (int i = 0; i < collection.getNumGeometries(); ++i) {
            Shape[] arrShp = RenderUtil.paint(collection.getGeometryN(i), g, viewport, renderingFill, fillStroke, fillPaint, renderingLine, lineStroke, lineColor, renderLineWithShape, renderingPoint);
            if (arrShp == null) continue;
            lstShp.addAll(Arrays.asList(arrShp));
        }
        return lstShp.toArray(EMPTY_SHAPE_ARRAY);
    }

    public static final Color getColorByFeature(SimpleFeature f, String strColName, Map<Object, Color> colorCache) {
        return RenderUtil.getColorByObject(FeatureUtil.getAttribute((SimpleFeature)f, (String)strColName), colorCache, null);
    }

    public static final Color getColorByObject(Object objColor, Map<Object, Color> colorCache, Color defaultColor) {
        if (defaultColor == null) {
            defaultColor = Color.BLACK;
        }
        if (objColor == null || objColor.equals("")) {
            return defaultColor;
        }
        try {
            Color newColor;
            if (colorCache != null && colorCache.containsKey(objColor)) {
                return colorCache.get(objColor);
            }
            if (objColor instanceof Color) {
                return (Color)objColor;
            }
            if (objColor instanceof Number) {
                Color newColor2 = new Color(((Number)objColor).intValue());
                if (colorCache != null) {
                    colorCache.put(objColor, newColor2);
                }
                return newColor2;
            }
            String colorText = objColor.toString();
            if (colorText.startsWith("#")) {
                newColor = new Color(Integer.parseInt(colorText.substring(1), 16));
            } else {
                String[] arrColor = objColor.toString().split(",");
                newColor = new Color(Integer.parseInt(arrColor[0]), Integer.parseInt(arrColor[1]), Integer.parseInt(arrColor[2]), 255);
                if (colorCache != null) {
                    colorCache.put(objColor, newColor);
                }
            }
            return newColor;
        }
        catch (Exception e) {
            LOG.debug(String.format("Error creating color from '%s': %s", objColor, e.getMessage()));
            return defaultColor;
        }
    }

    public static final SymbolStore getSymbolStore(String strStorename, Task task) {
        try {
            if (strStorename.equals("_buildIn")) {
                return BuildInSymbolStore.getInstance();
            }
            SymbolstoreMetadata smd = task == null ? WorkbenchContext.getTask().getSymbolStores().getByName(strStorename) : task.getSymbolStores().getByName(strStorename);
            if (smd == null) {
                throw new IllegalStateException("Symbol Store '" + strStorename + "' does not exist");
            }
            return smd.getSymbolStore();
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to retrieve SymbolStore '%s' from task '%s': %s", strStorename, task.getName(), e.getMessage()));
            return null;
        }
    }

    public static final BufferedImage getSymbolImage4WidthAndHeight(SymbolStore store, String strSymName, int width, int height) throws Exception {
        BufferedImage img = store.getSymbol(strSymName, width, null, null, false);
        if (img.getHeight() > height) {
            double newWidth = (double)width * ((double)height / (double)img.getHeight());
            img = store.getSymbol(strSymName, (int)newWidth, null, null, 255, false);
        }
        return img;
    }

    public static String getSymbolName(SymbolStyleModel symStyle) {
        if (ObjectUtils.toString((Object)symStyle.getStrPtSymbol()).isEmpty()) {
            if (!ObjectUtils.toString((Object)symStyle.getStrAreaSymbol()).isEmpty()) {
                return symStyle.getStrAreaSymbol();
            }
            if (!ObjectUtils.toString((Object)symStyle.getStrStartSymbol()).isEmpty()) {
                return symStyle.getStrStartSymbol();
            }
            if (!ObjectUtils.toString((Object)symStyle.getStrEndSymbol()).isEmpty()) {
                return symStyle.getStrEndSymbol();
            }
        } else {
            return symStyle.getStrPtSymbol();
        }
        return "";
    }

    public static ColorThemingRenderer getRenderer(ColorThemingStyleModel style) {
        if (style == null) {
            return null;
        }
        return (ColorThemingRenderer)style.getIntelligence();
    }

    public static BasicStyleRenderer getRenderer(BasicStyleModel style) {
        if (style == null) {
            return null;
        }
        return (BasicStyleRenderer)style.getIntelligence();
    }

    public static TextRenderer getRenderer(TextStyleModel style) {
        if (style == null) {
            return null;
        }
        return (TextRenderer)style.getIntelligence();
    }

    public static SymbolRenderer getRenderer(SymbolStyleModel style) {
        if (style == null) {
            return null;
        }
        return (SymbolRenderer)style.getIntelligence();
    }

    public static AbstractCadRenderer getRenderer(AbstractCadStyleModel style) {
        if (style == null) {
            return null;
        }
        return (AbstractCadRenderer)style.getIntelligence();
    }

    public static CadRenderer getRenderer(CadStyleModel style) {
        if (style == null) {
            return null;
        }
        return (CadRenderer)style.getIntelligence();
    }

    public static RedlineRenderer getRenderer(RedlineStyleModel style) {
        if (style == null) {
            return null;
        }
        return (RedlineRenderer)style.getIntelligence();
    }

    public static WMSStyleRenderer getRenderer(WMSStyleModel style) {
        if (style == null) {
            return null;
        }
        return (WMSStyleRenderer)style.getIntelligence();
    }

    public static WMTSStyleRenderer getRenderer(WMTSStyleModel style) {
        if (style == null) {
            return null;
        }
        return (WMTSStyleRenderer)style.getIntelligence();
    }

    public static RasterRenderer getRenderer(RasterStyleModel style) {
        if (style == null) {
            return null;
        }
        return (RasterRenderer)style.getIntelligence();
    }

    public static LineRenderer getRenderer(LineStyleModel style) {
        if (style == null) {
            return null;
        }
        return (LineRenderer)style.getIntelligence();
    }

    public static double getSize96DpiScale(Graphics2D g, double size) {
        if (g.getRenderingHint(Viewport.KEY_IS4PRINT) == Viewport.VALUE_IS4PRINT) {
            return size * 0.75;
        }
        return size;
    }

    public static int getSize96DpiScale(Graphics2D g, int size) {
        if (g.getRenderingHint(Viewport.KEY_IS4PRINT) == Viewport.VALUE_IS4PRINT) {
            return (int)((double)size * 0.75);
        }
        return size;
    }

    public static float getSize96DpiScale(Graphics2D g, float size) {
        if (g.getRenderingHint(Viewport.KEY_IS4PRINT) == Viewport.VALUE_IS4PRINT) {
            return size * 0.75f;
        }
        return size;
    }

    private RenderUtil() {
    }
}

