/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BshBuilderCache;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.LineStyleModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineRenderer
extends AbstractStyleRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(LineRenderer.class);
    private static final String BSH_FEAT_LINE_COLOR_KEY = "featLineColor";
    private static final String BSH_LINEWIDTH_KEY = "lineWidth";
    private static final String BSH_LINEPATTERN_KEY = "linePattern";
    private static final float MIN_LINE_WIDTH_96_DPI = 0.5f;
    private static final float MIN_LINE_WIDTH_72_DPI4PRINT = 0.33f;
    private BshBuilderCache bbCache = new BshBuilderCache();
    private String strLastLinePattern = null;
    private double dblLastLineWidth = -1.0;
    private BasicStroke lineStroke = null;
    private Color renderLineColor = null;
    private final LineStyleModel lineStyle;

    private LineRenderer(LineStyleModel lineStyle) {
        this.lineStyle = lineStyle;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        if (!this.lineStyle.isEnabled()) {
            return;
        }
        Geometry geom = (Geometry)f.getDefaultGeometry();
        if (geom == null || geom.isEmpty() || geom instanceof Point || geom instanceof MultiPoint) {
            return;
        }
        if (!BasicStyleRenderer.adobeReaderFix4Print_DoesGeomIntersectVisibleArea(geom, g, viewport)) {
            return;
        }
        String strSBLinePattern = this.getSBLinePattern(f);
        double dblLineWidth = this.lineStyle.getLengthUnit() == 1 ? this.getCalcLineWidth(f) * viewport.getScale() : this.getCalcLineWidth(f) * viewport.getPixelScale4LineWidth();
        if (this.lineStroke == null || this.strLastLinePattern == null || this.dblLastLineWidth != dblLineWidth || !this.strLastLinePattern.equals(strSBLinePattern)) {
            this.dblLastLineWidth = dblLineWidth;
            this.strLastLinePattern = strSBLinePattern;
            this.lineStroke = this.createLineStroke(g, (float)dblLineWidth, strSBLinePattern);
        }
        boolean renderLineWithShape = this.lineStroke.getLineWidth() > 4.0f && g.getRenderingHint(Viewport.KEY_IS4PRINT) == null;
        Shape[] arrShp = RenderUtil.paint(geom, g, viewport, false, null, null, true, (Stroke)this.lineStroke, this.getLineColorForFeatureWithUserDefinedAlpha(f), renderLineWithShape, false);
        if (arrShp != null) {
            if (renderLineWithShape) {
                tree.insert(arrShp, f, null, true);
            } else {
                tree.insert(arrShp, f, null);
            }
        }
    }

    @Override
    public void initialize(StyleCollection sCol) {
    }

    @Override
    public boolean isEnabled() {
        return this.lineStyle.isEnabled();
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return null;
    }

    public LineStyleModel getModel() {
        return this.lineStyle;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        this.renderLineColor = null;
        this.bbCache.reinitStringBuilder(modelEvent.getPropertyName());
        this.bbCache.reinitCalculator(modelEvent.getPropertyName());
        this.bbCache.reinitObjectBuilder(modelEvent.getPropertyName());
        if (modelEvent.getPropertyName().equals(BSH_LINEPATTERN_KEY)) {
            this.lineStroke = null;
        }
        if (modelEvent.getPropertyName().equals("renderingLinePattern")) {
            this.lineStroke = null;
        }
        this.clearLegendLabelCache();
    }

    private BasicStroke createLineStroke(Graphics2D g, float width, String strTmpPattern) {
        float minLineWidth = 0.5f;
        if (g.getRenderingHint(Viewport.KEY_IS4PRINT) != null) {
            minLineWidth = 0.33f;
        }
        if (this.lineStyle.isRenderingLinePattern() && strTmpPattern.trim().length() != 0 && width > 0.0f) {
            return new BasicStroke(width, 0, 2, 1.0f, LineRenderer.toArray(strTmpPattern, width, minLineWidth), 0.0f);
        }
        return new BasicStroke(Math.max(width, minLineWidth), 0, 2);
    }

    private Color getLineColorInternal() {
        if (this.renderLineColor == null) {
            this.renderLineColor = RiwaJumpModelUtilities.colorByColorModel(this.lineStyle.getLineColorWithAlpha());
        }
        return this.renderLineColor;
    }

    public double getCalcLineWidth(SimpleFeature f) {
        return this.bbCache.getCalcValue(BSH_LINEWIDTH_KEY, this.lineStyle.getLineWidth(), f, 1.0);
    }

    public String getSBLinePattern(SimpleFeature f) {
        return this.bbCache.getStringValue(BSH_LINEPATTERN_KEY, this.lineStyle.getLinePattern(), f, "1");
    }

    private Color getLineColorForFeatureWithUserDefinedAlpha(SimpleFeature feature) {
        return this.modulateColorWithUserDefinedAlpha(this.getSBLineColor(feature));
    }

    public Color getSBLineColor(SimpleFeature f) {
        if (this.lineStyle.getLineColorWithAlpha().isBshColor()) {
            try {
                Object objColor = this.bbCache.getObjectValue(BSH_FEAT_LINE_COLOR_KEY, this.lineStyle.getLineColorWithAlpha().getBsh(), f, null, true);
                Color newColor = RenderUtil.getColorByObject(objColor, null, this.getLineColorInternal());
                return GUIUtil.alphaColor(newColor, this.lineStyle.getIntAlpha());
            }
            catch (Exception e) {
                return this.getLineColorInternal();
            }
        }
        return this.getLineColorInternal();
    }

    public static float[] toArray(String linePattern, float lineWidth, double minLineWidth) {
        try {
            List<String> strings = StringUtil.fromCommaDelimitedString(linePattern);
            float[] array = new float[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                String string = strings.get(i);
                float dash = Float.parseFloat(string) * lineWidth;
                if ((double)dash < minLineWidth) {
                    return null;
                }
                array[i] = dash;
            }
            return array;
        }
        catch (NumberFormatException ne) {
            return null;
        }
    }

    static {
        IntelligenceFactory.register(LineStyleModel.class, LineRenderer::new);
    }
}

