/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.geom.CoordUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.plugin.layer.dim.DimFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.DimStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.unit.DrawingUnit;
import de.riwagis.util.construction.ConstSupport;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimRenderer
extends AbstractStyleRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(DimRenderer.class);
    private static final BasicStroke SYM_LINE_STROKE = new BasicStroke(1.0f, 0, 2);
    private static final Stroke SYM_FILL_STROKE = new BasicStroke(1.0f);
    private final TextStyleModel dimTextStyle = new TextStyleModel();
    private final DecimalFormat df = new DecimalFormat();
    private transient BasicStroke cachedDimLineStroke = null;
    private transient BasicStroke cachedRefLineStroke = null;
    private final GeometryFactory gfac = new GeometryFactory();
    private final DimStyleModel dimStyle;
    private double lastLineWidth = 0.0;
    private double lastRefLineWidth = 0.0;

    private DimRenderer(DimStyleModel dimStyle) {
        this.dimStyle = dimStyle;
        this.resetDimTextStyle();
    }

    @Override
    public boolean needsRendering() {
        return true;
    }

    public DimStyleModel getModel() {
        return this.dimStyle;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        if (modelEvent.getPropertyName().equalsIgnoreCase("lengthUnit") || modelEvent.getPropertyName().equalsIgnoreCase("fontDimText") || modelEvent.getPropertyName().equalsIgnoreCase("bolDimTextOpaque") || modelEvent.getPropertyName().equalsIgnoreCase("intDimTextDecPlaces") || modelEvent.getPropertyName().equalsIgnoreCase("colorDimText") || modelEvent.getPropertyName().equalsIgnoreCase("colorDimTextOpaque")) {
            this.resetDimTextStyle();
        }
        if (modelEvent.getPropertyName().equalsIgnoreCase("strRefLinePattern") || modelEvent.getPropertyName().equalsIgnoreCase("fltRefLineWidth") || modelEvent.getPropertyName().equalsIgnoreCase("strDimLinePattern") || modelEvent.getPropertyName().equalsIgnoreCase("fltDimLineWidth")) {
            this.cachedRefLineStroke = null;
            this.cachedDimLineStroke = null;
        }
        this.clearLegendLabelCache();
    }

    private BasicStroke getDimLineStroke(Viewport vp) {
        float lineWidth = (float)this.getStyleLengthInPixel(this.dimStyle.getFltDimLineWidth(), vp, true);
        if (this.cachedDimLineStroke == null || this.lastLineWidth != (double)lineWidth) {
            this.lastLineWidth = lineWidth;
            this.cachedDimLineStroke = this.dimStyle.isBolDimLinePattern() ? this.createLineStroke(this.dimStyle.getStrDimLinePattern(), lineWidth) : this.createLineStroke(null, lineWidth);
        }
        return this.cachedDimLineStroke;
    }

    private BasicStroke getRefLineStroke(Viewport vp) {
        float lineWidth = (float)this.getStyleLengthInPixel(this.dimStyle.getFltRefLineWidth(), vp, true);
        if (this.cachedRefLineStroke == null || this.lastRefLineWidth != (double)lineWidth) {
            this.lastRefLineWidth = lineWidth;
            this.cachedRefLineStroke = this.dimStyle.isBolRefLinePattern() ? this.createLineStroke(this.dimStyle.getStrRefLinePattern(), lineWidth) : this.createLineStroke(null, lineWidth);
        }
        return this.cachedRefLineStroke;
    }

    private void resetDimTextStyle() {
        if (this.dimTextStyle != null) {
            this.dimTextStyle.setFontText(this.dimStyle.getFontDimText());
            this.dimTextStyle.setColorText(this.dimStyle.getColorDimText());
            this.dimTextStyle.setBolOpaque(this.dimStyle.isBolDimTextOpaque());
            this.dimTextStyle.setColorOpaque(this.dimStyle.getColorDimTextOpaque());
            this.dimTextStyle.setIntUnitLength(this.dimStyle.getLengthUnit());
            this.dimTextStyle.setIntUnitLengthText(this.dimStyle.getLengthUnit());
            this.dimTextStyle.setIntUnitOrient(this.dimStyle.getOriUnit());
        }
        if (this.df != null) {
            this.df.setGroupingUsed(false);
            this.df.setMinimumFractionDigits(this.dimStyle.getIntDimTextDecPlaces());
            this.df.setMaximumFractionDigits(this.dimStyle.getIntDimTextDecPlaces());
        }
    }

    private TextRenderer getDimTextRenderer() {
        if (this.dimTextStyle == null) {
            return null;
        }
        return (TextRenderer)this.dimTextStyle.getIntelligence();
    }

    public void paintChainage(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        Geometry geom = (Geometry)f.getDefaultGeometry();
        MultiPoint mpt = (MultiPoint)geom;
        Coordinate[] arrCoord = mpt.getCoordinates();
        double dblDimTextHeight = this.getStyleLengthInPixel(this.dimStyle.getFltDimTextHeight(), viewport, false);
        LineString dimLine = this.gfac.createLineString(arrCoord);
        BasicStroke lineStroke = this.getRefLineStroke(viewport);
        Shape[] arrShp = RenderUtil.paint((Geometry)dimLine, g, viewport, false, null, null, true, (Stroke)lineStroke, this.modulateColorWithUserDefinedAlpha(this.dimStyle.getColorRefLine()), this.renderLineWithShape(g, lineStroke), false);
        tree.insert(arrShp, f, null, true);
        if (this.dimStyle.isBolDimText()) {
            double dblSumLength = 0.0;
            for (int i = 0; i < arrCoord.length; ++i) {
                Point2D textCentreInViewSpace;
                Coordinate coordTxt;
                Coordinate coordTemp;
                double dblLength;
                double tdim;
                if (arrCoord.length == 1) {
                    return;
                }
                if (i == 0) {
                    tdim = ConstSupport.getOrientation((Coordinate)arrCoord[i], (Coordinate)arrCoord[i + 1], (int)2);
                    dblLength = 0.0;
                } else {
                    tdim = ConstSupport.getOrientation((Coordinate)arrCoord[i - 1], (Coordinate)arrCoord[i], (int)2);
                    dblLength = this.getProjectionLength(arrCoord[i - 1], arrCoord[i]);
                }
                String strDimText = this.df.format(dblSumLength += dblLength);
                TextLayout dimTxtLayout = new TextLayout(strDimText, this.getDimTextRenderer().retrieveAwtFont(), g.getFontRenderContext());
                double dblTmpTxtHeight = dimTxtLayout.getBounds().getHeight();
                double dblTmpTxtWidth = dimTxtLayout.getBounds().getWidth();
                double dblDimTextWidth = dblDimTextHeight / dblTmpTxtHeight * dblTmpTxtWidth;
                double dblDimTextWidthDU = dblDimTextWidth / viewport.getScale();
                double dblDimTextHeightDU = dblDimTextHeight / viewport.getScale();
                if (i != 0 || !arrCoord[0].equals((Object)arrCoord[arrCoord.length - 1])) {
                    coordTemp = ConstSupport.getPolarCoord((Coordinate)arrCoord[i], (double)dblDimTextHeightDU, (double)(tdim - Math.PI));
                    coordTxt = ConstSupport.getPolarCoord((Coordinate)coordTemp, (double)(dblDimTextHeightDU / 4.0), (double)(tdim - 1.5707963267948966));
                    textCentreInViewSpace = viewport.toViewPoint(new Point2D.Double(coordTxt.x, coordTxt.y));
                    this.getDimTextRenderer().paintText(g, strDimText, textCentreInViewSpace, tdim, 0, dblDimTextHeight, 0.0, 0.0, tree, f, mpt.getGeometryN(i));
                }
                strDimText = this.df.format(dblLength);
                dimTxtLayout = new TextLayout(strDimText, this.getDimTextRenderer().retrieveAwtFont(), g.getFontRenderContext());
                dblTmpTxtHeight = dimTxtLayout.getBounds().getHeight();
                dblTmpTxtWidth = dimTxtLayout.getBounds().getWidth();
                dblDimTextWidth = dblDimTextHeight / dblTmpTxtHeight * dblTmpTxtWidth;
                dblDimTextWidthDU = dblDimTextWidth / viewport.getScale();
                dblDimTextHeightDU = dblDimTextHeight / viewport.getScale();
                if (i > 0) {
                    coordTemp = ConstSupport.getPolarCoord((Coordinate)arrCoord[i - 1], (double)(dblLength / 2.0 - dblDimTextWidthDU / 2.0), (double)tdim);
                    coordTxt = ConstSupport.getPolarCoord((Coordinate)coordTemp, (double)(dblDimTextHeightDU / 4.0), (double)(tdim + 1.5707963267948966));
                    textCentreInViewSpace = viewport.toViewPoint(new Point2D.Double(coordTxt.x, coordTxt.y));
                    this.getDimTextRenderer().paintText(g, strDimText, textCentreInViewSpace, tdim + 1.5707963267948966, 0, dblDimTextHeight, 0.0, 0.0, tree, f, mpt.getGeometryN(i));
                }
                double dblLineOverDimDU = this.getStyleLengthInDU(this.dimStyle.getFltRefLineOverDim(), viewport);
                double tOffset = tdim - 1.5707963267948966;
                Coordinate[] arrCoordEnd = new Coordinate[]{ConstSupport.getPolarCoord((Coordinate)arrCoord[i], (double)dblLineOverDimDU, (double)tOffset), ConstSupport.getPolarCoord((Coordinate)arrCoord[i], (double)dblLineOverDimDU, (double)(tOffset - Math.PI))};
                LineString endLine = this.gfac.createLineString(arrCoordEnd);
                arrShp = RenderUtil.paint((Geometry)endLine, g, viewport, false, null, null, true, (Stroke)lineStroke, this.modulateColorWithUserDefinedAlpha(this.dimStyle.getColorRefLine()), this.renderLineWithShape(g, lineStroke), false);
                tree.insert(arrShp, f, null, true);
            }
        }
    }

    private Coordinate[] checkOrthoDimFeature(SimpleFeature f, int dimType) throws Exception {
        MultiPoint mpt;
        Coordinate[] arrCoord;
        Geometry geom = (Geometry)f.getDefaultGeometry();
        if (!(geom instanceof MultiPoint)) {
            throw new Exception("Error rendering feature with fid " + f.getID() + ". Feature has no MultiPoint geometry.");
        }
        int requiredArraySize = 5;
        if (dimType == 1) {
            requiredArraySize = 6;
        }
        if ((arrCoord = (mpt = (MultiPoint)geom).getCoordinates()).length != requiredArraySize) {
            throw new Exception("Error rendering feature with fid " + f.getID() + ". " + requiredArraySize + " points required.");
        }
        return arrCoord;
    }

    private void paintOrthoDimOrdinate(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        BasicStroke lineStroke;
        Coordinate[] arrCoord = this.checkOrthoDimFeature(f, 1);
        double dblLength = this.getProjectionLength(arrCoord[0], arrCoord[3]);
        String[] arrMText = this.retrieveMText4OrthoDimension(f);
        String dimTextEnd = arrMText[0] == null ? this.df.format(dblLength) : arrMText[0];
        String dimTextStart = arrMText[1] == null ? this.df.format(0.0) : arrMText[1];
        double dblDimTextHeight = this.getStyleLengthInPixel(this.dimStyle.getFltDimTextHeight(), viewport, false);
        LineString dimLine = this.gfac.createLineString(new Coordinate[]{arrCoord[1], arrCoord[4]});
        Shape[] arrShp = RenderUtil.paint((Geometry)dimLine, g, viewport, false, null, null, true, (Stroke)(lineStroke = this.getDimLineStroke(viewport)), this.modulateColorWithUserDefinedAlpha(this.dimStyle.getColorDimLine()), this.renderLineWithShape(g, lineStroke), false);
        if (arrShp != null) {
            tree.insert(arrShp, f, null, true);
        }
        if (this.dimStyle.isBolDimText()) {
            TextLayout dimTxtLayout = new TextLayout(dimTextEnd, this.getDimTextRenderer().retrieveAwtFont(), g.getFontRenderContext());
            double dblTmpTxtHeight = dimTxtLayout.getBounds().getHeight();
            double dblTmpTxtWidth = dimTxtLayout.getBounds().getWidth();
            double dblDimTextWidth = dblDimTextHeight / dblTmpTxtHeight * dblTmpTxtWidth;
            double dblDimTextWidthDU = dblDimTextWidth / viewport.getScale();
            double dblDimTextHeightDU = dblDimTextHeight / viewport.getScale();
            double tdim = ConstSupport.getOrientation((Coordinate)arrCoord[0], (Coordinate)arrCoord[3], (int)2);
            Coordinate coordTxtInsertStart = ConstSupport.getPolarCoord((Coordinate)arrCoord[2], (double)(dblDimTextHeightDU / 3.0), (double)(tdim - 1.5707963267948966));
            Coordinate coordTxtInsertEnd = ConstSupport.getPolarCoord((Coordinate)arrCoord[5], (double)(dblDimTextHeightDU / 3.0), (double)(tdim - 1.5707963267948966));
            int txtAlignment = 4;
            Point2D txtStartInViewSpace = viewport.toViewPoint(new Point2D.Double(coordTxtInsertStart.x, coordTxtInsertStart.y));
            this.getDimTextRenderer().paintText(g, dimTextStart, txtStartInViewSpace, tdim, txtAlignment, dblDimTextHeight, 0.0, 0.0, tree, f);
            Point2D txtEndInViewSpace = viewport.toViewPoint(new Point2D.Double(coordTxtInsertEnd.x, coordTxtInsertEnd.y));
            AttributedString as = new AttributedString(dimTextEnd);
            as.addAttribute(TextAttribute.FONT, this.getDimTextRenderer().retrieveAwtFontForRendering(dblDimTextHeight));
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL);
            TextLayout tly = new TextLayout(as.getIterator(), g.getFontRenderContext());
            this.getDimTextRenderer().paintText(g, new TextLayout[]{tly}, txtEndInViewSpace, tdim, txtAlignment, dblDimTextHeight, 0.0, 0.0, tree, f);
        }
    }

    private String[] retrieveMText4OrthoDimension(SimpleFeature f) {
        String[] arrReturn = new String[2];
        String mText = Objects.toString(this.getAttribute(f, DimFeatureAtts.MTEXT.getName()), "").trim();
        String[] arrMText = mText.split("\\|");
        if (arrMText.length > 0 && arrMText[0].trim().length() > 0) {
            arrReturn[0] = arrMText[0].trim();
        }
        if (arrMText.length > 1 && arrMText[1].trim().length() > 0) {
            arrReturn[1] = arrMText[1].trim();
        }
        return arrReturn;
    }

    private void paintOrthoDimAbszissa(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        BasicStroke lineStroke;
        String[] arrMText;
        Coordinate[] arrCoord = this.checkOrthoDimFeature(f, 2);
        double dblLengthAbsz = this.getProjectionLength(arrCoord[1], arrCoord[3]);
        double dblLengthOrd = this.getProjectionLength(arrCoord[0], arrCoord[1]);
        boolean dimOnLine = false;
        if (Math.abs(dblLengthAbsz) < 1.0E-8) {
            dimOnLine = true;
        }
        String dimTextAbsz = (arrMText = this.retrieveMText4OrthoDimension(f))[0] == null ? this.df.format(dblLengthAbsz) : arrMText[0];
        String dimTextOrd = null;
        dimTextOrd = arrMText[1] == null ? this.df.format(dblLengthOrd) : arrMText[1].trim();
        double dblDimTextHeight = this.getStyleLengthInPixel(this.dimStyle.getFltDimTextHeight(), viewport, false);
        LineString dimLine = this.gfac.createLineString(new Coordinate[]{arrCoord[1], arrCoord[3]});
        Shape[] arrShp = RenderUtil.paint((Geometry)dimLine, g, viewport, false, null, null, true, (Stroke)(lineStroke = this.getDimLineStroke(viewport)), this.modulateColorWithUserDefinedAlpha(this.dimStyle.getColorDimLine()), this.renderLineWithShape(g, lineStroke), false);
        if (arrShp != null) {
            tree.insert(arrShp, f, null, true);
        }
        if (this.dimStyle.isBolDimText()) {
            TextLayout dimTxtLayout = new TextLayout(dimTextAbsz, this.getDimTextRenderer().retrieveAwtFont(), g.getFontRenderContext());
            double dblTmpTxtHeight = dimTxtLayout.getBounds().getHeight();
            double dblTmpTxtWidth = dimTxtLayout.getBounds().getWidth();
            double dblDimTextWidth = dblDimTextHeight / dblTmpTxtHeight * dblTmpTxtWidth;
            double dblDimTextWidthDU = dblDimTextWidth / viewport.getScale();
            double dblDimTextHeightDU = dblDimTextHeight / viewport.getScale();
            double quadrant = ((Number)this.getAttribute(f, DimFeatureAtts.MTEXT_ORI.getName())).doubleValue();
            int txtAlignmentAbsz = 4;
            int txtAlignmentOrd = 6;
            double tdimAbsz = ConstSupport.getOrientation((Coordinate)arrCoord[1], (Coordinate)arrCoord[3], (int)2);
            double tdimOrd = ConstSupport.getOrientation((Coordinate)arrCoord[0], (Coordinate)arrCoord[1], (int)2);
            tdimOrd = quadrant == 2.0 || quadrant == 4.0 ? (tdimOrd += 1.5707963267948966) : (tdimOrd -= 1.5707963267948966);
            Coordinate coordTxtInsertAbsz = ConstSupport.getPolarCoord((Coordinate)arrCoord[4], (double)(dblDimTextHeightDU / 3.0), (double)tdimAbsz);
            Coordinate coordTxtInsertOrd = ConstSupport.getPolarCoord((Coordinate)arrCoord[2], (double)(dblDimTextHeightDU / 3.0), (double)(tdimOrd + Math.PI));
            if (quadrant == 2.0 || quadrant == 3.0) {
                txtAlignmentOrd = 4;
                txtAlignmentAbsz = 6;
                tdimAbsz += Math.PI;
                tdimOrd += Math.PI;
            }
            if (!dimOnLine) {
                Point2D txtAbszInViewSpace = viewport.toViewPoint(new Point2D.Double(coordTxtInsertAbsz.x, coordTxtInsertAbsz.y));
                this.getDimTextRenderer().paintText(g, dimTextAbsz, txtAbszInViewSpace, tdimAbsz + 1.5707963267948966, txtAlignmentAbsz, dblDimTextHeight, 0.0, 0.0, tree, f);
            }
            Point2D txtOrdInViewSpace = viewport.toViewPoint(new Point2D.Double(coordTxtInsertOrd.x, coordTxtInsertOrd.y));
            AttributedString as = new AttributedString(dimTextOrd);
            as.addAttribute(TextAttribute.FONT, this.getDimTextRenderer().retrieveAwtFontForRendering(dblDimTextHeight));
            if (dimOnLine) {
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            TextLayout tly = new TextLayout(as.getIterator(), g.getFontRenderContext());
            this.getDimTextRenderer().paintText(g, new TextLayout[]{tly}, txtOrdInViewSpace, tdimOrd + 1.5707963267948966, txtAlignmentOrd, dblDimTextHeight, 0.0, 0.0, tree, f);
        }
    }

    public boolean renderLineWithShape(Graphics2D g, BasicStroke lineStroke) {
        return lineStroke.getLineWidth() > 4.0f && g.getRenderingHint(Viewport.KEY_IS4PRINT) == null;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        MultiPoint mpt;
        Coordinate[] arrCoord;
        Geometry geom;
        if (FeatureUtil.hasAttribute((SimpleFeature)f, (String)DimFeatureAtts.ISDIM.getName())) {
            Object isDim = FeatureUtil.getAttribute((SimpleFeature)f, (String)DimFeatureAtts.ISDIM.getName());
            if (isDim == null) {
                return;
            }
            if (isDim instanceof Number ? ((Number)isDim).intValue() != 1 : isDim instanceof Boolean && (Boolean)isDim == false) {
                return;
            }
        }
        if (!((geom = (Geometry)f.getDefaultGeometry()) instanceof MultiPoint)) {
            LOG.warn("Feature ignored in dimension layer {}. Geometry type should be MultiPoint but was {}", (Object)f.getFeatureType().getName(), (Object)geom.getGeometryType());
        }
        int intDimType = 0;
        if (this.getAttribute(f, DimFeatureAtts.MTYPE.getName()) != null) {
            intDimType = ((Number)this.getAttribute(f, DimFeatureAtts.MTYPE.getName())).intValue();
        }
        if (intDimType == 3) {
            this.paintChainage(f, g, viewport, tree);
            return;
        }
        if (intDimType == 2) {
            this.paintOrthoDimAbszissa(f, g, viewport, tree);
            return;
        }
        if (intDimType == 1) {
            this.paintOrthoDimOrdinate(f, g, viewport, tree);
            return;
        }
        String strDimText = null;
        if (this.getAttribute(f, DimFeatureAtts.MTEXT.getName()) != null && this.getAttribute(f, DimFeatureAtts.MTEXT.getName()).toString().trim().length() > 0) {
            strDimText = this.getAttribute(f, DimFeatureAtts.MTEXT.getName()).toString();
        }
        if ((arrCoord = (mpt = (MultiPoint)geom).getCoordinates()).length != 4) {
            throw new Exception("Error rendering feature with fid " + f.getID() + ". 4 points required.");
        }
        double dblDimTextHeight = this.getStyleLengthInPixel(this.dimStyle.getFltDimTextHeight(), viewport, false);
        double dblSymSizeDU = this.getStyleLengthInDU(this.dimStyle.getFltSymbolSize(), viewport);
        double dblLength = this.getProjectionLength(arrCoord[0], arrCoord[1]);
        if (strDimText == null) {
            strDimText = this.df.format(dblLength);
        }
        TextLayout dimTxtLayout = new TextLayout(strDimText, this.getDimTextRenderer().retrieveAwtFont(), g.getFontRenderContext());
        double dblTmpTxtHeight = dimTxtLayout.getBounds().getHeight();
        double dblTmpTxtWidth = dimTxtLayout.getBounds().getWidth();
        double dblDimTextWidth = dblDimTextHeight / dblTmpTxtHeight * dblTmpTxtWidth;
        double dblDimTextWidthDU = dblDimTextWidth / viewport.getScale();
        double dblDimTextHeightDU = dblDimTextHeight / viewport.getScale();
        double tdim = ConstSupport.getOrientation((Coordinate)arrCoord[0], (Coordinate)arrCoord[1], (int)2);
        double dblMinWidthDU = Math.max(dblSymSizeDU * 2.0, dblDimTextWidthDU);
        if (!this.dimStyle.isBolShowSymbol()) {
            dblMinWidthDU = this.dimStyle.isBolDimText() ? dblDimTextWidthDU : 0.0;
        }
        if (!arrCoord[0].equals((Object)arrCoord[1])) {
            BasicStroke lineStroke;
            LineString dimLine;
            Shape[] arrShp;
            Coordinate[] arrDimCoord = this.getDimCoords(arrCoord, intDimType, tdim, dblLength, dblMinWidthDU, viewport);
            if (this.dimStyle.isBolDimLine() && (arrShp = RenderUtil.paint((Geometry)(dimLine = this.gfac.createLineString(new Coordinate[]{arrDimCoord[4], arrDimCoord[5]})), g, viewport, false, null, null, true, (Stroke)(lineStroke = this.getDimLineStroke(viewport)), this.modulateColorWithUserDefinedAlpha(this.dimStyle.getColorDimLine()), this.renderLineWithShape(g, lineStroke), false)) != null) {
                tree.insert(arrShp, f, null, true);
            }
            if (this.dimStyle.isBolRefLine() && intDimType == 0 && !arrCoord[0].equals((Object)arrDimCoord[2])) {
                LineString refLine1 = this.gfac.createLineString(new Coordinate[]{arrDimCoord[2], arrCoord[0]});
                LineString refLine2 = this.gfac.createLineString(new Coordinate[]{arrDimCoord[3], arrCoord[1]});
                MultiLineString refLines = this.gfac.createMultiLineString(new LineString[]{refLine1, refLine2});
                BasicStroke lineStroke2 = this.getRefLineStroke(viewport);
                Shape[] arrShp2 = RenderUtil.paint((Geometry)refLines, g, viewport, false, null, null, true, (Stroke)lineStroke2, this.modulateColorWithUserDefinedAlpha(this.dimStyle.getColorRefLine()), this.renderLineWithShape(g, lineStroke2), false);
                tree.insert(arrShp2, f, null, true);
            }
            if (intDimType == 0 && this.dimStyle.isBolShowSymbol()) {
                Geometry symGeom2;
                Geometry symGeom1 = this.getSymbol(arrDimCoord[0], tdim, dblSymSizeDU, dblLength < dblMinWidthDU, viewport);
                ColorModel fillColorWithUserAlpha = this.modulateColorWithUserDefinedAlpha(this.dimStyle.getColorDimLine());
                if (symGeom1 != null) {
                    arrShp = RenderUtil.paint(symGeom1, g, viewport, true, SYM_FILL_STROKE, fillColorWithUserAlpha, true, (Stroke)SYM_LINE_STROKE, fillColorWithUserAlpha, this.renderLineWithShape(g, SYM_LINE_STROKE), false);
                    tree.insert(arrShp, f, null, true);
                }
                if ((symGeom2 = this.getSymbol(arrDimCoord[1], tdim, dblSymSizeDU, dblLength >= dblMinWidthDU, viewport)) != null) {
                    Shape[] arrShp3 = RenderUtil.paint(symGeom2, g, viewport, true, SYM_FILL_STROKE, fillColorWithUserAlpha, true, (Stroke)SYM_LINE_STROKE, fillColorWithUserAlpha, this.renderLineWithShape(g, SYM_LINE_STROKE), false);
                    tree.insert(arrShp3, f, null, true);
                }
            }
            Coordinate coordTxtInsert = this.getTextInsertCoord(arrCoord, arrDimCoord, intDimType, strDimText, tdim, dblLength, dblDimTextHeightDU, dblDimTextWidthDU, viewport, g);
            Point2D textCentreInViewSpace = viewport.toViewPoint(new Point2D.Double(coordTxtInsert.x, coordTxtInsert.y));
            if (this.dimStyle.isBolDimText()) {
                this.getDimTextRenderer().paintText(g, strDimText, textCentreInViewSpace, this.getTextOri(tdim, intDimType, f), 0, dblDimTextHeight, 0.0, 0.0, tree, f);
            }
        }
    }

    private Object getAttribute(SimpleFeature f, String strAttName) {
        return FeatureUtil.getAttribute((SimpleFeature)f, (String)strAttName);
    }

    private double getTextOri(double tdim, int intDimType, SimpleFeature f) throws Exception {
        boolean bolUseOri = false;
        if (this.getAttribute(f, DimFeatureAtts.USE_ORI.getName()) != null) {
            if (this.getAttribute(f, DimFeatureAtts.USE_ORI.getName()) instanceof Boolean) {
                bolUseOri = (Boolean)this.getAttribute(f, DimFeatureAtts.USE_ORI.getName());
            } else if (this.getAttribute(f, DimFeatureAtts.USE_ORI.getName()) instanceof Number) {
                int intOri = ((Number)this.getAttribute(f, DimFeatureAtts.USE_ORI.getName())).intValue();
                bolUseOri = intOri != 0;
            } else {
                throw new Exception("Attribute 'use_ori' has wrong type. It has to be boolean or numeric");
            }
        }
        if (bolUseOri) {
            if (this.getAttribute(f, DimFeatureAtts.MTEXT_ORI.getName()) == null) {
                return 0.0;
            }
            return ((Number)this.getAttribute(f, DimFeatureAtts.MTEXT_ORI.getName())).doubleValue();
        }
        if (intDimType == 0) {
            if (tdim < 0.0) {
                tdim += Math.PI * 2;
            }
            if (tdim > 400.0) {
                tdim -= Math.PI * 2;
            }
            if (tdim < Math.PI) {
                tdim += Math.PI;
            }
            return tdim + 1.5707963267948966;
        }
        if (intDimType == 2) {
            return tdim + 1.5707963267948966;
        }
        if (intDimType == 3) {
            return tdim;
        }
        return tdim;
    }

    private Coordinate getTextInsertCoord(Coordinate[] arrCoord, Coordinate[] arrDimCoord, int intDimType, String strDimText, double tdim, double dblLength, double dblDimTextHeightDU, double dblDimTextWidthDU, Viewport viewport, Graphics2D g) {
        if (!arrCoord[0].equals((Object)arrCoord[3])) {
            return arrCoord[3];
        }
        double dblTxtOffset = dblDimTextHeightDU / 4.0;
        if (intDimType == 1) {
            return arrCoord[3];
        }
        if (intDimType == 2) {
            return arrCoord[3];
        }
        double dblSymSizeDU = 0.0;
        if (this.dimStyle.isBolShowSymbol()) {
            dblSymSizeDU = this.getStyleLengthInDU(this.dimStyle.getFltSymbolSize(), viewport);
        }
        if (dblLength < dblDimTextWidthDU) {
            if (tdim < 0.0) {
                tdim += Math.PI * 2;
            }
            if (tdim > 400.0) {
                tdim -= Math.PI * 2;
            }
            Coordinate coordStart = arrDimCoord[1];
            if (tdim < Math.PI) {
                tdim += Math.PI;
                coordStart = arrDimCoord[0];
            }
            Coordinate coordTemp = ConstSupport.getPolarCoord((Coordinate)coordStart, (double)(dblSymSizeDU + dblTxtOffset / 3.0), (double)tdim);
            return ConstSupport.getPolarCoord((Coordinate)coordTemp, (double)dblTxtOffset, (double)(tdim + 1.5707963267948966));
        }
        if (dblLength < dblDimTextWidthDU + 2.0 * dblSymSizeDU) {
            dblTxtOffset = dblSymSizeDU / 2.0 + dblTxtOffset / 2.0;
        }
        if (tdim < 0.0) {
            tdim += Math.PI * 2;
        }
        if (tdim > 400.0) {
            tdim -= Math.PI * 2;
        }
        Coordinate coordStart = arrDimCoord[0];
        if (tdim < Math.PI) {
            tdim += Math.PI;
            coordStart = arrDimCoord[1];
        }
        Coordinate coordTemp = ConstSupport.getPolarCoord((Coordinate)coordStart, (double)(dblLength / 2.0 - dblDimTextWidthDU / 2.0), (double)tdim);
        return ConstSupport.getPolarCoord((Coordinate)coordTemp, (double)dblTxtOffset, (double)(tdim + 1.5707963267948966));
    }

    private double getStyleLengthInDU(double length, Viewport viewport) {
        if (this.dimStyle.getLengthUnit() == 0) {
            length *= viewport.getPixelScale();
            length /= viewport.getScale();
        }
        return length;
    }

    private double getStyleLengthInPixel(double length, Viewport viewport, boolean isForLine) {
        length = this.dimStyle.getLengthUnit() == 1 ? (length *= viewport.getScale()) : (isForLine ? (length *= viewport.getPixelScale4LineWidth()) : (length *= viewport.getPixelScale()));
        return length;
    }

    private Coordinate[] getDimCoords(Coordinate[] arrCoord, int intDimType, double tdim, double dblLength, double dblMinWidth, Viewport viewport) {
        Coordinate[] arrDimCoord = new Coordinate[6];
        if (intDimType == 0) {
            double dblLineOverDimDU = this.getStyleLengthInDU(this.dimStyle.getFltRefLineOverDim(), viewport);
            double dblOffset = 0.0;
            if (!arrCoord[0].equals((Object)arrCoord[2]) && !arrCoord[1].equals((Object)arrCoord[2])) {
                Coordinate coordSect = ConstSupport.getOrthoSection((Coordinate)arrCoord[0], (Coordinate)arrCoord[1], (Coordinate)arrCoord[2]);
                dblOffset = ConstSupport.getLength((Coordinate)arrCoord[2], (Coordinate)coordSect);
            }
            if (dblOffset > 1.0E-11) {
                double tref = ConstSupport.getOrientation((Coordinate)arrCoord[0], (Coordinate)arrCoord[2], (int)2);
                double delta = tref - tdim;
                if (delta < 0.0) {
                    delta += Math.PI * 2;
                }
                if (delta < Math.PI) {
                    dblOffset *= -1.0;
                    dblLineOverDimDU *= -1.0;
                }
                double tOffset = tdim - 1.5707963267948966;
                arrDimCoord[0] = ConstSupport.getPolarCoord((Coordinate)arrCoord[0], (double)dblOffset, (double)tOffset);
                arrDimCoord[1] = ConstSupport.getPolarCoord((Coordinate)arrCoord[1], (double)dblOffset, (double)tOffset);
                arrDimCoord[2] = ConstSupport.getPolarCoord((Coordinate)arrCoord[0], (double)(dblOffset + dblLineOverDimDU), (double)tOffset);
                arrDimCoord[3] = ConstSupport.getPolarCoord((Coordinate)arrCoord[1], (double)(dblOffset + dblLineOverDimDU), (double)tOffset);
            } else {
                arrDimCoord[0] = new Coordinate(arrCoord[0].x, arrCoord[0].y);
                arrDimCoord[1] = new Coordinate(arrCoord[1].x, arrCoord[1].y);
                arrDimCoord[2] = new Coordinate(arrCoord[0].x, arrCoord[0].y);
                arrDimCoord[3] = new Coordinate(arrCoord[1].x, arrCoord[1].y);
            }
            if (dblLength < dblMinWidth) {
                arrDimCoord[4] = ConstSupport.getPolarCoord((Coordinate)arrDimCoord[0], (double)(dblMinWidth / 2.0), (double)(tdim + Math.PI));
                arrDimCoord[5] = ConstSupport.getPolarCoord((Coordinate)arrDimCoord[1], (double)(dblMinWidth / 2.0), (double)tdim);
            } else {
                arrDimCoord[4] = new Coordinate(arrDimCoord[0].x, arrDimCoord[0].y);
                arrDimCoord[5] = new Coordinate(arrDimCoord[1].x, arrDimCoord[1].y);
            }
        } else {
            arrDimCoord[0] = new Coordinate(arrCoord[0].x, arrCoord[0].y);
            arrDimCoord[1] = new Coordinate(arrCoord[1].x, arrCoord[1].y);
            arrDimCoord[2] = new Coordinate(arrCoord[0].x, arrCoord[0].y);
            arrDimCoord[3] = new Coordinate(arrCoord[1].x, arrCoord[1].y);
            arrDimCoord[4] = new Coordinate(arrCoord[0].x, arrCoord[0].y);
            arrDimCoord[5] = new Coordinate(arrCoord[1].x, arrCoord[1].y);
        }
        return arrDimCoord;
    }

    private Geometry getSymbol(Coordinate coord, double tdim, double dblSymSizeDU, boolean bolRotateSym, Viewport viewport) {
        if (this.dimStyle.getIntSymbolType() == 2) {
            return null;
        }
        if (this.dimStyle.getIntSymbolType() == 1) {
            Coordinate coordStart = ConstSupport.getPolarCoord((Coordinate)coord, (double)dblSymSizeDU, (double)(tdim - 2.356194490192345));
            Coordinate coordEnd = ConstSupport.getPolarCoord((Coordinate)coord, (double)dblSymSizeDU, (double)(tdim + 0.7853981633974483));
            return this.gfac.createLineString(new Coordinate[]{coordStart, coordEnd});
        }
        if (bolRotateSym) {
            tdim += Math.PI;
        }
        Coordinate coordStart = new Coordinate(coord.x, coord.y);
        Coordinate coord1 = ConstSupport.getPolarCoord((Coordinate)coord, (double)dblSymSizeDU, (double)(tdim + 0.2617993877991494));
        Coordinate coord2 = ConstSupport.getPolarCoord((Coordinate)coord, (double)dblSymSizeDU, (double)(tdim - 0.2617993877991494));
        Coordinate coordEnd = new Coordinate(coord.x, coord.y);
        return this.gfac.createPolygon(this.gfac.createLinearRing(new Coordinate[]{coordStart, coord1, coord2, coordEnd}), null);
    }

    @Override
    public void initialize(StyleCollection sCol) {
    }

    private BasicStroke createLineStroke(String strLinePattern, float width) {
        return strLinePattern != null && strLinePattern.trim().length() != 0 && width > 0.0f ? new BasicStroke(Math.max(width, 0.3f), 0, 2, 1.0f, DimRenderer.toArray(strLinePattern, width), 0.0f) : new BasicStroke(Math.max(width, 0.3f), 0, 2);
    }

    @Override
    public boolean isEnabled() {
        return this.dimStyle.isEnabled();
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return Collections.emptyList();
    }

    public static float[] toArray(String strLinePattern, float lineWidth) {
        List<String> strings = StringUtil.fromCommaDelimitedString(strLinePattern);
        float[] array = new float[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            array[i] = Float.parseFloat(string) * lineWidth;
            if (!(array[i] <= 0.0f)) continue;
            throw new IllegalArgumentException(I18N.get("ui.renderer.style.BasicStyle.negative-dash-length"));
        }
        return array;
    }

    private double getProjectionLength(Coordinate coord0, Coordinate coord1) {
        double dblLength = ConstSupport.getLength((Coordinate)coord0, (Coordinate)coord1);
        Task task = WorkbenchContext.getTask();
        if (task.isProjectionReductionActive()) {
            CRSDefinition crsDef = task.getCRSDefinition();
            DrawingUnit unit = task.getDrawingUnit();
            Coordinate coordLastCenter = CoordUtil.average(coord0, coord1);
            return crsDef.getRealWorldDistance(dblLength, task.getHeightReduction(), coordLastCenter, unit);
        }
        return dblLength;
    }

    @Override
    public void setUserDefinedAlpha(int alpha) {
        super.setUserDefinedAlpha(alpha);
        this.getDimTextRenderer().setUserDefinedAlpha(alpha);
    }

    static {
        IntelligenceFactory.register(DimStyleModel.class, DimRenderer::new);
    }
}

