/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingSupport;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.SymbolRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.FontModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.util.StringSupport;
import de.riwagis.util.gui.highdpi.DpiAwareImage;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLegendLabelRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLegendLabelRenderer.class);
    private static final ImageIcon EMPTY_LABEL = GUIUtil.createBlankImage(20, 15);
    public static final ImageIcon RASTER_LABEL = DefaultLegendLabelRenderer.createIconSmallWithWhiteBackground("layer_raster.svg");
    public static final ImageIcon DIMENSION_LABEL = DefaultLegendLabelRenderer.createIconSmallWithWhiteBackground("layer_dimension.svg");
    public static final ImageIcon CAD_LABEL = DefaultLegendLabelRenderer.createIconSmallWithWhiteBackground("layer_cad.svg");
    public static final ImageIcon THEMING_LABEL = DefaultLegendLabelRenderer.createIconSmallWithWhiteBackground("layer_theme.svg");
    public static final ImageIcon REDLINE_LABEL = DefaultLegendLabelRenderer.createIconSmallWithWhiteBackground("layer_redline.svg");
    private static final int DEFAULT_HEIGHT_PX = 22;
    private static final int DEFAULT_WIDTH_PX = 60;
    private int height = 22;
    private int width = 60;
    private int textPt = (int)((double)(this.height - 4) * 0.75);
    private SimpleFeature areafeature = null;
    private SimpleFeature linefeature = null;
    private SimpleFeature textfeature = null;
    private SimpleFeature symfeature = null;
    private BasicStyleModel legendBasicStyle = null;
    private TextStyleModel legendTextStyle = null;
    private SymbolStyleModel legendSymStyle = null;
    private boolean whiteBackground = true;
    private final Viewport viewport = new Viewport(new JPanel(), false){
        private final AffineTransform transform;
        {
            this.transform = new AffineTransform();
        }

        @Override
        public Envelope getEnvelopeInModelCoordinates() {
            return new Envelope(0.0, (double)DefaultLegendLabelRenderer.this.width, 0.0, (double)DefaultLegendLabelRenderer.this.height);
        }

        @Override
        public AffineTransform getModelToViewTransform() {
            return this.transform;
        }

        @Override
        public Point2D toViewPoint(Coordinate modelCoordinate) {
            return new Point2D.Double(modelCoordinate.x, modelCoordinate.y);
        }

        @Override
        public double getPixelScale() {
            return 1.0;
        }

        @Override
        public double getPixelScale4LineWidth() {
            return 0.75;
        }

        @Override
        public Component getPanel() {
            Component pnl = super.getPanel();
            pnl.setSize(DefaultLegendLabelRenderer.this.width, DefaultLegendLabelRenderer.this.height);
            return pnl;
        }
    };

    public int getHeight() {
        return this.height;
    }

    private float getSizeDependentFactor(Graphics2D g2d) {
        return Math.min(1.5f, (float)this.height / RenderUtil.getSize96DpiScale(g2d, 22.0f));
    }

    public void setHeight(int height) {
        this.height = height;
        this.textPt = (int)((double)(height - 6) * 0.75);
        this.symfeature = null;
        this.textfeature = null;
        this.linefeature = null;
        this.areafeature = null;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        this.symfeature = null;
        this.textfeature = null;
        this.linefeature = null;
        this.areafeature = null;
    }

    public boolean isWhiteBackground() {
        return this.whiteBackground;
    }

    public void setWhiteBackground(boolean whiteBackground) {
        this.whiteBackground = whiteBackground;
    }

    public static ImageIcon getEmptyIcon() {
        return EMPTY_LABEL;
    }

    public int paintStyle(StyleCollection sCol, StyleModel _style, Graphics2D g2d) {
        Layerable ly = sCol.getLayerable();
        if (this.whiteBackground) {
            g2d.setColor(Color.WHITE);
            g2d.fill(new Rectangle2D.Float(0.0f, 0.0f, this.width, this.height));
        }
        if (!(ly instanceof Layer) || !(_style instanceof BasicStyleModel)) {
            g2d.drawImage(RASTER_LABEL.getImage(), 0, 0, RASTER_LABEL.getIconWidth(), RASTER_LABEL.getIconHeight(), null);
            return RASTER_LABEL.getIconWidth();
        }
        BasicStyleModel bSty = (BasicStyleModel)_style;
        int widthOfFeatures = this.createFeatures(g2d, bSty);
        if (bSty.isRenderingFill() || bSty.doesRenderLine()) {
            this.setBasicStyleModel4Legend(g2d, bSty);
            ((BasicStyleRenderer)this.legendBasicStyle.getIntelligence()).initialize(sCol);
            this.paint(sCol, this.legendBasicStyle, g2d);
        }
        if (bSty.isRenderingSymbol()) {
            this.setSymbolStyleModel4Legend(g2d, sCol, bSty.getSymStyle());
            ((SymbolRenderer)this.legendSymStyle.getIntelligence()).initialize(sCol);
            String symNameSVG = "";
            try {
                symNameSVG = RenderUtil.getRenderer(this.legendSymStyle).getBshBuilderCache().getStringValue("strPtSymbol", this.legendSymStyle.getStrPtSymbol(), this.symfeature, "");
            }
            catch (Throwable t) {
                LOG.warn("could not render symbol", t);
            }
            if (StringUtils.isNotBlank((CharSequence)symNameSVG) && !symNameSVG.equalsIgnoreCase(".svg") && !symNameSVG.equalsIgnoreCase(".png")) {
                this.paint(sCol, this.legendSymStyle, g2d);
            }
        }
        if (bSty.isRenderingText()) {
            this.setTextStyleModel4Legend(bSty.getTextStyle());
            ((TextRenderer)this.legendTextStyle.getIntelligence()).initialize(sCol);
            this.paint(sCol, this.legendTextStyle, g2d);
        }
        return widthOfFeatures;
    }

    public synchronized Icon getImage(StyleCollection sCol, StyleModel _style) {
        Layerable ly = sCol.getLayerable();
        if (!(ly instanceof Layer) || !(_style instanceof BasicStyleModel)) {
            return RASTER_LABEL;
        }
        int widthNeeded = this.paintScaledImage(sCol, _style, this.width, this.height, true).getWidth();
        return new ImageIcon((Image)new DpiAwareImage((w, h) -> this.paintScaledImage(sCol, _style, (Integer)w, (Integer)h, false), widthNeeded, this.height));
    }

    private BufferedImage paintScaledImage(StyleCollection sCol, StyleModel _style, Integer w, Integer h, boolean cropToContent) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        RenderingSupport.setRenderingHints(g2d, RenderingSupport.RENDERHINTS_DEFAULT);
        double scale = (double)h.intValue() / (double)this.height;
        g2d.scale(scale, scale);
        int widthNeeded = this.paintStyle(sCol, _style, g2d);
        if (cropToContent) {
            if (Math.abs(scale - 1.0) > 1.0E-4) {
                throw new IllegalStateException("Refitting image is only allowed for scale = 100%");
            }
            return image.getSubimage(0, 0, Math.min(w, widthNeeded), h);
        }
        return image;
    }

    private void setTextStyleModel4Legend(TextStyleModel oriTxt) {
        this.legendTextStyle = new TextStyleModel();
        this.legendTextStyle.setStrText("\"Tx\"");
        this.legendTextStyle.setStrHeight("" + this.textPt);
        this.legendTextStyle.setIntUnitLength(0);
        this.legendTextStyle.setAlignPoint("6");
        this.legendTextStyle.setFontText(oriTxt.getFontText());
        this.legendTextStyle.setColorText(oriTxt.getColorText());
        this.legendTextStyle.setColorOpaque(oriTxt.getColorOpaque());
        this.legendTextStyle.setBolOpaque(oriTxt.isBolOpaque());
    }

    private void setSymbolStyleModel4Legend(Graphics2D g2d, StyleCollection sCol, SymbolStyleModel oriSym) {
        this.legendSymStyle = new SymbolStyleModel();
        this.legendSymStyle.setIntUnitSize(0);
        this.legendSymStyle.setBolPtRatio(true);
        String strSymName = RenderUtil.getSymbolName(oriSym);
        int symwidth = this.height - RenderUtil.getSize96DpiScale(g2d, 6);
        int symheight = this.height - RenderUtil.getSize96DpiScale(g2d, 6);
        this.legendSymStyle.setStrPtSymbol(strSymName);
        try {
            strSymName = RenderUtil.getRenderer(this.legendSymStyle).getBshBuilderCache().getStringValue("strPtSymbol", strSymName, this.symfeature, null);
            if (strSymName != null) {
                SymbolStore store = RenderUtil.getSymbolStore(oriSym.getStrStorename(), sCol.getTask());
                symwidth = RenderUtil.getSymbolImage4WidthAndHeight(store, strSymName, symwidth, symheight).getWidth();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.legendSymStyle.setStrPtWidth("" + symwidth);
        this.legendSymStyle.setBolOverwriteLineColor(oriSym.isBolOverwriteLineColor());
        this.legendSymStyle.setBolOverwriteAreaColor(oriSym.isBolOverwriteAreaColor());
        this.legendSymStyle.setFillColor(oriSym.getFillColor());
        this.legendSymStyle.setLineColor(oriSym.getLineColor());
        this.legendSymStyle.setStrStorename(oriSym.getStrStorename());
    }

    private void setBasicStyleModel4Legend(Graphics2D g2d, BasicStyleModel oriBas) {
        float linewidth;
        float sizeFactor;
        try {
            this.legendBasicStyle = oriBas.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new RuntimeException("Should never reach here.", cne);
        }
        float nextDefaultLineWidth = sizeFactor = this.getSizeDependentFactor(g2d);
        if (this.legendBasicStyle.getLineForeground() != null) {
            if (this.legendBasicStyle.getLengthUnit() == 0 && StringSupport.isNumeric((String)this.legendBasicStyle.getLineForeground().getLineWidth())) {
                linewidth = Float.parseFloat(this.legendBasicStyle.getLineForeground().getLineWidth());
                this.legendBasicStyle.getLineForeground().setLineWidthFloat(Math.min(sizeFactor * 1.0f, linewidth));
            } else {
                this.legendBasicStyle.getLineForeground().setLineWidthFloat(nextDefaultLineWidth);
            }
            nextDefaultLineWidth = sizeFactor * 3.0f;
        } else {
            nextDefaultLineWidth = sizeFactor * 2.0f;
        }
        if (this.legendBasicStyle.getLineBase() != null) {
            if (this.legendBasicStyle.getLengthUnit() == 0 && StringSupport.isNumeric((String)this.legendBasicStyle.getLineBase().getLineWidth())) {
                linewidth = Float.parseFloat(this.legendBasicStyle.getLineBase().getLineWidth());
                this.legendBasicStyle.getLineBase().setLineWidthFloat(Math.min(sizeFactor * 4.0f, linewidth));
            } else {
                this.legendBasicStyle.getLineBase().setLineWidthFloat(nextDefaultLineWidth);
            }
            nextDefaultLineWidth += sizeFactor * 2.0f;
        }
        if (this.legendBasicStyle.getLineBackground() != null) {
            if (this.legendBasicStyle.getLengthUnit() == 0 && StringSupport.isNumeric((String)this.legendBasicStyle.getLineBackground().getLineWidth())) {
                linewidth = Float.parseFloat(this.legendBasicStyle.getLineBackground().getLineWidth());
                this.legendBasicStyle.getLineBackground().setLineWidthFloat(Math.min(sizeFactor * 6.0f, linewidth));
            } else {
                this.legendBasicStyle.getLineBackground().setLineWidthFloat(nextDefaultLineWidth);
            }
        }
        if (this.legendBasicStyle.getLengthUnit() != 0 || !StringSupport.isNumeric((String)this.legendBasicStyle.getFillSymWidth())) {
            this.legendBasicStyle.setFillSymWidth("10");
        }
        if (this.legendBasicStyle.getLengthUnit() != 0) {
            this.legendBasicStyle.setLengthUnit(0);
        }
        this.legendBasicStyle.setRenderingText(false);
        this.legendBasicStyle.setRenderingSymbol(false);
    }

    private int createFeatures(Graphics2D grx, BasicStyleModel basicStyleModel) {
        int widthAreaLine = this.width / 2;
        int xSymbol = this.height / 2;
        int xText = this.height;
        int x2Start = 0;
        float sizeFactor = this.getSizeDependentFactor(grx);
        if (basicStyleModel.isRenderingFill() || basicStyleModel.doesRenderLine()) {
            if (!basicStyleModel.isRenderingSymbol()) {
                widthAreaLine += this.width / 4;
            }
            if (!basicStyleModel.isRenderingText()) {
                widthAreaLine += this.width / 4;
            }
            x2Start += widthAreaLine;
        } else {
            x2Start = Math.round(sizeFactor * RenderUtil.getSize96DpiScale(grx, 3.0f));
        }
        if (basicStyleModel.isRenderingSymbol()) {
            xSymbol = x2Start + this.width / 8;
            int widthOfSym = Math.max(this.width / 4, this.height - Math.round(sizeFactor * RenderUtil.getSize96DpiScale(grx, 6.0f)));
            if (xSymbol < widthOfSym / 2) {
                xSymbol = x2Start + widthOfSym / 2;
            }
            if (xSymbol + widthOfSym / 2 > this.width) {
                xSymbol = this.width - widthOfSym / 2;
            }
            x2Start += widthOfSym;
        }
        if (basicStyleModel.isRenderingText()) {
            FontModel fontModel = basicStyleModel.getTextStyle().getFontText();
            Font awtFont = new Font(fontModel.getName(), fontModel.getStyle(), this.textPt);
            Rectangle2D rect = awtFont.getStringBounds("Tx", grx.getFontRenderContext());
            int textWidth = (int)Math.round(rect.getWidth() + (double)(sizeFactor * RenderUtil.getSize96DpiScale(grx, 3.0f)));
            xText = x2Start + this.width / 4;
            if (xText < (textWidth = (int)Math.round((double)textWidth * this.viewport.getPixelScale()))) {
                xText = textWidth;
            }
            if ((float)xText > (float)this.width - sizeFactor * RenderUtil.getSize96DpiScale(grx, 2.0f)) {
                xText = Math.round((float)this.width - sizeFactor * RenderUtil.getSize96DpiScale(grx, 2.0f));
            }
            x2Start = xText + Math.round(sizeFactor * RenderUtil.getSize96DpiScale(grx, 2.0f));
        }
        this.areafeature = this.createAreaFeature(grx, widthAreaLine);
        this.linefeature = this.createLineFeature(grx, widthAreaLine);
        this.symfeature = this.createSymFeature(xSymbol);
        this.textfeature = this.createTextFeature(xText);
        return x2Start;
    }

    private SimpleFeature createAreaFeature(Graphics2D grx, int widthAreaLine) {
        float sizeFactor = this.getSizeDependentFactor(grx);
        float leftTopOffset = sizeFactor * RenderUtil.getSize96DpiScale(grx, 3.0f);
        float rightBottomOffset = sizeFactor * RenderUtil.getSize96DpiScale(grx, 4.0f);
        String strWKT = "POLYGON ((" + leftTopOffset + " " + leftTopOffset + ", " + ((float)widthAreaLine - rightBottomOffset) + " " + leftTopOffset + ", " + ((float)widthAreaLine - rightBottomOffset) + " " + ((float)this.height - rightBottomOffset) + ", " + leftTopOffset + " " + ((float)this.height - rightBottomOffset) + ", " + leftTopOffset + " " + leftTopOffset + "))";
        return FeatureUtil.getWKTFeature((String)strWKT);
    }

    private SimpleFeature createLineFeature(Graphics2D grx, int widthAreaLine) {
        float sizeFactor = this.getSizeDependentFactor(grx);
        float leftTopOffset = sizeFactor * RenderUtil.getSize96DpiScale(grx, 3.0f);
        float rightBottomOffset = sizeFactor * RenderUtil.getSize96DpiScale(grx, 4.0f);
        String strWKT = "LINESTRING (" + leftTopOffset + " " + leftTopOffset + ", " + widthAreaLine / 2 + " " + leftTopOffset + ", " + widthAreaLine / 2 + " " + ((float)this.height - rightBottomOffset) + ", " + ((float)widthAreaLine - rightBottomOffset) + " " + ((float)this.height - rightBottomOffset) + ")";
        return FeatureUtil.getWKTFeature((String)strWKT);
    }

    private SimpleFeature createTextFeature(int x) {
        String strWKT = "POINT (" + x + " " + this.height / 2 + ")";
        return FeatureUtil.getWKTFeature((String)strWKT);
    }

    private SimpleFeature createSymFeature(int x) {
        String strWKT = "POINT (" + x + " " + this.height / 2 + ")";
        return FeatureUtil.getWKTFeature((String)strWKT);
    }

    private void paint(StyleCollection sCol, SymbolStyleModel renderSymStyle, Graphics2D g) {
        if (renderSymStyle == null) {
            return;
        }
        try {
            ShapeFeatureSTRtree tree = new ShapeFeatureSTRtree();
            ((SymbolRenderer)renderSymStyle.getIntelligence()).paint(this.symfeature, g, this.viewport, tree);
        }
        catch (Exception e) {
            String strLayer = "unknown";
            try {
                strLayer = sCol.getLayerable().getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOG.warn(String.format("Error rendering symbol legend label for layer %s.", strLayer), (Throwable)e);
        }
    }

    private void paint(StyleCollection sCol, TextStyleModel renderTextStyle, Graphics2D g) {
        if (renderTextStyle == null) {
            return;
        }
        try {
            ShapeFeatureSTRtree tree = new ShapeFeatureSTRtree();
            ((TextRenderer)renderTextStyle.getIntelligence()).paint(this.textfeature, g, this.viewport, tree);
        }
        catch (Exception e) {
            String strLayer = "unknown";
            try {
                strLayer = sCol.getLayerable().getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOG.warn(String.format("Error rendering text legend label for layer %s.", strLayer), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paint(StyleCollection sCol, BasicStyleModel style, Graphics2D g) {
        if (style == null) {
            return;
        }
        Stroke originalStroke = g.getStroke();
        try {
            ShapeFeatureSTRtree tree = new ShapeFeatureSTRtree();
            BasicStyleRenderer bsr = RenderUtil.getRenderer(style);
            if (style.isRenderingFill()) {
                bsr.paint(this.areafeature, g, this.viewport, tree);
            } else if (style.doesRenderLine()) {
                List<StyleRenderer> decRenderer = bsr.getDecorationRenderer();
                for (StyleRenderer sr : decRenderer) {
                    sr.paint(this.linefeature, g, this.viewport, tree);
                }
            }
        }
        catch (Exception e) {
            String strLayer = "unknown";
            try {
                strLayer = sCol.getLayerable().getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOG.warn(String.format("Error rendering line, area legend label for layer %s.", strLayer), (Throwable)e);
        }
        finally {
            g.setStroke(originalStroke);
        }
    }

    private static ImageIcon createIconSmallWithWhiteBackground(String name) {
        PNGTranscoder transcoder = IconLoader.createDefaultPNGTranscoder();
        transcoder.addTranscodingHint(ImageTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        return IconLoader.svgIcon((String)name, (int)16, (int)16, (PNGTranscoder)transcoder);
    }
}

