/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.DummyStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineRendererProxyOnlyLines;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.theming.ThemeRetriever;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.geotools.feature.bsh.FeatBshObjectBuilder;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.theme.ThemeModel;
import de.riwagis.riwajump.model.style.theme.ThemeSourceModel;
import de.riwagis.riwajump.model.util.ColorHelper;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class ColorThemingRenderer
extends AbstractStyleRenderer<ColorThemingStyleModel> {
    public static final int MAX_THEMES_FOR_RENDERING = 500;
    private List<StyleRenderer> decorationRenderers = null;
    private LayerStyleCollection sCol;
    private boolean reinitObjBuilder = true;
    private FeatBshObjectBuilder objBuilder = null;
    private final ColorThemingStyleModel themeStyle;

    public ColorThemingRenderer(ColorThemingStyleModel themeStyle) {
        this.themeStyle = themeStyle;
    }

    public FeatBshObjectBuilder getObjBuilder() {
        if (this.reinitObjBuilder || this.objBuilder == null) {
            this.reinitObjBuilder = false;
            try {
                this.objBuilder = FeatBshObjectBuilder.getInstance((String)this.themeStyle.getAttributeName());
            }
            catch (Exception e) {
                this.objBuilder = null;
            }
        }
        return this.objBuilder;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        this.decorationRenderers = null;
        if (modelEvent.getPropertyName().equals("attributeName")) {
            this.reinitObjBuilder = true;
        }
        this.clearCaches();
    }

    public static SimpleFeatureType getFeatureType(LayerStyleCollection _sCol) {
        SimpleFeatureType fSchema;
        try {
            fSchema = _sCol.getLayer().getFeatureType();
            if (fSchema == null) {
                fSchema = FeatureUtil.getEmptyFeatureType();
            }
        }
        catch (Exception e) {
            fSchema = FeatureUtil.getEmptyFeatureType();
        }
        return fSchema;
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        if (this.decorationRenderers != null) {
            return this.decorationRenderers;
        }
        boolean useLineBackground = false;
        boolean useLineBase = false;
        boolean useLineForeground = false;
        boolean useSymbol = false;
        boolean useText = false;
        if (this.getDefaultStyleRenderer().getLineBackgroundRenderer() != null) {
            useLineBackground = true;
        }
        if (this.getDefaultStyleRenderer().getLineBaseRenderer() != null) {
            useLineBase = true;
        }
        if (this.getDefaultStyleRenderer().getLineForegroundRenderer() != null) {
            useLineForeground = true;
        }
        if (this.getDefaultStyleRenderer().getSymbolRenderer() != null) {
            useSymbol = true;
        }
        if (this.getDefaultStyleRenderer().getTextRenderer() != null) {
            useText = true;
        }
        for (BasicStyleRenderer bsr : this.getThemeRenderers()) {
            if (bsr.getLineBackgroundRenderer() != null) {
                useLineBackground = true;
            }
            if (bsr.getLineBaseRenderer() != null) {
                useLineBase = true;
            }
            if (bsr.getLineForegroundRenderer() != null) {
                useLineForeground = true;
            }
            if (bsr.getSymbolRenderer() != null) {
                useSymbol = true;
            }
            if (bsr.getTextRenderer() == null) continue;
            useText = true;
        }
        this.decorationRenderers = new ArrayList<StyleRenderer>();
        if (useLineBackground) {
            this.decorationRenderers.add(new DummyStyleRenderer(){

                @Override
                public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
                    BasicStyleRenderer bsr = ColorThemingRenderer.this.getRenderer(f);
                    if (!bsr.isEnabled()) {
                        return;
                    }
                    if (bsr.getLineBackgroundRenderer() != null && LineRendererProxyOnlyLines.isGeometryForRenderer((Geometry)f.getDefaultGeometry())) {
                        bsr.getLineBackgroundRenderer().paint(f, g, viewport, tree);
                    }
                }
            });
        }
        if (useLineBase) {
            this.decorationRenderers.add(new DummyStyleRenderer(){

                @Override
                public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
                    BasicStyleRenderer bsr = ColorThemingRenderer.this.getRenderer(f);
                    if (!bsr.isEnabled()) {
                        return;
                    }
                    if (bsr.getLineBaseRenderer() != null && LineRendererProxyOnlyLines.isGeometryForRenderer((Geometry)f.getDefaultGeometry())) {
                        bsr.getLineBaseRenderer().paint(f, g, viewport, tree);
                    }
                }
            });
        }
        if (useLineForeground) {
            this.decorationRenderers.add(new DummyStyleRenderer(){

                @Override
                public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
                    BasicStyleRenderer bsr = ColorThemingRenderer.this.getRenderer(f);
                    if (!bsr.isEnabled()) {
                        return;
                    }
                    if (bsr.getLineForegroundRenderer() != null && LineRendererProxyOnlyLines.isGeometryForRenderer((Geometry)f.getDefaultGeometry())) {
                        bsr.getLineForegroundRenderer().paint(f, g, viewport, tree);
                    }
                }
            });
        }
        if (useSymbol) {
            this.decorationRenderers.add(new DummyStyleRenderer(){

                @Override
                public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
                    BasicStyleRenderer bsr = ColorThemingRenderer.this.getRenderer(f);
                    if (!bsr.isEnabled()) {
                        return;
                    }
                    if (bsr.getSymbolRenderer() != null) {
                        bsr.getSymbolRenderer().paint(f, g, viewport, tree);
                    }
                }
            });
        }
        if (useText) {
            this.decorationRenderers.add(new DummyStyleRenderer(){

                @Override
                public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
                    BasicStyleRenderer bsr = ColorThemingRenderer.this.getRenderer(f);
                    if (!bsr.isEnabled()) {
                        return;
                    }
                    if (bsr.getTextRenderer() != null) {
                        bsr.getTextRenderer().paint(f, g, viewport, tree);
                    }
                }
            });
        }
        return this.decorationRenderers;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        BasicStyleRenderer bsr = this.getRenderer(f);
        if (!bsr.isEnabled()) {
            return;
        }
        bsr.paint(f, g, viewport, tree);
    }

    public String getLabel(SimpleFeature feature) {
        ThemeRetriever<ThemeSourceModel> retriever;
        ThemeModel th;
        this.getObjBuilder().setFeature(feature);
        Object obj = this.getObjBuilder().getObject();
        Object strLabel = null;
        if (this.themeStyle.getAttributeName() != null && (th = (retriever = this.getThemeRetriever()).getThemeForObject(this.sCol.getLayer(), obj)) != null) {
            return th.getLabel();
        }
        return this.themeStyle.getDefaultLabel();
    }

    public BasicStyleModel getStyle(SimpleFeature feature) {
        ThemeRetriever<ThemeSourceModel> retriever;
        ThemeModel th;
        this.getObjBuilder().setFeature(feature);
        Object obj = this.getObjBuilder().getObject();
        if (this.themeStyle.getAttributeName() != null && (th = (retriever = this.getThemeRetriever()).getThemeForObject(this.sCol.getLayer(), obj)) != null) {
            return th.getStyle();
        }
        return this.themeStyle.getDefaultStyle();
    }

    private BasicStyleRenderer getRenderer(SimpleFeature feature) {
        BasicStyleModel bsm = this.getStyle(feature);
        if (bsm == null) {
            return null;
        }
        return (BasicStyleRenderer)bsm.getIntelligence();
    }

    @Override
    public void initialize(StyleCollection _sCol) {
        this.sCol = (LayerStyleCollection)_sCol;
        this.getDefaultStyleRenderer().initialize(this.sCol);
        for (BasicStyleRenderer bsr : this.getThemeRenderers()) {
            bsr.initialize(this.sCol);
        }
        this.decorationRenderers = null;
    }

    @Override
    public boolean isEnabled() {
        return this.themeStyle.isEnabled();
    }

    public static ColorThemingStyleModel get(LayerStyleCollection _sCol) {
        try {
            if (_sCol.getStyle(ColorThemingStyleModel.class) == null) {
                SimpleFeatureType fType;
                try {
                    fType = _sCol.getLayer().getFeatureType();
                    if (fType == null) {
                        fType = FeatureUtil.getEmptyFeatureType();
                    }
                }
                catch (Exception e) {
                    fType = FeatureUtil.getEmptyFeatureType();
                }
                ColorThemingStyleModel colorThemingStyle = new ColorThemingStyleModel("str(\"" + ColorThemingRenderer.pickNonSpatialAttributeName(fType) + "\")", new TreeMap(), new BasicStyleModel(ColorHelper.lightGray));
                _sCol.addStyle((StyleModel)colorThemingStyle);
            }
            return _sCol.getStyle(ColorThemingStyleModel.class);
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.getMessage());
            return null;
        }
    }

    private static String pickNonSpatialAttributeName(SimpleFeatureType schema) {
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getGeometryDescriptor() != null && schema.indexOf(schema.getGeometryDescriptor().getName()) == i) continue;
            return schema.getDescriptor(i).getLocalName();
        }
        return null;
    }

    private BasicStyleRenderer getDefaultStyleRenderer() {
        if (this.themeStyle.getDefaultStyle() == null) {
            return null;
        }
        return (BasicStyleRenderer)this.themeStyle.getDefaultStyle().getIntelligence();
    }

    private Collection<BasicStyleRenderer> getThemeRenderers() {
        ArrayList<BasicStyleRenderer> lstRenderer = new ArrayList<BasicStyleRenderer>();
        for (ThemeModel thModel : this.getThemes()) {
            lstRenderer.add((BasicStyleRenderer)thModel.getStyle().getIntelligence());
        }
        return lstRenderer;
    }

    private Collection<ThemeModel> getThemes() {
        Layer layer = this.getLayerFromStyleCollection();
        if (layer == null) {
            return Collections.emptyList();
        }
        return this.getThemeRetriever().getThemes(layer);
    }

    private Layer getLayerFromStyleCollection() {
        if (this.sCol == null) {
            return null;
        }
        return this.sCol.getLayer();
    }

    private ThemeRetriever<ThemeSourceModel> getThemeRetriever() {
        ThemeRetriever retriever = (ThemeRetriever)this.themeStyle.getThemeSource().getIntelligence();
        return retriever;
    }

    @Override
    public void clearLegendLabelCache() {
        this.getDefaultStyleRenderer().clearLegendLabelCache();
        for (BasicStyleRenderer bsr : this.getThemeRenderers()) {
            bsr.clearLegendLabelCache();
        }
    }

    @Override
    public boolean needsRendering() {
        if (this.getDefaultStyleRenderer() != null && this.getDefaultStyleRenderer().needsRendering()) {
            return true;
        }
        for (BasicStyleRenderer bsr : this.getThemeRenderers()) {
            if (!bsr.needsRendering()) continue;
            return true;
        }
        return false;
    }

    public ColorThemingStyleModel getModel() {
        return this.themeStyle;
    }

    @Override
    public void setUserDefinedAlpha(int alpha) {
        super.setUserDefinedAlpha(alpha);
        this.getDefaultStyleRenderer().setUserDefinedAlpha(alpha);
        this.getThemeRetriever().setUserDefinedAlpha(this.getLayerFromStyleCollection(), alpha);
    }

    public void clearCaches() {
        this.getThemeRetriever().clearCaches();
        this.clearLegendLabelCache();
    }

    static {
        IntelligenceFactory.register(ColorThemingStyleModel.class, ColorThemingRenderer::new);
    }
}

