/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import de.riwagis.geotools.feature.bsh.FeatBshCalculator;
import de.riwagis.geotools.feature.bsh.FeatBshObjectBuilder;
import de.riwagis.geotools.feature.bsh.FeatBshStringBuilder;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BshBuilderMaxCache {
    public static final int DEFAULT_CACHE_SIZE = 200;
    private static final Logger LOG = LoggerFactory.getLogger(BshBuilderMaxCache.class);
    private final Lock lock_calc = new ReentrantLock();
    private final Lock lock_sb = new ReentrantLock();
    private final Lock lock_obj = new ReentrantLock();
    private final Map<String, FeatBshStringBuilder> mapStringBuilders;
    private final Map<String, FeatBshCalculator> mapCalculators;
    private final Map<String, FeatBshObjectBuilder> mapObjectBuilders;
    private final int maxCacheSize;

    public BshBuilderMaxCache() {
        this(200);
    }

    public BshBuilderMaxCache(int _maxCacheSize) {
        this.mapStringBuilders = new LRUMap(_maxCacheSize);
        this.mapCalculators = new LRUMap(_maxCacheSize);
        this.mapObjectBuilders = new LRUMap(_maxCacheSize);
        this.maxCacheSize = _maxCacheSize;
    }

    public final void clear() {
        try {
            this.lock_calc.lock();
            this.mapCalculators.clear();
        }
        finally {
            this.lock_calc.unlock();
        }
        try {
            this.lock_sb.lock();
            this.mapStringBuilders.clear();
        }
        finally {
            this.lock_sb.unlock();
        }
        try {
            this.lock_obj.lock();
            this.mapObjectBuilders.clear();
        }
        finally {
            this.lock_obj.unlock();
        }
    }

    public int calcCacheSize() {
        return this.mapCalculators.size();
    }

    public int stringCacheSize() {
        return this.mapStringBuilders.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCalcValue(String strCalc, SimpleFeature f, double dblDefault) {
        try {
            this.lock_calc.lock();
            FeatBshCalculator calc = this.getCalculator(strCalc);
            if (calc != null) {
                calc.setFeature(f);
                double d = calc.getDouble();
                return d;
            }
        }
        finally {
            this.lock_calc.unlock();
        }
        return dblDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringValue(String strString, SimpleFeature f, String strDefault) {
        try {
            this.lock_sb.lock();
            FeatBshStringBuilder sb = this.getStringBuilder(strString);
            if (sb != null) {
                sb.setFeature(f);
                String string = sb.getString();
                return string;
            }
        }
        finally {
            this.lock_sb.unlock();
        }
        return strDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectValue(String strString, SimpleFeature f, Object objDefault) {
        try {
            this.lock_obj.lock();
            FeatBshObjectBuilder objBld = this.getObjectBuilder(strString);
            if (objBld != null) {
                objBld.setFeature(f);
                Object object = objBld.getObject();
                return object;
            }
        }
        finally {
            this.lock_obj.unlock();
        }
        return objDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatBshCalculator getCalculator(String _strCalc) {
        FeatBshCalculator calc = null;
        if (StringUtils.isNotBlank((CharSequence)_strCalc)) {
            try {
                this.lock_calc.lock();
                if (!this.mapCalculators.containsKey(_strCalc)) {
                    try {
                        LOG.debug(String.format("creating new Bsh '%s' (%d)", _strCalc, this.mapCalculators.size()));
                        calc = FeatBshCalculator.getInstance((String)_strCalc);
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Error creating Bsh '%s': %s ", _strCalc, e.getMessage()), (Throwable)e);
                        calc = null;
                    }
                    this.mapCalculators.put(_strCalc, calc);
                }
                calc = this.mapCalculators.get(_strCalc);
            }
            finally {
                this.lock_calc.unlock();
            }
        }
        return calc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatBshStringBuilder getStringBuilder(String _strCalc) {
        FeatBshStringBuilder sb = null;
        if (StringUtils.isNotBlank((CharSequence)_strCalc)) {
            try {
                this.lock_sb.lock();
                if (!this.mapStringBuilders.containsKey(_strCalc)) {
                    try {
                        LOG.debug(String.format("creating new Bsh '%s' (%d)", _strCalc, this.mapStringBuilders.size()));
                        sb = FeatBshStringBuilder.getInstance((String)_strCalc);
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Error creating Bsh '%s': %s ", _strCalc, e.getMessage()), (Throwable)e);
                        sb = null;
                    }
                    this.mapStringBuilders.put(_strCalc, sb);
                }
                sb = this.mapStringBuilders.get(_strCalc);
            }
            finally {
                this.lock_sb.unlock();
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FeatBshObjectBuilder getObjectBuilder(String _strCalc) {
        FeatBshObjectBuilder objBld = null;
        if (StringUtils.isNotBlank((CharSequence)_strCalc)) {
            try {
                this.lock_obj.lock();
                if (!this.mapObjectBuilders.containsKey(_strCalc)) {
                    try {
                        LOG.debug(String.format("creating new Bsh '%s' (%d)", _strCalc, this.mapObjectBuilders.size()));
                        objBld = FeatBshObjectBuilder.getInstance((String)_strCalc);
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Error creating Bsh '%s': %s ", _strCalc, e.getMessage()), (Throwable)e);
                        objBld = null;
                    }
                    this.mapObjectBuilders.put(_strCalc, objBld);
                }
                objBld = this.mapObjectBuilders.get(_strCalc);
            }
            finally {
                this.lock_obj.unlock();
            }
        }
        return objBld;
    }
}

