/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Task;
import de.riwagis.geotools.feature.bsh.FeatBshCalculator;
import de.riwagis.geotools.feature.bsh.FeatBshObjectBuilder;
import de.riwagis.geotools.feature.bsh.FeatBshStringBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BshBuilderCache {
    private static final Logger LOG = LoggerFactory.getLogger(BshBuilderCache.class);
    private final Lock lock_calc = new ReentrantLock();
    private final Lock lock_sb = new ReentrantLock();
    private final Lock lock_obj = new ReentrantLock();
    private final Map<String, FeatBshStringBuilder> mapStringBuilders = new HashMap<String, FeatBshStringBuilder>();
    private final Map<String, Boolean> mapInitStringBuilders = new HashMap<String, Boolean>();
    private final Map<String, FeatBshCalculator> mapCalculators = new HashMap<String, FeatBshCalculator>();
    private final Map<String, Boolean> mapInitCalculators = new HashMap<String, Boolean>();
    private final Map<String, FeatBshObjectBuilder> mapObjectBuilders = new HashMap<String, FeatBshObjectBuilder>();
    private final Map<String, Boolean> mapInitObjectBuilders = new HashMap<String, Boolean>();

    public double getCalcValue(String key, String bshExpression, SimpleFeature f, double dblDefault) {
        return this.getCalcValue(key, bshExpression, f, dblDefault, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCalcValue(String key, String bshExpression, SimpleFeature f, double dblDefault, boolean raiseErrorOnMissingAttributes) {
        FeatBshCalculator calc = this.getCalculator(key, bshExpression);
        if (calc != null) {
            try {
                this.lock_calc.lock();
                calc.setRaiseErrorOnMissingAttributes(raiseErrorOnMissingAttributes);
                calc.setFeature(f);
                double d = calc.getDouble();
                return d;
            }
            finally {
                this.lock_calc.unlock();
            }
        }
        return dblDefault;
    }

    public String getStringValue(String key, String bshExpression, SimpleFeature f, String strDefault) {
        return this.getStringValue(key, bshExpression, f, strDefault, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringValue(String key, String bshExpression, SimpleFeature f, String strDefault, boolean raiseErrorOnMissingAttributes) {
        FeatBshStringBuilder sb = this.getStringBuilder(key, bshExpression);
        if (sb != null) {
            try {
                this.lock_sb.lock();
                sb.setRaiseErrorOnMissingAttributes(raiseErrorOnMissingAttributes);
                sb.setFeature(f);
                String string = sb.getString();
                return string;
            }
            finally {
                this.lock_sb.unlock();
            }
        }
        return strDefault;
    }

    public Object getObjectValue(String key, String bshExpression, SimpleFeature f, Object objDefault) {
        return this.getObjectValue(key, bshExpression, f, objDefault, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectValue(String key, String bshExpression, SimpleFeature f, Object objDefault, boolean raiseErrorOnMissingAttributes) {
        FeatBshObjectBuilder objBld = this.getObjectBuilder(key, bshExpression);
        if (objBld != null) {
            try {
                this.lock_obj.lock();
                objBld.setRaiseErrorOnMissingAttributes(raiseErrorOnMissingAttributes);
                objBld.setFeature(f);
                Object object = objBld.getObject();
                return object;
            }
            finally {
                this.lock_obj.unlock();
            }
        }
        return objDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatBshCalculator getCalculator(String key, String bshExpression) {
        try {
            this.lock_calc.lock();
            if (!this.mapInitCalculators.containsKey(key)) {
                this.mapInitCalculators.put(key, true);
            }
            if (!this.mapCalculators.containsKey(key)) {
                this.mapCalculators.put(key, null);
            }
            boolean reinit = this.mapInitCalculators.get(key);
            Object calc = this.mapCalculators.get(key);
            if (reinit) {
                this.mapInitCalculators.put(key, false);
                try {
                    calc = bshExpression != null && !bshExpression.trim().isEmpty() ? FeatBshCalculator.getInstance((String)bshExpression) : null;
                }
                catch (Exception e) {
                    LOG.error("Error creating calculator for: " + bshExpression, (Throwable)e);
                    calc = null;
                }
                this.mapCalculators.put(key, (FeatBshCalculator)calc);
            }
            FeatBshCalculator featBshCalculator = calc;
            return featBshCalculator;
        }
        finally {
            this.lock_calc.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatBshStringBuilder getStringBuilder(String key, String bshExpression) {
        try {
            this.lock_sb.lock();
            if (!this.mapInitStringBuilders.containsKey(key)) {
                this.mapInitStringBuilders.put(key, true);
            }
            if (!this.mapStringBuilders.containsKey(key)) {
                this.mapStringBuilders.put(key, null);
            }
            boolean reinit = this.mapInitStringBuilders.get(key);
            Object sb = this.mapStringBuilders.get(key);
            if (reinit) {
                this.mapInitStringBuilders.put(key, false);
                try {
                    sb = bshExpression != null && !bshExpression.trim().isEmpty() ? FeatBshStringBuilder.getInstance((String)bshExpression) : null;
                }
                catch (Exception e) {
                    sb = null;
                }
                this.mapStringBuilders.put(key, (FeatBshStringBuilder)sb);
            }
            JUMPWorkbench.getContext();
            Task task = WorkbenchContext.getTask();
            if (sb != null && task != null) {
                sb.setProjectionReductionActive(task.isProjectionReductionActive());
                sb.setHeightReduction(task.getHeightReduction());
                sb.setCRSDefintion(task.getCRSDefinition());
                sb.setDrawingUnit(task.getDrawingUnit());
            }
            FeatBshStringBuilder featBshStringBuilder = sb;
            return featBshStringBuilder;
        }
        finally {
            this.lock_sb.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FeatBshObjectBuilder getObjectBuilder(String key, String bshExpression) {
        try {
            this.lock_obj.lock();
            if (!this.mapInitObjectBuilders.containsKey(key)) {
                this.mapInitObjectBuilders.put(key, true);
            }
            if (!this.mapObjectBuilders.containsKey(key)) {
                this.mapObjectBuilders.put(key, null);
            }
            boolean reinit = this.mapInitObjectBuilders.get(key);
            Object objBld = this.mapObjectBuilders.get(key);
            if (reinit) {
                this.mapInitObjectBuilders.put(key, false);
                try {
                    objBld = bshExpression != null && !bshExpression.trim().isEmpty() ? FeatBshObjectBuilder.getInstance((String)bshExpression) : null;
                }
                catch (Exception e) {
                    objBld = null;
                }
                this.mapObjectBuilders.put(key, (FeatBshObjectBuilder)objBld);
            }
            FeatBshObjectBuilder featBshObjectBuilder = objBld;
            return featBshObjectBuilder;
        }
        finally {
            this.lock_obj.unlock();
        }
    }

    public void reinitStringBuilder(String strKey) {
        try {
            this.lock_sb.lock();
            this.mapInitStringBuilders.put(strKey, true);
        }
        finally {
            this.lock_sb.unlock();
        }
    }

    public void reinitCalculator(String strKey) {
        try {
            this.lock_calc.lock();
            this.mapInitCalculators.put(strKey, true);
        }
        finally {
            this.lock_calc.unlock();
        }
    }

    public void reinitObjectBuilder(String strKey) {
        try {
            this.lock_obj.lock();
            this.mapInitObjectBuilders.put(strKey, true);
        }
        finally {
            this.lock_obj.unlock();
        }
    }
}

