/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.GeometryCollectionShape;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.LinePathShape;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BshBuilderCache;
import com.vividsolutions.jump.workbench.ui.renderer.style.DefaultLegendLabelRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineRendererProxyOnlyLines;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.SVGFillPattern;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.SymbolRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.riwajump.model.event.JumpModelChangedListener;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.symbol.SymbolStore;
import de.riwagis.util.svg.SVGSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import lombok.Generated;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStyleRenderer
extends AbstractStyleRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicStyleRenderer.class);
    private static final long serialVersionUID = -8701448936808492191L;
    private static final String BSH_FILL_SYM_KEY = "strFillSymName";
    private static final String BSH_FILL_SYM_WIDTH_KEY = "strFillSymWidth";
    private static final String BSH_OVERWRITE_FILL_COLOR_KEY = "featFillColor";
    private SVGFillPattern svgFillPattern = null;
    private String strLastFillSymName = null;
    private final transient Stroke fillStroke = new BasicStroke(1.0f);
    private StyleCollection sCol = null;
    private transient BshBuilderCache bbCache = new BshBuilderCache();
    private Color renderFillColor = null;
    private List<StyleRenderer> decorationRenderers = null;
    private final BasicStyleModel basicStyle;
    private final transient Collection<JumpModelChangedListener> modelChangedListeners = new HashSet<JumpModelChangedListener>();

    public Collection<JumpModelChangedListener> getModelChangedListeners() {
        return Collections.unmodifiableCollection(this.modelChangedListeners);
    }

    public void addModelChangedListener(JumpModelChangedListener listener) {
        this.modelChangedListeners.add(listener);
    }

    public boolean removeModelChangedListener(JumpModelChangedListener listener) {
        return this.modelChangedListeners.remove(listener);
    }

    public BasicStyleRenderer(BasicStyleModel basicStyle) {
        this.basicStyle = basicStyle;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        for (JumpModelChangedListener listener : this.modelChangedListeners) {
            listener.fireJumpModelChanged(modelEvent);
        }
        this.renderFillColor = null;
        this.bbCache.reinitStringBuilder(modelEvent.getPropertyName());
        this.bbCache.reinitCalculator(modelEvent.getPropertyName());
        this.bbCache.reinitObjectBuilder(modelEvent.getPropertyName());
        if (modelEvent.getPropertyName().equals("fillColor")) {
            this.svgFillPattern = null;
        }
        if (modelEvent.getPropertyName().equals("textStyle") || modelEvent.getPropertyName().equals("renderingText") || modelEvent.getPropertyName().equals("symStyle") || modelEvent.getPropertyName().equals("renderingSymbol") || modelEvent.getPropertyName().equals("lineBackground") || modelEvent.getPropertyName().equals("lineBase") || modelEvent.getPropertyName().equals("lineForeground")) {
            this.decorationRenderers = null;
        }
        this.clearLegendLabelCache();
    }

    TextRenderer getTextRenderer() {
        return this.basicStyle.isRenderingText() ? RenderUtil.getRenderer(this.basicStyle.getTextStyle()) : null;
    }

    SymbolRenderer getSymbolRenderer() {
        return this.basicStyle.isRenderingSymbol() ? RenderUtil.getRenderer(this.basicStyle.getSymStyle()) : null;
    }

    LineRenderer getLineForegroundRenderer() {
        return RenderUtil.getRenderer(this.basicStyle.getLineForeground());
    }

    LineRenderer getLineBaseRenderer() {
        return RenderUtil.getRenderer(this.basicStyle.getLineBase());
    }

    LineRenderer getLineBackgroundRenderer() {
        return RenderUtil.getRenderer(this.basicStyle.getLineBackground());
    }

    @Override
    public void initialize(StyleCollection sCol) {
        this.sCol = sCol;
        if (this.getTextRenderer() != null) {
            this.getTextRenderer().initialize(this.sCol);
        }
        if (this.getSymbolRenderer() != null) {
            this.getSymbolRenderer().initialize(this.sCol);
        }
        if (this.getLineForegroundRenderer() != null) {
            this.getLineForegroundRenderer().initialize(this.sCol);
        }
        if (this.getLineBaseRenderer() != null) {
            this.getLineBaseRenderer().initialize(this.sCol);
        }
        if (this.getLineBackgroundRenderer() != null) {
            this.getLineBackgroundRenderer().initialize(this.sCol);
        }
        this.decorationRenderers = null;
        this.svgFillPattern = null;
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        if (this.decorationRenderers != null) {
            return this.decorationRenderers;
        }
        this.decorationRenderers = new ArrayList<StyleRenderer>();
        if (this.basicStyle.getLineBackground() != null) {
            this.decorationRenderers.add(new LineRendererProxyOnlyLines(this.getLineBackgroundRenderer()));
        }
        if (this.basicStyle.getLineBase() != null) {
            this.decorationRenderers.add(new LineRendererProxyOnlyLines(this.getLineBaseRenderer()));
        }
        if (this.basicStyle.getLineForeground() != null) {
            this.decorationRenderers.add(new LineRendererProxyOnlyLines(this.getLineForegroundRenderer()));
        }
        if (this.basicStyle.isRenderingSymbol() && this.getSymbolRenderer() != null) {
            this.decorationRenderers.add(this.getSymbolRenderer());
        }
        if (this.basicStyle.isRenderingText() && this.getTextRenderer() != null) {
            this.decorationRenderers.add(this.getTextRenderer());
        }
        return this.decorationRenderers;
    }

    @Override
    public boolean isEnabled() {
        return this.basicStyle.isEnabled();
    }

    @Override
    public boolean needsRendering() {
        return this.basicStyle.isRenderingFill() || this.basicStyle.doesRenderLine();
    }

    private Color getFillColorInternal() {
        if (this.renderFillColor == null) {
            this.renderFillColor = RiwaJumpModelUtilities.colorByColorModel(this.basicStyle.getFillColorWithAlpha());
        }
        return this.renderFillColor;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        if (!this.basicStyle.isRenderingFill() && !this.basicStyle.doesRenderLine()) {
            return;
        }
        Geometry geom = (Geometry)f.getDefaultGeometry();
        if (geom instanceof Point || geom instanceof MultiPoint || LineRendererProxyOnlyLines.isGeometryForRenderer(geom)) {
            return;
        }
        if (!BasicStyleRenderer.adobeReaderFix4Print_DoesGeomIntersectVisibleArea(geom, g, viewport)) {
            return;
        }
        String strSBFillSym = this.getSBFillSymName(f);
        int intFillSymWidth = this.getFillSymWidth(f, viewport);
        if (this.basicStyle.isRenderingFill() && this.basicStyle.isRenderingFillPattern()) {
            if (intFillSymWidth > 0) {
                if (this.svgFillPattern == null || this.strLastFillSymName == null || !this.strLastFillSymName.equals(strSBFillSym)) {
                    this.svgFillPattern = this.getFillPattern(strSBFillSym, intFillSymWidth, f);
                    this.strLastFillSymName = strSBFillSym;
                } else {
                    this.svgFillPattern.setSymWidth(intFillSymWidth);
                }
            }
            if (this.svgFillPattern != null) {
                double minx = viewport.getEnvelopeInModelCoordinates().getMinX();
                double maxy = viewport.getEnvelopeInModelCoordinates().getMaxY();
                double modelWidth = (double)intFillSymWidth / viewport.getScale();
                this.svgFillPattern.transx = -Math.IEEEremainder(minx, modelWidth) * viewport.getScale();
                this.svgFillPattern.transy = Math.IEEEremainder(maxy, modelWidth / this.svgFillPattern.getRatioYX()) * viewport.getScale();
            }
        }
        Shape[] arrShp = null;
        if (g.getRenderingHint(Viewport.KEY_IS4PRINT) != null && strSBFillSym != null && strSBFillSym.toLowerCase().endsWith(".svg") && this.svgFillPattern != null && this.basicStyle.isRenderingFill() && this.basicStyle.isRenderingFillPattern()) {
            if (geom != null && geom.getArea() > 0.0) {
                this.paintFillForPrint(strSBFillSym, intFillSymWidth, f, g, viewport, geom);
            }
        } else {
            arrShp = RenderUtil.paint(geom, g, viewport, this.basicStyle.isRenderingFill(), this.fillStroke, this.basicStyle.isRenderingFillPattern() && this.svgFillPattern != null ? this.svgFillPattern : this.getFillColorForFeatureWithUserDefinedAlpha(f), false, null, null, false, false);
        }
        if (this.getLineBackgroundRenderer() != null) {
            this.getLineBackgroundRenderer().paint(f, g, viewport, tree);
            arrShp = null;
        }
        if (this.getLineBaseRenderer() != null) {
            this.getLineBaseRenderer().paint(f, g, viewport, tree);
            arrShp = null;
        }
        if (this.getLineForegroundRenderer() != null) {
            this.getLineForegroundRenderer().paint(f, g, viewport, tree);
            arrShp = null;
        }
        if (arrShp != null) {
            tree.insert(arrShp, f, null);
        }
    }

    private void paintFillForPrint(String strSBFillSym, int intFillSymWidth, SimpleFeature f, Graphics2D g, Viewport viewport, Geometry geom) throws NoninvertibleTransformException {
        try {
            Shape[] shapesOfGeom = new Shape[]{viewport.getJava2DConverter().toShape(geom)};
            BufferedImage fillPatternImage = this.getFillPattern4Print(strSBFillSym, intFillSymWidth, f, g);
            if (fillPatternImage != null) {
                for (Shape shape : shapesOfGeom) {
                    if (shape instanceof LinePathShape) continue;
                    List<Object> shapes2Fill = new ArrayList<Shape>();
                    if (shape instanceof GeometryCollectionShape) {
                        shapes2Fill = ((GeometryCollectionShape)shape).retrieveShapes();
                    } else {
                        shapes2Fill.add(shape);
                    }
                    for (int i = shapes2Fill.size() - 1; i >= 0; --i) {
                        if (!(shapes2Fill.get(i) instanceof LinePathShape)) continue;
                        shapes2Fill.remove(i);
                    }
                    SVGSupport.fillShapes4Print((Graphics2D)g, (Rectangle)viewport.getPanel().getBounds(), (Shape[])shapes2Fill.toArray(new Shape[0]), (BufferedImage)fillPatternImage);
                }
            }
        }
        catch (Exception e) {
            String strLayer = "unknown";
            if (this.sCol != null) {
                strLayer = this.sCol.getLayerable().getName();
            }
            log.warn(String.format("Error rendering fill 4 print. Layer: %s", strLayer), (Throwable)e);
            RenderUtil.paint(geom, g, viewport, true, this.fillStroke, this.svgFillPattern, false, null, null, false, false);
        }
    }

    private int getFillSymWidth(SimpleFeature f, Viewport viewport) {
        int intFillSymWidth = this.basicStyle.getLengthUnit() == 0 ? (int)(this.getCalcFillSymWidth(f) * viewport.getPixelScale()) : (int)(viewport.getScale() * this.getCalcFillSymWidth(f));
        return Math.min(intFillSymWidth, 500);
    }

    public String getSBFillSymName(SimpleFeature f) {
        return this.bbCache.getStringValue(BSH_FILL_SYM_KEY, this.basicStyle.getStrFillSymName(), f, "");
    }

    public double getCalcFillSymWidth(SimpleFeature f) {
        return this.bbCache.getCalcValue(BSH_FILL_SYM_WIDTH_KEY, this.basicStyle.getFillSymWidth(), f, 10.0);
    }

    private Color getFillColorForFeatureWithUserDefinedAlpha(SimpleFeature feature) {
        return this.modulateColorWithUserDefinedAlpha(this.getSBFillColor(feature));
    }

    public Color getSBFillColor(SimpleFeature f) {
        if (this.basicStyle.getFillColorWithAlpha().isBshColor()) {
            try {
                Object objColor = this.bbCache.getObjectValue(BSH_OVERWRITE_FILL_COLOR_KEY, this.basicStyle.getFillColorWithAlpha().getBsh(), f, null, true);
                Color newColor = RenderUtil.getColorByObject(objColor, null, this.getFillColorInternal());
                return this.basicStyle.isBolUseAlphaArea() ? GUIUtil.alphaColor(newColor, this.basicStyle.getIntAlpha()) : newColor;
            }
            catch (Exception e) {
                return this.getFillColorInternal();
            }
        }
        return this.getFillColorInternal();
    }

    private SVGFillPattern getFillPattern(String strSymName, int intFillSymWidth, SimpleFeature f) {
        if (this.basicStyle.getStrFillSymStore() == null || this.basicStyle.getStrFillSymStore().length() == 0) {
            return null;
        }
        if (this.basicStyle.getStrFillSymName() == null || this.basicStyle.getStrFillSymName().length() == 0) {
            return null;
        }
        SymbolStore symStore = RenderUtil.getSymbolStore(this.basicStyle.getStrFillSymStore(), this.sCol.getTask());
        if (symStore == null) {
            return null;
        }
        this.strLastFillSymName = strSymName;
        return new SVGFillPattern(symStore, strSymName, intFillSymWidth, this.getFillColorForFeatureWithUserDefinedAlpha(f), this.basicStyle.isBolFillSymColorOverwrite());
    }

    private BufferedImage getFillPattern4Print(String strSymName, int intFillSymWidth, SimpleFeature f, Graphics2D g) throws Exception {
        SymbolStore symStore;
        if (g.getRenderingHint(Viewport.KEY_IS4PRINT) == null) {
            return null;
        }
        if (this.basicStyle.getStrFillSymStore() == null || this.basicStyle.getStrFillSymStore().length() == 0) {
            return null;
        }
        if (this.basicStyle.getStrFillSymName() == null || this.basicStyle.getStrFillSymName().length() == 0) {
            return null;
        }
        Color sbFillColor = this.getFillColorForFeatureWithUserDefinedAlpha(f);
        Color opaqueFillColor = null;
        if (this.basicStyle.isBolFillSymColorOverwrite()) {
            opaqueFillColor = new Color(sbFillColor.getRGB());
        }
        if ((symStore = RenderUtil.getSymbolStore(this.basicStyle.getStrFillSymStore(), this.sCol.getTask())) == null) {
            return null;
        }
        Object[] svgNode = symStore.getSVGNode(strSymName, opaqueFillColor, opaqueFillColor, 255, true);
        if (sbFillColor != null) {
            return SVGSupport.fillShapes4PrintImg((Object[])svgNode, (int)intFillSymWidth, (int)sbFillColor.getAlpha());
        }
        return SVGSupport.fillShapes4PrintImg((Object[])svgNode, (int)intFillSymWidth);
    }

    @Override
    public Icon getLegendLabel(StyleCollection sCol) {
        if (this.basicStyle.doesRenderLine() || this.basicStyle.isRenderingFill() || this.basicStyle.isRenderingSymbol() || this.basicStyle.isRenderingText()) {
            return super.getLegendLabel(sCol);
        }
        return DefaultLegendLabelRenderer.getEmptyIcon();
    }

    @Override
    public void clearLegendLabelCache() {
        super.clearLegendLabelCache();
        if (this.getSymbolRenderer() != null) {
            this.getSymbolRenderer().clearLegendLabelCache();
        }
        if (this.getTextRenderer() != null) {
            this.getTextRenderer().clearLegendLabelCache();
        }
    }

    public BasicStyleModel getModel() {
        return this.basicStyle;
    }

    @Override
    public void setUserDefinedAlpha(int alpha) {
        super.setUserDefinedAlpha(alpha);
        if (this.getLineBaseRenderer() != null) {
            this.getLineBaseRenderer().setUserDefinedAlpha(alpha);
        }
        if (this.getLineBackgroundRenderer() != null) {
            this.getLineBackgroundRenderer().setUserDefinedAlpha(alpha);
        }
        if (this.getLineForegroundRenderer() != null) {
            this.getLineForegroundRenderer().setUserDefinedAlpha(alpha);
        }
        if (this.getSymbolRenderer() != null) {
            this.getSymbolRenderer().setUserDefinedAlpha(alpha);
        }
        if (this.getTextRenderer() != null) {
            this.getTextRenderer().setUserDefinedAlpha(alpha);
        }
    }

    public static boolean adobeReaderFix4Print_DoesGeomIntersectVisibleArea(Geometry geom, Graphics2D g, Viewport viewport) {
        if (g.getRenderingHint(Viewport.KEY_IS4PRINT) != null) {
            try {
                if (!geom.intersects(EnvelopeUtil.toGeometry(viewport.getEnvelopeInModelCoordinates()))) {
                    return false;
                }
            }
            catch (Throwable t) {
                log.debug("Error at AdobeReaderFix - Check if geometry intersects visible area");
            }
        }
        return true;
    }

    static {
        IntelligenceFactory.register(BasicStyleModel.class, BasicStyleRenderer::new);
    }
}

