/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.components.ColorPanel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.LineStyleModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class BasicStyleListCellRenderer
implements ListCellRenderer {
    protected ColorPanel colorPanel = new ColorPanel();
    private JPanel panel = new JPanel();
    protected DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setFont(label.getFont().deriveFont(10.0f));
            return label;
        }
    };
    private int alpha;
    private boolean bolUseAlphaArea;
    private boolean bolUseAlphaLine;

    public BasicStyleListCellRenderer() {
        this.panel.setLayout(new GridBagLayout());
        this.panel.add((Component)this.colorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.alpha = 255;
        this.bolUseAlphaArea = true;
        this.bolUseAlphaLine = true;
    }

    public void setColorPanelSize(Dimension d) {
        this.colorPanel.setMinimumSize(d);
        this.colorPanel.setMaximumSize(d);
        this.colorPanel.setPreferredSize(d);
    }

    public void setAlpha(int alpha, boolean bolArea, boolean bolLine) {
        this.alpha = alpha;
        this.bolUseAlphaArea = bolArea;
        this.bolUseAlphaLine = bolLine;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof String) {
            return this.defaultListCellRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
        BasicStyleModel basicStyle = (BasicStyleModel)value;
        boolean foregroundActive = false;
        if (basicStyle.getLineForeground() != null) {
            foregroundActive = true;
            LineStyleModel lineForegroundStyle = basicStyle.getLineForeground();
            this.colorPanel.setLineForegroundWidth(1);
            this.colorPanel.setLineForegroundColor(GUIUtil.alphaColor(lineForegroundStyle.getLineColor(), this.bolUseAlphaLine ? this.alpha : 255));
        } else {
            this.colorPanel.setLineForegroundColor(null);
        }
        if (basicStyle.getLineBase() != null) {
            LineStyleModel lineBaseStyle = basicStyle.getLineBase();
            if (foregroundActive) {
                this.colorPanel.setLineBaseWidth(3);
            } else if (basicStyle.getLengthUnit() == 0) {
                this.colorPanel.setLineBaseWidth((int)Math.min(3.0f, lineBaseStyle.getLineWidthFloat()));
            } else {
                this.colorPanel.setLineBaseWidth(1);
            }
            this.colorPanel.setLineBaseColor(GUIUtil.alphaColor(lineBaseStyle.getLineColor(), this.bolUseAlphaLine ? this.alpha : 255));
        } else {
            this.colorPanel.setLineBaseColor(null);
            this.colorPanel.setLineBaseWidth(1);
        }
        if (basicStyle.getLineBackground() != null) {
            LineStyleModel lineBackgroundStyle = basicStyle.getLineBackground();
            this.colorPanel.setLineBackgroundWidth(this.colorPanel.getLineBaseWidth() + 2);
            this.colorPanel.setLineBackgroundColor(GUIUtil.alphaColor(lineBackgroundStyle.getLineColor(), this.bolUseAlphaLine ? this.alpha : 255));
        } else {
            this.colorPanel.setLineBackgroundColor(null);
        }
        this.colorPanel.setFillColor(basicStyle instanceof BasicStyleModel && basicStyle.isRenderingFill() ? GUIUtil.alphaColor(basicStyle.getFillColor(), this.bolUseAlphaArea ? this.alpha : 255) : (isSelected ? list.getSelectionBackground() : list.getBackground()));
        if (isSelected) {
            this.colorPanel.setForeground(list.getSelectionForeground());
            this.colorPanel.setBackground(list.getSelectionBackground());
            this.panel.setForeground(list.getSelectionForeground());
            this.panel.setBackground(list.getSelectionBackground());
        } else {
            this.colorPanel.setForeground(list.getForeground());
            this.colorPanel.setBackground(list.getBackground());
            this.panel.setForeground(list.getForeground());
            this.panel.setBackground(list.getBackground());
        }
        return this.panel;
    }
}

