/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.renderer.style.DefaultLegendLabelRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LegendLabelRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.UserDefinedTransparencyRenderer;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.intelligence.JumpModelIntelligence;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.Color;
import javax.swing.Icon;
import org.locationtech.jts.util.Assert;

public abstract class AbstractStyleRenderer<T extends JumpModel>
implements LegendLabelRenderer,
UserDefinedTransparencyRenderer,
JumpModelIntelligence<T> {
    private transient Icon imgLegend = null;
    private static final DefaultLegendLabelRenderer llRender = new DefaultLegendLabelRenderer();
    private int userDefinedAlpha = 255;

    @Override
    public boolean needsRendering() {
        return true;
    }

    @Override
    public Icon getLegendLabel(StyleCollection sCol) {
        if (this.imgLegend == null) {
            this.imgLegend = llRender.getImage(sCol, (StyleModel)this.getModel());
        }
        return this.imgLegend;
    }

    @Override
    public void clearLegendLabelCache() {
        this.imgLegend = null;
    }

    public AbstractStyleRenderer clone() throws CloneNotSupportedException {
        try {
            return (AbstractStyleRenderer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    @Override
    public void setUserDefinedAlpha(int alpha) {
        this.userDefinedAlpha = alpha;
    }

    @Override
    public int getUserDefinedAlpha() {
        return this.userDefinedAlpha;
    }

    @Override
    public void resetUserDefinedAlpha() {
        this.setUserDefinedAlpha(255);
    }

    @Override
    public boolean canUserAdjustAlpha() {
        return true;
    }

    protected Color modulateColorWithUserDefinedAlpha(Color source) {
        return new Color(source.getRed(), source.getGreen(), source.getBlue(), source.getAlpha() * this.getUserDefinedAlpha() / 255);
    }

    protected ColorModel modulateColorWithUserDefinedAlpha(ColorModel source) {
        return new ColorModel(source.getRed(), source.getGreen(), source.getBlue(), source.getAlpha() * this.getUserDefinedAlpha() / 255);
    }
}

