/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.AbstractCadLayer;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.DimRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.LineRendererProxyOnlyLines;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.SymbolRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.TextRenderer;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.style.AbstractCadStyleModel;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorModel;
import de.riwagis.riwajump.model.style.DimStyleModel;
import de.riwagis.riwajump.model.style.SymbolStyleModel;
import de.riwagis.riwajump.model.style.TextStyleModel;
import de.riwagis.util.gui.FontSupport;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;

public abstract class AbstractCadRenderer
extends AbstractStyleRenderer {
    public static final String NO_LAYER = I18N.get("ui.renderer.style.CadStyle.no-layer");
    private static final int ALPHA_OPAQUE = 255;
    private static final String BUILTIN_STORE = "_buildIn";
    protected StyleCollection sCol = null;
    protected GeometryFactory gfac = new GeometryFactory();
    protected BasicStyleModel bStyle = null;
    protected DimStyleModel dimStyle = null;
    protected SymbolStyleModel symStyle = null;
    protected TextStyleModel txtStyle = null;
    private boolean bolInteralStylesOK = false;
    private transient Map<Object, Color> colorCache = null;
    private final AbstractCadStyleModel cadStyleModel;

    protected AbstractCadRenderer(AbstractCadStyleModel cadStyleModel) {
        this.cadStyleModel = cadStyleModel;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        String propertyName = modelEvent.getPropertyName();
        if (propertyName.equalsIgnoreCase("strSymStore") || propertyName.equalsIgnoreCase("intUnitLength") || propertyName.equalsIgnoreCase("intUnitOri")) {
            this.bolInteralStylesOK = false;
        }
        this.clearLegendLabelCache();
    }

    public AbstractCadStyleModel getModel() {
        return this.cadStyleModel;
    }

    @Override
    public boolean needsRendering() {
        return true;
    }

    protected void initInternalStyles() {
        this.bStyle = new BasicStyleModel();
        this.bStyle.setEnabled(true);
        this.bStyle.setBolFillSymColorOverwrite(true);
        this.bStyle.setStrFillSymName(this.castToStringBSH(CadFeatureAtts.FILL));
        if (this.cadStyleModel.getStrSymStore() == null || this.cadStyleModel.getStrSymStore().length() == 0) {
            this.bStyle.setStrFillSymStore(BUILTIN_STORE);
        } else {
            this.bStyle.setStrFillSymStore(this.cadStyleModel.getStrSymStore());
        }
        this.bStyle.setFillSymWidth(this.castToNumberBSH(CadFeatureAtts.FILLWIDTH));
        this.bStyle.setLengthUnit(this.cadStyleModel.getIntUnitLength());
        this.bStyle.setOriUnit(this.cadStyleModel.getIntUnitOri());
        this.bStyle.getLineBase().setLinePattern(this.castToStringBSH(CadFeatureAtts.LINEPATTERN));
        this.bStyle.getLineBase().setLineWidth(this.castToNumberBSH(CadFeatureAtts.LINEWIDTH));
        this.bStyle.setIntAlpha(255, true, false, false, false);
        this.txtStyle = new TextStyleModel();
        this.txtStyle.setStrText(this.castToStringBSH(CadFeatureAtts.TEXT));
        this.txtStyle.setIntUnitOrient(this.cadStyleModel.getIntUnitOri());
        this.txtStyle.setIntUnitLengthText(this.cadStyleModel.getIntUnitLength());
        this.txtStyle.setIntUnitLength(this.cadStyleModel.getIntUnitLength());
        this.txtStyle.setStrHeight(this.castToNumberBSH(CadFeatureAtts.TEXTSIZE));
        this.txtStyle.setStrOrient(this.castToNumberBSH(CadFeatureAtts.TEXTORI));
        this.txtStyle.setAlignPoint(String.valueOf(7));
        this.txtStyle.setAlignLine(String.valueOf(7));
        this.txtStyle.setAlignArea(String.valueOf(7));
        this.bStyle.setTextStyle(this.txtStyle);
        this.symStyle = new SymbolStyleModel();
        this.symStyle.setStrPtSymbol("((str(\"" + String.valueOf((Object)CadFeatureAtts.SYMBOL) + "\").toLowerCase().endsWith(\".svg\") || str(\"" + String.valueOf((Object)CadFeatureAtts.SYMBOL) + "\").toLowerCase().endsWith(\".png\"))?str(\"" + String.valueOf((Object)CadFeatureAtts.SYMBOL) + "\"):str(\"" + String.valueOf((Object)CadFeatureAtts.SYMBOL) + "\") + \".svg\")");
        this.symStyle.setIntUnitAngle(this.cadStyleModel.getIntUnitOri());
        this.symStyle.setIntUnitSizeSymbol(this.cadStyleModel.getIntUnitLength());
        this.symStyle.setIntUnitSize(this.cadStyleModel.getIntUnitLength());
        this.symStyle.setBolOverwriteAreaColor(false);
        this.symStyle.setBolOverwriteLineColor(false);
        if (this.cadStyleModel.getStrSymStore() == null || this.cadStyleModel.getStrSymStore().length() == 0) {
            this.symStyle.setStrStorename(BUILTIN_STORE);
        } else {
            this.symStyle.setStrStorename(this.cadStyleModel.getStrSymStore());
        }
        this.symStyle.setStrPtOri(this.castToNumberBSH(CadFeatureAtts.SYMORI));
        this.symStyle.setStrPtHeight(this.castToNumberBSH(CadFeatureAtts.SYMSIZE));
        this.symStyle.setStrPtWidth(this.castToNumberBSH(CadFeatureAtts.SYMSIZE));
        this.symStyle.setBolPtRatio(true);
        this.bStyle.setSymStyle(this.symStyle);
        this.dimStyle = new DimStyleModel();
        this.dimStyle.setLengthUnit(this.cadStyleModel.getIntUnitLength());
        this.dimStyle.setOriUnit(this.cadStyleModel.getIntUnitOri());
    }

    protected String castToStringBSH(CadFeatureAtts property) {
        return "str(\"" + String.valueOf((Object)property) + "\")";
    }

    protected String castToNumberBSH(CadFeatureAtts property) {
        return "num(\"" + String.valueOf((Object)property) + "\")";
    }

    public void setFeature(SimpleFeature f) {
        Geometry geom = (Geometry)f.getDefaultGeometry();
        if (geom == null) {
            return;
        }
        if (FeatureUtil.getBooleanAttribute((SimpleFeature)f, (String)CadFeatureAtts.ISDIM.getName())) {
            this.setFeature4DimStyle(f);
        } else if (geom instanceof Point || geom instanceof MultiPoint) {
            String text = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.TEXT.getName()), "");
            if (text.length() > 0) {
                this.setFeature4TextStyle(f);
            } else {
                this.setFeature4SymbolStyle(f);
            }
        } else {
            this.setFeature4BasicStyle(f);
        }
    }

    protected void setFeature4TextStyle(SimpleFeature f) {
        String fontAndStyle = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.TEXTFONT.getName()), "");
        String[] splittedFontAndStyles = fontAndStyle.split("\\|");
        if (fontAndStyle.isEmpty() || !FontSupport.isFontAvailable((String)splittedFontAndStyles[0])) {
            this.txtStyle.setFontText(TextRenderer.retrieveFontModel(AbstractCadLayer.DEFAULT_FONT));
        } else {
            try {
                int fontStyle = this.getFontStyle(splittedFontAndStyles);
                this.txtStyle.setFontText(TextRenderer.retrieveFontModel(new Font(splittedFontAndStyles[0], fontStyle, 12)));
            }
            catch (Exception e) {
                this.txtStyle.setFontText(TextRenderer.retrieveFontModel(AbstractCadLayer.DEFAULT_FONT));
            }
        }
        this.txtStyle.setColorText(RiwaJumpModelUtilities.colorModelByColor(RenderUtil.getColorByFeature(f, CadFeatureAtts.TEXTCOLOR.getName(), this.colorCache)));
        this.bStyle.setRenderingText(true);
        this.bStyle.setRenderingSymbol(false);
    }

    private int getFontStyle(String[] splittedFontAndStyles) {
        if (splittedFontAndStyles.length <= 1) {
            return 0;
        }
        int combinedStyle = 0;
        for (String style : splittedFontAndStyles) {
            if (style.equalsIgnoreCase("bold")) {
                combinedStyle |= 1;
                continue;
            }
            if (!style.equalsIgnoreCase("italic")) continue;
            combinedStyle |= 2;
        }
        return combinedStyle;
    }

    protected void setFeature4SymbolStyle(SimpleFeature f) {
        this.symStyle.setFillColor(RiwaJumpModelUtilities.colorModelByColor(RenderUtil.getColorByFeature(f, CadFeatureAtts.SYMFILLCOLOR.getName(), this.colorCache)));
        Object objUseSymFillColor = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.USE_SYMFILLCOLOR.getName());
        this.symStyle.setBolOverwriteAreaColor(objUseSymFillColor != null && objUseSymFillColor.toString().length() != 0);
        this.symStyle.setLineColor(RiwaJumpModelUtilities.colorModelByColor(RenderUtil.getColorByFeature(f, CadFeatureAtts.SYMLINECOLOR.getName(), this.colorCache)));
        Object objUseSymLineColor = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.USE_SYMLINECOLOR.getName());
        this.symStyle.setBolOverwriteLineColor(objUseSymLineColor != null && objUseSymLineColor.toString().length() != 0);
        this.bStyle.setRenderingText(false);
        this.bStyle.setRenderingSymbol(true);
    }

    protected void setFeature4BasicStyle(SimpleFeature f) {
        this.bStyle.setIntAlpha(this.getAlphaFromFeatureOrDefault(f));
        this.bStyle.setFillColor(RiwaJumpModelUtilities.colorModelByColor(RenderUtil.getColorByFeature(f, CadFeatureAtts.FILLCOLOR.getName(), this.colorCache)));
        this.bStyle.setRenderingFill(FeatureUtil.getBooleanAttribute((SimpleFeature)f, (String)CadFeatureAtts.RENDERFILL.getName()));
        Object objFillPattern = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.FILL.getName());
        this.bStyle.setRenderingFillPattern(objFillPattern != null && objFillPattern.toString().length() != 0);
        this.bStyle.getLineBase().setLineColor(RiwaJumpModelUtilities.colorModelByColor(RenderUtil.getColorByFeature(f, CadFeatureAtts.LINECOLOR.getName(), this.colorCache)));
        Object objLinePattern = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LINEPATTERN.getName());
        this.bStyle.getLineBase().setRenderingLinePattern(objLinePattern != null && objLinePattern.toString().length() != 0);
        this.bStyle.setRenderingText(false);
        this.bStyle.setRenderingSymbol(false);
    }

    private int getAlphaFromFeatureOrDefault(SimpleFeature f) {
        Object objAlpha = FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.ALPHA.getName());
        if (objAlpha == null) {
            return 255;
        }
        return ((Number)objAlpha).intValue();
    }

    protected void setFeature4DimStyle(SimpleFeature f) {
        ColorModel colorDim = RiwaJumpModelUtilities.colorModelByColor(RenderUtil.getColorByFeature(f, CadFeatureAtts.LINECOLOR.getName(), this.colorCache));
        this.dimStyle.setColorDimText(colorDim);
        this.dimStyle.setColorRefLine(colorDim);
        this.dimStyle.setColorDimLine(colorDim);
        Number txtHeight = (Number)FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.TEXTSIZE.getName());
        if (txtHeight == null) {
            txtHeight = Float.valueOf(10.0f);
        }
        this.dimStyle.setFltDimTextHeight((float)((double)txtHeight.floatValue() * 1.2));
        this.dimStyle.setFltRefLineOverDim(txtHeight.floatValue() / 2.0f);
        float dimLineWidth = 1.0f;
        Number lineWidth = (Number)FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.LINEWIDTH.getName());
        if (lineWidth != null) {
            dimLineWidth = lineWidth.floatValue();
        }
        this.dimStyle.setFltRefLineWidth(dimLineWidth / 2.0f);
        this.dimStyle.setFltDimLineWidth(dimLineWidth);
        this.dimStyle.setFltSymbolSize(txtHeight.floatValue());
    }

    public BasicStyleModel getInternalBasicStyle() {
        return this.bStyle;
    }

    private DimRenderer getDimRenderer() {
        if (this.dimStyle == null) {
            this.initializeStyles();
        }
        return (DimRenderer)this.dimStyle.getIntelligence();
    }

    private TextRenderer getTextRenderer() {
        if (this.txtStyle == null) {
            this.initializeStyles();
        }
        return (TextRenderer)this.txtStyle.getIntelligence();
    }

    private SymbolRenderer getSymRenderer() {
        if (this.symStyle == null) {
            this.initializeStyles();
        }
        return (SymbolRenderer)this.symStyle.getIntelligence();
    }

    private BasicStyleRenderer getBasicStyleRenderer() {
        if (this.bStyle == null) {
            this.initializeStyles();
        }
        return (BasicStyleRenderer)this.bStyle.getIntelligence();
    }

    private void initializeStyles() {
        if (!this.bolInteralStylesOK) {
            this.initInternalStyles();
            this.bolInteralStylesOK = true;
        }
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        Geometry geom = (Geometry)f.getDefaultGeometry();
        if (geom == null) {
            return;
        }
        if (FeatureUtil.getBooleanAttribute((SimpleFeature)f, (String)CadFeatureAtts.ISDIM.getName())) {
            this.setFeature4DimStyle(f);
            this.getDimRenderer().paint(f, g, viewport, tree);
        } else if (geom instanceof GeometryCollection) {
            this.renderPointsAndText(f, g, viewport, tree);
            this.renderEverythingElse(f, g, viewport, tree, geom);
        } else if (geom instanceof Point) {
            this.renderPointsAndText(f, g, viewport, tree);
        } else {
            this.renderEverythingElse(f, g, viewport, tree, geom);
        }
    }

    public void renderEverythingElse(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree, Geometry geom) throws Exception {
        this.setFeature4BasicStyle(f);
        this.getBasicStyleRenderer().paint(f, g, viewport, tree);
        if (LineRendererProxyOnlyLines.isGeometryForRenderer(geom)) {
            this.getBasicStyleRenderer().getLineBaseRenderer().paint(f, g, viewport, tree);
        }
    }

    public void renderPointsAndText(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        String text = Objects.toString(FeatureUtil.getAttribute((SimpleFeature)f, (String)CadFeatureAtts.TEXT.getName()), "");
        if (text.length() > 0) {
            this.setFeature4TextStyle(f);
            this.getTextRenderer().paint(f, g, viewport, tree);
        } else {
            this.setFeature4SymbolStyle(f);
            this.getSymRenderer().paint(f, g, viewport, tree);
        }
    }

    @Override
    public void initialize(StyleCollection sCol) {
        this.sCol = sCol;
        this.colorCache = new HashMap<Object, Color>();
        this.getBasicStyleRenderer().initialize(this.sCol);
        this.getTextRenderer().initialize(this.sCol);
        this.getSymRenderer().initialize(this.sCol);
        this.getDimRenderer().initialize(this.sCol);
    }

    @Override
    public boolean isEnabled() {
        return this.cadStyleModel.isEnabled();
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return Collections.emptyList();
    }

    @Override
    public void setUserDefinedAlpha(int alpha) {
        super.setUserDefinedAlpha(alpha);
        this.getBasicStyleRenderer().setUserDefinedAlpha(alpha);
        this.getTextRenderer().setUserDefinedAlpha(alpha);
        this.getSymRenderer().setUserDefinedAlpha(alpha);
        this.getDimRenderer().setUserDefinedAlpha(alpha);
    }
}

