/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.java2D;

import com.vividsolutions.jump.workbench.ui.renderer.java2D.ShapeCollectionPathIterator;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Coordinate;

public class PolygonShape
implements Shape {
    private final Polygon shell;
    private final ArrayList holes = new ArrayList();

    public PolygonShape(Coordinate[] shellVertices, Collection holeVerticesCollection) {
        this.shell = PolygonShape.toPolygon(shellVertices);
        for (Coordinate[] holeVertices : holeVerticesCollection) {
            this.holes.add(PolygonShape.toPolygon(holeVertices));
        }
    }

    private static Polygon toPolygon(Coordinate[] coordinates) {
        Polygon polygon = new Polygon();
        for (Coordinate coordinate : coordinates) {
            polygon.addPoint((int)coordinate.x, (int)coordinate.y);
        }
        return polygon;
    }

    @Override
    public Rectangle getBounds() {
        return this.shell.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.shell.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public boolean contains(Point2D p) {
        if (this.shell.contains(p)) {
            for (Polygon h : this.holes) {
                if (!h.contains(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        if (this.shell.intersects(r)) {
            for (Polygon h : this.holes) {
                if (!h.contains(r)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public boolean contains(Rectangle2D r) {
        if (this.shell.contains(r)) {
            for (Polygon h : this.holes) {
                if (!h.intersects(r)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        ArrayList<Polygon> rings = new ArrayList<Polygon>();
        rings.add(this.shell);
        rings.addAll(this.holes);
        return new ShapeCollectionPathIterator(rings, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

