/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.java2D;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LinePathShape
implements Shape {
    private static final int INIT_SIZE = 20;
    private final Path2D.Float internalPath = new Path2D.Float(1, 20);

    public void moveTo(double x, double y) {
        this.internalPath.moveTo(x, y);
    }

    public void moveTo(float x, float y) {
        this.internalPath.moveTo(x, y);
    }

    public void lineTo(double x, double y) {
        this.internalPath.lineTo(x, y);
    }

    public void lineTo(float x, float y) {
        this.internalPath.lineTo(x, y);
    }

    @Override
    public Rectangle getBounds() {
        return this.internalPath.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.internalPath.getBounds2D();
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        if (!this.internalPath.getBounds2D().intersects(r)) {
            return false;
        }
        PathIterator pi = this.internalPath.getPathIterator(null);
        float[] arrcoord = new float[6];
        float[] lastPoint = new float[2];
        while (!pi.isDone()) {
            int type = pi.currentSegment(arrcoord);
            switch (type) {
                case 0: {
                    lastPoint[0] = arrcoord[0];
                    lastPoint[1] = arrcoord[1];
                    break;
                }
                case 1: {
                    Line2D.Float l = new Line2D.Float(lastPoint[0], lastPoint[1], arrcoord[0], arrcoord[1]);
                    if (l.intersects(r)) {
                        return true;
                    }
                    lastPoint[0] = arrcoord[0];
                    lastPoint[1] = arrcoord[1];
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid type in PathIterator. Should never reach here");
                }
            }
            pi.next();
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.internalPath.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.internalPath.getPathIterator(at, flatness);
    }
}

