/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.java2D;

import com.vividsolutions.jump.workbench.ui.renderer.java2D.GeometryCollectionShape;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.LinePathShape;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.PolygonShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class Java2DConverter {
    private static final GeometryFactory gfac = new GeometryFactory();
    private static final double DEFAULT_POINT_MARKER_SIZE = 8.0;
    private final PointConverter pointConverter;
    private final boolean adobeReaderBugfix;

    public Java2DConverter(PointConverter pointConverter, boolean adobeReaderBugfix) {
        this.pointConverter = pointConverter;
        this.adobeReaderBugfix = adobeReaderBugfix;
    }

    private Shape toShape(Polygon p) throws NoninvertibleTransformException {
        ArrayList<Coordinate[]> holeVertexCollection = new ArrayList<Coordinate[]>();
        for (int j = 0; j < p.getNumInteriorRing(); ++j) {
            holeVertexCollection.add(this.toViewCoordinates(p.getInteriorRingN(j).getCoordinates()));
        }
        return new PolygonShape(this.toViewCoordinates(p.getExteriorRing().getCoordinates()), holeVertexCollection);
    }

    private Coordinate[] toViewCoordinates(Coordinate[] modelCoordinates) throws NoninvertibleTransformException {
        Coordinate[] viewCoordinates = new Coordinate[modelCoordinates.length];
        for (int i = 0; i < modelCoordinates.length; ++i) {
            Point2D point2D = this.toViewPoint(modelCoordinates[i]);
            viewCoordinates[i] = new Coordinate(point2D.getX(), point2D.getY());
        }
        return viewCoordinates;
    }

    private Shape toShape(GeometryCollection gc) throws NoninvertibleTransformException {
        GeometryCollectionShape shape = new GeometryCollectionShape();
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            shape.add(this.toShape(g));
        }
        return shape;
    }

    private void toShape(MultiLineString mls, LinePathShape path) throws NoninvertibleTransformException {
        for (int i = 0; i < mls.getNumGeometries(); ++i) {
            LineString lineString = (LineString)mls.getGeometryN(i);
            this.toShape(lineString, path);
        }
    }

    private void toShape(LineString lineString, LinePathShape shape) throws NoninvertibleTransformException {
        Geometry geom = this.bugFixAdobeReader(lineString);
        if (geom instanceof LineString) {
            lineString = (LineString)geom;
        } else if (geom instanceof MultiLineString) {
            this.toShape((MultiLineString)geom, shape);
            return;
        }
        if (lineString == null) {
            return;
        }
        Point2D viewPoint = this.toViewPoint(lineString.getCoordinateN(0));
        shape.moveTo((float)viewPoint.getX(), (float)viewPoint.getY());
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            viewPoint = this.toViewPoint(lineString.getCoordinateN(i));
            shape.lineTo((float)viewPoint.getX(), (float)viewPoint.getY());
        }
    }

    private Geometry bugFixAdobeReader(LineString line) {
        if (this.adobeReaderBugfix) {
            Envelope env = this.pointConverter.getEnvelopeInModelCoordinates();
            env.expandBy(env.getWidth() * 0.2);
            Geometry geom = gfac.toGeometry(env);
            if (geom.contains((Geometry)line)) {
                return line;
            }
            if (geom.intersects((Geometry)line)) {
                return geom.intersection((Geometry)line);
            }
            return null;
        }
        return line;
    }

    private Shape toShape(Point point, double dblPointMarkerSize) throws NoninvertibleTransformException {
        Rectangle2D.Double pointMarker = new Rectangle2D.Double(0.0, 0.0, dblPointMarkerSize, dblPointMarkerSize);
        Point2D viewPoint = this.toViewPoint(point.getCoordinate());
        pointMarker.x = viewPoint.getX() - dblPointMarkerSize / 2.0;
        pointMarker.y = viewPoint.getY() - dblPointMarkerSize / 2.0;
        return pointMarker;
    }

    private Point2D toViewPoint(Coordinate modelCoordinate) throws NoninvertibleTransformException {
        Point2D viewPoint = this.pointConverter.toViewPoint(modelCoordinate);
        viewPoint.setLocation(Math.round(viewPoint.getX()), Math.round(viewPoint.getY()));
        if (viewPoint.getX() == Double.NaN || viewPoint.getY() == Double.NaN) {
            Assert.shouldNeverReachHere((String)"NaN in Java2DConverter - toViewPoint.");
        }
        return viewPoint;
    }

    public Shape toShape(Geometry geometry) throws NoninvertibleTransformException {
        return this.toShape(geometry, 8.0);
    }

    public Shape toShape(Geometry geometry, double dblPointMarkerSize) throws NoninvertibleTransformException {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.toShape((GeometryCollection)((MultiPolygon)geometry));
        }
        if (geometry instanceof LineString) {
            LinePathShape path = new LinePathShape();
            this.toShape((LineString)geometry, path);
            return path;
        }
        if (geometry instanceof MultiLineString) {
            LinePathShape path = new LinePathShape();
            this.toShape((MultiLineString)geometry, path);
            return path;
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry, dblPointMarkerSize);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + String.valueOf(geometry.getClass()));
    }

    public static interface PointConverter {
        public Point2D toViewPoint(Coordinate var1) throws NoninvertibleTransformException;

        public Envelope getEnvelopeInModelCoordinates();
    }
}

