/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.java2D;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.ShapeCollectionPathIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class GeometryCollectionShape
implements Shape {
    private final List<Shape> shapes = new ArrayList<Shape>();

    public void add(Shape shape) {
        this.shapes.add(shape);
    }

    public List<Shape> retrieveShapes() {
        ArrayList<Shape> shapes2return = new ArrayList<Shape>();
        this.retrieveShapes(shapes2return);
        return shapes2return;
    }

    private void retrieveShapes(List<Shape> shapes2fill) {
        for (Shape shp : this.shapes) {
            if (shp instanceof GeometryCollectionShape) {
                ((GeometryCollectionShape)shp).retrieveShapes(shapes2fill);
                continue;
            }
            shapes2fill.add(shp);
        }
    }

    @Override
    public Rectangle getBounds() {
        throw new UnsupportedOperationException(I18N.get("ui.renderer.GeometryCollectionShape.method-getBounds-not-yet-implemented"));
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D rectangle = null;
        for (Shape shape : this.shapes) {
            if (rectangle == null) {
                rectangle = shape.getBounds2D();
                continue;
            }
            rectangle.add(shape.getBounds2D());
        }
        return rectangle;
    }

    @Override
    public boolean contains(double x, double y) {
        for (Shape shp : this.shapes) {
            if (!shp.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        for (Shape shp : this.shapes) {
            if (!shp.contains(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        for (Shape shp : this.shapes) {
            if (!shp.intersects(x, y, w, h)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        for (Shape shp : this.shapes) {
            if (!shp.intersects(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        for (Shape shp : this.shapes) {
            if (!shp.contains(x, y, w, h)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        for (Shape shp : this.shapes) {
            if (!shp.contains(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new ShapeCollectionPathIterator(this.shapes, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

