/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.WMTSLayer;
import com.vividsolutions.jump.workbench.ui.plugin.wmts.WMTSStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.ows.wmts.Layer;
import com.vividsolutions.ows.wmts.TileMatrix;
import com.vividsolutions.ows.wmts.TileMatrixLimits;
import com.vividsolutions.ows.wmts.TileMatrixSet;
import com.vividsolutions.ows.wmts.WMTService;
import de.riwagis.crs.Transformer;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.jai.PlanarImage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.coverage.Coverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSLayerRenderer
extends ImageCachingRenderer {
    private static final double DEFAULT_TILESET_THRESHOLD = 0.5;
    private static final Logger LOG = LoggerFactory.getLogger(WMTSLayerRenderer.class);
    private static final int TILE_READ_RENDER_TIMEOUT = 5000;
    private static final boolean DRAW_DEBUG_INFOS = false;

    public WMTSLayerRenderer(WMTSLayer layer, LayerView panel) {
        super(layer, panel);
    }

    @Override
    public ThreadSafeImage getImage() {
        if (!this.getLayer().isVisibleOnScreen()) {
            return null;
        }
        return super.getImage();
    }

    @Override
    public Runnable createRunnable() {
        if (!LayerRenderer.render(this.getLayer())) {
            this.clearImageCache();
            return null;
        }
        return super.createRunnable();
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        if (!LayerRenderer.render(this.getLayer())) {
            return;
        }
        super.copyTo(graphics);
    }

    private WMTSLayer getLayer() {
        return (WMTSLayer)this.getContentID();
    }

    @Override
    protected void renderHook(ThreadSafeImage image, CancelableRunnable runnable) throws Exception {
        TileRenderFunction renderFunction;
        ReferencedEnvelope requestedTilesBounds;
        TileMatrixLimits limits;
        Envelope sourceBounds;
        if (!this.getLayer().isVisibleOnScreen()) {
            return;
        }
        WMTSStyleModel style = this.getLayer().getValidWMTSStyle();
        if (style == null) {
            return;
        }
        if (runnable.isCanceled()) {
            return;
        }
        Envelope viewportBBox = this.getPanel().getViewport().getEnvelopeInModelCoordinates();
        Task task = this.getPanel().getLayerManager().getTask();
        double scale = task.getScale();
        TileMatrixSet tms = this.getLayer().getTileMatrixSet();
        if (tms == null) {
            throw new IllegalArgumentException(String.format("Tile Matrix Set %s not found in Capabilities", style.getTileMatrixSet()));
        }
        TileMatrix tm = WMTSLayerRenderer.findBestMatchingTileMatrix(tms, scale, style.getTileSetThreshold());
        if (tm == null) {
            return;
        }
        WMTService wmts = this.getLayer().getService();
        Layer layer = wmts.getCapabilities().getLayerByName(style.getLayerName());
        CoordinateReferenceSystem targetCRS = task.getCRSDefinition().getCRS();
        CoordinateReferenceSystem sourceCRS = tms.getCoordinateReferenceSystem();
        boolean needsTransform = targetCRS != null && sourceCRS != null && !CRS.equalsIgnoreMetadata((Object)targetCRS, (Object)sourceCRS);
        Transformer transformer = null;
        if (needsTransform) {
            transformer = new Transformer(targetCRS, sourceCRS);
            transformer.transform2d(viewportBBox);
        }
        if ((sourceBounds = tms.getBounds()) == null) {
            if (transformer != null) {
                sourceBounds = new Envelope(this.getLayer().getEnvelope());
                transformer.transform2d(sourceBounds);
            } else {
                sourceBounds = this.getLayer().getEnvelope();
            }
        }
        double tileSpanX = tm.computeTileSpanX();
        double tileSpanY = tm.computeTileSpanY();
        if (sourceBounds.isNull() && StringUtils.isNotBlank((CharSequence)tm.getTopLeftCorner())) {
            double[] coords = tm.getTopLeft();
            double minX = coords[0];
            double maxY = coords[1];
            double maxX = minX + (double)tm.getMatrixWidth() * tileSpanX;
            double minY = maxY - (double)tm.getMatrixHeight() * tileSpanY;
            sourceBounds = new ReferencedEnvelope(minX, maxX, minY, maxY, sourceCRS);
        }
        if (!viewportBBox.intersects(sourceBounds)) {
            return;
        }
        int minCol = 0;
        int minRow = 0;
        int maxCol = tm.getMatrixWidth() - 1;
        int maxRow = tm.getMatrixHeight() - 1;
        double x = sourceBounds.getMinX();
        double y = sourceBounds.getMaxY();
        if (StringUtils.isNotEmpty((CharSequence)tm.getTopLeftCorner())) {
            double[] coords = tm.getTopLeft();
            x = coords[0];
            y = coords[1];
        }
        if ((limits = layer.getTileMatrixSetLimits(tms.getIdentifier(), tm.getIdentifier())) != null) {
            minCol = limits.getMinTileCol();
            minRow = limits.getMinTileRow();
            maxCol = limits.getMaxTileCol();
            maxRow = limits.getMaxTileRow();
        } else {
            Envelope tmsBounds = tms.getBounds();
            if (tmsBounds != null) {
                viewportBBox = viewportBBox.intersection(tmsBounds);
            }
        }
        double tileMatrixMinX = x;
        double tileMatrixMaxY = y;
        double epsilon = 1.0E-6;
        int tileMinCol = MathUtil.clamp((int)Math.floor((viewportBBox.getMinX() - tileMatrixMinX) / tileSpanX + 1.0E-6), minCol, maxCol);
        int tileMaxCol = MathUtil.clamp((int)Math.floor((viewportBBox.getMaxX() - tileMatrixMinX) / tileSpanX - 1.0E-6), minCol, maxCol);
        int tileMinRow = MathUtil.clamp((int)Math.floor((tileMatrixMaxY - viewportBBox.getMaxY()) / tileSpanY + 1.0E-6), minRow, maxRow);
        int tileMaxRow = MathUtil.clamp((int)Math.floor((tileMatrixMaxY - viewportBBox.getMinY()) / tileSpanY - 1.0E-6), minRow, maxRow);
        BakingImage bakingImage = new BakingImage();
        if (needsTransform) {
            requestedTilesBounds = new ReferencedEnvelope(sourceCRS);
            renderFunction = (tileImage, bounds, row, col) -> this.renderToBakingImage(tm, tileMinCol, tileMaxCol, tileMinRow, tileMaxRow, bakingImage, row, col, tileImage, bounds, (Envelope)requestedTilesBounds);
        } else {
            requestedTilesBounds = null;
            renderFunction = (tileImage, bounds, row, col) -> this.renderImage(image, tileImage, bounds);
        }
        this.doParallelTileRetrievalAndRendering(runnable, style, viewportBBox, tm, layer, renderFunction, tileSpanX, tileSpanY, tileMatrixMinX, tileMatrixMaxY, tileMinCol, tileMaxCol, tileMinRow, tileMaxRow);
        if (needsTransform && !runnable.isCanceled()) {
            this.transformAndRenderBakingImage(image, targetCRS, bakingImage, requestedTilesBounds);
        }
    }

    private void transformAndRenderBakingImage(ThreadSafeImage image, CoordinateReferenceSystem targetCRS, BakingImage bakingImage, ReferencedEnvelope requestedTilesBounds) throws Exception {
        if (requestedTilesBounds.isEmpty() || bakingImage.getImage() == null) {
            return;
        }
        GridCoverageFactory fac = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D travoCoverage = fac.create((CharSequence)"WMTS", (RenderedImage)bakingImage.getImage(), (org.opengis.geometry.Envelope)requestedTilesBounds);
        GridCoverage2D coverageSourceCRS = (GridCoverage2D)Operations.DEFAULT.resample((Coverage)travoCoverage, targetCRS);
        ReferencedEnvelope bbox = new ReferencedEnvelope(coverageSourceCRS.getEnvelope());
        BufferedImage bImgTrans = ((PlanarImage)coverageSourceCRS.getRenderedImage()).getAsBufferedImage();
        this.renderImage(image, bImgTrans, (Envelope)bbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doParallelTileRetrievalAndRendering(CancelableRunnable runnable, WMTSStyleModel style, Envelope viewportBBox, TileMatrix tm, Layer layer, TileRenderFunction renderFunction, double tileSpanX, double tileSpanY, double tileMatrixMinX, double tileMatrixMaxY, int tileMinCol, int tileMaxCol, int tileMinRow, int tileMaxRow) throws InterruptedException, ExecutionException, TimeoutException {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("wmts-query-%d").build();
        ExecutorService execTileRequests = Executors.newFixedThreadPool(5, (ThreadFactory)factory);
        ReentrantLock renderImageLock = new ReentrantLock();
        ArrayList<Future<Void>> tileResults = new ArrayList<Future<Void>>();
        try {
            for (int col = tileMinCol; col <= tileMaxCol; ++col) {
                for (int i = tileMinRow; i <= tileMaxRow; ++i) {
                    if (runnable.isCanceled()) {
                        return;
                    }
                    double leftX = (double)col * tileSpanX + tileMatrixMinX;
                    double rightX = (double)(col + 1) * tileSpanX + tileMatrixMinX;
                    double upperY = tileMatrixMaxY - (double)i * tileSpanY;
                    double lowerY = tileMatrixMaxY - (double)(i + 1) * tileSpanY;
                    Envelope tileBounds = new Envelope(leftX, rightX, upperY, lowerY);
                    if (!viewportBBox.intersects(tileBounds)) continue;
                    if (runnable.isCanceled()) {
                        return;
                    }
                    int finalRow = i;
                    int finalCol = col;
                    Callable<Void> renderTile = () -> {
                        BufferedImage tileImage = null;
                        try {
                            LOG.trace("Retrieving from TileSet {} WMTS tile {}/{}", new Object[]{tm.getIdentifier(), finalRow, finalCol});
                            tileImage = this.getLayer().createImage(layer, tm, finalRow, finalCol, runnable);
                            if (tileImage == null) {
                                return null;
                            }
                        }
                        catch (Exception ex) {
                            throw new IOException(ex);
                        }
                        tileImage = WMTSLayerRenderer.setupTransparency(tileImage, style);
                        renderImageLock.lock();
                        try {
                            renderFunction.renderImage(tileImage, tileBounds, finalRow, finalCol);
                        }
                        finally {
                            renderImageLock.unlock();
                        }
                        return null;
                    };
                    tileResults.add(execTileRequests.submit(renderTile));
                }
            }
            for (Future future : tileResults) {
                future.get(5000L, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            execTileRequests.shutdown();
        }
    }

    private void renderToBakingImage(TileMatrix tm, int tileMinCol, int tileMaxCol, int tileMinRow, int tileMaxRow, BakingImage bakingImage, int finalRow, int finalCol, BufferedImage tileImage, Envelope tileBounds, Envelope requestedTilesBounds) {
        if (bakingImage.getImage() == null) {
            LOG.debug("Creating Baking Image");
            double tilePixelRatioX = (double)tileImage.getWidth() / (double)tm.getTileWidth();
            double tilePixelRatioY = (double)tileImage.getHeight() / (double)tm.getTileHeight();
            int sourceTileWidth = tileImage.getWidth();
            int sourceTileHeight = tileImage.getHeight();
            int bakingWidth = (tileMaxCol - tileMinCol + 1) * sourceTileWidth;
            int bakingHeight = (tileMaxRow - tileMinRow + 1) * sourceTileHeight;
            bakingImage.setScaledTileWidth(sourceTileWidth);
            bakingImage.setScaledTileHeight(sourceTileHeight);
            bakingImage.setImage(this.createBufferedImage(bakingWidth, bakingHeight));
            if (tilePixelRatioX != 1.0 || tilePixelRatioY != 1.0) {
                LOG.debug("WMTS used different tilePixelRatio {}/{}, source Image {}/{}, wmts defined {}/{}", new Object[]{tilePixelRatioX, tilePixelRatioY, tileImage.getWidth(), tileImage.getHeight(), tm.getTileWidth(), tm.getTileHeight()});
            }
        }
        requestedTilesBounds.expandToInclude(tileBounds);
        int tx = (finalCol - tileMinCol) * bakingImage.getScaledTileWidth();
        int ty = (finalRow - tileMinRow) * bakingImage.getScaledTileHeight();
        this.renderImage(bakingImage.getImage(), tileImage, tx, ty, bakingImage.getScaledTileWidth(), bakingImage.getScaledTileHeight());
    }

    public BufferedImage createBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    protected void renderImage(BufferedImage image, BufferedImage tileImage, int x, int y, int width, int height) {
        Graphics2D graphics = image.createGraphics();
        this.drawImageWithImprovedScaling(graphics, tileImage, x, y, width, height);
        this.drawDebugInfos(graphics, x, y, width, height);
    }

    private static BufferedImage setupTransparency(BufferedImage img, WMTSStyleModel style) {
        if (img == null) {
            return null;
        }
        if (!style.isUseClearColor()) {
            return img;
        }
        ColorModel cm = img.getColorModel();
        if (style.getClearColor() == null) {
            return null;
        }
        int transparentColor = RiwaJumpModelUtilities.colorByColorModel(style.getClearColor()).getRGB();
        if (!cm.hasAlpha()) {
            img = WMTSLayer.makeBufferedImage(img);
            cm = img.getColorModel();
        }
        LOG.debug("Current colormodel: {}", (Object)cm);
        for (int w = 0; w < img.getWidth(); ++w) {
            for (int h = 0; h < img.getHeight(); ++h) {
                int currentColor = img.getRGB(w, h);
                if (currentColor != transparentColor) continue;
                ByteBuffer bbuf = ByteBuffer.allocate(4);
                bbuf.putInt(currentColor);
                byte[] arrColor = bbuf.array();
                arrColor[0] = 0;
                bbuf.clear();
                bbuf.put(arrColor);
                bbuf.flip();
                int newColor = bbuf.getInt();
                img.setRGB(w, h, newColor);
            }
        }
        return img;
    }

    public static TileMatrix findBestMatchingTileMatrix(TileMatrixSet tms, double scaleDenom) {
        return WMTSLayerRenderer.findBestMatchingTileMatrix(tms, scaleDenom, 0.5);
    }

    public static TileMatrix findBestMatchingTileMatrix(TileMatrixSet tms, double scaleDenom, double threshold) {
        TreeMap<Double, TileMatrix> list = new TreeMap<Double, TileMatrix>();
        for (TileMatrix tm : tms.getTileMatrices()) {
            list.put(tm.getScaleDenominator(), tm);
        }
        if (list.isEmpty()) {
            return null;
        }
        double first = (Double)list.firstKey();
        if (scaleDenom <= first) {
            return (TileMatrix)list.get(first);
        }
        double last = (Double)list.lastKey();
        if (scaleDenom >= last) {
            return (TileMatrix)list.get(last);
        }
        double lastScaleDenom = first;
        Iterator iterator = list.keySet().iterator();
        while (iterator.hasNext()) {
            double currentScaleDenom = (Double)iterator.next();
            double max = lastScaleDenom + (currentScaleDenom - lastScaleDenom) * threshold;
            if (scaleDenom <= max) {
                TileMatrix bestTileMatrix = (TileMatrix)list.get(lastScaleDenom);
                LOG.debug("Best fitting tile matrix is id {}, scale {} for current scale {}, lower {}, upper {}, threshold {}", new Object[]{bestTileMatrix.getIdentifier(), bestTileMatrix.getScaleDenominator(), scaleDenom, lastScaleDenom, currentScaleDenom, threshold});
                return bestTileMatrix;
            }
            lastScaleDenom = currentScaleDenom;
        }
        return (TileMatrix)list.get(last);
    }

    protected void renderImage(ThreadSafeImage image, Image tileImage, Envelope bounds) throws Exception {
        Point2D p = this.getPanel().getViewport().toViewPoint(new Coordinate(bounds.getMinX(), bounds.getMaxY()));
        Point2D p2 = this.getPanel().getViewport().toViewPoint(new Coordinate(bounds.getMaxX(), bounds.getMinY()));
        image.draw(g -> {
            Object renderingHintBackup = g.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            Composite oldComposite = g.getComposite();
            try {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                WMTSStyleModel validWMTSStyle = this.getLayer().getValidWMTSStyle();
                WMTSStyleRenderer intelligence = (WMTSStyleRenderer)validWMTSStyle.getIntelligence();
                g.setComposite(AlphaComposite.getInstance(3, (float)(intelligence.getUserDefinedAlpha() * validWMTSStyle.getAlpha() / 255) / 255.0f));
                int ix = (int)Math.round(p.getX());
                int iy = (int)Math.round(p.getY());
                int width = (int)Math.round(p2.getX()) - ix;
                int height = (int)Math.round(p2.getY()) - iy;
                this.drawImageWithImprovedScaling(g, tileImage, ix, iy, width, height);
                this.drawDebugInfos(g, ix, iy, width, height);
                LOG.debug("Rendering final WMTS layer source size {}x{} -> target size {}x{}", new Object[]{tileImage.getWidth(null), tileImage.getHeight(null), width, height});
            }
            finally {
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, renderingHintBackup);
                g.setComposite(oldComposite);
            }
        });
    }

    private void drawImageWithImprovedScaling(Graphics2D g, Image tileImage, int x, int y, int width, int height) {
        int sourceWidth = tileImage.getWidth(null);
        int sourceHeight = tileImage.getHeight(null);
        while (width < sourceWidth / 2 && height < sourceHeight / 2) {
            tileImage = tileImage.getScaledInstance(sourceWidth / 2, sourceHeight / 2, 16);
            sourceWidth = tileImage.getWidth(null);
            sourceHeight = tileImage.getHeight(null);
        }
        g.drawImage(tileImage, x, y, width, height, null);
    }

    private void drawDebugInfos(Graphics2D graphics, int x, int y, int width, int height) {
    }

    private static class BakingImage {
        private BufferedImage image;
        private int scaledTileWidth;
        private int scaledTileHeight;

        private BakingImage() {
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }

        public int getScaledTileWidth() {
            return this.scaledTileWidth;
        }

        public void setScaledTileWidth(int scaledTileWidth) {
            this.scaledTileWidth = scaledTileWidth;
        }

        public int getScaledTileHeight() {
            return this.scaledTileHeight;
        }

        public void setScaledTileHeight(int scaledTileHeight) {
            this.scaledTileHeight = scaledTileHeight;
        }
    }

    @FunctionalInterface
    private static interface TileRenderFunction {
        public void renderImage(BufferedImage var1, Envelope var2, int var3, int var4) throws Exception;
    }
}

