/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.plugin.wms.WMSStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.ows.wms.wmscapabilities.WMSCapabilities;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import de.riwagis.util.thread.Cancelable;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSLayerRenderer
extends ImageCachingRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(WMSLayerRenderer.class);
    private static final int MIN_TILE_SIZE = 150;
    private static File SAVEWMSIMG_DIR = null;

    public static final void setSAVEWMSIMG_DIR(File SAVEWMSIMG_DIR) {
        WMSLayerRenderer.SAVEWMSIMG_DIR = SAVEWMSIMG_DIR;
    }

    public WMSLayerRenderer(WMSLayer layer, LayerView panel) {
        super(layer, panel);
    }

    @Override
    public ThreadSafeImage getImage() {
        if (!this.getLayer().isVisibleOnScreen()) {
            return null;
        }
        return super.getImage();
    }

    @Override
    public Runnable createRunnable() {
        if (!LayerRenderer.render(this.getLayer())) {
            this.clearImageCache();
            return null;
        }
        return super.createRunnable();
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        if (!LayerRenderer.render(this.getLayer())) {
            return;
        }
        super.copyTo(graphics);
    }

    private WMSLayer getLayer() {
        return (WMSLayer)this.getContentID();
    }

    @Override
    protected void renderHook(ThreadSafeImage image, CancelableRunnable runnable) throws Exception {
        if (!this.getLayer().isVisibleOnScreen()) {
            return;
        }
        WMSStyleModel style = this.getLayer().getValidWMSStyle();
        if (style == null) {
            return;
        }
        if (runnable.isCanceled()) {
            return;
        }
        int tileSizeDU = (int)((double)Math.max(this.getLayer().determineTileSize(), 150) / this.getPanel().getScale());
        WMSStyleRenderer intelligence = (WMSStyleRenderer)style.getIntelligence();
        WMSCapabilities capabilities = intelligence.getWMService().getCapabilities();
        int maxWidth = capabilities.getMaxWidth();
        int maxHeight = capabilities.getMaxHeight();
        int mapWidth = maxWidth < 1 ? tileSizeDU : Math.min(tileSizeDU, maxWidth);
        int mapHeight = maxHeight < 1 ? tileSizeDU : Math.min(tileSizeDU, maxHeight);
        int panelWidthDU = this.getPanel().getWidth();
        int panelHeightDU = this.getPanel().getHeight();
        int lastWidth = panelWidthDU % mapWidth;
        int offsetStartWith = 0;
        if (lastWidth > 0 && lastWidth < 5) {
            offsetStartWith = -50;
        }
        int lastHeight = panelHeightDU % mapHeight;
        int offsetStartHeight = 0;
        if (lastHeight > 0 && lastHeight < 5) {
            offsetStartHeight = -50;
        }
        if (mapWidth < panelWidthDU || mapHeight < panelHeightDU) {
            for (int i = 0; i < panelWidthDU; i += mapWidth) {
                int fi = i;
                int innerMapWidth = mapWidth;
                if (i == 0 && offsetStartWith != 0) {
                    i += offsetStartWith;
                    innerMapWidth += offsetStartWith;
                }
                int width = Math.min(panelWidthDU - fi, innerMapWidth);
                for (int j = 0; j < panelHeightDU; j += mapHeight) {
                    if (runnable.isCanceled()) {
                        return;
                    }
                    int fj = j;
                    int innerMapHeight = mapHeight;
                    if (j == 0 && offsetStartHeight != 0) {
                        j += offsetStartHeight;
                        innerMapHeight += offsetStartHeight;
                    }
                    int height = Math.min(panelHeightDU - fj, innerMapHeight);
                    Image tileImage = this.getLayer().createImage(this.getPanel(), fi, fj, width, height, style, null);
                    if (tileImage == null) continue;
                    image.draw(g -> {
                        g.setComposite(AlphaComposite.getInstance(3, (float)(intelligence.getUserDefinedAlpha() * style.getAlpha() / 255) / 255.0f));
                        g.drawImage(tileImage, fi, fj, width, height, null);
                    });
                }
            }
        } else {
            Image sourceImage = this.getLayer().createImage(this.getPanel(), (Cancelable)runnable);
            if (runnable.isCanceled()) {
                return;
            }
            image.draw(g -> {
                WMSStyleModel wmsStyle = this.getLayer().getValidWMSStyle();
                if (wmsStyle == null) {
                    return;
                }
                g.setComposite(AlphaComposite.getInstance(3, (float)(intelligence.getUserDefinedAlpha() * wmsStyle.getAlpha() / 255) / 255.0f));
                if (sourceImage != null) {
                    g.drawImage(sourceImage, 0, 0, panelWidthDU, panelHeightDU, null);
                }
            });
        }
        if (SAVEWMSIMG_DIR != null && SAVEWMSIMG_DIR.isDirectory()) {
            try {
                File wmsDebugFile = File.createTempFile("savedWMSimg.", ".png", SAVEWMSIMG_DIR);
                LOG.debug("writing WMS file '{}'", (Object)wmsDebugFile);
                ImageIO.write((RenderedImage)((Object)image.getImage()), "PNG", wmsDebugFile);
            }
            catch (Throwable t) {
                LOG.warn(String.format("Unable to write image to '%s': %s", SAVEWMSIMG_DIR, t.getMessage()), t);
            }
        }
    }
}

