/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.util.ImageUtil;
import com.vividsolutions.jump.workbench.ui.renderer.GraphicsState;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingSupport;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;

public class ThreadSafeImage
implements Cloneable {
    protected Image image = null;
    private Graphics2D graphics = null;
    private final LayerView panel;
    private AffineTransform oldTrans = null;
    private final GraphicsState dummyGraphicsState = new GraphicsState(this){

        @Override
        public void restore(Graphics2D g) {
        }
    };

    public ThreadSafeImage(LayerView panel) {
        this.panel = panel;
    }

    public void reset() {
        this.image = null;
        this.graphics = null;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = ImageUtil.createBlankPanelImage(this.panel.getWidthInPixels(), this.panel.getHeightInPixels());
            try {
                this.oldTrans = this.panel.getViewport().getModelToViewTransform();
            }
            catch (Exception e) {
                this.oldTrans = null;
            }
        }
        return this.image;
    }

    protected Graphics2D getGraphics() {
        if (this.graphics == null) {
            this.graphics = (Graphics2D)this.getImage().getGraphics();
            RenderingSupport.setRenderingHints(this.graphics, this.panel.getRenderHints());
            this.scaleToScreenUnits(this.graphics);
        }
        return this.graphics;
    }

    public synchronized void copyTo(Graphics2D destination, ImageObserver imageObserver) {
        if (this.image == null) {
            return;
        }
        AffineTransform drawTrans = AffineTransform.getScaleInstance(1.0, 1.0);
        if (this.oldTrans != null) {
            try {
                AffineTransform newTrans = this.panel.getViewport().getModelToViewTransform();
                drawTrans = this.oldTrans.createInverse();
                drawTrans.preConcatenate(newTrans);
            }
            catch (Exception e) {
                drawTrans = AffineTransform.getScaleInstance(1.0, 1.0);
            }
        }
        AffineTransform screenTransform = this.scaleToDisplayUnits(drawTrans);
        destination.drawImage(this.image, screenTransform, imageObserver);
    }

    private boolean isPanelReady() {
        if (this.panel.getSize().equals(new Dimension(0, 0))) {
            return false;
        }
        return this.getImage() != null;
    }

    public synchronized void draw(Drawer drawer) throws Exception {
        if (!this.isPanelReady()) {
            return;
        }
        Graphics2D g = (Graphics2D)this.image.getGraphics();
        RenderingSupport.setRenderingHints(g, this.panel.getRenderHints());
        this.scaleToScreenUnits(g);
        drawer.draw(g);
    }

    private void scaleToScreenUnits(Graphics2D g) {
        double scale = this.panel.getScale();
        if (scale == 1.0) {
            return;
        }
        g.scale(scale, scale);
    }

    private AffineTransform scaleToDisplayUnits(AffineTransform drawTrans) {
        double scale = this.panel.getScale();
        if (scale == 1.0) {
            return drawTrans;
        }
        double scaleFactor = 1.0 / scale;
        AffineTransform scaledTransform = new AffineTransform(drawTrans);
        scaledTransform.scale(scaleFactor, scaleFactor);
        return scaledTransform;
    }

    public synchronized GraphicsState getGraphicsState() {
        if (!this.isPanelReady()) {
            return this.dummyGraphicsState;
        }
        return new GraphicsState(this.getGraphics());
    }

    public synchronized void setGraphicsState(GraphicsState gs) {
        if (!this.isPanelReady()) {
            return;
        }
        gs.restore(this.getGraphics());
    }

    public Object clone() {
        ThreadSafeImage clone = new ThreadSafeImage(this.panel);
        if (!clone.isPanelReady()) {
            return null;
        }
        this.copyTo(clone.getGraphics(), null);
        return clone;
    }

    public static interface Drawer {
        public void draw(Graphics2D var1) throws Exception;
    }
}

