/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import java.awt.Graphics2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRenderer.class);
    private volatile boolean cancelled = false;
    private final Object contentID;
    private final LayerViewPanelContext errorHandler;

    public SimpleRenderer(Object contentID, LayerViewPanelContext errorHandler) {
        this.contentID = contentID;
        this.errorHandler = errorHandler;
    }

    @Override
    public void clearImageCache() {
        LOG.trace("clearing Image Cache");
    }

    protected abstract void paint(Graphics2D var1) throws Exception;

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isRendering() {
        return false;
    }

    @Override
    public Object getContentID() {
        return this.contentID;
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        try {
            this.cancelled = false;
            this.paint(graphics);
            this.setRenderError(null);
        }
        catch (Throwable t) {
            if (this.errorHandler != null) {
                this.errorHandler.warnUser(WorkbenchFrame.toMessage(t));
            }
            LOG.error(String.format("Error rendering: %s", t.getMessage()), t);
            this.setRenderError(String.format("%s: %s", t.getClass().getName(), t.getMessage()));
        }
    }

    private void setRenderError(String strError) {
        if (this.contentID instanceof Layerable) {
            ((Layerable)this.contentID).setRenderError(strError);
        }
    }

    @Override
    public Runnable createRunnable() {
        return null;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }
}

