/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.WMTSLayer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.GPSPluginRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LineStringSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.PartSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.RasterImageRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderContext;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingListener;
import com.vividsolutions.jump.workbench.ui.renderer.SelectionBackgroundRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.WMSLayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.WMTSLayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.factory.ContentDependendRendererFactory;
import com.vividsolutions.jump.workbench.ui.renderer.factory.RendererFactory;
import de.riwagis.thread.ThreadQueue;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderingManager {
    private static final Logger LOG = LoggerFactory.getLogger(RenderingManager.class);
    private static final Runnable DUMMY_RUNNER = () -> {};
    private final AtomicBoolean bolInRendering = new AtomicBoolean(false);
    private volatile ThreadSafeImage imageCache = null;
    private final LayerViewPanel lvp;
    public static final String USE_MULTI_RENDERING_THREAD_QUEUE_KEY = RenderingManager.class.getName() + " - USE MULTI RENDERING THREAD QUEUE";
    private final Map<Object, Renderer> contentIDToRendererMap = new LinkedHashMap<Object, Renderer>();
    private final Map<Object, RendererFactory> contentIDToLowRendererFactoryMap = new LinkedHashMap<Object, RendererFactory>();
    private final Map<Object, RendererFactory> contentIDToHighRendererFactoryMap = new LinkedHashMap<Object, RendererFactory>();
    private final int singleThreadQueueCount = Runtime.getRuntime().availableProcessors() * 6;
    private final ThreadQueue singleThreadQueue = this.createThreadQueue(this.singleThreadQueueCount, "RenderThreadQueue");
    private final ThreadQueue enqueueRendererDeamon = new ThreadQueue(1);
    private final List<RenderingListener> listeners = new ArrayList<RenderingListener>();
    private boolean paintingEnabled = true;
    protected static final Map<Class<?>, ContentDependendRendererFactory> layerableClassToRendererFactoryMap = new HashMap();
    private final Lock lockThreadQueue = new ReentrantLock();
    private final ReadWriteLock lockListeners = new ReentrantReadWriteLock();
    private final Lock lockImageCache = new ReentrantLock();

    public RenderingManager(LayerViewPanel layerViewPanel) {
        this.lvp = layerViewPanel;
        this.putAboveLayerables("SELECTION_BACKGROUND", () -> new SelectionBackgroundRenderer(layerViewPanel, layerViewPanel.getSelectionManager()));
        this.putAboveLayerables("SELECTED_FEATURES", () -> new FeatureSelectionRenderer(layerViewPanel, layerViewPanel.getSelectionManager()));
        this.putAboveLayerables("SELECTED_LINESTRINGS", () -> new LineStringSelectionRenderer(layerViewPanel, layerViewPanel.getSelectionManager()));
        this.putAboveLayerables("SELECTED_PARTS", () -> new PartSelectionRenderer(layerViewPanel, layerViewPanel.getSelectionManager()));
        this.putAboveLayerables("GPS_PREVIEW", () -> new GPSPluginRenderer(layerViewPanel, "GPS_PREVIEW"));
    }

    private ThreadQueue createThreadQueue(int threadCount, String externalQueueName) {
        ThreadQueue thqueue = new ThreadQueue(threadCount, externalQueueName);
        thqueue.add(interrupted -> {
            Runnable rRenderingStopped = () -> this.fireRenderingStopped(true);
            Thread thRenderingStopped = new Thread(rRenderingStopped, "Rendering Manager - fire rendering stopped");
            thRenderingStopped.start();
        });
        thqueue.start();
        return thqueue;
    }

    public boolean isRendering() {
        return this.bolInRendering.get();
    }

    public final void putBelowLayerables(Object contentID, RendererFactory factory) {
        this.contentIDToLowRendererFactoryMap.put(contentID, factory);
    }

    public final void putAboveLayerables(Object contentID, RendererFactory factory) {
        this.contentIDToHighRendererFactoryMap.put(contentID, factory);
    }

    public synchronized void stopAll() {
        try {
            this.lockThreadQueue.lock();
            this.enqueueRendererDeamon.interruptQueue();
            this.enqueueRendererDeamon.add(this.singleThreadQueue::interruptQueue);
        }
        finally {
            this.lockThreadQueue.unlock();
        }
    }

    public synchronized void renderAll() {
        try {
            this.lockThreadQueue.lock();
            this.enqueueRendererDeamon.interruptQueue();
            this.enqueueRendererDeamon.add(() -> {
                this.singleThreadQueue.interruptQueue();
                this.enqueueRenderer(this.contentIDs().iterator(), false);
            });
        }
        finally {
            this.lockThreadQueue.unlock();
        }
    }

    public List<Object> contentIDs() {
        ArrayList<Object> contentIDs = new ArrayList<Object>();
        contentIDs.addAll(this.contentIDToLowRendererFactoryMap.keySet());
        contentIDs.addAll(this.lvp.getLayerManager().getContentIDsDescending());
        contentIDs.addAll(this.contentIDToHighRendererFactoryMap.keySet());
        return contentIDs;
    }

    public Renderer getRenderer(Object contentID) {
        return this.contentIDToRendererMap.get(contentID);
    }

    private void setRenderer(Object contentID, Renderer renderer) {
        this.contentIDToRendererMap.put(contentID, renderer);
    }

    public boolean removeRenderer(Object contentID) {
        return this.contentIDToRendererMap.remove(contentID) != null;
    }

    public void render(Iterator<?> iContentID) {
        this.render(iContentID, false);
    }

    public void render(Iterator<?> iContentID, boolean clearImageCache) {
        try {
            this.lockThreadQueue.lock();
            this.enqueueRendererDeamon.add(() -> this.enqueueRenderer(iContentID, clearImageCache));
        }
        finally {
            this.lockThreadQueue.unlock();
        }
    }

    public void render(Object contentID) {
        this.render(contentID, false);
    }

    public void render(Object contentID, boolean clearImageCache) {
        try {
            this.lockThreadQueue.lock();
            this.enqueueRendererDeamon.add(() -> this.enqueueRenderer(contentID, clearImageCache));
        }
        finally {
            this.lockThreadQueue.unlock();
        }
    }

    public void clearImageCache() {
        try {
            this.lockImageCache.lock();
            for (Object contentID : this.contentIDs()) {
                if (this.getRenderer(contentID) == null) continue;
                this.getRenderer(contentID).clearImageCache();
            }
            this.imageCache = null;
        }
        finally {
            this.lockImageCache.unlock();
        }
    }

    private synchronized void enqueueRenderer(Object contentID, boolean clearImageCache) {
        this.enqueueRendererDeamon.add(() -> {
            Runnable runnable;
            Renderer renderer = this.getRenderer(contentID);
            if (renderer == null) {
                renderer = this.createRenderer(contentID);
                this.setRenderer(contentID, renderer);
            } else {
                renderer.cancel();
            }
            if (clearImageCache) {
                renderer.clearImageCache();
            }
            if ((runnable = renderer.createRunnable()) != null) {
                if (!this.singleThreadQueue.isRunning()) {
                    this.fireRenderingStarted();
                }
                this.singleThreadQueue.add(runnable);
            } else {
                this.singleThreadQueue.add(DUMMY_RUNNER);
            }
        });
    }

    private synchronized void enqueueRenderer(Iterator<?> iContent, boolean clearImageCache) {
        this.enqueueRendererDeamon.add(() -> {
            ArrayList<Runnable> lstSingle = new ArrayList<Runnable>();
            while (iContent.hasNext()) {
                Runnable runnable;
                Object contentID = iContent.next();
                Renderer renderer = this.getRenderer(contentID);
                if (renderer == null) {
                    renderer = this.createRenderer(contentID);
                    this.setRenderer(contentID, renderer);
                } else {
                    renderer.cancel();
                }
                if (clearImageCache) {
                    renderer.clearImageCache();
                }
                if ((runnable = renderer.createRunnable()) == null) continue;
                lstSingle.add(runnable);
            }
            if (!this.singleThreadQueue.isRunning() && !lstSingle.isEmpty()) {
                this.fireRenderingStarted();
            }
            this.singleThreadQueue.addRunnables(lstSingle);
            if (lstSingle.isEmpty()) {
                this.singleThreadQueue.add(DUMMY_RUNNER);
            }
        });
    }

    private Thread repaintPanel(boolean bolClearImageCache) {
        if (!this.paintingEnabled) {
            return null;
        }
        if (bolClearImageCache) {
            try {
                this.lockImageCache.lock();
                this.imageCache = null;
            }
            finally {
                this.lockImageCache.unlock();
            }
        }
        return this.lvp.copyTo();
    }

    private Thread repaintPanel() {
        return this.repaintPanel(true);
    }

    public static ContentDependendRendererFactory getRenderFactoryForLayerable(Class<?> clss) {
        if (layerableClassToRendererFactoryMap.containsKey(clss)) {
            return layerableClassToRendererFactoryMap.get(clss);
        }
        return null;
    }

    public static void putRendererForLayerable(Class<?> clss, ContentDependendRendererFactory rendererFactory) {
        if (!layerableClassToRendererFactoryMap.containsKey(clss)) {
            layerableClassToRendererFactoryMap.put(clss, rendererFactory);
        }
    }

    public final Renderer createRenderer(Object contentID) {
        Renderer res = RenderingManager.createRenderer(contentID, this.lvp);
        if (res != null) {
            return res;
        }
        if (this.contentIDToLowRendererFactoryMap.containsKey(contentID)) {
            return this.contentIDToLowRendererFactoryMap.get(contentID).create();
        }
        if (this.contentIDToHighRendererFactoryMap.containsKey(contentID)) {
            return this.contentIDToHighRendererFactoryMap.get(contentID).create();
        }
        Assert.shouldNeverReachHere((String)contentID.toString());
        return null;
    }

    public void setPaintingEnabled(boolean paintingEnabled) {
        this.paintingEnabled = paintingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadSafeImage copyTo() {
        try {
            this.lockImageCache.lock();
            if (this.imageCache == null) {
                this.imageCache = new ThreadSafeImage(this.lvp);
                Graphics2D g = this.imageCache.getGraphics();
                for (Object contentID : this.contentIDs()) {
                    Renderer renderer;
                    if (this.contentIDToHighRendererFactoryMap.containsKey(contentID) || (renderer = this.getRenderer(contentID)) == null) continue;
                    renderer.copyTo(g);
                }
            }
            ThreadSafeImage threadSafeImage = this.imageCache;
            return threadSafeImage;
        }
        finally {
            this.lockImageCache.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToOverlay(Graphics2D destination) {
        Iterator<Object> iHigh = this.contentIDToHighRendererFactoryMap.keySet().iterator();
        Object objAntiAliasFlag = destination.getRenderingHints().get(RenderingHints.KEY_ANTIALIASING);
        try {
            destination.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            while (iHigh.hasNext()) {
                Renderer r = this.getRenderer(iHigh.next());
                if (r == null) continue;
                r.copyTo(destination);
            }
        }
        finally {
            destination.setRenderingHint(RenderingHints.KEY_ANTIALIASING, objAntiAliasFlag);
        }
    }

    public ThreadQueue getDefaultRendererThreadQueue() {
        return this.singleThreadQueue;
    }

    public void dispose() {
        this.enqueueRendererDeamon.shutdown();
        this.enqueueRendererDeamon.interruptQueue();
        this.singleThreadQueue.shutdown();
        if (this.singleThreadQueue.isRunning()) {
            this.fireRenderingStopped(false);
        }
        this.singleThreadQueue.interruptQueue();
        this.contentIDToRendererMap.clear();
        if (this.imageCache != null) {
            this.imageCache.reset();
        }
        this.listeners.clear();
    }

    public LayerViewPanel getPanel() {
        return this.lvp;
    }

    public void addRenderingListener(RenderingListener listener) {
        try {
            this.lockListeners.writeLock().lock();
            this.listeners.add(listener);
        }
        finally {
            this.lockListeners.writeLock().unlock();
        }
    }

    public void removeRenderingListener(RenderingListener listener) {
        try {
            this.lockListeners.writeLock().lock();
            this.listeners.remove(listener);
        }
        finally {
            this.lockListeners.writeLock().unlock();
        }
    }

    private void fireRenderingStarted() {
        try {
            this.lockListeners.readLock().lock();
            this.bolInRendering.set(true);
            for (RenderingListener listener : this.listeners) {
                listener.renderingStarted(this.lvp);
            }
        }
        finally {
            this.lockListeners.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRenderingStopped(boolean repaint) {
        if (repaint) {
            Thread thRepaint = this.repaintPanel();
            try {
                if (thRepaint != null) {
                    thRepaint.join();
                }
            }
            catch (InterruptedException ex) {
                LOG.error("Error on repaint thread - Interrupted", (Throwable)ex);
                Thread.currentThread().interrupt();
            }
        }
        try {
            this.lockListeners.readLock().lock();
            for (RenderingListener listener : this.listeners) {
                listener.renderingStopped(this.lvp);
            }
            this.bolInRendering.set(false);
        }
        finally {
            this.lockListeners.readLock().unlock();
        }
    }

    public static Renderer createRenderer(Object contentID, LayerView lvp) {
        if (contentID instanceof Layer) {
            return new LayerRenderer((Layer)contentID, (RenderContext)lvp);
        }
        if (contentID instanceof RasterImageLayer) {
            return new RasterImageRenderer(contentID, lvp);
        }
        if (contentID instanceof WMSLayer) {
            return new WMSLayerRenderer((WMSLayer)contentID, lvp);
        }
        if (contentID instanceof WMTSLayer) {
            return new WMTSLayerRenderer((WMTSLayer)contentID, lvp);
        }
        ContentDependendRendererFactory renderFactoryForLayerable = RenderingManager.getRenderFactoryForLayerable(contentID.getClass());
        if (renderFactoryForLayerable != null) {
            return renderFactoryForLayerable.create(contentID, lvp);
        }
        return null;
    }
}

