/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.plugin.raster.RasterRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import de.riwagis.riwajump.model.style.RasterStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterImageRenderer
extends ImageCachingRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(RasterImageRenderer.class);
    private final AtomicBoolean doneRendering = new AtomicBoolean(true);

    public RasterImageRenderer(Object contentID, LayerView panel) {
        super(contentID, panel);
    }

    @Override
    public ThreadSafeImage getImage() {
        if (!this.getLayer().isVisibleOnScreen()) {
            return null;
        }
        return super.getImage();
    }

    @Override
    public Runnable createRunnable() {
        if (!LayerRenderer.render(this.getLayer())) {
            return null;
        }
        return super.createRunnable();
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        if (!LayerRenderer.render(this.getLayer())) {
            return;
        }
        super.copyTo(graphics);
    }

    private RasterImageLayer getLayer() {
        return (RasterImageLayer)this.getContentID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderHook(ThreadSafeImage image, CancelableRunnable runnable) throws Exception {
        try {
            if (!this.getLayer().isVisibleOnScreen()) {
                return;
            }
            while (!this.doneRendering.get()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.doneRendering.set(false);
            RasterImageLayer rLayer = this.getLayer();
            Envelope realWorldCoordinates = new Envelope(rLayer.getEnvelope());
            if (!this.getPanel().getViewport().getEnvelopeInModelCoordinates().intersects(realWorldCoordinates)) {
                this.doneRendering.set(true);
                return;
            }
            StyleCollection sCol = rLayer.getValidStyleCollection();
            if (sCol == null) {
                this.doneRendering.set(true);
                return;
            }
            Collection<StyleModel> styles = sCol.getStyles();
            if (styles.isEmpty()) {
                this.doneRendering.set(true);
                return;
            }
            if (runnable.isCanceled()) {
                this.doneRendering.set(true);
                return;
            }
            ThreadSafeImage.Drawer drawer = g -> {
                Object oldRenderingKey = g.getRenderingHint(RenderingHints.KEY_RENDERING);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                Object oldColorRenderingKey = g.getRenderingHint(RenderingHints.KEY_COLOR_RENDERING);
                g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                Object oldDitheringKey = g.getRenderingHint(RenderingHints.KEY_DITHERING);
                g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
                Object oldAplhaInterpolationKey = g.getRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
                Object oldAAKey = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                for (StyleModel style : styles) {
                    RasterRenderer renderer = RenderUtil.getRenderer((RasterStyleModel)style);
                    if (renderer == null) {
                        throw new NullPointerException(String.format("no renderer for '%s'. Maybe 'intelligences' not registered.", this.getContentID()));
                    }
                    renderer.initialize(sCol);
                    renderer.paint(null, g, this.getPanel().getViewport(), null);
                }
                if (oldRenderingKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, oldRenderingKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                }
                if (oldColorRenderingKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, oldColorRenderingKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
                }
                if (oldDitheringKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_DITHERING, oldDitheringKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DEFAULT);
                }
                if (oldAplhaInterpolationKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, oldAplhaInterpolationKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
                }
                if (oldAAKey != null) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAKey);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                }
            };
            image.draw(drawer);
        }
        finally {
            this.doneRendering.set(true);
        }
    }
}

