/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureIteratorProxy;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureProxyRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderContext;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Collections;

public class LayerRenderer
extends FeatureProxyRenderer {
    private final Layer layer;
    public static final String ALWAYS_USE_IMAGE_CACHING_KEY = LayerRenderer.class.getName() + " - ALWAYS USE IMAGE CACHING";

    public LayerRenderer(Layer layer, RenderContext renderContext) {
        super(layer, renderContext);
        this.layer = layer;
    }

    @Override
    public Runnable createRunnable() {
        if (!LayerRenderer.render(this.layer)) {
            this.clearImageCache();
            return null;
        }
        return super.createRunnable();
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        if (!LayerRenderer.render(this.layer)) {
            return;
        }
        super.copyTo(graphics);
    }

    public static boolean render(Layerable layerable) {
        if (!layerable.getLayerManager().getLayerables(Layerable.class).contains(layerable)) {
            WorkbenchContext.getInstance().getLayerViewPanel().getRenderingManager().removeRenderer(layerable);
            return false;
        }
        return layerable.isVisibleOnScreen();
    }

    public static boolean withinVisibleScaleRange(Layerable layerable) {
        if (!layerable.isScaleDependentRenderingEnabled()) {
            return true;
        }
        return layerable.withinVisibleScaleRange();
    }

    @Override
    protected Collection<StyleModel> styles() {
        if (this.layer.getValidStyleCollection() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.layer.getValidStyleCollection().getStyles());
    }

    @Override
    protected FeatureIteratorProxy getFeatureIteratorProxy() {
        return this.layer;
    }
}

