/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.Graphics2D;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.locationtech.jts.geom.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageCachingRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(ImageCachingRenderer.class);
    private final Object contentID;
    private volatile ThreadSafeImage image = null;
    private CancelableRunnable lastRunnable = null;
    private final LayerView panel;
    private volatile boolean rendering = false;
    private final ReadWriteLock lckImg = new ReentrantReadWriteLock();

    public ImageCachingRenderer(Object contentID, LayerView panel) {
        this.contentID = contentID;
        this.panel = panel;
    }

    @Override
    public void clearImageCache() {
        this.lckImg.writeLock().lock();
        try {
            this.image = null;
        }
        finally {
            this.lckImg.writeLock().unlock();
        }
    }

    @Override
    public boolean isRendering() {
        return this.rendering;
    }

    @Override
    public Object getContentID() {
        return this.contentID;
    }

    public LayerView getPanel() {
        return this.panel;
    }

    protected ThreadSafeImage getImage() {
        this.lckImg.readLock().lock();
        try {
            ThreadSafeImage threadSafeImage = this.image;
            return threadSafeImage;
        }
        finally {
            this.lckImg.readLock().unlock();
        }
    }

    private void setImage(ThreadSafeImage newImage) {
        this.lckImg.writeLock().lock();
        try {
            this.image = newImage;
        }
        finally {
            this.lckImg.writeLock().unlock();
        }
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        this.lckImg.readLock().lock();
        try {
            if (this.image == null) {
                return;
            }
            this.image.copyTo(graphics, null);
        }
        finally {
            this.lckImg.readLock().unlock();
        }
    }

    @Override
    public Runnable createRunnable() {
        this.cancel();
        this.rendering = true;
        this.lastRunnable = new CancelableRunnable(){
            private boolean cancelled = false;

            public boolean isCanceled() {
                return this.cancelled;
            }

            public void cancel() {
                this.cancelled = true;
            }

            public void run() {
                block12: {
                    try {
                        ThreadSafeImage image2;
                        block11: {
                            if (this.cancelled) {
                                return;
                            }
                            image2 = new ThreadSafeImage(ImageCachingRenderer.this.panel);
                            try {
                                if (!(ImageCachingRenderer.this.contentID instanceof Layerable) || ((Layerable)ImageCachingRenderer.this.contentID).isVisibleOnScreen()) break block11;
                                ImageCachingRenderer.this.clearImageCache();
                                return;
                            }
                            catch (Throwable t) {
                                ImageCachingRenderer.this.clearImageCache();
                                ImageCachingRenderer.this.panel.getContext().warnUser(WorkbenchFrame.toMessage(t));
                                LOG.warn(String.format("Error rendering Layer '%s': %s", ImageCachingRenderer.this.contentID, t.getMessage()), t);
                                if (ImageCachingRenderer.this.contentID instanceof Layerable) {
                                    ((Layerable)ImageCachingRenderer.this.contentID).setRenderError(String.format("%s: %s", t.getClass().getName(), t.getMessage()));
                                }
                                break block12;
                            }
                        }
                        ImageCachingRenderer.this.renderHook(image2, this);
                        if (!this.cancelled) {
                            ImageCachingRenderer.this.setImage(image2);
                        }
                        ImageCachingRenderer.this.setRenderError(null);
                    }
                    finally {
                        ImageCachingRenderer.this.rendering = false;
                    }
                }
            }
        };
        return this.lastRunnable;
    }

    private void setRenderError(String strError) {
        if (this.contentID instanceof Layerable) {
            ((Layerable)this.contentID).setRenderError(strError);
        }
    }

    protected abstract void renderHook(ThreadSafeImage var1, CancelableRunnable var2) throws Exception;

    @Override
    public void cancel() {
        if (this.lastRunnable != null) {
            this.lastRunnable.cancel();
        }
    }

    public Envelope getEnvelope() throws Exception {
        Envelope viewportEnvelope = this.panel.getViewport().getEnvelopeInModelCoordinates();
        return viewportEnvelope;
    }
}

