/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.RenderContext;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSPluginRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(GPSPluginRenderer.class);
    public static final String GPSPLUGINRENDERER_PREVIEW_COORD = "GPS_PREVIEW_COORD";
    public static final String GPSPLUGINRENDERER_PREVIEW_LINE = "GPS_PREVIEW_LINE";
    public final RenderContext renderContext;
    private static final Stroke POINT_GPS_STROKE = new BasicStroke(2.0f);
    private static final Color POINT_GPS_COLOR = Color.MAGENTA;
    private static final Stroke LINE_GPS_STROKE = new BasicStroke(2.0f);
    private static final Color LINE_GPS_COLOR = Color.CYAN;
    private static final Stroke FILL_STROKE = new BasicStroke(1.0f);
    private static final Color FILL_COLOR = Color.WHITE;
    private final String strContentID;

    public GPSPluginRenderer(RenderContext rc, String strContentID) {
        this.strContentID = strContentID;
        this.renderContext = rc;
    }

    public void paint(Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        Geometry gps_coord = (Geometry)WorkbenchContext.getBlackboard().get(GPSPLUGINRENDERER_PREVIEW_COORD);
        Geometry gps_line = (Geometry)WorkbenchContext.getBlackboard().get(GPSPLUGINRENDERER_PREVIEW_LINE);
        if (gps_coord != null) {
            RenderUtil.paint(gps_coord, g, viewport, true, FILL_STROKE, FILL_COLOR, true, POINT_GPS_STROKE, POINT_GPS_COLOR, false, true);
        }
        if (gps_line != null) {
            RenderUtil.paint(gps_line, g, viewport, true, FILL_STROKE, FILL_COLOR, true, LINE_GPS_STROKE, LINE_GPS_COLOR, false, true);
        }
    }

    @Override
    public void clearImageCache() {
    }

    @Override
    public boolean isRendering() {
        return false;
    }

    @Override
    public Object getContentID() {
        return this.strContentID;
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        try {
            this.paint(graphics, this.renderContext.getViewport());
        }
        catch (Throwable t) {
            this.renderContext.getContext().warnUser(WorkbenchFrame.toMessage(t));
            LOG.error("Error rendering GPS-data: " + t.getMessage(), t);
        }
    }

    @Override
    public Runnable createRunnable() {
        return null;
    }

    @Override
    public void cancel() {
    }
}

